case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
	echo "Using config.sh from above..."
    fi
    . ./config.sh
    ;;
esac
case "$ascii_codeset" in
	"")
	ascii_codeset_val=NULL
	;;
	*)
	ascii_codeset_val="\"$ascii_codeset\""
	;;
esac

echo "Extracting config.h (with variable substitutions)"
sed <<!GROK!THIS! >config.h -e 's!^#undef!/\*#undef!' -e 's!/\*\(.*\)/\*!/\*\1!'
/* config.h
 *
 * $Id: config.h.SH,v 2.36 2020/06/19 15:20:03 hurtta Exp $	
 *
 * This file was produced by running the config.h.SH script, which
 * gets its values from config.sh, which is generally produced by
 * running Configure.
 *
 * Feel free to modify any of this as the need arises.  Note, however,
 * that running config.h.SH again will wipe out any changes you've made.
 * For a more permanent change edit config.sh and rerun config.h.SH.
 */

/*
 * If set builtin pager is default even when \$PAGER is set
 */
#$use_builtin_pager	USE_BUILTIN_PAGER	/**/

/* BIN:
 *	This symbol holds the name of the directory in which the user wants
 *	to put publicly executable images for the package in question.  It
 *	is most often a local directory such as /usr/local/bin.
 */
#define BIN "$bin"             /**/

/* BACKTRACE
 *      This symbol, if defined, indicates that program may include execinfo.h
 *      and call backtrace(), backtrace_symbols_fd() functions.
 */
#$d_backtrace BACKTRACE        /**/

/* CPPSTDIN:
 *	This symbol contains the first part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.	 Typical value of "cc -E" or "/lib/cpp".
 */
/* CPPMINUS:
 *	This symbol contains the second part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.  This symbol will have the value "-" if CPPSTDIN needs a minus
 *	to specify standard input, otherwise the value is "".
 */
#define CPPSTDIN "$cppstdin"
#define CPPMINUS "$cppminus"

/* GETOPT:
 *	This symbol, if defined, indicates that the getopt() routine exists.
 *            GETOPT_OK        usable
 *            GETOPT_BROKEN    does not work for reset scannig
 */
#$d_getopt	GETOPT	 $d_getopt_type	/**/
#ifdef GETOPT
#define   GETOPT_BROKEN    0
#define   GETOPT_OK         1
#endif

/* MEMCPY:
 *	This symbol, if defined, indicates that the memcpy routine is available
 *	to copy blocks of memory.  Otherwise you should probably use bcopy().
 *	If neither is defined, roll your own.
 */
#$d_memcpy	MEMCPY		/**/

/* SYMLINK:
 *	This symbol, if defined, indicates that the symlink routine is available
 *	to create symbolic links.
 */
#$d_symlink	SYMLINK		/**/

/* WHOAMI:
 *	This symbol, if defined, indicates that the program may include
 *	whoami.h.
 */
#$d_whoami	WHOAMI		/**/

/* DIROPS
 *      if USE_DIRENT, indicates that program may include dirent.h
 *      if USE_SYSDIR, indicates that program may include sys/dir.h
 */
#$d_directory 	DIROPS	$d_directyry_type /**/
#ifdef DIROPS
#define		USE_DIRENT	1
#define		USE_SYSDIR	2
#endif

/* POLL:
 *	This symbol, if defined, indicates that the program may include
 *	poll.h.
 * I_SYS_SELECT:
 *      This symbol, if defined, indicates that the program may include sys/select.h
 * SELECT:
 *      This symbol, if defined, indicates that select() is available
 */
#$d_poll	POLL		/**/
#$i_sys_select   I_SYS_SELECT    /**/
#$d_select	SELECT          /**/

/* I_SYSEXITS:
 *         This symbol, if defined, indicates that the program may include sysexits.h
 */	   
#$i_sysexits     I_SYSEXITS    /**/    

/* I_STDINT:
 *         This symbol, if defined, indicates that the program may include stdint.h
 */	   
#$i_stdint	I_STDINT	/**/

/* MMAP:
 *	This symbol, if defined, indicates that the program may include
 *	sys/mman.h (and mmap() works)
 */
#$d_mmap	MMAP		/**/

/* I_INTTYPES:
 *	This symbol, if defined, indicates that the program may include
 *	inttypes.h.
 */
#$i_inttypes	I_INTTYPES		/**/
#$d_nointtypes NO_INTTYPES		/**/

/* HAVE_SOCKET:
 *	This symbol, if defined, indicates that the program may include
 *	sys/socket.h and socket() is available.
 *      Also sys/un.h can be included.
 * HAVE_SOERROR:
 *      This symbol, if defined, indicates that the program may use
 *      getsockopt(fd, SOL_SOCKET, SO_ERROR, &error, &len)
 * HAVE_GETSOCKNAME:
 *     This symbol, if defined, indicates that the program may use getsockname()
 * I_NETDB:
 *	This symbol, if defined, indicates that the program may include
 *	netdb.h.
 * HAVE_ADDRINFO:
 *	This symbol, if defined, indicates that the program may use
 *	getaddrinfo(), freeaddrinfo() and gai_strerror()
 * USABLE_ADDRCONFIG
 *      This symbol, if defined, indicates that  AI_ADDRCONFIG is usable
 *      with getaddrinfo()
 * HAVE_GETNAMEINFO:
 *      This symbol, if defined, indicates that the program may use getnameinfo()
 * I_NETINET_IN:
 *      This symbol, if defined, indicates that the program may include
 *      netinet/in.h
 * HAVE_IN6:
 *      This symbol, if defined, indicates that netinet/in.h includes
 *      struct sockaddr_in6
 * HAVE_SCOPE:
 *      This symbol, if defined, indicates that struct sockaddr_in6 includes
 *      sin6_scope_id
 * HAVE_IFADDRS
 *      This symbol, if defined, indicates that the program may include
 *      ifaddrs.h and use getifaddrs
 * I_ARPA_INET:
 *      This symbol, if defined, indicates that the program may include
 *      arpa/inet.h
 * USE_INET_ATON:
 *      This symbol is defined, it inet_aton is available
 * USE_INET_XTOX_PN:
 *      This symbol is defined, it inet_pton() and inet_ntop()
 *      are available. This replaces inet_aton()
 * I_NET_IF:
 *      This symbol, if defined, indicates that the program may include
 *      net/if.h	
 * HAVE_NAMEINDEX:
 *	This symbol, if defined, indicates that program  may 
 *	use if_nameindex()
 */	
#$d_have_socket	HAVE_SOCKET		/**/
#ifdef HAVE_SOCKET
#$d_have_soerror HAVE_SOERROR		/**/
#$d_have_getsockname HAVE_GETSOCKNAME	/**/
#endif
#ifdef HAVE_GETSOCKNAME
#$d_have_getsockname GETSOCKNAME_SOCKLEN $getsockname_socklen /**/
#endif
#$i_netdb	I_NETDB			/**/
#$d_addrinfo	HAVE_ADDRINFO		/**/
#$d_getnameinfo HAVE_GETNAMEINFO        /**/
#$i_netinet_in	I_NETINET_IN		/**/
#$d_have_in6	HAVE_IN6		/**/
#$d_have_scope	HAVE_SCOPE		/**/	
#$d_ifaddrs	HAVE_IFADDRS		/**/
#$i_arpa_inet	I_ARPA_INET		/**/
#$d_use_aton	USE_INET_ATON		/**/
#$d_use_xtox_pn	USE_INET_XTOX_PN	/**/
#$i_net_if	I_NET_IF		/**/
#$d_nameindex	HAVE_NAMEINDEX		/**/
#ifdef HAVE_SCOPE
#$d_ipv6_scope_id SCOPE_ID_DEFAULT $scope_id_default /**/
#endif
#ifdef HAVE_ADDRINFO
#$d_addrconfig	USABLE_ADDRCONFIG	/**/
#endif

/* CONFIGURE_DATE
 *	This symbol contains the last date that configure was run for elm -v output.
 */
#define		CONFIGURE_DATE	"$c_date"

/* ASCII_CTYPE:
 *	This symbol, if defined, indicates that the ctype functions and
 *	macros are ASCII specific and not 8-bit clean.
 */
#$d_ascii	ASCII_CTYPE	/**/

/* BROKE_CTYPE:
 *	This symbol, if defined, indicates that toupper and tolower
 *	routines/macros are not safe to use.
 */
#$d_broke_ctype	BROKE_CTYPE	/**/

/* ENABLE_CALENDAR:
 *	This symbol, if defined, indicates that the calendar feature
 *	should be supported.
 */
#$d_calendar	ENABLE_CALENDAR	/**/
#define dflt_calendar_file	"$calendar"	

/* CHOWN_NEG1:
 */
#$d_chown_neg1	CHOWN_NEG1	/**/

/* DONT_ESCAPE_MESSAGES:
 *	This symbol, if defined, indicates that a binary capable MTA is in use
 *	that honors the content-length header and no message constructs need
 *	to be escaped.
 */
#$d_content	DONT_ESCAPE_MESSAGES /**/

/* CRYPT:
 *	This symbol, if defined, indicates that the crypt routine is available
 *	to encrypt passwords and the like.
 */
#$d_crypt	CRYPT		/**/

/* I_CRYPT:
 *	This symbol is defined if the program should include <crypt.h>.
 */
#$i_crypt		I_CRYPT	 	/**/

/* DISP_HOST:
 *	This symbol, if defined, indicates that elm should display the
 *	host name on the index screen.
 */
#$d_disphost	DISP_HOST /**/

/* GETDOMAINNAME
 *	This symbol, if defined, indicates that the getdomainname system call
 *	is available to obtain the domain name.  Note that the $etc/domain
 *	file overrides the value of getdomainname().  If getdomainname() exists,
 *	MYDOMAIN will be ignored.
 */
/* USEGETDOMAINNAME
 *	This symbol, if defined, indicates that the getdomainname system call
 *	should be used to obtain the domain name.  Note that the $etc/domain
 *	file overrides the value of getdomainname().  If this variable is set
 *	MYDOMAIN will be ignored.
 *	If this is set default value "name-resolution" elmrc variable includes 
 *	"getdomainname"
 */
#$d_domname	GETDOMAINNAME		/**/
#ifdef GETDOMAINNAME
#$d_usegetdom	USEGETDOMAINNAME		/**/
#endif

/* MAILNAME_FILE
 *      This symbol, if defined, tells filename from where read first valued from
 *      "mailname" elmrc variable
 * USEMAILNAME
 *      This symbol, if defined , tells that MAILNAME_FILE sgould be used by default
 *      If this is set default value "name-resolution" elmrc variable includes 
 *	"mailname-file" 
*/			
#$d_mailname    MAILNAME_FILE  "$mailname_file" /**/
#ifdef MAILNAME_FILE
#$d_usemailname USEMAILNAME                     /**/
#endif

/* FALLBACKMSGIDDOM
 *     This symbol, if defined, gives fall back domain name for message-id
 *     generation. This should be generic name which exists on DNS.
 */
#$d_msgiddomain	FALLBACKMSGIDDOM	"$fmsgiddomain"  /**/

/* USEGETIFADDRS
 *	This symbol, if defined, tells that getifaddrs() should beused to populate 
 *	"mailname" global elm.rc variable.
*/
#ifdef HAVE_IFADDRS
#$d_usegetifaddrs	USEGETIFADDRS		/**/
#endif

/* STRERROR:
 *	This symbol, if defined, indicates that strerror() exists.
 */
#$d_strerror	STRERROR	/**/
#ifndef STRERROR

/* ERRLST:
 *	This symbol, if defined, indicates that the sys_errlist and sys_nerr
 *	symbols exist.
 */
#$d_errlst	ERRLST	/**/
#endif

/* USE_FLOCK_LOCKING
 *	This symbol, if defined, indicates that the flock mailbox locking should be used.
 */
/* USE_DOTLOCK_LOCKING
 *	This symbol, if defined, indicates that the .lock mailbox locking should be used.
 */
/* USE_FCNTL_LOCKING
 *	This symbol, if defined, indicates that SYSV style fcntl file locking should be used.
 */
#$d_compile_flock   COMPILE_FLOCK_LOCKING	/**/
#ifdef COMPILE_FLOCK_LOCKING
#$d_flock	    USE_FLOCK_LOCKING		/**/
#endif

#$d_dotlock	    USE_DOTLOCK_LOCKING		/**/

#$d_compile_fcntl   COMPILE_FCNTL_LOCKING	/**/
#ifdef COMPILE_FCNTL_LOCKING
#$d_fcntlock	    USE_FCNTL_LOCKING		/**/
#endif

/* FTRUNCATE:
 *	This symbol, if defined, indicates that the ftruncate() routine exists.
 */
#$d_ftruncate	FTRUNCATE		/**/

/* GETHOSTNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	gethostname() routine to derive the host name.  See also DOUNAME.
 */
/* DOUNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	uname() routine to derive the host name.  See also GETHOSTNAME.
 */
#$d_gethname	GETHOSTNAME	/**/
#$d_douname	DOUNAME		/**/

/* HAVETERMLIB:
 *	This symbol, when defined, indicates that termlib-style routines
 *	are available.  
 * I_TERM:
 *      Include <term.h>
 * I_CURSES:
 *      Include also <curses.h> (before <term.h>)
 */
#$d_havetlib	HAVETERMLIB	/**/
#ifdef HAVETERMLIB
#$i_term        I_TERM          /**/
#$i_curses      I_CURSES        /**/
#endif

/* HAVE_INT128:
	This symbol, if defined, indicates that the C program may use
	__int128 type
*/
#$d_have_int128	HAVE_INT128	/**/

/* index:
 *	This preprocessor symbol is defined, along with rindex, if the system
 *	uses the strchr and strrchr routines instead.
 */
/* rindex:
 *	This preprocessor symbol is defined, along with index, if the system
 *	uses the strchr and strrchr routines instead.
 */
#$d_index	index strchr	/* cultural */
#$d_index	rindex strrchr	/*  differences? */

/* ISPELL:
 *	This symbol, if defined, indicates that the GNU ispell
 *	spelling checker that is available to Elm.
 */
/* ISPELL_PATH:
 *	This symbol contains the path to the GNU ispell
 *	spelling checker that is available to Elm.
 */
/* ISPELL_OPTIONS:
 *	This symbol contains the options to the GNU ispell
 *	spelling checker that is available to Elm.
 */
#$d_ispell	ISPELL	/**/
#ifdef ISPELL
#define		ISPELL_PATH	"$ispell_path" /**/
#define		ISPELL_OPTIONS	"$ispell_options" /**/
#endif

/* I_LOCALE:
 *	This symbol, if defined, indicates that the file locale.h
 *	should be included
 */
/* I_NL_TYPES:
 *	This symbol, if defined, indicates that the file nl_types.h
 *	should be included
 */
/* MSGCAT:
 *	This symbol, if defined, indicates that the MSGCAT NLS libraries
 *	are available.
 */
#$i_locale	I_LOCALE	/**/
#$i_nl_types	I_NL_TYPES	/**/
#$d_msgcat	MSGCAT		/**/
#$have_codeset  HAVE_CODESET    /**/
#ifdef HAVE_CODESET
#define         ASCII_CODESET   $ascii_codeset_val
#endif
#$d_wchar       WCHAR           /**/
#$d_wcwidth     WCWIDTH         /**/

/* MALLOCVOID:
 *	This symbol, if defined, indicates that the malloc_t type should
 *	be void * instead of char *
 */
#$d_mallocvoid	MALLOCVOID	/**/

/* ALLOW_MAILBOX_EDITING:
 *	This symbol, if defined, indicates that the E)dit mailbox
 *	function is to be allowed.
 */
#$d_mboxedit	ALLOW_MAILBOX_EDITING	/**/

/* MIME:
 *	This symbol defines default path to metamail.
 *          Special values:    none         Don't call metamail
 *                             metamail     Call metamail if environment
 *                                          variable NOMETAMAIL is not defined
 */                     
#define METAMAIL_PATH    "$metamail_path"


/* MAILER_BV_OK
 *   mailer -bv address     is OK
 */
#$mailer_bv_ok		MAILER_BV_OK   /**/

/* DEFAULT_8BITMIME
 *     Mailer accepts -B8BITMIME option
 *     -B == BODYTYPE
 */
#$d_8bitmime     DEFAULT_8BITMIME      /**/

/* DEFAULT_BINARYMIME
 *     Mailer accepts -BBINARYMIME option
 *     -B == BODYTYPE
 *
 * Elm don't yet fully support BINARYMIME: it requires that lines are
 * terminated with \r\n, Unix's \n isn't sufficient!
 * That is only partially implemented in this version of Elm.
 *
 * Quote from RFC 1830 (Experimental Protocol): 
 *  SMTP Service Extensions for Transmission of Large and Binary MIME Messages
 *
 *      It is important to note that when using BINARYMIME, it is
 *      especially important to ensure that the MIME message itself is
 *      properly formed.  In particular, it is essential that text be
 *      canonically encoded with each line properly terminated with <CR>
 *      <LF>.  Any transformation of text into non-canonical MIME to
 *      observe local storage conventions must be reversed before sending
 *      as BINARYMIME.  The usual line-oriented shortcuts will break if
 *      used with BINARYMIME.
 */
#$d_binarymime     DEFAULT_BINARYMIME      /**/

/*
 *  If mailer support DSN via options -N -V -R
 */
#$d_dsn            DEFAULT_DSN      /**/

/* MMDF:
 *	This symbol, if defined, indicates that mailboxes are in
 *	the MMDF format.
 */
#$d_mmdf	MMDF	/**/

/* AUTO_BACKGROUND:
 *	This symbol, if defined, indicates that newmail should go to
 *	the background automatically.
 */
#$d_newauto AUTO_BACKGROUND /**/

/* DONT_ADD_FROM:
 *	This symbol, if defined, indicates that elm should not add
 *	the From: header
 */
/* USE_DOMAIN:
 *	This symbol, if defined, indicates that elm should add
 *	the domain name to our address
 */
#$d_noaddfrom	DEFAULT_DONT_ADD_FROM /**/
#$d_usedomain	DEFAULT_USE_DOMAIN /**/

/* NO_XHEADER:
 *	This symbol, if defined, will not automatically add "X-Mailer:"
 *	headers.
 */
#$d_noxheader	NO_XHEADER	/**/

/* PIDCHECK:
 *	This symbol, if defined, means that the kill(pid, 0) will
 *	check for an active pid.
 */
#$d_pidcheck PIDCHECK		/**/

/* PTEM:
 *	This symbol, if defined, indicates that the sys/ptem.h include file is
 *	needed for window sizing.
 */
#$d_ptem	PTEM		/**/

/* PUTENV:
 *	This symbol, if defined, indicates that putenv() exists.
 */
#$d_putenv	PUTENV	/**/

/* MAX_ATTEMPTS:
 *	This symbol defines to the C code the number of times to try
 *	locking the mail file.
 */
#define MAX_ATTEMPTS	$maxattempts

/* SIGVEC:
 *	This symbol, if defined, indicates that BSD reliable signals routine
 *	sigvec is available.
 */
/* SIGVECTOR:
 *	This symbol, if defined, indicates that the sigvec() routine is called
 *	sigvector() instead, and that sigspace() is provided instead of
 *	sigstack().  This is probably only true for HP-UX.
 */
/* SIGSET:
 *	This symbol, if defined, indicates that BSD reliable signal routine
 *	sigset is available.
 */
/* POSIX_SIGNALS:
 *	This symbol, if defined, indicated that POSIX sigaction
 *	routine is available.
 */
/* HASSIGHOLD:
 *	This symbol, if defined, indicates that sighold routine is
 *	available.
 */
/* HASSIGBLOCK
 *	This symbol, if defined, indicates that the sigblock routine is
 *	available.
 */
/* HASSIGPROCMASK:
 *	This symbol, if defined, indicates that POSIX sigprocmask
 *	routine is available.
 */
#$d_sigvec	SIGVEC		/**/

#$d_sigvectr	SIGVECTOR	/**/

#$d_sigset	SIGSET	/**/

#$d_sigaction	POSIX_SIGNALS	/**/

#$d_sighold	HASSIGHOLD	/**/

#$d_sigblock	HASSIGBLOCK	/**/

#$d_sigprocmask	HASSIGPROCMASK	/**/

#$d_waitpid	HASWAITPID	/**/

/* STRSPN:
 *	This symbol, if defined, indicates that the strspn() routine exists.
 */
/* STRCSPN:
 *	This symbol, if defined, indicates that the strcspn() routine exists.
 */
/* STRPBRK:
 *	This symbol, if defined, indicates that the strpbrk() routine exists.
 */
#$d_strspn	STRSPN		/**/

#$d_strcspn	STRCSPN		/**/

#$d_strpbrk	STRPBRK		/**/

/* STRFTIME:
 *	This symbol, if defined, indicates that strftime() exists.
 */
#$d_strftime	STRFTIME	/**/

/* MKTIME:
 *	This symbol, if defined, indicates that mktime() exists.
 */
#$d_mktime	MKTIME	/**/


/* GETUSERSHELL:
 *	This symbol, if defined, indicates that getusershell() exists.
 */
#$d_getusershell	GETUSERSHELL	/**/


/* STRINGS:
 *	This symbol, if defined, indicates that the file strings.h
 *	should be included not string.h
 */
/* PWDINSYS:
 *	This symbol, if defined, indicates that the file pwd.h
 *	is in the sys sub directory
 */
#$d_strings	STRINGS		/**/
#$d_pwdinsys	PWDINSYS	/**/

/* STRSTR:
 *	This symbol, if defined, indicates that strstr() exists.
 */
#$d_strstr	STRSTR	/**/

/* STRTOK:
 *	This symbol, if defined, indicates that strtok() exists.
 */
#$d_strtok	STRTOK	/**/

/* ALLOW_SUBSHELL:
 *	This symbol, if defined, indicates that the '!' subshell
 *	function is to be allowed at various places.
 */
#$d_subshell	ALLOW_SUBSHELL	/**/

/* TEMPNAM:
 *	This symbol, if defined, indicates that the tempnam() routine exists.
 */
#$d_tempnam	TEMPNAM		/**/

/* SETLINEBUF:
 * 	This symbol, if defined, indicates that the setlinebuf() routine 
 *      exists.
 */
#$d_setlinebuf	SETLINEBUF	/**/

/* TERMIOS:
 *	This symbol, if defined, indicates that the program should include
 *	termios.h rather than sgtty.h or termio.h.  There are also differences
 *	in the ioctl() calls that depend on the value of this symbol.
 */
/* TERMIO:
 *	This symbol, if defined, indicates that the program should include
 *	termio.h rather than sgtty.h.  There are also differences in the
 *	ioctl() calls that depend on the value of this symbol.
 */
#$d_termios	TERMIOS		/**/

#$d_termio	TERMIO		/**/


/* UTIMBUF:
 *	This symbol is defined if this system defines struct utimbuf.
 */
#$d_utimbuf UTIMBUF		/**/

/* VFORK:
 *	This symbol, if defined, indicates that vfork() exists.
 */
#$d_vfork	VFORK	/**/

/* DEFEDITOR:
 *	This symbol contains the name of the default editor.
 */
/* EDITOROPTS:
 *	This symbol contains the command line options for the default editor.
 */
#define DEFEDITOR "$defeditor"		/**/

#define EDITOROPTS "$editoropts"		/**/

/* BINARY_PACKAGE:
 *	If this variable is set MYDOMAIN will be ignored.
 */
#$build_package	BINARY_PACKAGE   /**/

#ifndef BINARY_PACKAGE
/* MYDOMAIN:
 *	This symbol contains the domain of the host the program is going to
 *	run on.  The domain must be appended to HOSTNAME to form a complete
 *	host name.  The dot comes with MYDOMAIN, and need not be supplied by
 *	the program.  If the host name is derived from PHOSTNAME, the domain
 *	may or may not already be there, and the program should check.
 */
#define MYDOMAIN "$mydomain"		   /**/
#$d_dummydomain DUMMYDOMAIN "$dummydomain"  /**/
#endif

/* I_MEMORY:
 *	This symbol, if defined, indicates that the file memory.h
 *	should be included instead of declaring the memory routines.
 */
#$i_memory	I_MEMORY	/**/

/* I_TIME:
 *	This symbol is defined if the program should include <time.h>.
 */
/* I_SYSTIME:
 *	This symbol is defined if the program should include <sys/time.h>.
 */
/* I_SYSTIMEKERNEL:
 *	This symbol is defined if the program should include <sys/time.h>
 *	with KERNEL defined.
 */
/*
* S_TIMEVAL
*	This symbol indicates that struct timeval is defined
*/
#$i_time		I_TIME	 	/**/
#$i_systime	I_SYSTIME 	/**/
#$d_systimekernel	SYSTIMEKERNEL 	/**/
#$s_timeval    		S_TIMEVAL      /**/

/* GETTIMEOFDAY:
 *	This symbol, if defined, indicates that gettimeofday() 
 *      is available
 * SUSECONDS
 *      This symbol gives either suseconds_t or long
 *
*/
#$d_gettimeofday	 GETTIMEOFDAY	/**/
#ifdef GETTIMEOFDAY
#$d_suseconds SUSECONDS      $suseconds   /**/
#endif

/* CLOCK_GETTIME:
 *	This symbol, if defined, indicates that clock_gettime() 
 *      is available
*/
#$d_clock_gettime	 CLOCK_GETTIME	/**/

/* I_UNISTD:
 *	This symbol, if defined, indicates that the file unistd.h
 *	should be included instead of declaring the unistd routines.
 */
#$i_unistd	I_UNISTD	/**/

/* I_UTIME:
 *	This symbol, if defined, indicates that the file utime.h
 *	should be included instead of declaring our own utimbuf.
 */
/* I_USYSTIME:
 *	This symbol, if defined, indicates that the file sys/utime.h
 *	should be included instead of declaring our own utimbuf.
 */
#$i_utime	I_UTIME	/**/
#$i_sysutime	I_SYSUTIME	/**/

/* PASSNAMES:
 *	This symbol, if defined, indicates that full names are stored in
 *	the /etc/passwd file.
 */
/* BERKNAMES:
 *	This symbol, if defined, indicates that full names are stored in
 *	the /etc/passwd file in Berkeley format (name first thing, everything
 *	up to first comma, with & replaced by capitalized login ID, yuck).
 */
/* USGNAMES:
 *	This symbol, if defined, indicates that full names are stored in
 *	the /etc/passwd file in USG format (everything after - and before ( is
 *	the name).
 */
#$d_passnames	PASSNAMES /*  (undef to take name from ~/.fullname) */
#$d_berknames	BERKNAMES /* (that is, ":name,stuff:") */
#$d_usgnames	USGNAMES  /* (that is, ":stuff-name(stuff):") */

/* SIG_TYPE:
 *	This symbol contains the type name of the signal handler functions.
 */
#define	SIGHAND_TYPE	$sigtype

/* TZNAME_USE_xxxxxx:
 *	Specify how to get timezone name.  Possible values are:
 *		 TZNAME_USE_TM_NAME	use (struct tm *)->tm_name
 *		 TZNAME_USE_TM_ZONE	use (struct tm *)->tm_zone
 *		 TZNAME_USE_TZNAME	use "tzname[]" external
 *		 TZNAME_USE_TIMEZONE	use timezone() function
 */
#define TZNAME_USE_$tzname_handling

/* XENIX:
 *	This symbol, if defined, indicates this is a Xenix system,
 *	for knocking  out the far keyword in selected places.
 */
/* BSD_TYPE:
 *	This symbol, if defined, indicates this is a BSD type system,
 */
#$d_xenix	XENIX	/**/
#$d_bsd	BSD_TYPE	/**/

/* USE_PGP:
 *	This symbol, if defined, means that PGP support should be compiled in.
 */
/* PGP2_PATH:
 *	The path to the PGP 2 binary.
 */
#$d_pgp USE_PGP /**/
#ifdef USE_PGP
#define PGP2_PATH "$pgp2_path"
#define PGP5_DIR "$pgp5_dir"
#define GPG_PATH "$gpg_path"

#endif

/* SHARED_LIBS:
 *    This symbol is defined, if shared libraries (.so) defined
 * USE_DLOPEN:
 *    This symbol is defined, if dlopen() can be used
 */
#$d_shared SHARED_LIBS   /**/
#$d_dlopen_libs USE_DLOPEN /**/


!GROK!THIS!
