case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH = "
    regarg=
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    regarg="-A \"$source_dir/$subdir/\""
    ;;
esac



#   Eliminate complaints about duplicate makefile entries if mansrc and
#   catmansrc are both "none".
if [ $mansrc = "none" ]; then mansrc="man-none"; fi
if [ $catmansrc = "none" ]; then catmansrc="catman-none"; fi

echo "Extracting doc/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.27 2024/06/10 18:05:34 hurtta Exp $
#
# Modified by Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#	       	      (was hurtta+elm@posti.FMI.FI)
#             Kari Hurtta <elm@elmme-mailer.org>
####################################################################
# Based on Elm 2.4 doc/Makefile.SH. That code was following copyright:
#
#  Makefile for the documentation of the ELM mail system
#
#         (C) Copyright 1988-1992, USENET Community Trust
#####################################################################
#  Incorparated Elm 2.5 code from doc/Makefile.SH.
#  That code was following copyright:
#
#  Makefile for the documentation of the ELM mail system
#
#         (C) Copyright 1988-1992, USENET Community Trust
#
#####################################################################
# Variables
#	Variables established by Configure
CHMOD		=	$chmod
CP		=	$cp
SED		=       $sed
SUBS           =       's"\#LIB\#"$lib"g; s"\#ETC\#"$etc"g;'
DEST		=	$bin
ECHO		=	$echo
LIB		=	\$(ELM_ROOT)//$lib
LN		=	$ln
MAN		=	\$(ELM_ROOT)//$mansrc
MANEXT		=	$manext
CATMAN		=	\$(ELM_ROOT)//$catmansrc
CATMANEXT	=	$catmanext
RM		= 	$rm -f
TBL       	=	$tbl
MANROFF		=	$manroff
MANROFF_OPTS	=	$manroffopts
MV		=	$mv
TEST		=	$test
SUFFIX		=	$suffix
PACKED		=	$packed
PACKER		=	$packer
$vpathdef
REGARG		=	$regarg
!GROK!THIS!


case "$d_dlopen_libs" in
define)  regman="\$(MAN)/elmlibregister\$(MANEXT)"
	 regcat="\$(CATMAN)/elmlibregister\$(CATMANEXT)\$(SUFFIX)"
	 regcatman="catman/elmlibregister\$(CATMANEXT)\$(SUFFIX)"
	 ;;
*)	 regman=
	 regcat=
	 regcatman=
	;;
esac
cat >>Makefile <<!GROK!THIS!
REGMAN		= $regman
REGCAT		= $regcat
REGCATMAN	= $regcatman

!GROK!THIS!

if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

case "$install_prefix" in
	/*)
	echo "MANROOT       =  \$(ELM_ROOT)//$install_prefix/man" >> Makefile
	;;
	*)
	echo "MANROOT       =  " >> Makefile
	;;
esac

cat >>Makefile <<'!NO!SUBS!'

#	Other variables
SHELL		=	/bin/sh
REG		=	../bin/elmregister $(REGARG)

# List of installed man pages (except for wnemail.1 - handled differently)
MAN_LIST1	=	$(MAN)/checkalias$(MANEXT)	\
			$(MAN)/elm$(MANEXT)		\
			$(MAN)/elmalias$(MANEXT)	\
			$(MAN)/fastmail$(MANEXT)	
MAN_LIST2	=	$(MAN)/frm$(MANEXT)		\
			$(MAN)/listalias$(MANEXT)	\
			$(MAN)/messages$(MANEXT)	\
			$(MAN)/newalias$(MANEXT)	\
			$(MAN)/newmail$(MANEXT)	
MAN_LIST3	=	$(MAN)/printmail$(MANEXT)	\
			$(MAN)/readmsg$(MANEXT)		\
			$(MAN)/elmcharset$(MANEXT)	\
			$(MAN)/elmconfwriter$(MANEXT)	\
			$(MAN)/elmiso2022sets$(MANEXT)	\
			$(MAN)/elmrc-write$(MANEXT)	
MAN_LIST4	=	$(MAN)/elmterminal$(MANEXT)	\
			$(MAN)/elmmimetypes$(MANEXT)	\
			$(MAN)/elmmailinglists$(MANEXT)	\
			$(MAN)/elmmailservices$(MANEXT)	\
			$(MAN)/elmaliases-write$(MANEXT)	\
			$(MAN)/elmunidata$(MANEXT)	\
			$(MAN)/elmbindata$(MANEXT)	
MAN_LIST5	=	$(MAN)/elmstringconvert$(MANEXT) \
			$(MAN)/elmtagfilterents$(MANEXT) \
			$(MAN)/prlong$(MANEXT)		\
			$(MAN)/elmregister$(MANEXT)     \
			$(MAN)/elmhashmarks$(MANEXT)	\
			$(REGMAN)
MAN_LIST	=	$(MAN_LIST1) $(MAN_LIST2) $(MAN_LIST3) $(MAN_LIST4) $(MAN_LIST5)

# List of installed catman pages (except for wnemail.1 - handled differently)
CATMAN_LIST1	=	$(CATMAN)/checkalias$(CATMANEXT)$(SUFFIX)\
			$(CATMAN)/elm$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmalias$(CATMANEXT)$(SUFFIX)\
			$(CATMAN)/fastmail$(CATMANEXT)$(SUFFIX)	
CATMAN_LIST2	=	$(CATMAN)/frm$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/listalias$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/messages$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/newalias$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/newmail$(CATMANEXT)$(SUFFIX)	
CATMAN_LIST3	=	$(CATMAN)/printmail$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/readmsg$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmcharset$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmconfwriter$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmiso2022sets$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmrc-write$(CATMANEXT)$(SUFFIX) 
CATMAN_LIST4	=	$(CATMAN)/elmterminal$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmmimetypes$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmmailinglists$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmmailservices$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmaliases-write$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmunidata$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmbindata$(CATMANEXT)$(SUFFIX) 
CATMAN_LIST5	=	$(CATMAN)/elmstringconvert$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmtagfilterents$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/prlong$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmregister$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmhashmarks$(CATMANEXT)$(SUFFIX) \
			$(REGCAT)
CATMAN_LIST	=	$(CATMAN_LIST1) $(CATMAN_LIST2) $(CATMAN_LIST3) \
		$(CATMAN_LIST4) $(CATMAN_LIST5)

# List of formatted pages for catman
FORMATTED_PAGES_LIST =	catman/checkalias$(CATMANEXT)$(SUFFIX)\
			catman/elm$(CATMANEXT)$(SUFFIX)	\
			catman/elmalias$(CATMANEXT)$(SUFFIX)\
			catman/fastmail$(CATMANEXT)$(SUFFIX)	\
			catman/frm$(CATMANEXT)$(SUFFIX)	\
			catman/listalias$(CATMANEXT)$(SUFFIX)	\
			catman/messages$(CATMANEXT)$(SUFFIX)	\
			catman/newalias$(CATMANEXT)$(SUFFIX)	\
			catman/newmail$(CATMANEXT)$(SUFFIX)	\
			catman/printmail$(CATMANEXT)$(SUFFIX)	\
			catman/readmsg$(CATMANEXT)$(SUFFIX)     \
			catman/elmcharset$(CATMANEXT)$(SUFFIX)	\
			catman/elmconfwriter$(CATMANEXT)$(SUFFIX)	\
			catman/elmrc-write$(CATMANEXT)$(SUFFIX)	\
			catman/elmterminal$(CATMANEXT)$(SUFFIX) \
			catman/elmmimetypes$(CATMANEXT)$(SUFFIX) \
			catman/elmmailinglists$(CATMANEXT)$(SUFFIX) \
			catman/elmmailservices$(CATMANEXT)$(SUFFIX) \
			catman/elmaliases-write$(CATMANEXT)$(SUFFIX) \
			catman/elmunidata$(CATMANEXT)$(SUFFIX) \
			catman/elmbindata$(CATMANEXT)$(SUFFIX) \
			catman/elmstringconvert$(CATMANEXT)$(SUFFIX) \
			catman/prlong$(CATMANEXT)$(SUFFIX) \
			catman/elmregister$(CATMANEXT)$(SUFFIX)	\
			catman/elmhashmarks$(CATMANEXT)$(SUFFIX)	\
			$(REGCATMAN)

INFO_LIST	=	$(LIB)/elmrc-info \
  $(LIB)/elmaliases-info $(LIB)/elmmimetypes-info \
  $(LIB)/elmterminalinfo-info $(LIB)/elmmimecharsets-info \
  $(LIB)/elmmailinglists-info $(LIB)/elmmailservices-info \
  $(LIB)/elmiso2022sets-info $(LIB)/elmhashmarks-info \
  $(LIB)/elmtagfilent-info  $(LIB)/elmlastread-info

# List of files installed in LIB directory

LIB_LIST	= $(INFO_LIST)

# Remove obsolete files
RMLIST          = rm-help-main rm-help-pager rm-help-alias rmlist_s \
 rm-help-fbrowser rm-help-options rm-help-fboptions

# Targets

!NO!SUBS!

cat >>Makefile <<!GROK!THIS!
all: Makefile 
	@if \$(TEST) $catmansrc != catman-none; then \$(MAKE) formatted_pages ;  else true ; fi

install_s: \$(LIB_LIST) \$(RMLIST)
	@if \$(TEST) $mansrc != man-none; then \$(MAKE) install_man ; \
 else \$(MAKE) rmclass_man ;  fi
	@if \$(TEST) $catmansrc != catman-none; then \$(MAKE) install_catman ; \
 else   \$(MAKE) rmclass_catman ;  fi

uninstall_s: \$(RMLIST) rmclass_man rmclass_catman
	\$(REG) rm \$(LIB_LIST) 
	@if \$(TEST) $mansrc != man-none; then  \
		\$(REG) rm \$(MAN_LIST) \$(MAN)/wnewmail\$(MANEXT) \$(MAN)/nfrm\$(MANEXT) \$(MAN)/elmuninstall\$(MANEXT); \
	else \
		true ; \
	fi
	@if \$(TEST) $catmansrc != catman-none; then \
		\$(REG) rm \$(CATMAN_LIST) \$(CATMAN)/wnewmail\$(CATMANEXT)\$(SUFFIX) \$(CATMAN)/nfrm\$(CATMANEXT)\$(SUFFIX) \$(CATMAN)/elmuninstall\$(CATMANEXT)\$(SUFFIX); \
	else \
		true ; \
	fi

rmlist_s:
	@if \$(TEST) $mansrc != man-none; then \$(MAKE) rm-answer-man ;  else true ; fi
	@if \$(TEST) $catmansrc != catman-none;  then \$(MAKE) rm-answer-catman ;  else true ; fi

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	The following are no-ops
lint:
clean:	

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

elm.1.subs: elm.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
chkalias.1.subs: chkalias.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmalias.1.subs: elmalias.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmcharset.1.subs: elmcharset.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmconfwriter.1.subs: elmconfwriter.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmiso2022sets.1.subs: elmiso2022sets.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmrc-write.1.subs: elmrc-write.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmterminal.1.subs: elmterminal.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmmimetypes.1.subs: elmmimetypes.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmmailinglists.1.subs: elmmailinglists.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmmailservices.1.subs: elmmailservices.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmaliases-write.1.subs: elmaliases-write.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmunidata.1.subs: elmunidata.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmbindata.1.subs: elmbindata.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
fastmail.1.subs: fastmail.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
frm.1.subs: frm.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
listalias.1.subs: listalias.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
messages.1.subs: messages.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
newalias.1.subs: newalias.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
printmail.1.subs: printmail.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
readmsg.1.subs: readmsg.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
newmail.1.subs: newmail.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmstringconvert.1.subs: elmstringconvert.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmtagfilterents.1.subs: elmtagfilterents.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
prlong.1.subs: prlong.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmregister.1.subs: elmregister.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmlibregister.1.subs: elmlibregister.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@
elmhashmarks.1.subs: elmhashmarks.1
	$(RM) $@
	$(SED) $(SUBS) < $? > $@

formatted_pages: catman $(FORMATTED_PAGES_LIST)

catman:
	mkdir catman

install_man: $(MANROOT) $(MAN) $(MAN_LIST) $(MAN)/wnewmail$(MANEXT) $(MAN)/nfrm$(MANEXT) $(MAN)/elmuninstall$(MANEXT)
	$(REG) classify manpages $(MAN_LIST1) 
	$(REG) classify manpages $(MAN_LIST2)
	$(REG) classify manpages $(MAN_LIST3)  
	$(REG) classify manpages $(MAN_LIST4)  
	$(REG) classify manpages $(MAN_LIST5)  
	$(REG) classify manpages $(MAN)/wnewmail$(MANEXT) $(MAN)/nfrm$(MANEXT) $(MAN)/elmuninstall$(MANEXT)

$(MAN):
	$(REG) mkdir $(MAN)

rmclass_man:
	$(REG) rmclass manpages

install_catman: $(MANROOT) $(CATMAN) $(CATMAN_LIST) $(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX) \
 $(CATMAN)/nfrm$(CATMANEXT)$(SUFFIX) $(CATMAN)/elmuninstall$(CATMANEXT)$(SUFFIX) 
	$(REG) classify catmanpages $(CATMAN_LIST1) 
	$(REG) classify catmanpages $(CATMAN_LIST2) 
	$(REG) classify catmanpages $(CATMAN_LIST3) 
	$(REG) classify catmanpages $(CATMAN_LIST4) 
	$(REG) classify catmanpages $(CATMAN_LIST5) 
	$(REG) classify catmanpages $(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX) \
 $(CATMAN)/nfrm$(CATMANEXT)$(SUFFIX) $(CATMAN)/elmuninstall$(CATMANEXT)$(SUFFIX) 

$(CATMAN):
	$(REG) mkdir $(CATMAN)

rmclass_catman:
	$(REG) rmclass catmanpages

#	Dependencies and rules for installing man pages and lib files
rm-answer-man:
				$(REG) remove-installed $(MAN)/answer$(MANEXT)

$(MAN)/checkalias$(MANEXT):	chkalias.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elm$(MANEXT):		elm.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmalias$(MANEXT):	elmalias.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmcharset$(MANEXT):	elmcharset.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmconfwriter$(MANEXT):	elmconfwriter.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmiso2022sets$(MANEXT):	elmiso2022sets.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmrc-write$(MANEXT):	elmrc-write.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmterminal$(MANEXT):	elmterminal.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmmimetypes$(MANEXT):	elmmimetypes.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmmailinglists$(MANEXT):	elmmailinglists.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmmailservices$(MANEXT):	elmmailservices.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmaliases-write$(MANEXT):	elmaliases-write.1.subs
				$(REG) copydoc -m 444 $? $@


$(MAN)/elmunidata$(MANEXT):	elmunidata.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmbindata$(MANEXT):	elmbindata.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/fastmail$(MANEXT):	fastmail.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/frm$(MANEXT):		frm.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/nfrm$(MANEXT):		$(MAN)/frm$(MANEXT)
				$(REG) link        $? $@

$(MAN)/elmuninstall$(MANEXT):		$(MAN)/elmregister$(MANEXT)
				$(REG) link        $? $@

$(MAN)/listalias$(MANEXT):	listalias.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/messages$(MANEXT):	messages.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/newalias$(MANEXT):	newalias.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/newmail$(MANEXT):	newmail.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/printmail$(MANEXT):	printmail.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/readmsg$(MANEXT):	readmsg.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmstringconvert$(MANEXT): elmstringconvert.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmtagfilterents$(MANEXT): elmtagfilterents.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/prlong$(MANEXT): prlong.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmregister$(MANEXT): elmregister.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmlibregister$(MANEXT): elmlibregister.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/elmhashmarks$(MANEXT): elmhashmarks.1.subs
				$(REG) copydoc -m 444 $? $@

$(MAN)/wnewmail$(MANEXT):	$(MAN)/newmail$(MANEXT)
				$(REG) link        $? $@

rm-help-main:
				$(REG) rm $(LIB)/help-main
				$(REG) rm $(LIB)/elm-help.0

rm-help-options:		
				$(REG) rm $(LIB)/help-options
				$(REG) rm $(LIB)/elm-help.1

rm-help-alias:		
				$(REG) rm $(LIB)/help-alias
				$(REG) rm $(LIB)/elm-help.2

rm-help-fbrowser:
				$(REG) rm $(LIB)/help-fbrowser

rm-help-fboptions:		
				$(REG) rm $(LIB)/help-fboptions

rm-help-pager:		
				$(REG) rm $(LIB)/help-pager
				$(REG) rm $(LIB)/elm-help.3

$(LIB)/elmrc-info:		elmrc-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmaliases-info:		elmaliases-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmmimetypes-info:	elmmimetypes-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmterminalinfo-info:	elmterminalinfo-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmmimecharsets-info:	elmmimecharsets-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmmailinglists-info:	elmmailinglists-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmmailservices-info:	elmmailservices-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmiso2022sets-info:	elmiso2022sets-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmhashmarks-info:	elmhashmarks-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmtagfilent-info:	elmtagfilent-info
				$(REG) copy -m 444 $? $@

$(LIB)/elmlastread-info:	elmlastread-info
				$(REG) copy -m 444 $? $@



info-list: $(INFO_LIST)

#	Dependencies and rules for installing catman
rm-answer-catman:
				$(REG) remove-installed $(CATMAN)/answer$(CATMANEXT)$(SUFFIX)

$(CATMAN)/checkalias$(CATMANEXT)$(SUFFIX): catman/checkalias$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elm$(CATMANEXT)$(SUFFIX): catman/elm$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmalias$(CATMANEXT)$(SUFFIX): catman/elmalias$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmcharset$(CATMANEXT)$(SUFFIX): catman/elmcharset$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmconfwriter$(CATMANEXT)$(SUFFIX): catman/elmconfwriter$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmiso2022sets$(CATMANEXT)$(SUFFIX): catman/elmiso2022sets$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmrc-write$(CATMANEXT)$(SUFFIX): catman/elmrc-write$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmunidata$(CATMANEXT)$(SUFFIX): catman/elmunidata$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmbindata$(CATMANEXT)$(SUFFIX): catman/elmbindata$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmterminal$(CATMANEXT)$(SUFFIX): catman/elmterminal$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmmimetypes$(CATMANEXT)$(SUFFIX): catman/elmmimetypes$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmmailinglists$(CATMANEXT)$(SUFFIX): catman/elmmailinglists$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmmailservices$(CATMANEXT)$(SUFFIX): catman/elmmailservices$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmaliases-write$(CATMANEXT)$(SUFFIX): catman/elmaliases-write$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/fastmail$(CATMANEXT)$(SUFFIX): catman/fastmail$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/frm$(CATMANEXT)$(SUFFIX): catman/frm$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/listalias$(CATMANEXT)$(SUFFIX): catman/listalias$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/messages$(CATMANEXT)$(SUFFIX): catman/messages$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/newalias$(CATMANEXT)$(SUFFIX): catman/newalias$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/newmail$(CATMANEXT)$(SUFFIX): catman/newmail$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/printmail$(CATMANEXT)$(SUFFIX): catman/printmail$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/readmsg$(CATMANEXT)$(SUFFIX): catman/readmsg$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX): $(CATMAN)/newmail$(CATMANEXT)$(SUFFIX)
				$(REG) link        $? $@

$(CATMAN)/nfrm$(CATMANEXT)$(SUFFIX): $(CATMAN)/frm$(CATMANEXT)$(SUFFIX)
				$(REG) link        $? $@

$(CATMAN)/elmuninstall$(CATMANEXT)$(SUFFIX): $(CATMAN)/elmregister$(CATMANEXT)$(SUFFIX)
				$(REG) link        $? $@

$(CATMAN)/elmstringconvert$(CATMANEXT)$(SUFFIX): catman/elmstringconvert$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmtagfilterents$(CATMANEXT)$(SUFFIX): catman/elmtagfilterents$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/prlong$(CATMANEXT)$(SUFFIX): catman/prlong$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmregister$(CATMANEXT)$(SUFFIX): catman/elmregister$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmlibregister$(CATMANEXT)$(SUFFIX): catman/elmlibregister$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

$(CATMAN)/elmhashmarks$(CATMANEXT)$(SUFFIX): catman/elmhashmarks$(CATMANEXT)$(SUFFIX)
				$(REG) copydoc -m 444 $? $@

#	Dependencies and rules for making catman pages

catman/checkalias$(CATMANEXT)$(SUFFIX):		chkalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/checkalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/checkalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elm$(CATMANEXT)$(SUFFIX):		elm.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elm$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elm$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmalias$(CATMANEXT)$(SUFFIX):		elmalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmcharset$(CATMANEXT)$(SUFFIX):		elmcharset.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmcharset$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmcharset$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmconfwriter$(CATMANEXT)$(SUFFIX): elmconfwriter.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmconfwriter$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmconfwriter$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmiso2022sets$(CATMANEXT)$(SUFFIX): elmiso2022sets.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmiso2022sets$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmiso2022sets$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmrc-write$(CATMANEXT)$(SUFFIX): elmrc-write.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmrc-write$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmrc-write$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmunidata$(CATMANEXT)$(SUFFIX):		elmunidata.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmunidata$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmunidata$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmbindata$(CATMANEXT)$(SUFFIX):		elmbindata.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmbindata$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmbindata$(CATMANEXT) ; \
	else \
		true ; \
	fi


catman/elmterminal$(CATMANEXT)$(SUFFIX):	elmterminal.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmterminal$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmterminal$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmmimetypes$(CATMANEXT)$(SUFFIX):	elmmimetypes.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmmimetypes$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmmimetypes$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmmailinglists$(CATMANEXT)$(SUFFIX):	elmmailinglists.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmmailinglists$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmmailinglists$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmmailservices$(CATMANEXT)$(SUFFIX):	elmmailservices.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmmailservices$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmmailservices$(CATMANEXT) ; \
	else \
		true ; \
	fi



catman/elmaliases-write$(CATMANEXT)$(SUFFIX):	elmaliases-write.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmaliases-write$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmaliases-write$(CATMANEXT) ; \
	else \
		true ; \
	fi


catman/fastmail$(CATMANEXT)$(SUFFIX):		fastmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/fastmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/fastmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/frm$(CATMANEXT)$(SUFFIX):		frm.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/frm$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/frm$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/listalias$(CATMANEXT)$(SUFFIX):		listalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/listalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/listalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/messages$(CATMANEXT)$(SUFFIX):		messages.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/messages$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/messages$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/newalias$(CATMANEXT)$(SUFFIX):		newalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/newalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/newalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/newmail$(CATMANEXT)$(SUFFIX):		newmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/newmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/newmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/printmail$(CATMANEXT)$(SUFFIX):		printmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/printmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/printmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/readmsg$(CATMANEXT)$(SUFFIX):		readmsg.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/readmsg$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/readmsg$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmstringconvert$(CATMANEXT)$(SUFFIX): elmstringconvert.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmstringconvert$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmstringconvert$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmtagfilterents$(CATMANEXT)$(SUFFIX): elmtagfilterents.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmtagfilterents$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmtagfilterents$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/prlong$(CATMANEXT)$(SUFFIX): prlong.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/prlong$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/prlong$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmregister$(CATMANEXT)$(SUFFIX): elmregister.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmregister$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmregister$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmlibregister$(CATMANEXT)$(SUFFIX): elmlibregister.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmlibregister$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmlibregister$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmhashmarks$(CATMANEXT)$(SUFFIX): elmhashmarks.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmhashmarks$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmhashmarks$(CATMANEXT) ; \
	else \
		true ; \
	fi


!NO!SUBS!

case "$install_prefix" in
	/*)
	cat >>Makefile <<'!NO!SUBS!'
$(MANROOT):
	$(REG) mkdir $(MANROOT)
!NO!SUBS!
esac

