/* $Id: connection_imp.h,v 2.43 2022/11/02 16:26:29 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.43 $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


/* service_list.c -------------------------------------------- */

typedef enum { PORT_end = 0, PORT_smtp = 25, PORT_pop3 = 110, 
	       PORT_imap4 = 143, 

	       /* NOTE: no PORT_smtps = 465 because
		        this registeration is revoked

                        also PORT_submissions replaces this
	       */

	       PORT_submissions = 465,
	       PORT_submission = 587, 
	       
	       PORT_imaps = 993, PORT_pop3s = 995     
} PORTS;

enum connection_state { 
    CON_verify_failure = -2,
    CON_greeting = -1,
    CON_error = 0, CON_open = 1, CON_logged = 2,


};


#ifdef REMOTE_MBX

#ifdef I_NETINET_IN
#include <netinet/in.h>
#endif

#ifdef I_ARPA_INET
#include <arpa/inet.h>
#endif

typedef union socket_addr
{
    /* struct sockaddr is defined on <sys/socket.h> */

    struct sockaddr         sa;     /* generic version */
#ifdef I_NETINET_IN
    struct sockaddr_in     sin;    /* INET family */

#ifdef HAVE_IN6
    /* struct sockaddr_in6 is defined on <netinet/in.h> */
    struct sockaddr_in6    sin6;   /* INET6 family */
#endif
#endif
} SOCKADDR;

union SOCKADDR_ptr {   /* Different ways to access same data */
    void                  * dummy;
    SOCKADDR              * generic;
    struct sockaddr       * sa;     /* generic version */
#ifdef I_NETINET_IN
    struct sockaddr_in    * sin;    /* INET family */
#ifdef HAVE_IN6
    /* struct sockaddr_in6 is defined on <netinet/in.h> */
    struct sockaddr_in6   * sin6;   /* INET6 family */
#endif
#endif       
};

#else
union SOCKADDR_ptr {   /* Different ways to access same data */
    void                  * dummy;
};

#endif

#ifdef REMOTE_MBX
extern const char * give_addr_as_string P_((SOCKADDR *sa,
					    char * mybuffer,
					    size_t buffer_size));

extern const char * give_SOCKADDR_ptr_as_string P_((const union SOCKADDR_ptr addr,
						    const size_t             addrsize,
						    char                   * buffer,
						    size_t                   buffer_size));

#if defined(I_NETINET_IN) && defined(I_ARPA_INET)
extern int give_addr_port P_((SOCKADDR *sa));
extern void set_addr_port P_((SOCKADDR *sa, int port));
extern int get_ip P_((SOCKADDR * result, const char * val));
#endif

#define    STFLAG_browser      0x01
#define    STFLAG_mbox         0x02
#define    STFLAG_smtp_like    0x04
#define    STFLAG_require_port 0x08

#define    STFLAG_is_imap          0x0100
#define    STFLAG_is_pop           0x0200
#define    STFLAG_is_submission    0x0400
#define    STFLAG_is_smtp          0x0800

#define    STFLAG_type_mask        0xFF00

#define SE_given_alias      (1<<0)
#define SE_given_addr       (1<<1)
#define SE_given_port       (1<<2)
#define SE_temporary        (1<<3)
#define SE_static           (1<<4) /* lib/static-hosts.c */
#define SE_given_name_addr  (1<<5)
#define SE_rescan_name_addr (1<<6)
#define SE_ver_tls_cert     (1<<7)
#define SE_nover_tls_cert   (1<<8)
#define SE_require_tls_name (1<<9)
#define SE_given_name_port  (1<<10)
#define SE_rescan_name_port (1<<11)
#define SE_nouse_tls_checks (1<<12)

#ifdef ANSI_C
struct     SE_option;
#endif

/* return:  0 = failure,
            1 = option ok
*/
typedef int SE_option_parse P_((struct     SE_option *X,
				const char       *name,   /* without prefix */
				const char       * value));

/* return: malloced string -- caller must free */
typedef char * SE_option_values P_((struct     SE_option *X, 
				    const char *prefix));

typedef void SE_option_zero   P_((struct     SE_option *X));
typedef void SE_option_free   P_((struct     SE_option *X));
typedef void SE_option_merge  P_((struct     SE_option *target, 
				  struct     SE_option *source));

/* precious options from target with same name are removed */
typedef void SE_option_opdate  P_((struct     SE_option *target, 
				   struct     SE_option *source));

#define SE_option_t_magic       0xF907
#define SERVICE_ENTRY_magic	0xF90B

extern struct service_entry {
    unsigned short magic;                   /* SERVICE_ENTRY_magic */
    int            refcount;

    int      flags;
    char *   official_name;

    union SOCKADDR_ptr ip_literal_address;
    size_t  ip_literal_addrsize;

    struct service_entry_name {
	
	char     * aliasname;
	struct schedule_timelimit   valid_until;            /* absolute time: now + ttl */

    }        * aliases_list;
    int        aliases_count;

    struct service_entry_addr {
	size_t              addrsize;
	union SOCKADDR_ptr  address;
	struct schedule_timelimit     valid_until;          /* absolute time: now + ttl */
	char     * hostname;
    }        * addr_list;
    int        addr_count;
   
    char    ** addr_name_list;
    int        addr_name_count;

    const struct service_type  * service;

    int      * port_list;
    int        port_count;    

    char    ** port_name_list;
    int        port_name_count;


    struct     SE_option {
	struct SE_option_type {
	    unsigned short magic;    /* SE_option_t_magic */
	    SE_option_parse   * parse_on_option;
	    SE_option_values  * give_values;
	    SE_option_zero    * zero_options;
	    SE_option_free    * free_options;	    
	    SE_option_merge   * merge_options;
	    SE_option_opdate  * update_options;
	} * type;
	char * prefix;

	/* Anonymous type */
	struct SE_option_value  * value;       	
    }        * option_list;
    int        option_count;

    struct string   ** req_tls_peername_list;
    int                req_tls_peername_count;

}  * give_service_entry P_((const char *hostname, int flag));   


/* Return 1 if succedd, 0 on failure 

   Check with 		
      if (cancel_p && *cancel_p && is_canceled(*cancel_p))
   if failed for cancelation

   (re)allocates (*res_p) array
   
   Caller must free (*res_p) array
*/


enum lookup_show_message {
    no_lookup_message    = 0,
    show_lookup_message  = 1
};

extern int give_name_from_sockaddr P_((const union SOCKADDR_ptr sockaddr_ptr,
				       const size_t             sockaddr_size,
				       char                 *** res_p,
				       size_t                 * reslen_p,
				       struct cancel_data    ** cancel_p
				       /* May be NULL, Used if dns lookup 
					  was cancelable */,
				       enum lookup_show_message show_message,
				       int                    * was_error_p
				       /* Error message is shown 
					  if was_error_p != NULL */
				       ));


extern int service_type_flags P_((const struct service_type *st,
				  int mask));
extern const char * service_type_name P_((const struct service_type *st));
extern const struct service_type * service_type_from_name 
   P_((const char *ascii_name));
extern PORTS service_type_defport P_((const struct service_type *st));

/* Increments refcount */
extern struct service_entry *convert_service_entry P_(( struct service_entry *source,
							const struct service_type * st));


#define ENUM_SERVICE_TYPE_magic 0xF921

extern const struct enum_service_type {
    unsigned short       magic;    /* ENUM_SERVICE_TYPE_magic */
    
    int                   idx;
    enum init_tls_pass {
	no_init_tls      = -1,
	init_tls_default = 0,
	try_Implicit_TLS,
	try_no_init_tls, 
	NUM_init_tls_pass
    }                      tls_idx;
    int                    mask_idx;
    int                    any_mask;
    const int            * mask_list;
    int                    require_mask;
} NULL_enum_service_type;

extern  void init_enum_service_type P_((struct enum_service_type *est,
					enum init_tls_pass        start_tls_idx,
					int                       any_mask,
					int                       require_mask));
extern  void init_enum_service_list P_((struct enum_service_type * est,
					enum init_tls_pass        start_tls_idx,
					const int                * mask_list,
					int                       require_mask));

extern const struct service_type * enumerate_service_type P_((struct enum_service_type *est));

enum initial_tls_flag { itls_ignore  = -1,
			itls_disable = 0,
			itls_require = 1 };

/* Increments refcount */
extern struct service_entry *scan_mail_services_conf 
   P_((struct mail_services_conf * conf,
       const char                * hostname,
       int                         flag,
       enum initial_tls_flag       initial_tls,
       const struct schedule_timelimit * now,
       SOCKADDR                  * have_ip_literal,
       const struct service_type * st));

extern struct service_entry * give_service_entry2 P_((const char *hostname,
						      int flag,
						      enum initial_tls_flag 
						      initial_tls));
extern struct service_entry * give_service_entry3 P_((const char *hostname,
						      int flag,
						      enum initial_tls_flag 
						      initial_tls,
						      const struct schedule_timelimit * now));

/* Increments refcount */
extern struct service_entry * give_service_entry4 
    P_((const char                 * hostname,
	SOCKADDR                   * have_ip_literal, 
	const struct service_type  * servicetype,
	int                          flag,
	enum initial_tls_flag        initial_tls,
	const struct schedule_timelimit * now));

/*  Increments refcount */

extern struct service_entry * give_service_entry_can
    P_((const char                 * hostname,
	int                         flag,
	enum initial_tls_flag 	     initial_tls,
	const struct schedule_timelimit * now  /* May be NULL */,
	struct cancel_data         ** cancel_p /* May be NULL,
						  Used if dns lookup was
						  cancelable */
	));

/* Increments refcount */
extern struct service_entry * give_service_entry5
    P_((const char                 * hostname,
	SOCKADDR                   * have_ip_literal, 
	const struct service_type  * servicetype,
	int                          flag,
	enum initial_tls_flag        initial_tls,
	const struct schedule_timelimit * now,
	struct cancel_data         ** cancel_p
	/* May be NULL, Used if dns lookup was cancelable */
	));


/* Increments refcount */
extern struct service_entry * give_service_entryS 
   P_((struct service_entry  * value,
       int                          flag,
       enum initial_tls_flag        initial_tls,
       const struct schedule_timelimit * now,
       struct cancel_data         ** cancel_p));

extern int  STFLAG_service_type P_((struct service_entry *se));
extern const char * have_init_tls P_((struct service_entry *se));

extern void free_service_entry P_((struct service_entry **Y));
extern void inc_service_entry_refcount  P_((struct service_entry *Y));

extern int dump_service_entry P_((FILE *f, struct service_entry *entry,
				  charset_t fileset));

extern void free_se_aliases_list P_((struct service_entry * se));
extern void add_alias_to_entry P_((struct service_entry *entry,
				   const char *name,
				   const struct schedule_timelimit * valid_until));
extern void add_se_alias_to_entry P_((struct service_entry      * entry,
				      struct service_entry_name * name,
				      int malloc_it));
extern void free_se_addr_list P_((struct service_entry * se));
extern void add_addr_to_entry P_((struct service_entry *entry,
				  const SOCKADDR * result,
				  const struct schedule_timelimit * valid_until,
				  const char * hostname));
extern void add_se_addr_to_entry P_((struct service_entry *entry,
				     struct service_entry_addr *addr,
				     int    malloc_it));

extern void free_se_addr_name_list P_((struct service_entry * se));
extern void add_addr_name_to_entry P_((struct service_entry *entry,
				       char *name, int malloc_it));

extern void free_se_port_name_list P_((struct service_entry * se));
extern void add_port_name_to_entry P_((struct service_entry *entry,
				       char *name, int malloc_it));

extern void free_se_port_list P_((struct service_entry * se));
extern void add_port_to_entry P_((struct service_entry *entry,
				  int port));

extern int add_option_type_to_entry P_((struct service_entry *entry,
					struct SE_option_type * Y,
					const char * prefix));

extern void free_se_rqtls_pername_list P_((struct service_entry * se));
extern void add_req_peername_to_entry P_((struct service_entry *entry,
					  const struct string * req_peername));

extern int is_similar_service_entry P_((struct service_entry * se1,
					struct service_entry * se2));

/* Return 1 if succeed, 0 if wrong size or unsupported family */
extern int set_SOCKADDR_from_data P_((size_t             * target_addrsize,
				      union SOCKADDR_ptr * target,
				      int                  addrtype,
				      int                  addrlength,
				      char               * addrdata));

/* Return 1 if succeed, 0 if too small, or does not fit */
extern int set_SOCKADDR_from_ptr_helper 
   P_((SOCKADDR * target,
       const size_t             addrsize,
       const union SOCKADDR_ptr source));

extern void l_free_addr_list P_((struct service_entry_addr  ** addr_list,
				 int                         * addr_count));
extern void l_append_addr_list P_((struct service_entry_addr  ** addr_list,
				   int                         * addr_count,
				   struct service_entry_addr *addr,
				   int malloc_it));

extern void l_free_name_list P_((struct service_entry_name  ** aliases_list,
				 int                         * aliases_count));
extern void l_append_name_list P_((struct service_entry_name  ** aliases_list,
				   int                         * aliases_count,
				   struct service_entry_name * alias,
				   int malloc_it));

#define MAIL_SERVICES_magic	0xF90C

extern struct mail_services_conf {
    unsigned short magic;     /* MAIL_SERVICES_magic */
    
    struct service_entry ** service_list;
    int                     service_count;
    
} * malloc_mail_services_conf P_((void));

/* remote_mbx.c ---------------------------------------------- */

/* Number of  'enum ipv_option' values
   or AF_INET and AF_INET6
*/
#define NUM_protocols 2

/* Value on ipv6_option_af is either  AF_INET or AF_INET6 */

/* return number of options */
extern size_t get_ipv_option P_((const int             ** ipv_option_af  /* NULL, if not required */,
				  const enum ipv_option ** ipv_option_c  /* NULL, if not required */));
			   

extern void free_remote_mbx_config P_((void));

extern void set_address_from_gen_helper P_((size_t             * addrsize,
					    union SOCKADDR_ptr * ptr,
					    const SOCKADDR     * generic));
extern int set_address_from_gen_helper2 P_((size_t             * addrsize,
					    union SOCKADDR_ptr * ptr,
					    const SOCKADDR     * generic,
					    size_t               genericsize));

extern int same_SOCKADDR_ptr_generic P_((const union SOCKADDR_ptr addr,
					 size_t                   addrsize,
					 const SOCKADDR         * generic));


extern int same_SOCKADDR_ptr P_((const union SOCKADDR_ptr addr1,
				 size_t                   addr1size,
				 const union SOCKADDR_ptr addr2,
				 size_t                   addr2size,
				 int                      addr_only /* ignore port */));


/* Return 1 if succeed, 0 if too small */
extern int set_SOCKADDR_ptr_helper P_((size_t                 * target_addrsize,
				       union SOCKADDR_ptr     * target,
				       const size_t             source_addrsize,
				       const union SOCKADDR_ptr source));


#endif

struct Read_Buffer {
    char      *read_buffer;
    size_t    read_len;
};
struct Write_Buffer {
    char      *write_buffer;
    int       write_len;
};

extern int ReadFromSocket P_((int fd, struct Read_Buffer *buffer,
			      int wanted));
extern int find_crlf P_((struct Read_Buffer *buffer, int add_null));
extern void zero_Read_Buffer P_((struct Read_Buffer *buffer));
extern void free_Read_Buffer P_((struct Read_Buffer *buffer));
extern void cut_line P_((struct Read_Buffer *buffer, size_t len));
extern void zero_Write_Buffer P_((struct Write_Buffer *buffer));
extern void free_Write_Buffer P_((struct Write_Buffer *buffer));
extern int WriteToSocket P_((int fd, struct Write_Buffer *buffer));
extern void cut_Write_Buffer P_((struct Write_Buffer *buffer, int n));
extern void add_to_Write_Buffer P_((struct Write_Buffer *buffer,
				    char **str,int l));

#ifdef REMOTE_MBX


#define REMOTE_ACCOUNT_magic    0xF504

extern struct remote_account {
    unsigned short magic;    /* REMOTE_ACCOUNT_magic */
    
    size_t    addrsize;
    
    /* Different ways to access same data */
    union SOCKADDR_ptr hostaddr;
    char             * hostname;  /* name corresponding to hostaddr */ 

    struct streamsched *stream;
    struct service_entry *service;

    char    * username;
    char    * host;

    /* Only used if getsockname() is supported */
    size_t             socknamesize;
    union SOCKADDR_ptr socknameaddr;
    
    
} * malloc_remote_account P_((const char *username, const char *host));

extern void zero_remote_account P_((struct remote_account *ra));
extern void clear_remote_account P_((struct remote_account *ra));
extern void clear_remote_account0 P_((struct remote_account *ra,
				      int seen_badpid));
extern void free_remote_account P_((struct remote_account **ra));

extern int connect_remote_account P_((struct remote_account *ra,
				      int *got,
				      struct service_entry *se,
				      const PORTS default_portlist[],
				      const PORTS force_port,
				      struct cancel_data *main_cancel /* Used if
									 dns lookup was
									 cancelable */
				      ));


extern int connect_remote_account_2 P_((struct remote_account      * ra,
					struct service_entry       * initial_se,
					struct cancel_data *main_cancel
					/* Used if  dns lookup was  
					   cancelable */                ,
					
					struct service_entry      ** result_se
					/* Increments refcount   */     ,
					const struct service_type ** got_type,
					int                        * got_port,
					
					
					/* For enumerate_service_type */
					struct enum_service_type *est));

/* -1 == name not found or bad syntax
    0 == not a remote address
    1 == name found 
    2 == no lookup (se == NULL)
*/

extern int split_remote_name P_((const char *name,
				 struct remote_account *X,
			 struct service_entry **se /* NULL if no lookup */,
				 char **rest,
				 int lookup_flags,
	struct cancel_data         ** cancel_p /* May be NULL,
						  Used if dns lookup was
						  cancelable */

				 ));


extern int remote_account_OK P_((size_t st_size));

/* Makes new connection to same host */
extern int connect_remote_account_1 P_((struct remote_account *ra,
					const struct remote_account *ra_from));

extern enum itls_status {
    itls_unsupported = -2   /* initial tls not supported */,
	itls_failed  = -1   /* initial tls failed        */,
	itls_none    =  0   /* no   initial tls                      */,
	itls_done    =  1   /* initial tls, initialized */
	} remote_account_init_tls P_((struct remote_account *ra));

union ra_verify_peer_cb_data {
    void                    * data;
    struct mailer_info_1    * mailer;
    struct smtp_info        * smtp;
    struct folder_info      * folder;
    struct connection_cache * connection;
};

/* return 1 if cb success, 0 failure
   return -1 no connection
 */
typedef int ra_verify_peer_cb_f P_((struct remote_account *ra,
				    union ra_verify_peer_cb_data *data,
				    const struct string * Server,
				    const struct string * server));

/* cb is called so that possible STARTTLS is started */


/* 1 verify OK
   0 verify failed
  -1 no connection or other failure
*/

extern int remote_account_verify_peer P_((struct remote_account *ra,
					  union ra_verify_peer_cb_data *data,
					  ra_verify_peer_cb_f * cb,
					  const struct string * Server,
					  const struct string * server));



#ifdef ANSI_C
struct connection_cache;
struct folder_browser;
struct browser_passhm;
#endif

typedef void  cache_zero_connection P_((struct connection_cache *c));
typedef void  cache_free_connection P_((struct connection_cache *c));

typedef int  cache_open_connection P_((struct connection_cache *c));
typedef int  cache_login_connection P_((struct connection_cache *c,
					const struct string *password /* May be NULL */));
typedef int  cache_close_connection P_((struct connection_cache *c,
					struct cancel_data  * cd
					));

typedef void cache_folder_from_connection P_((struct connection_cache *c,
					      struct folder_info *f));
typedef void cache_browser_from_connection P_((struct connection_cache *c,
					       struct folder_browser *d));

typedef struct string * cache_verify_server_const P_((void));

/* return 1 if cb success, 0 failure
   return -1 no connection
 */
typedef int cache_verify_cb_connection P_((struct connection_cache *c,
					   struct remote_account *ra,
					   const struct string * Server,
					   const struct string * server));

typedef int  cache_open_connection_hm P_((struct connection_cache *c,
					  struct browser_passhm *passhm,
					  int  * use_passhm));


#define CONNECTION_TYPE_magic   0xF906

struct connection_type { 
    unsigned short                magic;   /* CONNECTION_TYPE_magic */
    const char                    * type_name;
    cache_zero_connection         * cache_zero_it;
    cache_free_connection         * cache_free_it;
    cache_open_connection         * cache_open_it;
    cache_login_connection        * cache_login_it;
    cache_close_connection        * cache_close_it;      
    cache_folder_from_connection  * cache_folder_from_it;
    cache_browser_from_connection * cache_browser_from_it;
    cache_verify_server_const     * cache_verify_server_const;
    cache_verify_server_const     * cache_verify_Server_const;
    cache_verify_cb_connection    * cache_verify_cb_connection;
    cache_open_connection_hm      * cache_open_hm_it;
};

/* Structure is on connection cache list if not given to
   folder - structure ...
*/


#define CONNECTION_CACHE_magic	0xF916

struct connection_cache {
    unsigned short magic;   /* CONNECTION_CACHE_magic */
    struct connection_type  * type;

    /* Either one from these only should be on non-NULL */
    struct connection_cache * next;       
    struct folder_info      *f;
    struct folder_browser   *d;

    struct remote_account   C;
    struct remote_server   * this_server;  

    uint16                  port;    /* 0 == default port */
    enum connection_state   state;
    int                     seen_badpid;

    union {
	void                         * any;
	struct generic_connection_1  * g1_con;
	struct generic_connection_2  * g2_con;

        struct IMAP_CON              * imap_con;
    } a;

    struct mail_quota        * quota;  /* Not refcounted */;
};

extern int connection_match_username_host P_((const struct connection_cache *c,
					      const char *username,
					      const char *host));

/* May not be 
       uin16 port
   because this is promoted to int
*/

extern struct connection_cache * locate_from_cache_1 
   P_((const struct remote_account *ra,
       const struct connection_type  *con_type,
       int port));

/* May not be 
      uin16 port
   because this is promoted to int
*/

extern struct connection_cache * 
locate_from_cache P_((const char * username,
		      const char * host,
		      const struct connection_type *con_type,
		      int port    /* 0 == default port */,
		      struct service_entry * se));

extern enum connection_state get_connection_state P_((const struct connection_cache *c));
extern void set_connection_state P_((struct connection_cache *c,
				     enum connection_state s));

extern struct connection_cache * create_connection P_((struct connection_type *T));

/* If wait canceled, may return 0
   connection is always free'ed
*/
extern int  free_connection P_((struct connection_cache **c,
				 struct cancel_data  * cd
				 ));

extern int  join_connection P_((struct connection_cache *c,
				struct remote_account *X,
				enum connection_state st));
extern int  join_connection_hm P_((struct connection_cache *c,
				   struct remote_account *X,
				   enum connection_state st,
				   struct browser_passhm *passhm));


/* return 1 if cb success, 0 failure return -1 no connection
 */
extern int prepare_connection_verify P_((struct connection_cache *c));

extern int login_connection P_((struct connection_cache *c,
				const struct string *password /* May be NULL */));

extern int login_connection_hm P_((struct connection_cache *c,
				   struct browser_passhm *passhm));

extern void folder_from_connection P_((struct connection_cache *c,
				       struct folder_info *f));

/* Sets *c = NULL */
extern void browser_from_connectionX P_((struct connection_cache **c,
					 struct folder_browser *d));

/* return status of cache_close_connection() */
extern int close_connection P_((struct connection_cache *c,
				int free_stream_only,
				struct cancel_data  * cd));

extern void  cache_connection P_((struct connection_cache *c));

/* static_hosts.c */

enum lookup_class {
    lc_default,
    lc_dotless,
    lc_qualified
};

extern enum etc_hosts_status {
    etc_hosts_maybe        = -2    /* Status not set yet (or tried only cache) */,
    etc_hosts_failed       = -1    /* can't read /etc/hosts or canceled        */,
    etc_hosts_not_found    =  0    /* /etc/hosts opened, lookup_name not found */,
    etc_hosts_found        =  1    /* /etc/hosts opened, lookup_name found     */,
    etc_hosts_parsed       =  4    /* /etc/hosts parsed, lookup_name == NULL   */,
    etc_hosts_found_cached =  5    /* read from cache,   lookup_name found     */ 
} lookup_static_host P_((const char * lookup_name,
			 const struct schedule_timelimit * now,
			 const struct schedule_timelimit * valid_until /* default        */,
			 enum lookup_class                 lc           /* Optimization */,
			 char                           ** rewrite_p,
			 struct service_entry_addr      ** addr_list_p,
			 int                             * addr_count_p,
			 struct service_entry_name      ** aliases_list_p,
			 int                             * aliases_count_p,
			 int                             * was_error_p  /* Print errors only if
									   was_error_p != NULL */,

			 struct cancel_data             ** cancel_p ));


/* shared_connect.c */
#ifdef USE_DLOPEN

enum itls_status initial_TLS_ra
     P_((struct remote_account * ra,
	 const char            * proto_name /* for messages */));

extern enum address_lookup_result {
    address_lookup_no_routine = -3   /* no lookup name routine       */, 
    address_lookup_fallback   = -2   /* call default routine instead */,
    address_lookup_failed     = -1   /* can't lookup                 */,
    address_lookup_not_found  =  0   /* name not found               */,
    address_lookup_done       =  1   /* name found                   */,
    address_lookup_bad_syntax =  3   /* name have bad syntax         */
} shared_address_lookup P_((const char                      * hostname, 
			    char                           ** rewrite,
			    const char                      * tag,
			    int                               translated_value,
			    const struct dt_enum_shared     * is_shared_value,
			    struct service_entry_addr      ** addr_list,
			    int                             * addr_count,
			    struct service_entry_name      ** aliases_list,
			    int                             * aliases_count,
			    const struct service_type       * service,
			    const struct schedule_timelimit * now,
			    const struct schedule_timelimit * default_valid_until /* for static hosts lookup */,
			    int                             * was_error_p,
			    struct cancel_data             ** cancel_p     
			    /* May be NULL, Used if dns lookup was cancelable */
			    ));


extern void shared_notify_if_change P_((void));
#endif

/* Returns pointer to static storage */

/* Hook for resolv -module :
 *    *count == -1 if not supported 
 */

#define INTERFACE_ADDRLIST       1
#define INTERFACE_INDEX	         2
#define INTERFACE_CHANGE         4

/* Returns 1 if succeed */
extern int update_interface_list P_((int flags, int *save_errno));
extern void free_interface_list P_((void));

#define INTERFACE_INFO_magic	0xF518

extern struct interface_info {
    unsigned short magic;     /* INTERFACE_INFO_magic */

    char * name;

#define INTERFACE_ADDR_magic	0xF519

    struct interface_addr {
	unsigned short magic;  /* INTERFACE_ADDR_magic */ 

	size_t             addrsize;
	union SOCKADDR_ptr address;

	unsigned int    valid_address      : 1;
	
	unsigned int    interface_up       : 1;
	unsigned int    interface_loopback : 1;


    }      **  addr_list;
    int        addr_count;

    unsigned int    if_index;   /* index 0 is not used */

    unsigned int    valid_addrlist : 1;
    unsigned int    valid_index    : 1;

} ** get_interfaces P_((size_t interface_info_size,
			size_t interface_addr_size,
			int * count,
			int * flags  /* IN OUT */ ));




#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

