/* $Id: cs_terminal.h,v 2.2 2014/07/14 15:07:25 hurtta Exp $ */

#define DISPLAY_STATE_magic     0xF304

struct display_settings {
    unsigned short       magic;       /* DISPLAY_STATE_magic */

    int                  set_count;
    struct iso2022_setid sets [ISO2022_SET_COUNT + 6];  /* must be bigger than 
							   ISO2022_SET_COUNT */

    int                  width[ISO2022_SET_COUNT + 6];

    int                  bank[ISO2022_BANK_NUM];

    enum iso2022_bank    current_L;   /*  32-127 */
    enum iso2022_bank    current_R;   /* 160-255 */

#ifdef WCHAR
    int wcwidth;
#endif

};

extern void reset_display_settings P_((struct display_settings *p));
extern void free_terminal_info P_((struct display_settings **p));

/* May be called from signal handler -- on that situation use
   buffer specified as argument -- otherwise result is malloced
*/
extern char * iso2022_change_helper_1 P_((screen_info_p terminal_info,
					  struct iso2022_setid ID,
					  int setnum,
					  char * buffer, 
					  int size));

extern void iso2022_setid_select_bank (struct iso2022_setid *ID,
				       screen_info_p terminal_info);
extern void debug_display_settings P_((struct display_settings *p,
				       int sig,int stream));
/* Return setnumber from terminal info */
extern int set_initial_bank P_((char **ret,struct iso2022_setid ID,
				screen_info_p terminal_info,   
				char * buffer,
				int size, 
				int maybe_signal));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
