/* $Id: digest_imp.h,v 1.2 2020/05/13 05:11:21 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#define DIGEST_PROC_TYPE_magic	0xFC0A

typedef void digest_proc_alloc_ctx P_((struct digest_proc *dp));
typedef void digest_proc_free_ctx  P_((struct digest_proc *dp));
typedef void digest_proc_init_ctx  P_((struct digest_proc *dp));
typedef void digest_proc_update_ctx  P_((struct digest_proc *dp,
					 const unsigned char data[],
					 const size_t        data_len));
typedef void digest_proc_final_ctx  P_((struct digest_proc *dp,
					unsigned char digest_buffer[],
					size_t        digest_buffer_len));
					 

struct digest_proc_type {
    
    unsigned short         magic;        /* DIGEST_PROC_TYPE_magic */

    size_t                 digest_len;   /* Constant */

    digest_proc_alloc_ctx  * alloc_ctx;
    digest_proc_free_ctx   * free_ctx;
    digest_proc_init_ctx   * init_ctx;
    digest_proc_update_ctx * update_ctx;
    digest_proc_final_ctx  * final_ctx;

};


#define DIGEST_PROC_magic	0xFC09

struct digest_proc {

    unsigned short             magic;    /* DIGEST_PROC_magic */

    const struct digest_proc_type * digest_type;
    
    int                        refcount;

    enum digest_proc_mode  mode;

    union {
	void              * dummy;
	struct md5_ctx    * md5;
    }                       context;
  
    unsigned char         * digest_result;  /* digest_type->digest_len bytes */
    
};


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

