/* $Id: elm_defs.h,v 2.47 2024/01/01 17:00:40 hurtta Exp $ */

/*************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.47 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *************************************************************************
 *  Based on Elm 2.4 hdrs/defs.h. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *************************************************************************
 *  Based on Elm 2.5 hdrs/elm_defs.h. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *                      Copyright (c) 1988-1998 USENET Community Trust
 *                      Copyright (c) 1986,1987 Dave Taylor
 ************************************************************************/

/**  define file for ELM mail system.  **/

#include "defs_major.h"

#include <errno.h>

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define KLICK		32      /* increment for  mssg list       */

#define SHORT		10	    /* super short strings!		  */
                                    /* FIXME:   remove!!                   */

#define TLEN           10      /* super short (tiny) strings               */
                               /* FIXME:    not used yet                   */

#define WLEN		20      /* small words                              */
#define NLEN		48	/* name length for aliases                   */
#define STRING		128	/* reasonable string length for most..      */
#define LONG_STRING	512	/* even longer string for group expansion   */
#define VERY_LONG_STRING 2560	/* huge string for group alias expansion    */
#define MAX_LINE_LEN	5120	/* even bigger string for "filter" prog..   */
#define MAX_UNFOLDED_HDR (32*1024)  /* max length for unfolded header       */

#define TILDE_ESCAPE	'~'		/* escape character~    */

#define default_folders		"Mail"
#define default_recvdmail	"=received"
#define default_sentmail	"=sent"
#define default_dsnmail         "=dsn"
#define DEFAULT_TO_CHARS       " TC*L"

#if 0              /* XXX not used yet */
#define streq(p, q)            (strcmp((p), (q)) == 0)

/* use these ONLY where "d" is a constant string value */
#define strbegConst(s, d)      (strncmp((s), (d), sizeof(d)-1) == 0)
#define stribegConst(s, d)     (strincmp((s), (d), sizeof(d)-1) == 0)
#endif

#if 0              /* XXX not used yet */
/*
 * The macros implement speeded up constant string comparisons.
 * They are useful alternatives when a string is subject to
 * multiple comparisons.  The comparison target (the "d" value)
 * *must* be a constant string, and the first character of this
 * string *must* be upper case (or non-alphabetic).
 *
 * To use them, "FAST_COMP_DECLARE" must appear in variable declarations
 * at the top of the procedure.  Then "fast_comp_load" must be invoked
 * to preload the first character of the string.
 */
#define FAST_COMP_DECLARE              int FAST_COMP_ch
#define fast_comp_load(c)              FAST_COMP_ch = toupper(c)
#define fast_strbegConst(s, d)         strbegConst(s, d)
#define fast_stribegConst(s, d)                (FAST_COMP_ch == (d)[0] \
           && strincmp((s), (d), sizeof(d)-1) == 0)
#define fast_header_cmp(s, d, result)  (FAST_COMP_ch == (d)[0] \
           && header_ncmp((s), (d), sizeof(d)-1, (result), sizeof(result)-1))
#endif

/*****************************************************************************
 *
 * System portability definitions, header inclusions, and brokeness unbotching.
 *
 ****************************************************************************/


#if 0              /*       XXXX    not implemented yet */
#ifdef HAS_SETEGID
#define SETGID(s) setegid(s)
#else
#define SETGID(s) setgid(s)
#endif
#endif

/* inttypes.h includes stdarg.h, so it conflicts with varargs.h 
 *
 * varargs.h does not work in 64 bit IRIXes...
 */

#if  ANSI_C
# include <stdarg.h>
# define Va_start(a,b) va_start(a,b)
#else
# include <varargs.h>
# define Va_start(a,b) va_start(a)
#endif

/* inttypes.h can't be used if it conflicts with sys/types.h
 *
 * unfortunately sys/types.h does not define uint16_t (in IRIX 5.3),
 * but including of inttypes.h causes compilation error!
 */

#if defined(I_INTTYPES) && ANSI_C && !defined(NO_INTTYPES)

#include <inttypes.h>

/* For support 64 bit IRIXes also */
#define int32                         int32_t
#define uint32                        uint32_t
#define uint16                        uint16_t
#define uint8                         uint8_t

#else /* I_INTTYPES */

#ifdef __alpha

#define int32                         int
#define uint32                        unsigned int
#define uint16                        unsigned short    /* is this correct? */
#define uint8                         unsigned char     /* is this correct? */
#else

#define int32                         long
#define uint32                        unsigned long
#define uint16                        unsigned short
#define uint8                         unsigned char
#endif

#endif /* I_INTTYPES */

#ifdef CRAY
/* avoid conflict with typedef'd word */
#define word wrd   
#endif /* CRAY */


#ifdef	__convex__
/*
 *  Nice work Convex people! Thanks a million!
 *  When STDC is used feof() is defined as a true library routine
 *  in the header files and moreover the library routine also leaks
 *  royally. (It returns always 1!!) Consequently this macro is
 *  unavoidable.)
 */
#  ifndef   feof
#    define   feof(p)	((p)->_flag&_IOEOF)
#  endif
#endif

#if 0              /* XXX not used yet */
/* 
 * Ultrix's fflush returns EOF and sets error flag if the stream is read-only.
 */
#if defined(ULTRIX_FFLUSH_BUG) && defined(ANSI_C)
# define fflush(fp) \
	    ((((fp)->_flag & (_IOREAD | _IORW)) == _IOREAD) ? 0 : fflush(fp))
#endif
#endif

#ifdef SHORTNAMES	/* map long names to shorter ones */
# include <shortname.h>
#endif

#ifdef MEMCPY

#  ifdef I_MEMORY
#   include <memory.h>
#  else /* I_MEMORY */
#   ifndef ANSI_C   /* ANSI puts these in string.h */
#if defined(__convexc__)
extern void *memcpy(), *memset();
#else
extern char *memcpy(), *memset();
#endif
extern int memcmp();
#   endif /* ANSI_C */
#  endif /* I_MEMORY */

#define bcopy(s1,s2,l) memcpy(s2,s1,l)
#define bcmp(s1,s2,l) memcmp(s1,s2,l)
#define bzero(s,l) memset(s,0,l)
#endif /* MEMCPY */

/*
 * Some of the old BSD ctype conversion macros corrupted characters.
 * We will substitute our own versions if required.
 */
#include <ctype.h>
#ifdef BROKE_CTYPE
# undef  toupper
# define toupper(c)	(islower(c) ? ((c) - 'a' + 'A') : (c))
# undef  tolower
# define tolower(c)	(isupper(c) ? ((c) - 'A' + 'a') : (c))
#endif

/* things normally found in <unistd.h> */

#ifndef F_OK
# define F_OK	0
# define X_OK	1
# define W_OK	2
# define R_OK	4
#endif
#ifndef SEEK_SET
#define	SEEK_SET	0	/* Set file pointer to "offset" */
#define	SEEK_CUR	1	/* Set file pointer to current plus "offset" */
#define	SEEK_END	2	/* Set file pointer to EOF plus "offset" */
#endif
#ifndef STDIN_FILENO
# define STDIN_FILENO	0
# define STDOUT_FILENO	1
# define STDERR_FILENO	2
#endif

/* Elm likes to use these happy names instead */
#define ACCESS_EXISTS	F_OK
#define EXECUTE_ACCESS	X_OK
#define WRITE_ACCESS	W_OK
#define READ_ACCESS	R_OK
#define EDIT_ACCESS	(R_OK|W_OK)

#if defined(POSIX_SIGNALS) && defined(HASWAITPID)
#define BACKGROUD_PROCESSES               /* Only with POSIX signals */
#endif

/* <ulimit.h> is XPG3 ... but not POSIX nor ANSI */
extern long ulimit P_((int, ...));

#ifdef POSIX_SIGNALS
# define signal posix_signal
  extern SIGHAND_TYPE
	      (*posix_signal P_((int, SIGHAND_TYPE (*)(int)))) P_((int));
#else
# ifdef SIGSET
#   define signal sigset
#   ifdef _AIX
      extern SIGHAND_TYPE (*sigset(int sig, SIGHAND_TYPE (*func)(int)))(int);
#   endif
# endif
#endif

#include <setjmp.h>

#if defined(POSIX_SIGNALS) && !defined(__386BSD__)
# define JMP_BUF		sigjmp_buf
# define SETJMP(env)		sigsetjmp((env), 1)
# define LONGJMP(env,val)	siglongjmp((env), (val))
#else
# define JMP_BUF		jmp_buf
# define SETJMP(env)		setjmp(env)
# define LONGJMP(env,val)	longjmp((env), (val))
#endif

#ifdef I_LOCALE
#include <locale.h>
#endif

#ifdef I_NL_TYPES
#include <nl_types.h>
#else
#include "elm_nl_types.h"
#endif

/* FOO - I wonder if we should be including <time.h> in this header */
char *ctime P_((const time_t *));


/*****************************************************************************
 *
 * data structures
 *
 ****************************************************************************/

/** "status" values for the header and alias record **/

enum status_bits {
    ACTION_bit = 0,
    CONFIDENTIAL_bit,
    DELETED_bit,
    EXPIRED_bit,
    NEW_bit     = 5,
    PRIVATE_MAIL_bit,
    TAGGED_bit,
    URGENT_bit,
    VISIBLE_bit,
    UNREAD_bit,
    REPLIED_TO_bit,
    MIME_MESSAGE_bit,
    PRE_MIME_CONTENT_bit,
    MIME_UNSUPPORTED_bit,
    NOHDRENCODING_bit
};

#define ACTION		 (1 << ACTION_bit)
#define CONFIDENTIAL	 (1 << CONFIDENTIAL_bit)
#define DELETED		 (1 << DELETED_bit)
#define EXPIRED		 (1 << EXPIRED_bit)
#define NEW		 (1 << NEW_bit)
#define PRIVATE_MAIL	 (1 << PRIVATE_MAIL_bit)
#define TAGGED		 (1 << TAGGED_bit)
#define URGENT		 (1 << URGENT_bit)
#define VISIBLE		 (1 << VISIBLE_bit)
#define UNREAD		 (1 << UNREAD_bit)
#define REPLIED_TO       (1 << REPLIED_TO_bit)
#define MIME_MESSAGE     (1 <<MIME_MESSAGE_bit)  /* indicates existence of MIME Header */
#define PRE_MIME_CONTENT (1 << PRE_MIME_CONTENT_bit)
#define MIME_UNSUPPORTED (1 << MIME_UNSUPPORTED_bit)
#define NOHDRENCODING    (1 << NOHDRENCODING_bit)
/* Don't add values bigger than 2^15 == 32768 */

/* Defines for  status1          */

#define S1_FLAGGED           (1<<0)
#define S1_NODATA            (1<<1)
#define S1_RECONNECT_LOST    (1<<2)


#define PGP_MESSAGE		(1<<0)
#define PGP_SIGNED_MESSAGE	(1<<1)
#define PGP_PUBLIC_KEY		(1<<2)



/* Values for dsn flag */
#define DSN_FULL    1
#define DSN_HDRS    2
#define DSN_SUCCESS 4
#define DSN_FAILURE 8
#define DSN_DELAY   16
#define DSN_NEVER   32

/* message sorting selections */

#define REVERSE		-		/* for reverse sorting           */
    
enum msg_sort_type {
    SENT_DATE =		1		/* the date message was sent     */,
    RECEIVED_DATE =	2		/* the date message was received */,
    SENDER =		3		/* the name/address of sender    */,
    SIZE =		4		/* the # of lines of the message */,
    SUBJECT =		5		/* the subject of the message    */,
    STATUS =		6		/* the status (deleted, etc)     */,
    MAILBOX_ORDER =	7		/* the order it is in the file   */,
    THREAD =         	8               /* thread order (date sent/subject */
};

/* alias sorting selections */

enum alias_sort_type {
    ALIAS_SORT =	1		/* the name of the alias         */,
    NAME_SORT =		2		/* the actual name for the alias */,
    TEXT_SORT =	 3		/* the order of aliases.text     */
};
#define LAST_ALIAS_SORT	TEXT_SORT

enum no_yes {
    NO =		0,
    YES	=		1,
    MAYBE =		2		/* a definite define, eh?  */
};

#define	NO_TITE		2		/* ti/te or in flag 	   */

/** and a couple for dealing with status flags... **/

#define ison(n, mask)		(((n) & (mask)) != 0)
#define isoff(n, mask)		(((n) & (mask)) == 0)
#define setit(n, mask)		(n) |= (mask)
#define clearit(n, mask)	(n) &= ~(mask)




/*****************************************************************************
 *
 * Data common to many programs in the Elm package.
 *
 ****************************************************************************/


#ifdef INTERN
# define INIT(X) =X
# define EXTERN 

static char  ident[] FORIDENT = WHAT_STRING;
static char copyright[] FORIDENT = "\
@(#)          (C) Copyright 1986,1987, Dave Taylor\n\
@(#)          (C) Copyright 1988-1995, The Usenet Community Trust\
@(#)          (C) Copyright 1996-2024, Kari Hurtta\n";

#else
# define INIT(X)
# define EXTERN extern
#endif


#define ok_alias_char(c) (isalnum(c) || c == '-' || c == '_' || c == '.')
#define ok_rc_char(c)	(isalnum(c) || c == '-' || c == '_')
#define whitespace(c)	(c == ' ' || c == '\t')
#define first_word(s,w) (strncmp(s,w, strlen(w)) == 0)
#define first_word_nc(s,w) (strincmp(s,w, strlen(w)) == 0)

#define no_ret(s)	{ int xyz; /* varname is for lint */	      \
                          char * yxz_s = (s);                         \
		          for (xyz=strlen(yxz_s)-1; xyz >= 0 && 		      \
				(yxz_s[xyz] == '\r' || yxz_s[xyz] == '\n'); )	      \
			     yxz_s[xyz--] = '\0';                                 \
			}

#define equal(s,w)	(strcmp(s,w) == 0)
	
/* environment variable with name of folder state dump file */
#define FOLDER_STATE_ENV	"ELMSTATE"

#define FORMFEED	'\f'     	/* form feed (^L) char  */

#define NONULL(x) (x ? x : "")
		  
/* ----------------------------------------------------------------- */

#if defined(COMPILE_FCNTL_LOCKING) || defined(COMPILE_FLOCK_LOCKING)
# define SYSCALL_LOCKING
#endif


#ifdef I_TIME
#  include <time.h>
#endif
#ifdef I_SYSTIME
#  include <sys/time.h>
#endif

#ifndef	_POSIX_SOURCE
extern struct tm *localtime();
extern struct tm *gmtime();
extern time_t	  time();
#endif

#if defined(SELECT) || defined(I_SYS_SELECT) 
#define POLL_METHOD POLL_method_select
#define HAVE_SELECT
#if defined(I_SYS_SELECT) 
#include <sys/select.h>
#endif
#endif

#if defined(POLL)
#include <poll.h>

#ifndef POLL_METHOD
#define POLL_METHOD POLL_method_poll
#endif

#endif

#ifdef HAVE_SOCKET
/* Configure tested both <sys/socket.h> and  <sys/un.h> */

#include <sys/socket.h>
#include <sys/un.h>
#endif

#ifdef I_NETDB
#include <netdb.h>
#endif

#if defined(POLL_METHOD) && defined(HAVE_SOCKET) && \
  defined(I_NETDB) && !defined(NO_REMOTE_MBX)
#define REMOTE_MBX

#define MIN_POP_TIMEOUT  5      /* Minimum value for pop-idle-alive-interval  */
#define MIN_IMAP_TIMEOUT 5      /* Minimum value for imap-idle-alive-interval */
#define MIN_NAME_CACHE_TIME 3   /* Minimum value for name-lookup-cache-time   */

#endif

#if defined(I_TIME) && defined(CLOCK_GETTIME) && \
    defined(CLOCK_MONOTONIC)
#define USE_CLOCK_MONOTONIC
#endif

#if defined(GETTIMEOFDAY) && defined(S_TIMEVAL)
#define USE_GETTIMEOFDAY
#endif

/*****************************************************************************
 *
 * declarations for routines in lib/libutil.a
 *
 ****************************************************************************/

#include "elmlib.h"


/* ------------------------------------------------------------------------ */

/* hdrs/filelock.h and hdrs/misclib.h */

enum FLOCKING_status {
    FLOCKING_FAIL  = -1,
    FLOCKING_OK    = 0,
    FLOCKING_RETRY = 1,
    FLOCKING_UNSUPPORTED  = 2   /* Not locked (dotlock?) */
}; 

enum FLOCKING_mode {
    FLOCKING_release   = -1,
    FLOCKING_exclusive = 0  /* excluside or read/write lock */,
    FLOCKING_shared    = 1  /* shared or read-only log */
};

enum FLOCKING_blocking {
    FLOCKING_interrupt = -1 /* called from interrupt handler */,
    FLOCKING_non_block = 0,
    FLOCKING_block = 1
};


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
