/* $Id: elm_globals.h,v 2.16 2022/11/19 06:50:54 hurtta Exp $ */

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.16 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 hdrs/defs.h and hdrs/headers.h. 
 *  That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Based on Elm 2.5 hdrs/elm_globals.h. That code was following copyright:
 *
 *  The Elm Mail System
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*
 * All source files in the Elm package should include this right
 * after "elm_defs.h".  This header should not be used by the
 * library or utility files.
 */

#define BACKSPACE	'\b'     	/* backspace character  */
#define TAB		'\t'            /* tab character        */
#define RETURN		'\r'     	/* carriage return char */
#define LINE_FEED	'\n'     	/* line feed character  */
#define ESCAPE		'\033'		/* the escape		*/

#define NO_OP_COMMAND	'\0'		/* no-op for timeouts   */
                                        /* XXX ? ? ? ?          */

#define PAD		0		/* for printing name of    */
                                        /* XXX  remove             */
#define FULL		1		/*   the sort we're using  */
                                        /* XXX  remove             */

enum CM_bits {
    CM_bit_REMOVE_HEADER   = 0         /* skip header of message            */,
    CM_bit_UPDATE_STATUS   = 2         /* Update Status: Header             */,
    CM_bit_PREFIX          = 3         /* Add prefix (">", etc.) to lines   */,
    CM_bit_REMAIL          = 4         /* Add Sender: and Orig-To: headers  */,
    CM_bit_DECODE          = 5         /* Decode MIME, PGP and elm          */,
    CM_bit_FILT_HDR        = 6         /* Filter headers (for forwarding)   */,
    CM_bit_DISPLAYING      = 7         /* Pass to MIME code                 */,
    CM_bit_REMOVE_ENVELOPE = 8         /* Remove envelope                   */,
    CM_bit_CRLF            = 9         /* Use CRLF                          */,
    CM_bit_LF              = 10        /* Force CRLF -> LF                  */,
    CM_bit_FORWARDING      = 11        /* text is a message that we are     */
                                       /*   forwarding			    */,
    CM_bit_ATTRIBUTION     = 12        /* add attribution strings that	    */
                                       /* format this as an included mssg   */,
    CM_bit_QUOTE_L         = 13        /* Quote [                           */,
    CM_bit_SHOW_ERROR                  /* Pass to MIME code                 */
};  


/* options to the copy_message() procedure */
#define CM_REMOVE_HEADER	(1 << CM_bit_REMOVE_HEADER)	/* skip header of message */
#define CM_UPDATE_STATUS	(1 << CM_bit_UPDATE_STATUS)	/* Update Status: Header  */
#define CM_PREFIX               (1 << CM_bit_PREFIX)    /* Add prefix (">", etc.) to lines   */
#define CM_REMAIL		(1 << CM_bit_REMAIL)	/* Add Sender: and Orig-To: headers */
#define CM_DECODE		(1 << CM_bit_DECODE)	/* Decode MIME, PGP and elm */
#define CM_FILT_HDR		(1 << CM_bit_FILT_HDR)  /* Filter headers (for forwarding) */
#define CM_DISPLAYING		(1 << CM_bit_DISPLAYING)        /* Pass to MIME code */
#define CM_REMOVE_ENVELOPE	(1 << CM_bit_REMOVE_ENVELOPE)	/* Remove envelope */
#define CM_CRLF                 (1 << CM_bit_CRLF)              /* Use CRLF */
#define CM_LF                   (1 << CM_bit_LF)        /* Force CRLF -> LF */
#define CM_FORWARDING		(1 << CM_bit_FORWARDING)      /* text is a message that we are   */
					                      /*   forwarding			 */
#define CM_ATTRIBUTION		(1 << CM_bit_ATTRIBUTION)     /* add attribution strings that	 */
					                      /* format this as an included mssg */
#define CM_QUOTE_L              (1 << CM_bit_QUOTE_L)         /* Quote [                         */
#define CM_SHOW_ERROR           (1 << CM_bit_SHOW_ERROR)      /* Pass to MIME code               */

#if  0           /* NOT USED --  */
#define CM_REMOTE		(1<<1)	/* append remote from hostname to    */
					/*   first line			     */
#define CM_MMDF_HEAD		(1<<XX)	/* strip mmdf message seperator	     */


#endif

#if 0                 /* XXX not used yet */
/* options to the leave() procedure */
#define LEAVE_NORMAL		000	/* normal program termination	*/
#define LEAVE_ERROR		001	/* exit due to program error	*/
#define LEAVE_KEEP_EDITTMP	010	/* ...preserve composition file	*/
#define LEAVE_KEEP_TEMPFOLDER	020	/* ...preserve temp folder	*/
#define LEAVE_KEEP_LOCK		040	/* ...preserve folder locks	*/
#define LEAVE_EMERGENCY		071	/* emergency exit		*/
#define LEAVE_EXIT_STATUS(mode)	((mode) & 07)

#endif


#define UNDELETE	0		/* purely for ^U function... */
                                        /* XXX  remove          */

#if 0                 /* XXX not used yet */
/* options to the meta_match() procedure */
#define MATCH_TAG	0		/* tag matching entries		*/
#define MATCH_DELETE	1		/* delete matching entries	*/
#define MATCH_UNDELETE	2		/* undelete matching entries	*/
#endif

/****************************************************************************/

/* map character (e.g. 'A') to its control equivalent (e.g. '^A') */
#define ctrl(c)	        (((c) + '@') & 0x7f)

#if 0            /* XXX -- not used */
/* calculate next tabstop from position (col) */
/* leftmost col is zero, assumes 8-position tabstops */
#define tabstop(col)	(((col) & ~07) + 010)
#endif

/*    FIXME:               ....   remove these ... 
#define MAIN_HELP    0
#define OPTIONS_HELP 1
#define ALIAS_HELP   2
#define PAGER_HELP   3
*/

#if 0                   /* softkeys not used */
#define MAIN	0
#define ALIAS   1
#define YESNO	2
#define CHANGE  3
#define READ	4
#endif


#define onoff(n)	(n == 0 ? "OFF" : "ON")

#define ClearLine(n)	MoveCursor(n,0); CleartoEOLN()
#define plural(n)	n == 1 ? "" : "s"

/* Options for mail() procedure */
#define MAIL_COPY_MSG          (1<<0)
#define MAIL_EDIT_MSG          (1<<1)
/* #define MAIL_ISFORM         (1<<2) */
#define MAIL_REPLYING          (1<<3)
#define MAIL_FORWARDING        (1<<4)
#define MAIL_HAVE_PGP_ENCODED  (1<<6)    /* Flag for verify transmission */
#define MAIL_MIME_ATTCH        (1<<7)    /* mimeforward */
#define MAIL_COPY_SELECTION    (1<<8)    /* canceled mail */
#define MAIL_DELETE_CANCEL     (1<<9)    /* And delete canceled_view mail also */
#define MAIL_ASK_SEND          (1<<10)   /* used by URL code             */
#define MAIL_FORGET            (1<<11)   /* used by verify_transmission() on failure */

/*
 * "opmode" global - current operation mode settings.
 */

#define OPMODE_MASK             077

#define OPMODE_READ		010	/* running in folder read mode	*/
#define OPMODE_READ_NONEMPTY	011	/*  ...only read if non-empty	*/
#define OPMODE_READ_UNREAD	012	/*  ...only read if unread  ... not on Elm 2.5	*/
#define OPMODE_READ_SELECT      014     /* Select folder                */
#define OPMODE_SEND		020	/* running in send-only mode	*/
#define OPMODE_CHECK            040     /* check_only ... not on Elm 2.5 */

#define OPMODE_BATCH           0100     /* Non-interactive              */




#define OPMODE_IS_READMODE(op)		(((op) & OPMODE_READ) != 0)
#define OPMODE_IS_SENDMODE(op)		(((op) & OPMODE_SEND) != 0)
#define OPMODE_IS_CHECKMODE(op)		(((op) & OPMODE_CHECK) != 0)
#define OPMODE_IS_BATCHMODE(op)		(((op) & OPMODE_BATCH) != 0)

#define OPMODE_IS_INTERACTIVE(op)	( ((op) & OPMODE_BATCH) == 0 && \
                                          ((op) & OPMODE_CHECK) == 0)


/******** global variables accessable by all pieces of the program *******/

EXTERN int last_current     INIT(-1); /* previous current message */
EXTERN int last_header_page INIT(-1); /* last header page        */
EXTERN int mini_menu        INIT(1);  /* flag: display menu? (&  mini_menu_rc)      */
EXTERN int headers_per_page;	      /* number of headers/page  */
EXTERN int original_umask;	      /* original umask, for restore before subshell */
EXTERN int sendmail_verbose;          /* Allow extended debugging on sendmail */
EXTERN int nucurr; 		      /* change list or just the current pointer  **/
EXTERN char cur_editfile[SLEN];       /* editor buffer */

EXTERN char version_buff[NLEN];       /* version buffer */

EXTERN char *def_ans_yes;	      /* default yes answer - single char, lc*/
EXTERN char *def_ans_no;	      /* default no answer - single char, lc */
EXTERN char *nls_deleted;	      /* [deleted] */
EXTERN char *nls_message;	      /* Message */
EXTERN char *nls_to;		      /* To */
EXTERN char *nls_from;		      /* From */
EXTERN char *nls_page;		      /* Page */
EXTERN char *save_word;		      /* save */
EXTERN char *copy_word;		      /* copy */
EXTERN char *cap_save_word;	      /* Save */
EXTERN char *cap_copy_word;	      /* Copy */
EXTERN char *saved_word;	      /* saved */
EXTERN char *copied_word;	      /* copied */

EXTERN int  write_elmrc;              /* flag: write elmrc in starting      */

EXTERN JMP_BUF GetPromptBuf;		/* setjmp buffer */
EXTERN int InGetPrompt;		/* set if in GetPrompt() in read() */

EXTERN short mime_count; /* A counter used so that each call to
                         * mime_generate_boundary() returns a unique value.
                         */

/* fbrowser.c */

#define FB_EXIST        (1<<0)  /* file must exist                      */
#define FB_READ         (1<<1)  /* file must exist and be readable      */
#define FB_WRITE        (1<<2)  /* if file exists, must be writable     */
#define FB_NOMBOX_CHECK (1<<4)  /* Do notcheck that folder is on be mbox format  */



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */




