/* $Id: mboxlib.h,v 2.48 2024/06/23 07:38:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.48 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* declarations ------------------------------------------------------------ */

typedef struct read_folder_state * READ_STATE;
typedef struct reconnect_mode    * RECONNECT_MODE;
#ifdef ANSI_C
struct header_rec;
#endif

/* init.c ------------------------------------------------------------------ */

enum use_lastread_v {
    use_lastread_no,
    use_lastread_yes,
    use_lastread_auto,
    use_lastread_existing,
    NUM_use_lastread
};

extern ENUMERATE editor_hm_propline;
#if USERMAP_PROPLINE
extern ENUMERATE editor_usermap_propline;
#endif
extern ENUMERATE use_last_read_file;
extern ESTR      user_map_dir_e;

extern charset_t                   system_hash_marks_cs;
extern struct editor_propline    * system_hash_marks_pl;
extern struct hash_marks_conf    * system_hash_marks_conf;

extern charset_t                   user_hash_marks_cs;
extern struct editor_propline    * user_hash_marks_pl;
extern struct hash_marks_conf    * user_hash_marks_conf;

extern void init_mboxlib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* expires.c --------------------------------------------------------------- */

extern void process_expiration_date P_((char *date,
					int  *message_status));

/* forwarded.c ------------------------------------------------------------- */

extern void forwarded P_((char *buffer, struct header_rec *entry));

/* hashmark.c ----------------------------------------------------------- */

extern struct hash_marks_conf * parse_hash_mark_entries 
     P_((const char *filename, 
	 int *errors, 
	 charset_t *fileset,
	 struct editor_propline **propline,
	 enum record_mode rc  /* SYSTEM_RC = 0, 
				 LOCAL_RC = 1 */
							    ));
extern void free_hash_marks_conf P_((struct hash_marks_conf **conf));

extern int dump_hash_mark_entries 
      P_((FILE *f, struct hash_marks_conf *conf,
	  FILE *commentfile,
	  const char *actor,
	  char *version_buff,
	  charset_t fileset,
	  const struct editor_propline *propline,
				      enum record_mode rc  /* SYSTEM_RC = 0, LOCAL_RC = 1 */));

extern void change_hash_marks_conf P_((struct hash_marks_conf **conf,
				       const struct hash_marks_conf *new));

/* hashmark_remote.c -------------------------------------------------- */

typedef FILE *usermap_copy_callback P_((const char *name, 
					const char *pathname));

extern void set_usermap_copy_callback P_((usermap_copy_callback *cb));

/* header_cmp.c ------------------------------------------------------- */

extern char * header_cmp P_((char *header, char *prefix, char *suffix));

/* headers.c --------------------------------------------------------------- */

/* Returns either original body or pointer to buffer, may return NULL on overflow
   Returns also return NULL if body == NULL

   Also handles \r and \n
*/
const char * header_trim_whitespace_helper P_((const char *body,
					       char buffer[],
					       size_t buffer_size));



extern struct header_list * read_folder_headers P_((READ_STATE read_state_ptr,
						    struct folder_info *folder,
						    struct header_rec *entry));

extern void read_folder_headers_helper P_((struct header_rec *entry,
					   struct header_list *result));


/* localmbx.c -------------------------------------------------------------- */

extern void remove_possible_trailing_spaces P_((char *string));
extern void mailbox_2_status P_((char * status, struct header_rec *entry));
extern int status_2_mailbox P_((struct header_rec *entry, char *buffer, 
				int size));


/* These are wrappers to filelock_fd() */

extern enum FLOCKING_status Release_the_file  P_((int flock_fd, struct dt_flags_info *flags));
extern enum FLOCKING_status Grab_the_file     P_((int flock_fd, struct dt_flags_info *flags));
extern enum FLOCKING_status GrabRead_the_file P_((int flock_fd, struct dt_flags_info *flags));


extern int mbx_read_line P_((FILE *fh,char **buffer, int *len, int max_read));
extern int mbx_max_line_read P_((long size, long offset));




/* mbox.c ------------------------------------------------------------------ */

extern int same_file P_((const char *,const char *)); 

enum sessionlock_mode { SESSIONLOCK_NORMAL    = 0,
			SESSIONLOCK_REOPEN    = 1,
			SESSIONLOCK_TRUNCATE  = 2,
			SESSIONLOCK_CHECK     = 3,
			SESSIONLOCK_NONE      = 4,
			SESSIONLOCK_RECONNECT = 5,
	SESSIONLOCK_NONE_CHECKNEW    =  0x80 + 4 /* not actually mode */ 
};


typedef struct folder_type * folder_type_p;

#define FOLDER_INFO_magic	0xFA02

struct folder_info {
    unsigned short magic;           /* FOLDER_INFO_magic */
    char             * cur_folder_sys;	 /* name of current folder         */
    struct string    * cur_folder_disp;  /* Display name of current folder */

    char cur_tempfolder[SLEN];  /* name of temp folder open for a mailbox */

    folder_type_p folder_type;	 /* flag: type of folder     */
    long mailfile_size;	         /* size of current mailfile */

    struct private_data * p;

    unsigned int       was_reconnected  :1;
    unsigned int       got_skipped_mail :1; /* prepare_message_access loaded skipped mail */
};

enum close_mode { CLOSE_NORMAL = 0,
		  CLOSE_LEAVE_LOCKED = 1 };

/* close may mail if it is canceled ,
   even on failure files are closeed
*/
extern int close_folder P_((struct folder_info *folder,
			     enum close_mode mode,
			     struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
							  on remote mailbox
						       */
			     ));  

/* Flush may fail if canceled */
extern int flush_folder P_((struct folder_info *folder,
			    int *err_p  /* errno value */,
			    struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
							 on remote mailbox
						      */
			    ));

extern struct folder_info *enter_new_folder 
    P_((const char *new_file,
	int treat_as_spooled,
	unsigned int defaultfile_keyword, 
	unsigned int defaultfile_cmask)); /* create */

/* struct folder_info is free'd also when wait is canceled */
extern int leave_old_folder P_((struct folder_info **folder,
				 enum close_mode mode,
				 struct cancel_data  * cd /* Allow cancelation (Ctrl-C)
							     on remote mailbox
							  */
				 )) ;    /* free   */

#define FOLDER_MBOX          0x001         /* Folder is mbox */
#define FOLDER_RDONLY        0x002         /* Folder is read-only */
#define FOLDER_FILE          0x004         /* Folder is file */
#define FOLDER_DISCONNECTED  0x008         /* Folder is remote and connection is broken */

extern int get_folder_mode P_((struct folder_info *folder));

/* Opens folder -- Return 1 on succeed */

extern enum sessionlock_status {
    sessionlock_fail = 0,
    sessionlock_open = 1,
    sessionlock_reconnect
} sessionlock_folder P_((struct folder_info     * folder,
			 enum sessionlock_mode    mode,
			 int                    * err /* errno */,
			 RECONNECT_MODE         * reconnect_mode_ptr  /* Hack for SESSIONLOCK_TRUNCATE */
			 ));

extern void free_reconnect_mode P_((struct reconnect_mode **ptr));

enum lock_direction {
  LOCK_OUTGOING	= 0,		/* defines for lock file   */
  LOCK_INCOMING	= 1		/* creation..see lock()    */
};

/* Return 1 on succeed */
extern int lock_folder P_((enum lock_direction direction,
			   struct folder_info *folder));
extern int unlock_folder P_((int interrupt, struct folder_info *folder));
extern int ferror_folder P_((struct folder_info *folder, int clean));


enum prepare_mode { PREPARE_NORMAL = 0, PREPARE_NEW_ONLY = 1,
		    PREPARE_NOLOCK = 2, PREPARE_NEW_ONLY_NOLOCK = 3,
		    PREPARE_ACCESS = 4, PREPARE_RECONNECT = 5 };


extern enum prepare_result {
    prepare_fail = 0,
    prepare_done = 1,
    prepare_reconnected = 2
} prepare_read_folder P_((struct folder_info *folder,
			  enum prepare_mode mode,
			  READ_STATE      * read_state_ptr,
			  RECONNECT_MODE  * reconnect_mode_ptr
			  ));
extern int end_read_folder P_((struct folder_info *folder,
			       READ_STATE * read_state_ptr,
			       RECONNECT_MODE  * reconnect_mode_ptr,
			       int silent));

#ifdef ANSI_C
struct counter_data;
struct cancel_data;
#endif

/* 0 = Error, 1 = OK */
typedef int parse_header_callback P_((struct folder_info *folder,
				      READ_STATE read_state_ptr,
				      struct header_rec *entry,
				      struct header_list *parsed_headers ));
typedef int parse_body_callback P_((struct folder_info *folder,
				    READ_STATE read_state_ptr,
				    struct header_rec *entry,
				    struct header_list *parsed_headers,
				    struct counter_data *counter
				    ));

/* Returns:  0 = End of folder
             1 = OK
	    -1 = format error
	    -2 = not found (skipped)
*/
extern enum copy_env_status {
    copy_env_no_data = -2  /* not found (skipped) */,
    copy_env_format = -1,
    copy_env_eof = 0,
    copy_env_ok  = 1,	    
} copy_envelope_folder P_((struct folder_info *folder,
			   READ_STATE read_state_ptr,
			   struct header_rec *entry,
			   parse_header_callback *parse_header,
			   parse_body_callback *parse_body,
			   struct counter_data *counter));


struct previous_data {
    struct header_rec * rec;
    int                 found_index;
};

extern struct previous_data *
   search_previous_header P_((struct folder_info *folder,
			      struct header_rec *entry,
			      RECONNECT_MODE    reconnect_mode_ptr,
			      struct previous_data * previous_headers,
			      size_t                 previous_count,
			      size_t                *result_index
			      ));
				    
extern enum copy_env_status copy_previous_mail
                             P_((struct folder_info *folder,
				 READ_STATE          read_state_ptr,
				 struct header_rec * entry, /* May be replaced entry */
				 parse_header_callback * parse_header,
				 parse_body_callback   * parse_body,
				 struct counter_data    * counter,
				 RECONNECT_MODE         reconnect_mode_ptr,
				 struct previous_data * previous_header
				 ));

extern const char * is_forwarded_folder P_((struct folder_info *folder,
					    READ_STATE read_state_ptr));
extern long copy_fbytes_folder P_((struct folder_info *folder,
				   READ_STATE read_state_ptr));

/* -1 if not available (local mail) */
extern int copy_num_messages_folder P_((struct folder_info *folder));

extern int copy_lines_folder P_((struct folder_info *folder,
				   READ_STATE read_state_ptr));
extern void copy_skipcount_folder P_((struct folder_info *folder,
				      READ_STATE read_state_ptr,
				      int *skipcount,
				      long *skipbytes));

/* Gives header including continuation lines */
extern int copy_header_folder P_((struct folder_info *folder,
				  READ_STATE read_state_ptr,
				  char **buffer, int *len));

/* Unfolds line returned by copy_header_folder */
extern void unfold_header P_((char *buffer, int *len, 
			    struct header_rec *current_header));

extern void mbx_status_hook P_((struct header_rec *hdr, char *buffer));

extern int copy_body_folder P_((struct folder_info *folder,
				READ_STATE read_state_ptr,
				char **buffer, int *len,
				long *content_remaining));

/* Returns 0 if not end of message (needs resync without content-length) */
extern enum copy_env_end_status {
    copy_env_end_failure  = -1   /* Hard failure */,
    copy_env_end_mismatch =  0   /* Not end of message */,
    copy_env_end_match    = 1    /* Is end of message  */,
    copy_env_end_newmail         /* new mail have arrived (IMAP mailbox) */
} copy_envelope_end_folder P_((struct folder_info *folder,
			       READ_STATE read_state_ptr,
			       long *newbytes,
			       int  *newmails ));

extern int copy_envelope_reset_body P_((struct folder_info *folder,
                                        READ_STATE read_state_ptr,
					long *content_remaining));

typedef int parse_mime_callback P_((struct folder_info *folder,
				   struct header_rec *entry,
				   FILE *fp));
extern int NO_mime_parse P_((struct folder_info *folder,
                                   struct header_rec *entry,
                                   FILE *fp));


extern int prepare_message_access P_((struct folder_info *folder,
				      struct header_rec *entry,
				      parse_header_callback *parse_header,
				      parse_body_callback *parse_body,
				      struct counter_data *counter,
				      parse_mime_callback *parse_mime
				      ));

/* Return 1 on success, 0 on failure */

extern int folder_give_message_msize P_((struct folder_info *folder,
					 struct header_rec *entry,
					 unsigned long      * ret_size));
					 

extern FILE * folder_to_fd P_((struct folder_info *folder,long offset));

extern enum new_mail_stat {
    failed_mbx_ign_new_mail = -2   /* New mail is not available anyway (POP mailbox) */,
    new_mail_check_failed = -1,
    no_new_mail = 0,
    have_new_mail = 1,
    new_mail_reconnect = 2  /* Is reconnected, can't compare new mail */	
} new_mail_on_folder P_((struct folder_info *folder,
			 long *bytes,
			 int  *new_mailcount   /* -1 for local mailbox */,
			 int *err_p  /* errno value */,
			 struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
						      check of remote mailbox
						   */
			 ));

/* possible removes file and closes folder -- 
   returns 1 if removed  and closed */
extern int consider_remove_folder P_((struct folder_info *folder));

typedef struct keep_folder_state * KEEP_STATE;

extern int prepare_keep_folder P_((struct folder_info *folder,
				   KEEP_STATE * keep_state_ptr));
extern int end_keep_folder P_((struct folder_info *folder,
			       KEEP_STATE * keep_state_ptr));
extern void end_keep_folder_failure P_((struct folder_info *folder,
					KEEP_STATE * keep_state_ptr));
extern int mark_keep_folder P_((struct folder_info *folder,
				KEEP_STATE keep_state_ptr,
				struct header_rec *entry,
				int keep));

extern const char * folder_type P_((struct folder_info *folder));
extern int start_edit_folder P_((struct folder_info *folder, 
				 const char **buffer));
extern enum end_edit_fol_status {
    end_edit_fail_abort = -1,
    end_edit_none = 0,
    end_edit_open = 1       /* sessionlock_open       */,
    end_edit_reconnect = 2  /* sessionlock_reconnect */
} end_edit_folder P_((struct folder_info *folder));
extern void write_folder_info P_((FILE *F, struct folder_info *folder));

extern void free_rec_mbx_info P_((struct header_rec *entry));

extern void return_path_to_env_from P_((struct header_rec *entry,
					const char *value));


/* Gives username@server handle */
extern const struct remote_server * give_folder_server
                                              P_((struct folder_info *folder));
 
/* Increments refcount */

enum quota_mode { quotam_normal = 0,
		  quotam_refresh };

extern struct mail_quotaroot_list * give_folder_quotaroot_l
                                           P_((struct folder_info *folder,
					       struct cancel_data  * cd
					       /* Allow cancelation (Ctrl-C)
						  on remote mailbox.
					       */,
					       enum quota_mode refresh
					       ));

/* Increments refcount */
extern struct mail_quota * have_folder_quota P_((struct folder_info *folder));


extern int in_directory P_((struct stat *buf1, const char *name,
			    const char * dir));



/* mk_lockname.c ----------------------------------------------------------- */
     
extern char * mk_lockname P_((char *));
extern char * is_lockname P_((char *));

/* parsarpdat.c ------------------------------------------------------------ */

extern int parse_date_time P_((const char *str, 
			       char *time_zone, int size_time_zone,
			       time_t *tz_offset, time_t *time_result,
			       short *year_result
			       ));

extern int parse_arpa_date P_((char *str,
			       struct header_rec *entry));

/* realfrom.c -------------------------------------------------------------- */

extern int real_from P_((char *buffer, struct header_rec *entry));

/* remote_server.c --------------------------------------------------------- */


/* Gives server type and username@server handle as string -- 
   caller must free_string(), may return NULL */
extern struct string * give_remote_server_title
                                     P_((const struct remote_server *server));

#define USERADDR_SELF_CC  1
#define USERADDR_SELF_BCC 2

/* Caller must free this */
extern struct address * give_remote_server_useraddr
                                      P_((const struct remote_server *server,
					  int  * useraddr_flags));


/* quota.c ----------------------------------------------------------------- */

#ifdef ANSI_C
struct mail_quota;
struct mail_quotaroot_list;
struct mail_quotaroot;
struct mail_quota_item;
#endif

/* Decrements refcount */
extern void free_mail_quota P_((struct mail_quota **quota));
extern void free_mail_quotaroot_list
                                P_((struct mail_quotaroot_list **quota_list));
extern void free_mail_quotaroot P_((struct mail_quotaroot **quotaroot));
extern void free_mail_quota_item P_((struct mail_quota_item **quota_item));

/* Refcount increments */
extern void inc_mail_quota_refcount P_((struct mail_quota *quota));
extern void inc_mail_quotaroot_list_refcount
                                 P_((struct mail_quotaroot_list *quota_list));
extern void inc_mail_quotaroot_refcount P_((struct mail_quotaroot *quotaroot));
extern void inc_mail_quota_item_refcount
                                      P_((struct mail_quota_item *quota_item));

/* Returns 0 if  associated struct mail_quota is deallocated */

extern size_t quotaroot_list_len  P_((struct mail_quotaroot_list *quota_list));

/* Increments refcount 
   Returns NULL if  associated struct mail_quota is deallocated */
extern struct mail_quotaroot *quotaroot_list_item
                              P_((struct mail_quotaroot_list *quota_list,
				  size_t idx,
				  struct cancel_data  * cd
				  ));
extern void quotaroot_list_set_refresh P_((struct mail_quotaroot_list *quota_list,
					   enum quota_mode refresh));

/* Increments refcount 
   Returns NULL if  associated struct mail_quota is deallocated */
extern struct mail_quota *quotaroot_list_mquota
                                 P_((struct mail_quotaroot_list *quota_list));


/* Predefined names for localization */
enum quota_reserved_quotaroot {
    qr_root_none = 0
};

/* Caller must call free_string, may return NULL */
extern struct string *quotaroot_name
                     P_((struct mail_quotaroot *quotaroot,
			 enum quota_reserved_quotaroot *tok_r /* return value */
			 ));

/* Returns 0 if  associated struct mail_quota is deallocated */
extern size_t quotaroot_item_count P_((struct mail_quotaroot *quotaroot));

/* Increments refcount 
   Returns NULL if  associated struct mail_quota is deallocated */
extern struct mail_quota_item *quotaroot_item
                        P_((struct mail_quotaroot *quotaroot,
			    size_t idx));

extern enum quota_quotaroot_status {
    qr_stat_failed = -1           /* Failed to parse quota root resource limits */,
    qr_stat_none = 0              /* No status information or associated struct mail_quota is deallocated */,
    qr_stat_empty                 /* no administrative resource limits in the quota root */,
    qr_stat_normal                /* quotaroot resource quotas available */
	} quotaroot_status P_((struct mail_quotaroot *quotaroot));
	


/* Predefined names for localization */
enum quota_reserved_resource {
    qr_res_none = 0
};

/* Caller must free_string() result, may return NULL */
extern struct string *quota_item_name
               P_((struct mail_quota_item *quota_item,
		   enum quota_reserved_resource *tok_r /* return value */));

#define QUOTA_ITEM_have_usage      0x01
#define QUOTA_ITEM_have_limit      0x02

/* Return bitmask tells which return values are valid, 
   returns bitmask 0 if associated struct mail_quota is deallocated */
extern int quota_item_values P_((struct mail_quota_item *quota_item,
				  uint32 * usage_r /* return value */,
				  uint32 * limit_r /* return value */));




/* savefolder.c ------------------------------------------------------------ */

enum selection_type { selection_file, selection_folder, 
		      selection_url,
		      NUM_selection_type };

typedef struct folder_browser  *folder_dir;

extern void free_dir P_((struct folder_browser **dir));
extern struct folder_browser *new_browser P_((enum selection_type  sel_type));
extern enum selection_type get_browser_sel_type P_((struct folder_browser *dir));


#ifdef REMOTE_MBX

extern const struct browser_url_method  URL_imap;   
extern const struct browser_url_method  URL_imaps;   


/* 0 == no port */
extern uint16 browser_URL_default_port P_((const struct browser_url_method  *schema));

/* May not be 
      uin16 port
   because this is promoted to int
*/

extern struct folder_browser * browser_connect_URL P_((
                    const struct browser_url_method  *schema,
		    const struct string              *user   /* May be NULL */,
		    const struct string              *password /* May be NULL */,
		    const char                       *host   /* May be NULL */,
		    int                      port   /* May be 0 */));

/* Returns 1 on succeed */
/* This is always absolute path -- from root as defined for URL */
extern int select_item_from_URL P_((
	const struct browser_url_method  *schema,
	struct folder_browser *browser,
	int elems_count,
	const struct string **elems));

#endif

/* Returns 1 if succesfully, and may canonify argument
   may change type of dir
 */

extern int change_dir P_((struct folder_browser *dir, 
			  struct string **buffer));

/* Returns 1 if succesfully */
extern int reload_dir P_((struct folder_browser *dir,
			  int *pos));


/* buffer is used selection, may trash directory listing
   and change directory
 */
extern int select_dir_item P_((struct folder_browser *dir, 
			       struct string **buffer,
			       int *pos));

/* idx is used for selection, fills buffer */
extern int select_dir_item_by_idx P_((struct folder_browser *dir,
				      int idx, struct string **buffer));

extern int change_dir_to_entry P_((struct folder_browser *dir, 
				   int entry,
				   struct string **buffer));
extern int change_dir_to_selection P_((struct folder_browser *dir,
				       struct string **buffer));

extern int change_dir_up P_((struct folder_browser *dir, 
			     struct string **buffer,
			     int *pos));


extern struct string * give_title_dir P_((struct folder_browser *dir,
					  int *entry_count));


/* NULL == clear message */
typedef void print_sort_message P_((struct string *message));
extern void  folder_sort_dir P_((struct folder_browser *dir,
				 print_sort_message * print,
				 int *pos));

extern int give_edit_buffer P_((struct folder_browser *dir,
				int entry, struct string **buffer,
				int fill_with_entry));

/* append filename to current directory */
extern struct string * dir_cat_filename P_((struct folder_browser *dir,
					    const struct string *filename));


/* Resets filter
   Changes directory if have wildcard
   Applies filter
 */
extern int dir_is_wildcard P_((struct folder_browser *dir,
			       struct string **buffer));


/* Changes directory if have wildcard,
   do not apply filter
   *changed == 1 if directory is changed
 */
struct string * dir_give_wildcard P_((struct folder_browser *dir,
				      struct string **buffer,
				      int *changed));


extern const struct string * dir_give_filter P_((struct folder_browser *dir));

extern int dir_give_count P_((struct folder_browser *dir));

/* Returns 1 if changed, -1 error */
extern int dir_reset_filter P_((struct folder_browser *dir));

/* Returns 1 if directory changed, -1 error */
extern int dir_change_filter P_((struct folder_browser *dir,
				 const struct string *filter));

extern int dir_autocomplete P_((struct folder_browser *dir,
				struct string **buffer,
				int *first_match));


#define BROWSER_NODIR              1          /* Not a directory */         
#define BROWSER_NOFOLDER           2          /* Not a folder  */
#define BROWSER_MARKED             4          /* New mails ?   */
#define BROWSER_NEEDSTAT           8          /* Internal only ... */
#define BROWSER_HAVELOCKFILE      16          /* Have correspond .lock file 
						 which is not shown */
#define BROWSER_SESSIONLOCK       32          /* Have corresponding 
						 sessionlock file */

/* return reference to array -- do not free_string !!! */
extern const struct string * give_line_dir P_((struct folder_browser *dir,
					       int idx,
					       int *flags,
					       const struct string  **comment));


/* Operations for selection */

#define BROWSER_MAILFILE            64

#define BROWSER_SELECTED           128
#define BROWSER_EXIST              256
#define BROWSER_DIRPREFIX          512    /* Selection is dir prefix */

extern int give_dir_flags P_((struct folder_browser *dir));
extern struct folder_info * 
  folder_from_dir_item P_((struct folder_browser *dir,
			   int treat_as_spooled
			 ));

extern int create_selection_dir P_((struct folder_browser *dir));

typedef struct browser_write_state * WRITE_STATE;
extern int prepare_write_folder P_((struct folder_browser *dir,
				    WRITE_STATE * write_state_ptr));
extern int end_write_folder P_((struct folder_browser *dir,
				    WRITE_STATE * write_state_ptr));
extern int sync_write_folder P_((struct folder_browser *dir,
				 WRITE_STATE write_state_ptr));

extern struct string * selection_name_dir P_((struct folder_browser *dir));
extern void clear_selection_dir P_((struct folder_browser *dir));

/* Returns -1 if not seekable, else position */
extern long tell_dir_write_state P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr));
/* Returns 0 on failure! */
extern int seek_dir_write_state P_((struct folder_browser *dir,
                                    WRITE_STATE write_state_ptr,
				    long pos));
/* Return 0 on failure */

extern int dir_make_ref P_((struct folder_browser *dir,
			    char **refname, int *iscopy, int is_text));

#define WE_ADD_RETURN_PATH           1
#define WE_USE_CRLF                  2

extern int write_dir_write_state P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr,
				     int l, const char *buffer));
extern int write_envelope_start P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    int write_envelope,
				    struct header_rec *current_header,
				    int *env_flags));
extern int write_envelope_end P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    int write_envelope,
				    struct header_rec *current_header));

extern int selection_is_folder P_((struct folder_browser *dir,
				   struct folder_info *folder));

/* helper routines for fileio.c */
extern void start_fd_write_state P_((FILE *fd, 
				     struct folder_browser **dir,
				     WRITE_STATE *write_state_ptr));
extern void end_fd_write_state P_((struct folder_browser **dir,
				   WRITE_STATE *write_state_ptr));

/* Sets username@server handle handle for & -prefix    */
extern void browser_set_remote_server P_((struct folder_browser *dir,
					  const struct remote_server *server));

/* Gives browser's default remote server handle */
extern const struct remote_server * browser_get_remote_server P_((struct folder_browser *dir));


/* state.c ------------------------------------------------------------------ */

/* STATE_out_dir */
extern void set_out_state_dir   P_((struct folder_browser *,
				    WRITE_STATE,
				    struct out_state *));  

extern struct out_state_type  STATE_out_dir_type;
#define   STATE_out_dir      &STATE_out_dir_type

/* shared_mbox.c ----------------------------------------------------------- */


#ifdef REMOTE_MBX
#ifdef ANSI_C
struct POP_capa_libs;
#endif

extern void probe_pop_capa_lib P_((struct POP_capa_libs * *pop_capa_libs,
				   int                  * pop_capa_libcount,
				   const char *capa,
				   const char *capa_args));


/* Also frees pop_capa_libs list ... */
extern int handle_pop_capa_libs P_((struct folder_info *folder,
				    struct POP_capa_libs * *pop_capa_libs,
				    int                  * pop_capa_libcount,
				    enum CAPA_phase      * phase,
				    struct pop_callbacks *commands));

extern void probe_imap_capa_lib P_((struct IMAP_capa_libs * *imap_capa_libs,
				   int                  * imap_capa_libcount,
				   const char *capa));


enum imap_phase { IMAP_prelogin = 0, IMAP_logged = 1 };
/* Also frees imap_capa_libs list ... */
extern int handle_imap_capa_libs P_((struct connection_cache *con,
				    struct IMAP_capa_libs * *imap_capa_libs,
				    int                  * imap_capa_libcount,
				    enum CAPA_phase      * phase,
				    struct imap_callbacks *commands));

extern void free_only_imap_capa_libs P_((struct IMAP_capa_libs * *imap_capa_libs,
					 int                  * imap_capa_libcount));

#endif

/* utime_util.c ------------------------------------------------------------------- */

/* Return 1 un succeed,
   Return  on failure */

extern int change_file_utime P_((const char *file_name,
				 const struct stat *stat_buffer, int *errno_res));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
