/* $Id: mbxlocal_imp.h,v 2.10 2024/06/10 18:05:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

extern char * resolve_selection_local P_((struct folder_browser *dir,
					  int assume_incoming   /* Assume incoming folder */
					  ));


extern int real_select_local P_((struct folder_browser *dir,
				 const struct string *rel_itemname,
				 struct string * relative,
				 int *newpos));

extern struct folder_info * real_folder_from_local 
P_((struct folder_browser *dir,
    int treat_as_spooled,
    int assume_incoming));

extern int real_selection_is_local P_((struct folder_browser *dir,
				       struct folder_info *folder,
				       int assume_incoming));

extern int real_create_selection_local P_((struct folder_browser *dir,
					   int assume_incoming   /* Assume incoming folder */));

extern int real_prepare_write_local P_((struct folder_browser *dir,
					WRITE_STATE ptr,
					const char *filename));

extern int real_end_write_local P_((struct folder_browser *dir,
				    WRITE_STATE ptr,
				    const char *filename));

extern int real_sync_write_local P_((struct folder_browser *dir,
				    WRITE_STATE ptr,
				    const char *filename));

extern long real_browser_tell_ws P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr));

extern int real_browser_seek_ws P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    long pos));

extern int real_browser_write_ws P_((struct folder_browser *dir,
				     WRITE_STATE ptr,
				     int l, const char *buffer));

extern int real_start_we_local P_((struct folder_browser *dir,
				   WRITE_STATE write_state_ptr,
				   struct header_rec *current_header,
				   int *env_flags));

extern int real_end_we_local P_((struct folder_browser *dir,
				 WRITE_STATE write_state_ptr,
				 struct header_rec *current_header));

extern int real_make_ref_local P_((struct folder_browser *dir,
				   char **refname, int *iscopy,
				   int is_text));

extern int local_stat_flags P_((const char * pathname,struct stat * buf	,			
				/* upgrade_last_read() is assumed to be called */
				struct last_read_cache * this_last_read
				));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
