/* $Id: me.h,v 2.119 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.119 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "misclib.h"
#include "addrlib.h"
#include "aliaslib.h"
#include "melib.h"
#include "mime.h"

enum { elm_mp_menu, elm_mp_modified,
       elm_mp_index_width,
       elm_mp_time_menu_width,
       elm_mp_size_with /* or (lines) */,
       elm_mp_COUNT };
struct menu_param {
    enum menu_para_type { mp_integer, mp_menu_common, 
			  mp_anon_param,
			  mp_END } t;
    union {
	int                      i;
	struct menu_common     * c;
	struct menu_anon_param * a;
    } u;
};

#if ANSI_C
struct MailboxView;
struct current_astorage;
struct AliasView;
struct menu_common;
struct menu_context;
struct fbrowser_call;
struct optsmenu;
struct OLD_optsmenu;
struct elm_commands;
#endif

/* --------------------------------------------------------------- */

#if ANSI_C
struct text_block;
#endif

/* src/args.c */

extern void set_early_options P_((int argc,char *argv[]));

/* Returns array of files requested */
extern char ** parse_arguments P_((int argc, char *argv[], char ***to_whom,
				   char **url_mode,
				   const char ** ret_included_file,
				   const char ** ret_subject));
extern char * wanted_charset;
extern int wanted_switchmode;

extern char * conf_backup_suffix;

extern char * wanted_title_string;
extern char * wanted_icon_string;
extern char * with_title;
extern char * wanted_mailbox_title;
extern int    opmode;
extern int    TreatAsSpooled;

extern int confirm_url;
extern int have_DW_characters;

extern struct Attachments {
    mime_t *attach_files;    /* prepare attachments for sending */
    int attachment_count;
} attach_files;

extern const struct Attachments NULL_Attachments;
extern void add_Attachments  P_((struct Attachments *A,mime_t *x));
extern void free_Attachments P_((struct Attachments *A));

/* src/init.c */

extern void initialize P_((struct AliasView **main_alaises, 
			   struct menu_context **page));

struct screen_parts {
    struct menu_context  *title_page;
    struct menu_context  *header_page;
    struct menu_context  *menu_page;
    struct menu_context  *prompt_page;
};

#if ANSI_C
struct url;
#endif

extern struct MailboxView * initialize_mailbox P_((
	    char **requestedmfiles,
	    struct menu_context *page,	
	    struct AliasView *main_aliases,
	    /* Commands from quota display */
	    int   * ret_letter,
	    struct elm_commands        * cmds /* may be NULL */	    
	    ));


extern struct MailboxView * initialize_mailbox_from_url P_((
	    struct url * url,
	    struct menu_context *page,
	    int ask,
	    /* Commands from quota display */
	    int   * ret_letter,
	    struct elm_commands        * cmds /* may be NULL */	    
							    ));

/* src/file_util.c */

#if ANSI_C
struct current_storage;
#endif

int check_mailfile_size P_((struct folder_info *mfile));
int append P_((FILE *fd, char *filename, char *prefix_str,
	       struct menu_context *page));

/* src/find_alias.c */

extern int find_alias P_((char *word, int alias_type,
			  struct AliasView *aview));


/* src/showmsg_c.c */

struct pager_page {
    struct menu_context  * root;    /* Or parent */
   
    struct menu_param  PARAM[elm_mp_COUNT+1];

    struct menu_context  * border_line;
    struct menu_context  * prompt_area;   /* on showmsg_c */
};

extern void showmsg_set_border P_((struct pager_page *pager_page));
extern int sb_showmsg_update_border P_((struct menu_context  *ptr,
					struct menu_param *list));
extern int sb_showmsg_update_prompt P_((struct menu_context  *ptr,
					struct menu_param *list));


extern int showmsg_main_cmd P_((     struct MailboxView *mailbox,
				     int cmd, 
				     struct pager_page *pager_page));
extern void put_cmd_name P_((struct pager_page *pager_page,
			     int will_mangle,
			     const char * format, const char *msg, ...));

extern void put_border P_((     struct menu_context  *page));
extern void build_bottom P_((struct menu_common *menu,
			     struct menu_context  *page));

typedef int showmsg_cmd P_((     struct MailboxView *mailbox,
				 int cmd, 
				 struct pager_page *pager_page));

#define SHOWMSG_NOMAIL     1
extern int process_showmsg_cmd P_((int command,      
				   struct MailboxView *mailbox,
				   showmsg_cmd cmd,
				   struct AliasView  *aview,
				   struct pager_page * pager_page,
				   int flags,
				   struct elm_commands *pager_cmds));


/* src/showmsg_1.c */

extern int show_message_with_headers P_((struct MailboxView *mailbox,
					 showmsg_cmd  cmdX,
					 struct AliasView *aview,
					 struct menu_context  *page,
					 struct menu_context  *header_area,
					 struct elm_commands *pager_cmds
					 ));

extern int show_message_normal P_((struct MailboxView *mailbox,
				   showmsg_cmd  cmdX,
				   struct AliasView *aview,
				   struct menu_context  *page,
				   struct menu_context  *header_area,
				   int flags,
				   struct elm_commands *pager_cmds));

extern int show_next_message P_((struct MailboxView *mailbox,
				 showmsg_cmd  cmdX,
				 struct AliasView *aview,
				 struct menu_context *page,
				 struct menu_context *header_area,
				 struct elm_commands *pager_cmds));

/* src/movement.c */

typedef void move_message P_((void));

struct move_messages {
    move_message   * first_item;
    move_message   * last_item;
};

extern int do_movement P_(( struct menu_context *ptr, int ch, int len,
			    struct move_messages *m));
extern int do_movement1 P_((struct menu_context *ptr, int ch, int len,
			    struct move_messages *m));

/* src/motion.c */

/* Return key if unknown */

extern int motion P_((int ch, struct menu_common *mc,
		      struct screen_parts *LOC,		      
		      struct menu_context  *page,
		      struct elm_commands *menu_cmds
		      ));

enum process_motion_actions { 
    motion_done      = 256,
    /*   EOF         = -1  */
    motion_EOF       = EOF,
    motion_exit_loop = 0,
    motion_view      = 257

};

/* Returns enum process_motion_actions or
   key if unknown */

extern enum process_motion_actions 
    process_motion_command P_((int ch,
			       struct menu_common *mc,
			       struct string **msg_line));


/* src/network.c */

enum mbx_cancel_message {
    mbx_closing_con,
    mbx_leaving_mailbox,
    mbx_checking_mailbox
};

extern void setup_mbx_cancel_message P_((struct cancel_data **cancel_info,
					 enum mbx_cancel_message msg));

/* src/elm.c */

extern void mailbox_screen_common P_((struct menu_context  *page, 
				      struct screen_parts *LOC,
				      struct menu_param  *LIST));

extern void free_mailbox_screen P_((struct screen_parts *LOC));

extern void check_range P_((struct menu_common *mc,
			    struct screen_parts *LOC));
extern void forget_passphrase P_((void) );

extern int mailbox_command P_((struct MailboxView *mailbox, int ch, 
			       struct screen_parts *LOC,
			       showmsg_cmd cmdX,
			       struct AliasView *aview,
			       struct menu_context  *page,
			       struct elm_commands *pager_cmds,
			       int is_main_message_loop,
			       struct elm_commands *menu_cmds
			       ));
extern void new_mail_check P_((struct MailboxView *mailbox,
			       struct menu_context  *page,
			       struct screen_parts *LOC,
			       const char **exit_hint_p));


/* src/help.c */

/*  Returns EOF if EOF seen */
extern int help_generic P_((struct elm_commands  * cmds,
			    int pager_help, 
			    struct menu_context  *page,
			    struct menu_context  *prompt_area));


/* src/in_utils.c */

extern int want_to P_((char *question, int dflt, int where, 
		       int clear_and_center,
		       struct menu_context  *page));

extern int read_number      P_((int ch, const struct string *item, int defval,
				struct menu_context  *page,
				struct menu_context  *prompt_area));

#define PROMPT_center       1
#define PROMPT_yesno        2
#define PROMPT_redraw_mark  4
#define PROMPT_ctrlL        8
#define PROMPT_cancel      16

extern int prompt_letter P_((int line, char *letters, int def,
			     int flags, 
			     struct menu_context  *page,
			     const char * format, const char *msg, ...));

#define OE_APPEND_CURRENT   (1<<0)
#define OE_PASSWD           (1<<1)
#define OE_REDRAW_MARK      (1<<2)
#define OE_ADD_COMMA        (1<<3)
#define OE_ALT_SOLIDUS      (1<<4)
#define OE_ALLOW_MIMEENC    (1<<5)
#define OE_EDITOR_ESCAPE    (1<<6)
#define OE_TABACTION        (1<<7)
#define OE_SIG_CHAR             (1<<8)

extern int optionally_enter2 P_((struct menu_context  *page,
				 struct string **buffer, 
				 int x, int y, int flags, 
				 const char * format, const char *msg, ...));
extern int optionally_enter P_((char *string, int x, int y, 
				int flags, int size,
				struct menu_context  *page));
extern int pattern_enter    P_((struct string **string, 
				struct string **alt_string, 
				int x, int y, 
				struct string *alternate_prompt, 
				struct string *prompt,
				int *redraw,
				struct menu_context  *page));

extern int GetPrompt        P_((struct menu_context  *page,
				int wait_time));


/* src/enter_helper.c ------------------------------------------------------- */

#if ANSI_C
struct enter_info;
#endif

/* Notify buffer changes */

enum alter_buffer_action { ab_erase, ab_free_buffer, ab_truncated, ab_autocomma };

typedef void alter_buffer_r P_((struct enter_info *I,
				struct string **buffer,
				enum alter_buffer_action action,
				struct menu_context *base_page));

enum  full_page_action { fp_resized, fp_redraw };

typedef void full_page_r  P_((struct enter_info *I,
			      enum full_page_action action,
			      struct menu_context *base_page));

#if ANSI_C
extern full_page_r default_full_page;
#endif
extern void default_full_page  P_((struct enter_info *I,
				   enum full_page_action action,
				   struct menu_context *base_page));

#if ANSI_C
extern alter_buffer_r default_alter_buffer;
#endif
extern void default_alter_buffer P_((struct enter_info *I,
				     struct string **buffer,
				     enum alter_buffer_action action,
				     struct menu_context *base_page));


enum enter_mode { em_redraw, em_enter, em_prev, em_next, em_wrap,
		  em_redraw_initial, em_editor_escape, em_tabaction,
		  em_bs_prev, em_left, em_right,
		  
		  em_page_up, em_page_down,

		  em_F1_key,
		  em_F2_key,
		  em_F3_key,
		  em_F4_key,
		  em_F5_key,
		  em_F6_key,
		  em_F7_key,
		  em_F8_key,
		  em_F9_key,
		  em_F10_key,
		  em_F11_key,
		  em_F12_key,
};

/* FOr debug */

extern const char * enter_mode_debug_name P_((enum enter_mode em));


typedef struct string **give_buffer_r P_((struct enter_info *I,
					  enum enter_mode em,
					  struct menu_context *base_page));

enum prompt_hint_mode { phm_clear = 0, phm_empty_buffer };

typedef void prompt_hint_r P_((struct enter_info *I,
			       enum prompt_hint_mode phm,
			       struct menu_context *base_page));
			      
#if ANSI_C
extern prompt_hint_r default_prompt_hint;
#endif
extern void default_prompt_hint P_((struct enter_info *I,
				    enum prompt_hint_mode phm,
				    struct menu_context *base_page));
			      

#define ENTER_INFO_magic	0xEB23

struct enter_info {
    unsigned short magic; 	/* ENTER_INFO_magic */
    
    struct string      ** pvector;
    
    give_buffer_r       * give_buffer;
    alter_buffer_r      * alter_buffer;
    full_page_r         * full_page;
    prompt_hint_r       * prompt_hint;
    
    int flags;
    int ch_count;
    struct in_utils_edit *in_utils;
    struct builtin_edit  *builtin;
    struct browser_edit  *browser;
    struct address_edit  *address;

    struct menu_context *current_page;  /* give_buffer_r may alloc new */
};

extern void zero_enter_info P_((struct enter_info *info));

extern int enter_helper P_((struct enter_info *info,
			    struct menu_context *prompt_area,
			    struct menu_context *base_page));

/* src/out_utils.c */

extern void error_wait P_((void));   /* call before exiting */
extern void sleep_message P_((void));
extern int  error P_((const char *s));
extern void out_util_setup P_((void));

/* Returns 1 if error was shown (was on RawState()) */
extern int show_last_error P_((void));
extern void clear_error P_((void));
extern void set_error P_((char *s));
extern void lower_prompt P_((char *s));

extern void prompt P_((char *s));
extern void prompt_s P_((struct menu_context  *page,
			 const struct string *S));

extern void print_center P_((int line, struct string * buffer));
extern void menu_print_center P_((struct menu_context  *ptr, 
				  int line, const struct string * buffer));
extern void print_format_center P_((int lineY,const char *format, 
				    const char *line, ...));
extern void menu_print_format_center P_((struct menu_context  *ptr,
					 int lineY,const char *format, 
					 const char *line, ...));

extern void Raw_OFF P_((int exiting));  /* used on init.c for exit */

/* Used by newmbox.c */
extern int need_refresh_low_line P_((void));

extern int open_messages_log P_((const char *filename));
extern void close_messages_log P_((void));

/* src/pattern.c */

extern int from_matches P_((struct header_rec *mss, struct string *pat));
extern int to_matches P_((struct header_rec *mss, struct string *pat));
extern int cc_matches P_((struct header_rec *mss, struct string *pat));
extern int subject_matches P_((struct header_rec *mss, struct string *pat));
extern int match_in_message P_((struct string *pat,
				struct MailboxView *mailbox,
				struct AliasView *aview));
extern enum pattern_result {
   pattern_intr      = -2,
   pattern_eof       = EOF,
   pattern_not_found = 0,
   pattern_found     = 1

} pattern_match P_((struct menu_common *mc, 
			     struct menu_context *page,
			     struct screen_parts *LOC));
extern int meta_match P_((int function, struct menu_common *mc,
			  struct menu_context *page,
			  struct screen_parts *LOC));


/* src/addr_prompt.c */

extern int prompt_expanded_address P_((struct menu_context  *page,
				       struct expanded_address *expanded,
				       struct mailer_info      *mailer_info,
				       struct string          **buffer /* for redraw */,
				       struct AliasView *aview /* May be NULL */,
					struct string           * title  /* Title on full page mode */,
				       struct menu_context     *prompt_area,
				       /* Cordinates use prompt_area */
				       int x, int y, int flags, 
				       const char * format, const char *msg, ...));

/* src/addr_util.c */

#if ANSI_C
struct aliasview_record;
#endif

extern void free_addr_util P_((void));

extern int build_address_l P_((struct expanded_address *expanded,
			       struct mailer_info      *mailer_info,

			       /* aview is NULL if aliases are ignored */
			       struct AliasView *aview 
			       ));


extern int build_address_is_local P_((const char *domain));

extern int need_verify_ldomain P_((struct mailer_info      * mailer_info,
				   const char *addr));

extern int argv_to_expanded P_((struct expanded_address *result,
				char *argv[],
				struct mailer_info      *mailer_info,
				struct AliasView *aview));
extern void addr_to_expanded P_((struct expanded_address *result,
				 struct addr_list *addrs,
				 struct mailer_info      *mailer_info,
				 struct AliasView *aview));
extern void expanded_to_edit_buffer P_((struct string ** buffer,   
					struct expanded_address expanded
					));
extern void update_expanded_from_edit_buffer P_((struct expanded_address 
						 *expanded,
						 const struct string *buffer,
						 struct mailer_info     
						 *mailer_info,
						 /* aview is NULL if aliases 
						    are ignored  */
						 struct AliasView *aview
						 ));

/* parses without expanding --- */

extern void update_textual_from_tokenized P_((const struct expanded_address *expanded,
					      struct expanded_address *result,
					      struct string_token * tokenized,
					      struct AliasView *aview /* Used as flag */,
					      const struct string *buffer /* For error message */
					      ));


extern int aliases_to_expanded P_((struct expanded_address *x,
				   struct AliasView *aview));

extern void add_one_alias_to_expanded P_((struct expanded_address *x,
					  struct aliasview_record  *a));

/* src/alias.c */


#if ANSI_C
struct current_storage;
#endif

extern int lookup_dummy P_((union alias_stack_item     value,
			    const struct string       *alias,
			    const struct address_alias **result_alias,
			    /* Caller must free result_list */
			    struct addr_list          **result_list,
			    enum alias_address_expand_result * expand_result
			    ));


extern int alias      P_((struct MailboxView *mailbox,
			  struct AliasView *aview));

extern int delete_from_alias_text P_((char **name, int num_to_delete));

extern const struct string *address_to_alias P_((
        const struct address * address,
	struct AliasView *aview));

/* src/a_edit.c */

extern int edit_aliases_text P_((struct AliasView *aview, 
				 struct menu_context *page,
				 struct screen_parts *LOC));

/* src/a_sort.c */

enum sort_aliases_mode { sa_silent_sort = 0,
			 sa_visible_sort /* Shows sort message if
					    entries > 30
					 */
};

extern void sort_aliases P_((int entries, enum sort_aliases_mode show_message,
			     struct AliasView *aview));
extern char *alias_sort_name P_((int type));

/* src/a_screen.c */

extern struct string *build_alias_line P_((struct  aliasview_record *entry,
					   int message_number, int highlight,
					   struct menu_context *page,
					   int index_width));

extern void alias_screen P_((struct AliasView *aview,
			     struct menu_context *page));
extern int sb_alias_menu P_((struct menu_context  *ptr,
			     struct menu_param *list));

extern void show_alias_menu P_((struct menu_context *page));

extern char *show_alias_status P_((struct aliasview_record *entry));
extern void set_folder_window_title P_((struct folder_info *folder,
					char *title_s, char *icon_s));

extern char *alias_type P_((int type));

/* src/a_quit.c */

extern void exit_alias    P_((struct AliasView *aview));
extern int delete_aliases P_((int newaliases, int prompt,
			      struct AliasView *aview,
			      struct menu_context  * page,
			      struct screen_parts *LOC));

/* src/exitprog.c */

/* returns:

   0 .. do not do exit
   1 .. do normal exit
   EOF

   Does NOT free mailbox
*/

extern int exit_mailbox P_((struct MailboxView *mailbox,
			    struct menu_context *page));

/* src/file.c */

extern int expand_filename P_((char *, int, int));
extern void init_helpmsg P_(( char *, char *, int, int ));
extern int save P_((int silently, int delete, int text_only,
		    struct MailboxView *mailbox,
		    struct AliasView *aview, 
		    struct menu_context *page,
		    struct menu_context *prompt_area,
		    struct menu_context *header_area));
		   

/* src/fileutil.c */

extern FILE *open_end_update P_((char *name));

/* src/pgp.c */
extern int pgp_menu			P_((char *filename,
					    struct mailing_headers *headers,
					    struct menu_context  *page));
extern void pgp_extract_public_key	P_((struct header_rec  *hdr,
					    FILE *infile,
					    struct menu_context *page));
extern void pgp_mail_public_key          P_((struct MailboxView *mailbox,
					     struct AliasView *aview,
					     struct menu_context  *page,
					     struct menu_context  *prompt_area));
/* src/read_rc.c */

extern void directory_check     P_((void));
extern void aliases_check P_((struct AliasView *main_aliases));


enum pager_prompt {
    prompt_quit_pager     = 0,
    prompt_return_index   = 1  /* have index */,
    prompt_quit_or_return_index
};

/* src/builtin++.c */
extern int builtinplusplus	P_((struct stringbuffer * bout,
				    struct pager_page   * pager_page,
				    int is_helper,
				    struct elm_commands *pager_cmds,
				    enum pager_prompt have_index));

/* src/mime.c */

extern const char * have_metamail P_((void));
extern void clear_mime_send_info P_((mime_send_t *mime_info));
extern void free_mime_send_info P_((mime_send_t *mime_info));

/* Returns 1 if OK */
extern int convert_text P_((FILE *source, FILE *dest, 
			    mime_send_t *mime_info,
			    charset_t from_charset,
			    charset_t to_charset,
			    int do_pgp,
			    struct Attachments *attachments,
			    struct mailer_info  *mailer_info,
			    struct menu_context *page,
			    struct menu_context *prompt_area,
			    const struct remote_server *remote_server));

/* src/strings.c */

extern void Centerline P_((int line,
			   char *string,
			   struct menu_context  *page));

extern char *argv_zero P_((const char *string));

extern char *get_token P_((char *source, char *keys,
			   int   depth));


/* src/string2.c */

/* NOTE: Must be 'int ch', no 'char ch' so that it matches to default promotion
         of arguments
*/
extern int occurances_of P_((int ch, char *string));

/* src/fileio.c */
extern int copy_message P_((struct folder_info *, struct header_rec *,
			     char *, FILE *, int, charset_t));
extern int copy_message_f P_((FILE *infile, struct header_rec *current_header,
			      FILE *dest_file,
			      int cm_options, charset_t file_set,
			      const char *sender));

extern int copy_message_d P_((struct folder_info *infolder,
			      struct header_rec *current_header,
			      struct folder_browser *dir, 
			      WRITE_STATE dest, int cm_options,
			      charset_t file_set,
			      const char *sender));
extern int copy_message_df P_((FILE *infile,
			       struct header_rec *current_header,
			       struct folder_browser *dir,
			       WRITE_STATE dest,
			       int cm_options,
			       charset_t file_set,
			       const char *sender));

extern int copy_message_2 P_((FILE *infile, 
			      struct header_rec *current_header,
			      struct out_state *dest_file, 
			      int cm_options,
			      int env_flags,
			      const char *sender));

extern int copy_body P_((FILE *infile, 
			 struct header_rec *current_header,
			 struct out_state *dest_file, 
			 int cm_options));

extern int copy_plain P_((struct out_state *,int, struct header_rec *, 
			   FILE *));
extern int copy_mime P_((struct out_state *,int, struct header_rec *, 
			  FILE *));

typedef int copy_decoder P_((struct out_state *,int, struct header_rec *,
			     FILE *));
typedef copy_decoder *copy_decoder_t;
extern copy_decoder_t select_copy_decoder P_((struct header_rec *));

/* src/newmbox.c */

extern  enum sessionlock_status  open_folder_lock P_((enum lock_direction direction,
						 struct folder_info *folder));
extern int reopen_folder_lock_sessionlock P_((struct folder_info *folder));

extern int parse_header_routine P_((struct folder_info *folder,
				    READ_STATE read_state_ptr,
				    struct header_rec *current_header,
				    header_list_ptr parsed_headers 
				    ));

extern void parse_body_line_helper P_((struct header_rec * current_header,
				       const char        * buffer,
				       const int           len));

extern int parse_body_routine P_((struct folder_info *folder,
				  READ_STATE read_state_ptr,
				  struct header_rec *current_header,
				  header_list_ptr parsed_headers,
				  struct counter_data *counter
				  ));

#if ANSI_C
struct current_storage;
struct quota_display;
#endif
extern void newmbox_1 P_((struct folder_info *new_folder,
			  struct MailboxView **mailbox,
			  int append, 
			  struct menu_context *page,
			  int was_reconnected,
			  RECONNECT_MODE * reconnect_ptr,
			  struct quota_display *quotad
			  ));
extern int read_new_mails P_((struct current_storage *storage,
			      struct menu_context *page));
extern int reconnect_mails P_((struct current_storage *storage,
			       struct menu_context *page));

extern void resort_mailbox P_((struct MailboxView *mailbox,
			       int add_new_only));

extern void add_new_mailbox P_((struct folder_info   * new_folder,
				struct MailboxView   * mailbox,
				struct menu_context  * page,
				struct quota_display * quotad));


extern struct menu_context *  quota_display_current_page
       P_((struct quota_display * quotad));

/* If new folder is freed / moved to new owner,
   then *new_folder == NULL is NULL
   if *new_folder is not modified (set to NULL)
   caller must free *new_folder 

   reads mailbox
*/
extern struct MailboxView * enter_mailbox P_((struct folder_info **new_folder,
					      struct menu_context *page,
					      struct quota_display *quotad
					      ));

/* src/reconnect.c */

const char * found_disconnected P_((struct MailboxView *mailbox));

extern void update_selected_counter P_((struct MailboxView *mailbox));
					
extern int ReconnectMailbox P_((struct MailboxView *mailbox,
				struct menu_context  *page));

extern void ReconnectMailboxPost P_((struct MailboxView *mailbox,
				     struct menu_context  *page,
				     struct screen_parts *LOC));

/* src/openmailbox.c */

/* Opens new mailbox to current mailbox view without closing current mailbox */
/* Return EOF if EOF seen */
extern int OpenMailbox P_((struct MailboxView *mailbox, 
			    struct AliasView *aview,
			    struct menu_context  *page));
extern void OpenMailboxPost P_((struct MailboxView *mailbox, 
				struct menu_context  *page,
				struct screen_parts *LOC));


/* src/file_util.c */

extern long fsize P_((FILE *));
extern long bytes P_((char *));
extern int copy_to_folder P_((FILE * from, struct folder_info *to));
extern int copy1 P_((FILE *from, char *to, int isspool));

/* src/mailcap_sel.c */

struct prompt_programs_list {
    struct mimeinfo * structure;
    char            * printable_command;
    char            * blacklisted_command;

    unsigned int              selected :1;    
    unsigned int              need_metamail :1;
    unsigned int              type_not_found :1;

    int    col;

    int    list_position;
};

enum prompt_mailcap_other_stat {
    prompt_mailcap_other_EOF = EOF,
    prompt_mailcap_other_none = 0,
    prompt_mailcap_other_navigate
} prompt_mailcap_other P_((struct prompt_programs_list *pg,			   
			   struct menu_context  *parent_page,
			   int *ret_ch));
			   
/* src/mailmsg1.c */

extern void a_sendmsg P_((int edit_message, 
			  struct MailboxView *mailbox,
			  struct AliasView *aview, 
			  struct menu_context *page,
			  struct screen_parts *LOC));

extern int send_msg_argv P_((char *argv[],
			     const char *given_subject,
			     int options, 
			     struct AliasView   *aview,
			     struct menu_context *page,
			     struct menu_context *prompt_area,
			     int *exit_status,
			     struct text_block  *body));

extern int send_msg_url P_((const struct url *url,
			    const char * given_subject,
			    int options, 
			    struct AliasView   *aview,
			    struct menu_context *page,
			    struct menu_context *prompt_area,
			    int *exit_status,
			    struct text_block  *body));

extern int send_msg_middle2 P_((struct mailing_headers *headers,
				int index,
				int   options, 
				struct mailer_info  *mailer_info,
				struct MailboxView *mailbox,
				struct AliasView *aview,
				struct menu_context *page,
				struct menu_context *prompt_area,
				struct text_block *body,
				int *exit_status,
				int pgp_status,
				struct header_rec *current_header  /* for forwarding */));


extern int send_msg_middle P_((int index,
			       struct expanded_address *given_to, 
			       struct expanded_address *given_cc,
			       const char *given_subject,
			       int   options, 
			       struct mailer_info  *mailer_info,
			       struct MailboxView *mailbox,
			       struct AliasView *aview,
			       struct menu_context *page,
			       struct menu_context *prompt_area,
			       struct text_block *body,
			       int *exit_status,
			       int pgp_status,
			       struct header_rec *current_header  /* for forwarding */));

extern int send_msg_l P_((int index,
			  struct addr_list *given_to, 
			  struct addr_list *given_cc,
			  char *given_subject,
			  int   options, 
			  struct MailboxView *mailbox,
			  struct AliasView *aview,
			  struct menu_context *page,
			  struct menu_context *prompt_area,

			  struct header_rec *current_header  /* for forwarding */
			  ));

extern void display_to P_((struct expanded_address address,
			   struct menu_context  *page,
			   /* NULL if mail only mode */
			   struct menu_context *prompt_area));

extern int get_to P_((struct expanded_address *to,
		      struct mailer_info      *mailer_info,
		      struct AliasView        *aview,
		      struct menu_context     *page,
		      struct MailboxView      *cancel_view,
		      int                     *cancel_selection,
		      struct menu_context     *prompt_area));


/* src/mailmsg2.c -------------- */

#if ANSI_C
struct run_state;           /* Needed for prototype */
struct text_block;
#endif

/* Clear page and make 4 line prompt area */
struct menu_context *prompt_mailmsg_page_interactive P_((struct menu_context *page));


extern struct string * gen_From_buffer P_((const struct header_rec * current_header));

/* Returns 0 if reading of body failed */
extern int mail P_((int idx, 
		    int options, 
		    struct mailing_headers *headers,
		    struct mailer_info  *mailer_info,
		    struct MailboxView *mailbox,
		    struct AliasView *aview,
		    struct menu_context  *parent_page,
		    struct MailboxView *selection_view,
		    int selection_idx,
		    struct text_block *body,
		    int *exit_status,
		    int pgp_status));

extern int attach_rfc822 P_((struct Attachments *attachments,
			     struct header_rec  *hdr,
			     FILE               *mailbox_file,
			     struct string      *title,
			     enum mailer_capab  mailer_level));
extern int attach_body P_((struct Attachments *attachments,
			   struct header_rec  *hdr,
			   FILE               *mailbox_file,
			   enum mailer_capab  mailer_level));

extern enum mailer_capab get_mailer_level P_((struct mailer_info 
					      *mailer_info));

/* src/canceled.c */

extern char * last_canceled_mail;
extern int view_canceled_mails P_((struct MailboxView * cancel_view,
				   int *cancel_selection,
				   struct AliasView *aview));
/* src/aliaslib.c */

extern struct addr_list *get_alias_address_expanded P_((
           const struct string              * name, /* name to expand as an alias */
	   struct mailer_info               * mailer_info,
	   struct AliasView                 * aview,
	   int                                unquote,
	   enum alias_address_expand_result * expand_result));

extern const struct address_alias *get_alias_only P_((
           const struct string   *name, /* name to lookup as an alias */
	   struct AliasView *aview));



/* src/syscall.c */

extern int system_call    P_((const char *, volatile int,      
			      struct MailboxView *mailbox));

extern void subshell       P_((struct MailboxView *mailbox,
			       struct menu_context  *page,
			       struct menu_context  *prompt_area));

extern void do_pipe       P_((struct MailboxView *mailbox,
			      struct menu_context  *page,
			      struct menu_context  *prompt_area));
extern const char * have_printout  P_((void));
extern void print_msg      P_((int pause_on_scroll,
			       struct MailboxView *mailbox,
			       struct menu_context  *page,
			       struct menu_context *prompt_area));
extern void print_text     P_((int pause_on_scroll,      
			       struct MailboxView *mailbox,
			       struct menu_context  *page,
			       struct menu_context  *header_area,
			       struct menu_context *prompt_area));

extern int create_folder_state_file P_((struct MailboxView *mailbox));
extern int remove_folder_state_file P_((void));

/* src/savecopy.c */

struct copy_file {
    struct string         * copy_file;
    struct folder_browser * dir;
};


extern void zero_copy_file P_((struct copy_file *cf));
extern void clear_copy_file P_((struct copy_file *cf));
extern void name_copy_file P_((struct copy_file *cf,
			       struct AliasView *aview,
			       struct MailboxView *mailbox,
			       struct menu_context  *page));

extern int save_copy P_((struct mailing_headers * headers,
			 struct copy_file *cf,
			 mime_send_t *mime_info,
			 FILE * conv_file,
			 struct menu_context  *page,
			 struct AliasView *aview,
			 struct menu_context *prompt_area));

extern int append_copy_to_file P_((struct mailing_headers * headers,
				   struct folder_browser *cf,
				   mime_send_t *mime_info,
				   FILE * conv_file,
				   WRITE_STATE dest));


enum cm_across_mode { cm_across_send = 0, cm_across_copy = 1,
		      cm_across_preview = 2};


extern void write_header_info P_((struct out_state *mailer,
				  struct mailing_headers * headers,
				  enum cm_across_mode copy,
				  mime_send_t *mime_info));
		     
extern int copy_message_across P_((mime_send_t *mime_info,
				   struct out_state *dest, 
				   enum cm_across_mode copy,
				   FILE *conv_file));

/* src/mime.c */

#if ANSI_C
struct scan_list;
#endif

extern int check_for_multipart	P_((FILE *filedesc, mime_send_t *mime_info,
				    struct mailer_info  *mailer_info,
				    charset_t from_charset,
				    const struct remote_server *remote_server));

/* src/mime_encode.c */


extern int attach_message P_((mime_t *part, struct out_state *mailer, 
			      mime_send_t *mime_info, 
			      struct mime_send_part * X));

extern char *mime_generate_boundary	P_((char *, int));

extern enum encoding update_encoding P_((enum encoding *top_encoding,
					 enum encoding encoding));
extern void write_encoded P_((FILE *srcfp, struct out_state *mailer, 
			      enum encoding encoding, 
			      int is_text, mime_send_t *mime_info,
			      int source_is_binary));

extern void mime_write_part_headers P_((struct out_state *fp,
					mime_send_t *ptr,
					struct mime_send_part * part));
extern void mime_write_top_headers P_((struct out_state *fp,
				       mime_send_t *ptr));
extern void rfc1522_encode_text         P_((char *,int,const char *,int));

void mime_write_header P_((struct out_state *mailer,
			   const char *hdr_name,
			   const char *first_part,
			   struct mime_param * opts,
			   enum encoding top_encoding));


/* src/attach_menu.c */

extern void attach_menu		P_((FILE *F,
				    mime_t *T,
				    struct Attachments *A,
				    charset_t defcharset,
				    struct mailer_info  *mailer_info,
				    struct header_rec *hdr,
				    struct AliasView *aview,
				    struct MailboxView *mailbox,
				    struct header_errors **header_error,
				    const struct remote_server *remote_server));

extern int Attach_it             P_((const char *pathname));
extern int Check_attachments     P_((void));

#define MAX_COMPAT_LEN   70
extern char * compat_filename P_((const char * orig, int *ok));
extern struct string * pick_name P_((const struct string *str));
extern char * pick_name_ascii P_((const char *str, int *was_ok)); 

extern int detect_mime_type P_((const char * filename, 
				media_type_t *TYPE, 
				struct mime_param **TYPE_opts,
				const char *ext,
				struct scan_list *scanlist));

extern struct scan_list * init_scanlist P_((const char *ext));


/* src/returnadd.c */
extern void kludge                      P_((char *buffer, int size));

/* src/lock.c */

extern int unlock P_((int interrupt, struct folder_info *folder));
extern int lock P_((enum lock_direction direction,struct folder_info *folder));

/* src/utils.c */

extern void utils_open_debug P_((void));
extern void emergency_exit P_((int interrupt));
extern void leave P_((int interrupt, int exit_status));
extern void create_new_folders P_((void));
extern void create_new_elmdir P_((void));
extern void rm_temps_exit P_((void));
extern void silently_exit P_((void));
extern void leave_locked P_((void));
extern void get_page P_((struct menu_common *mc,
			struct menu_context  *header_page));

extern void malloc_failed_exit P_((char *proc,size_t n));

/* src/date.c */

#define TODAY_INFO_magic	0xF527

struct today_info {    /* Handled by src/messages/messages.c */
    unsigned short            magic;   /* TODAY_INFO_magic */

    int    tz_mins;   /* offset, in minutes, EAST of GMT */

    /* Range when time is today on local time */

    time_t today_start_time;
    time_t today_end_time;
    
    /* struct tm  values: */
    
    int tm_mday;   /* Day of the month (1-31) */
    int tm_mon;    /* Month (0-11) */
    int tm_year;   /* Year - 1900 */
    
    
};

/* Caller must free -- uses return value of days_ahead_tm() ,
   return NULL on failure
*/
extern struct string * days_ahead_text P_((const struct tm * expire_time,
					   enum print_time print_time));

enum pager_zone_mode {
    elm_date_no_zone,
    elm_date_show_zone };
    

/* Caller must string_free() result;
 *  may return NULL
 *
 */
extern struct string * elm_date_text P_((struct header_rec         * entry,
					 enum pager_time_display_v time_mode,
					 enum pager_zone_mode      show_zone));



extern void make_menu_date P_((struct header_rec       * entry,
			       enum time_menu_mode       menu_type,
			       const struct today_info * today_info
			       ));



/* src/reply.c */

extern void append_addresses_to_addr_list P_((struct addr_list *target,
					      const struct addr_list *list));
extern struct addr_list *  handle_reply_to P_((struct header_rec * 
					      current_header,
					      FILE *infile));
extern struct addr_list *  get_and_expand_everyone 
    P_((struct header_rec      * current_header,
	struct addr_list       * return_address,
	const struct address   * usraddr));

extern void get_return_name P_((const char *address, 
				char *name,
				int   trans_to_lowercase,
				int size));
extern void forward P_((int index,
			struct MailboxView *mailbox,
			struct AliasView *aview,
			struct menu_context  *page,
			struct menu_context  *prompt_area,
			struct menu_context  *header_area));
extern void reply_to_everyone P_((int index,
				  struct MailboxView *mailbox,
				  struct AliasView *aview,
				  struct menu_context *page,
				  struct menu_context *prompt_area,
				  struct menu_context *header_area));
extern void reply P_((int index,
		      struct MailboxView *mailbox,
		      struct AliasView   *aview,
		      struct menu_context  *page,
		      struct menu_context  *prompt_area,
		      struct menu_context  *header_area));

/* src/leavembox.c */

extern enum sync_mbox_stat {
    sync_mbox_EOF       = -5,
    sync_mbox_cancel    = -4,  
    sync_mbox_reconnect = -3,
    sync_mbox_failure   = -2,
    sync_mbox_newmail   = -1,
    sync_mbox_nochange  = 0,
    sync_mbox_changed   = 1
} sync_mbox P_((int resyncing,  int quitting, int prompt,
		struct folder_info **new_folder,
		struct MailboxView *mailbox,
		struct menu_context  *page,
		struct menu_context  *prompt_area));

/* sync_mbox() must be called before close_cleanup_mbox */

extern void close_cleanup_mbox P_((struct MailboxView *mailbox));


		
/* src/mkhdrs.c */

extern void generate_reply_to P_((struct header_rec * current_header,
				  struct mailing_headers *headers));
extern void generate_references P_((struct header_rec * current_header,
				    struct mailing_headers *headers));


/* src/opt_generic.c */

extern struct optsmenu * malloc_optsmenu P_((void));
extern void free_optsmenu P_((struct optsmenu **ptr));

typedef void option_post_handling_f P_((int));

extern void NULL_option_post_handling P_((int));

extern void add_old_options P_((struct optsmenu *ptr, 
				const struct OLD_optsmenu * opts));


/* pointers are shared -- must be malloced and caller must not free them */
extern void add_option P_((struct optsmenu *ptr, int letter,
			   char *parm, 
			   struct string *menu_prompt,
			   struct string *one_liner,
			   option_post_handling_f *post));


extern const struct opts_menu_item * gen_find_cfg_opts P_((
         struct optsmenu *cfg_opts, 
	 int c));

/* 256 == done
   256 <> return with that value
   EOF    return with that value
*/
   
typedef int option_extra_func P_((struct optsmenu *cfg_opts,
				  struct menu_context *page,
				  int key));

#define OPTION_EXTRA_magic      0xF514
  
struct option_extra {
    unsigned short magic;      /* OPTION_EXTRA_magic */
    int key;               
   
    struct string     * help_text;
    option_extra_func * func;    

    struct option_extra * next;
};

extern struct option_extra * alloc_extra_action_f P_((int key,
						      option_extra_func * func,
						      const char *format,
						      const char *msg, ...));

extern void free_extra_action_list P_((struct option_extra **list));


/* 0 == OK
   EOF  return with that value
*/

extern int gen_options P_((struct optsmenu     * cfg_opts,
			   struct menu_context * parent_page,
			   struct option_extra * extra_actions,
			   struct elm_commands * cmds  /* for help */,
			   struct string       * title,
			   const char          * opt_string,
			   struct string       * menu_text));

/* src/options.c */

extern int options P_((struct MailboxView *mailbox,
		       struct AliasView *aview,
		       struct menu_context *parent_page,
		       int *setscreen));
extern char * level_name P_((int n));
extern void init_opts_menu P_((void));
extern void free_opts_menu P_((void));

const struct opts_menu_item * find_cfg_opts P_((int c));


/* src/hdrconfig.c */

#define HDRMENU_CONTEXT_magic	0xF613

extern struct hdrmenu_context {
    unsigned short magic;    /* HDRMENU_CONTEXT_magic */ 

    struct string           * buffer;
    struct expanded_address * exp_buffer; /* on  prompt_expanded_address() */

    /* Title on full page mode on  prompt_expanded_address() */
    struct string           * title;
    
    unsigned   redrawing:1;

} NULL_hdrmenu_context;

extern void clear_hdrmenu_context P_((struct hdrmenu_context *cnt));


extern charset_t want_convert_to_utf7 P_((const struct string * text));

extern void display_add_one_address P_((struct string ** buffer,
					const struct address * address));
extern void display_add_phrase P_((struct string ** buffer,
				   const struct string *str));


enum show_presend_mode {
    show_prehdr_normal,
    show_prehdr_bounce
};

extern void show_presend_headers P_((struct mailing_headers *headers,
				     charset_t hdr_charset,
				     struct menu_context  *page,
				     enum show_presend_mode show_prehdr_mode
				     ));




/* returns 0 if command not found
           1 if found 
	   REDRAW_MARK is redraw required 
*/
extern int presend_action P_((struct mailing_headers * headers,
			      struct mailer_info     * mailer_info,
			      int                      c,
			      struct hdrmenu_context * redraw_context,
			      charset_t                hdr_charset,
			      struct AliasView       * aview,
			      struct menu_context    * page,
			      struct menu_context    * prompt_area,
			      struct header_rec      * parent_message,
			      enum show_presend_mode   show_prehdr_mode));
extern void edit_headers P_((struct mailing_headers * headers,
			     struct mailer_info     * mailer_info,
			     charset_t                hdr_charset,
			     int                      hdr_encondig_supported,
			     struct AliasView       * aview,
			     struct header_rec      * parent_message));

extern struct string *hdr_to_expval P_((struct expanded_address addrs));

/* src/remail.c */

extern void remail P_((struct header_rec *hdr,
		       FILE *F, struct AliasView *aview,
		       struct menu_context  *page,
		       struct menu_context  *prompt_area));

extern void do_mmdf_addresses P_((FILE *dest_file,
				  struct mailing_headers * headers));

extern int  convert_remail_message_1 P_((FILE *infile,
					 struct header_rec *current_header,
					 enum mailer_capab  mailer_level,
					 struct out_state      * target,
					 enum encoding    * encoding,
					 const char * sender));

/* src/editmsg.c */

extern void  edit_headers_on_editor P_((struct mailing_headers *headers,
					const char *editor, 
					int encoding_supported,
					struct menu_context *page));

/* src/editmsg.c */

extern int have_editor P_((const char *editor));
extern int edit_the_message P_((char *filename,
				int  already_has_text,
				struct mailing_headers * headers,
				const char *editor /* NULL == use "editor" or 
						      "alteditor" */, 
				charset_t  file_set,
				struct mailer_info  *mailer_info,
				struct MailboxView *mailbox /* needed for
							       system_call() */,
				struct AliasView *aview,
				struct menu_context *page
				));

extern int no_editor_edit_the_message P_((char *filename,
					 struct mailing_headers * headers,
					 charset_t  file_set,
					 struct mailer_info  *mailer_info,
					 struct MailboxView *mailbox
					 /* needed for system_call() */,
					 struct AliasView *aview
					 ));

/* src/delete.c */

extern void delete_msg   P_((int real_del, 
			     struct menu_common *mc,      
			     struct screen_parts *LOC));
extern void undelete_msg P_((struct menu_common *mc,
			     struct menu_context *header_area));
extern int DeleteTagged     P_((struct menu_common *menu,
				struct menu_context  *page,
				struct menu_context *header_area));
extern int tag_message      P_((struct menu_common *mc, 
				struct menu_context *header_area));
extern int flag_message      P_((struct menu_common *mc, 
				 struct menu_context *header_area));
extern void unread_msg P_((struct MailboxView *mailbox,
			   struct menu_context *header_area));


/* src/forms.c */

extern int format_form P_((char *filename));
extern int check_form_file P_((char *filename));

/* src/quit.c */

/* returns:

   0 .. do not do exit
   1 .. do normal exit
   EOF

   Do NOT free mailbox ...
*/
extern int quit P_((int prompt, struct MailboxView *mailbox,
		    struct menu_context  *page,
		    struct menu_context  *prompt_area));

extern void resync P_((struct MailboxView **mailbox, 
		       struct menu_context *page,
		       struct screen_parts *LOC));
extern struct MailboxView *  change_file P_((struct MailboxView  * mailbox,
					     struct AliasView    * aview,
					     struct menu_context * page,
					     struct menu_context * prompt_area,
					     int                 * ret_letter,
					     struct elm_commands * cmds /* may be NULL */
					     ));


/* src/save_opts.c */

int  check_options_backup_suffix P_((const char * option /* for error message */,
				     const char * backup_suffix));

extern void save_options P_((const char *backup_suffix));
extern void save_user_options P_((FILE *elminfo_fd, FILE *newelmrc));

char *str_opt_nam P_((char *s, int f));


/* src/screen.c */

extern void showscreen P_((struct menu_context *page));
extern void copy_current P_((struct menu_common *menu, 
			     struct menu_context  *ptr));
extern int sb_update_title P_((struct menu_context  *ptr,
			       struct menu_param *list));

extern int sb_show_menu P_((struct menu_context  *ptr,
			    struct menu_param *list));
extern void hdr_show_header P_((struct menu_context  *ptr,
				struct menu_param *list,
				int line_number,
				int index,
				int is_current));
extern void hdr_show_current P_((struct menu_context  *ptr,
				 struct menu_param *list,	   
				 int line_number,
				 int index,
				 int is_current));
extern void hdr_show_status P_((struct menu_context  *ptr,
				 struct menu_param *list,	   
				 int line_number,
				 int index,
				 int is_current));

extern int hdr_line_separator_index P_((struct menu_context  *ptr,
					struct menu_param *list,	    
					int index));

extern void hdr_show_separator  P_((struct menu_context  *ptr,
				    struct menu_param *list,	    
				    int line_number,  
				    int separator_index /* may be HEADER_NO_SEPARATOR if last line */));

extern int  hdr_init_separators P_((struct menu_context  *ptr,
				    struct menu_param *list));

extern int hdr_setup_init P_((struct menu_context  *ptr,
			       struct menu_param *list));

extern void hdr_setup_line P_((struct menu_context  *ptr,
			       struct menu_param *list,
			       int index));

extern void draw_dummy_hl P_((struct menu_context  *ptr, 
			      int line_number,
			      int is_current));


/* src/showmsg.c */



extern void OverrideCharset P_((struct MailboxView *mailbox,
				struct menu_context  *page,
				struct menu_context  *prompt_area,
				struct menu_context  *header_area));

extern void print_errors_att P_((struct header_errors *header_error,
				 int start_line,
				 int *cancel));

extern int show_msg P_((struct header_rec *current_header,
			FILE *infile, int current, int message_count,
			struct pager_page *pager_page,
			struct elm_commands *pager_cmds));

extern int mbx_show_msg P_((struct MailboxView *mailbox, int msg, 
			    struct pager_page *pager_page,
			    struct elm_commands *pager_cmds));

extern enum need_meta_state {
    metamail_EOF    = -2  /* != EOF */,
    metamail_cancel = -1,
    metamail_none   = FALSE,
    metamail_needed = TRUE	
    
} need_meta P_((struct header_rec *hdr, int current,
			 int message_count, int *cancel_ret));

extern char * check_mailcap_view_cmd P_((struct mimeinfo *structure,
					 int *is_ok));

/* src/sort.c */

extern void sort_mailbox P_((int entries, int visible, 
			     struct MailboxView *mailbox));
extern char *sort_name P_((int type));

extern int time_sent_compare P_((struct header_rec *h1,struct header_rec *h2));

/* src/edit.c */

extern void edit_mailbox P_((struct MailboxView **mailbox,
			     struct menu_context *page));
extern int edit_a_file P_((const char *editfile,
			   struct menu_context  *page));

/* src/limit.c */

extern int compute_visible P_((int message, struct menu_common *menu));
extern int next_message    P_((int iindex, int skipdel,
			       struct menu_common *mc));
extern int prev_message P_((int iindex, int skipdel,
			    struct menu_common *mc));

extern int visible_to_index P_((int message,
				struct menu_common *mc));
extern void limit P_((struct menu_common *mc, 
		      struct menu_context  *page,
		      struct screen_parts *LOC));
extern void ClearSelection P_((struct MailboxView *mailbox));



/* src/calendar.c */

extern void scan_calendar P_((struct MailboxView *mailbox));

/* src/fbrowser.c */

extern struct fbrowser_call * alloc_fbrowser_call P_((struct string  * filter,
						     struct string  * prompt,
						     int options));    /* initialize structure  */

extern struct fbrowser_call * alloc_fbrowser_call_f P_((int options,const char *format, 
						       const char *msg, ...));

extern void free_fbrowser_call P_((struct fbrowser_call **fc));   /* free structure fields */

#define  FBROWSER_USE_SELECTION   1
#define  FBROWSER_RERUN           2

extern void set_fbrowser_flags P_((struct fbrowser_call *fc, int flags));

extern void set_fbrowser_default_filename P_((struct fbrowser_call *fc,
					      const struct string *fn));

extern enum fbrowser_result { fbrowser_INTR = -1,
				  fbrowser_quit = 0, fbrowser_selected,
				  fbrowser_error, fbrowser_return_browser 

} fbrowser P_((struct menu_context   *parent_page,
	       struct folder_browser *dir,
	       struct MailboxView    *mailbox,
	       struct string        **buffer,
	       struct fbrowser_call  *fc));  


/* src/browser.c */

extern struct folder_info * folder_browser P_((struct menu_context *page,
					       struct folder_browser *p,
					       struct string **buffer,
					       struct fbrowser_call *fc,
					       struct AliasView *aview,
					       struct MailboxView *mailbox,
					       const char *format, 
					       const char *msg, ...));


enum word_sel { word_change, word_save, word_copy, word_save_copy, 
		word_read, word_open };

extern int gen_browser P_((struct menu_context *page,
			   struct folder_browser *p,
			   struct string **buffer,
			   struct fbrowser_call *fc,
			   enum word_sel w,
			   struct string * prev_fold,
			   struct AliasView *aview,
			   struct MailboxView *mailbox,
			   const char *format, 
			   const char *msg, ...));

extern int browser_expand P_((struct folder_browser * XXX,
			      struct string **name,
			      struct string ** prev_folder,
			      struct AliasView *aview,
			      int              *pos));

extern int file_browser P_((struct menu_context *page,
			    struct folder_browser *p,
			    struct string **buffer,
			    struct fbrowser_call *fc,
			    enum word_sel w,
			    struct AliasView *aview,
			    struct MailboxView *mailbox,
			    struct string * default_extension,
			    const char *format, const char *msg, ...));

/* src/metapager.c */


extern struct pager_page * init_pager_page P_((struct menu_common *mptr));
extern void exit_pager_page P_((struct pager_page ** pager_page,
				struct menu_context * other));

/* Returns '\0' or EOF */
extern int PressAnyKeyToContinue P_((void));
extern struct string * title_text P_((struct header_rec *hdr, int current,
				      int message_count,
				      int width, charset_t cs));

#define METAPAGER_do_headers 1
#define METAPAGER_no_index   2
#define METAPAGER_index_and_quit 4

extern int metapager P_((FILE *fp,  struct header_rec *hdr,
			 int metapager_flags, int current, int message_count,
			 struct pager_page * pager_page,
			 struct elm_commands *pager_cmds));

extern int mime_signature_mismatch P_((mime_t *ptr, int displaying));

/* src/signals.c */

extern char * Stopped_Text;  /* Initialized by init.c */
extern char * Back_Text;     /* Initialized by init.c */
extern char * Segv_Text;     /* Initialized by init.c */
extern char * Bus_Text;      /* Initialized by init.c */
extern char * Fpe_Text;      /* Initialized by init.c */
extern char * Ill_Text;      /* Initialized by init.c */

extern void init_signals P_((void));
extern void init_signals1 P_((void));

extern SIGHAND_TYPE quit_signal P_((int));
extern SIGHAND_TYPE hup_signal P_((int));
extern SIGHAND_TYPE term_signal P_((int));
extern SIGHAND_TYPE ill_signal P_((int));
extern SIGHAND_TYPE fpe_signal P_((int));
#ifdef SIGBUS
extern SIGHAND_TYPE bus_signal P_((int));
#endif
extern SIGHAND_TYPE segv_signal P_((int));
extern SIGHAND_TYPE alarm_signal P_((int));
extern SIGHAND_TYPE pipe_signal P_((int));
#ifdef SIGTSTP
extern SIGHAND_TYPE sig_user_stop P_((int));
extern SIGHAND_TYPE sig_return_from_user_stop P_((int));
#endif
#ifdef SIGWINCH
extern SIGHAND_TYPE winch_signal P_((int));
#endif
extern SIGHAND_TYPE usr1_signal P_((int ));
extern SIGHAND_TYPE usr2_signal P_((int));

/* src/messages/header_alloc.c */

extern void header_zero P_((struct header_rec *));
extern void header_clear P_((struct header_rec *));  /* Free's fields */
extern void header_free P_((struct header_rec **h)); /* Free's record */
extern void realloc_headers P_((struct current_storage *storage, 
				int current_count));
extern void alloc_header P_((struct current_storage *storage, 
			     int current_count));
extern void header_parse_helper  P_((struct header_rec *current_header,
				     header_list_ptr parsed_headers));

extern struct header_rec *malloc_header_rec P_((void));
extern void free_header_rec P_((struct header_rec **h));

/* src/messages/storage.c */

struct current_storage {
    struct folder_info * current_folder;   
    int                  message_count;	/* max message number      */

    int  max_headers;	/* number of headers currently allocated */

    struct header_rec **headers; /* array of header structure pointers */

};

/* struct current_storage is free'd also when wait is canceled */
extern int free_storage P_((struct current_storage **storage,
			     struct cancel_data *cd));
extern struct current_storage *new_storage P_((struct folder_info *new_folder));

/* src/messages/messages.c */



/* Better handling of current mailbox: 
   idx == 0 first
*/

extern struct MailboxView    * give_next_open_mailbox P_((int *idx,
							  int signal));
extern void free_all_mailboxes P_((struct cancel_data *cd));

/* Joins storage to new view */
extern struct MailboxView * malloc_mailbox_view P_((struct current_storage *
						    storage));

extern struct MailboxView * digest_to_mailbox_view P_((mime_t *list,
						       time_t received_time,
						       char * env_from,
						       FILE *F,
						       charset_t defcharset));
						       
extern struct MailboxView * partial_to_mailbox_view P_((struct MailboxView *
							parent));

extern struct MailboxView * duplicate_to_mailbox_view 
P_((struct MailboxView * parent));

/* struct MailboxView is also free'd when wait
   is canceled
*/
extern int free_mailbox P_((struct MailboxView **mailbox,
			    struct cancel_data *cd));

/* Return 1 if redraw required */
extern int update_view P_((struct MailboxView *mailbox));
extern struct folder_info * get_main_folder P_((struct MailboxView *
						     mailbox));

/* Can be called from signal handler */
extern struct current_storage * get_storage P_((struct MailboxView *mailbox,
						int i));

/* Can be called from signal handler */
extern int get_storage_count P_((struct MailboxView *mailbox));

enum query_mailbox { qf_can_add_storage };

extern int query_mailbox_flag P_((struct MailboxView *mailbox,
				  enum query_mailbox q));

extern void add_storage P_((struct MailboxView *mailbox,
			    struct current_storage *storage));

extern void add_digest P_((struct MailboxView *mailbox,
			   mime_t *list,
			   time_t received_time,
			   char * env_from,
			   FILE *F,
			   charset_t defcharset
			   ));
			   

extern struct header_rec * give_header P_((struct MailboxView *mailbox,
					   int index));

extern void give_index_number P_((struct MailboxView *mailbox,
				  int index, struct folder_view *res));

/*  current == index+1     value is used only by caller */
extern int get_current P_((struct MailboxView *mailbox));
extern void set_current P_((struct MailboxView *mailbox, int cur));

extern int get_selected P_((struct MailboxView *mailbox));
extern void set_selected P_((struct MailboxView *mailbox, int sel));


/* Returns -1 if threads not initialized, create=1 initializes threads */
extern int get_message_count P_((struct MailboxView *mailbox));




#if ANSI_C
struct sort_data;
#endif

extern struct header_rec * give_header_s P_((struct sort_data *s));
extern void give_index_number_s P_((struct sort_data *s,
				    struct folder_view *res));

typedef int hdr_compare_func P_((struct sort_data *s1,
				 struct sort_data *s2));

extern void sort_mailbox_view P_((struct MailboxView *mailbox,
				  hdr_compare_func   *func));

/* Return 1 if succeed, 0 is fails --
   seeks to {header}->offset
*/
extern int give_message_data P_((struct MailboxView *mailbox,
				 int index,
				 struct header_rec **ret_header,
				 FILE              **ret_F,
				 struct counter_data *counter,
				 parse_mime_callback *parse_mime));

/* Return 1 if succeed, 0 is fails 
   Give message size for menu
*/
extern int give_message_menu_size P_((struct MailboxView * mailbox,
				      int                  index,
				      unsigned long      * ret_size));

extern int give_message_folder P_((struct MailboxView *mailbox,
				   int index,
				   struct header_rec **ret_header,
				   struct folder_info **ret_folder,
				   struct counter_data *counter,
				   parse_mime_callback *parse_mime));

/* index == -1    first folder remote server */
extern const struct remote_server * give_message_remote_server
P_((struct MailboxView *mailbox, int index));   

#define MENU_SEPARATOR_magic	0xF526

extern const struct menu_separator {
    unsigned short magic;     /* MENU_SEPARATOR_magic */
    
    enum separator_type {
	sep_none   = 0,
	sep_year   = 1,
	sep_other,
	sep_today
	
    }     sep_type;
    int   sep_value;
} * give_menu_separator P_((struct MailboxView *mailbox, int sepindex));

extern int menu_separator_count P_((struct MailboxView *mailbox));
extern int menu_separator_init P_((struct MailboxView * mailbox,
				   int                  subpage_lines,
				   int                  subpage_columns));

extern int get_menu_separator_index P_((struct MailboxView *mailbox,
					int index));

extern const struct today_info * get_today_info P_((struct MailboxView *mailbox));

extern int message_hdr_setup_init P_((struct MailboxView *mailbox,
				      struct menu_param   * list));
extern void message_hdr_setup_line P_((struct MailboxView *mailbox,
				       int idx,
				       struct menu_param   * list));

extern void write_mailbox_info P_((FILE *fp, struct MailboxView *mailbox));

/* caller must string_free() result -- calculated if not set */
extern struct string * mailbox_title P_((struct MailboxView *mailbox));

/* v must not fred -- shared/stored to structure
   -- set_mailbox_title will free_string()
   it later */
extern void set_mailbox_title P_((struct MailboxView *mailbox,
				  struct string *v));

/* src/messages/thread.c */

extern int time_OK P_((time_t t));
extern void update_mailbox_threads P_((struct MailboxView *mailbox));

/* Used for sorting */
struct thread_info {
     struct string_sort  * thread_subject;
    
    /* first and last on sent time */
    time_t    time_sent_first;
    time_t    time_sent_last;

    /* first and last on  time_menu_year (sender timezone) 
       if  time_sent_first || time_sent_last
       is <= 0 or time_MAX
    */

    short     year_sent_first;
    short     year_sent_last;

    int    num_messages;   /* Number of messages on this thread */
};

extern const struct thread_info * give_thread_info_s P_((struct sort_data *s));

extern int get_thread_count P_((struct MailboxView *mailbox, int create));
extern const struct thread_info * give_thread_info P_((struct MailboxView *
						       mailbox, int idx));

/* caller must free result */
extern int * give_thread_message_list P_((struct MailboxView * mailbox,
					  int idx,
					  int *reslen));

/* src/messages/status.c */

enum status_x { status_basic, status_1 };
/* bit field:

   status_basic:
   ACTION, CONFIDENTIAL, DELETED, EXPIRED, FORM_LETTER, NEW,
   PRIVATE_MAIL, TAGGED, URGENT, VISIBLE, UNREAD, REPLIED,
   MIME_MESSAGE, PRE_MIME_CONTENT, MIME_UNSUPPORTED, NOHDRENCODING

   status_1:
   S1_FLAGGED, S1_NODATA
*/


extern char * show_status_message P_((struct MailboxView *mailbox,
				      int index));
extern int   ison_status_message  P_((struct MailboxView *mailbox,
				      int index, 
				      enum status_x t, int mask));
extern int   setf_status_message  P_((struct MailboxView *mailbox,
				      int index, 
				      enum status_x t, int mask));
extern int   clearf_status_message  P_((struct MailboxView *mailbox,
					int index, 
					enum status_x t, int mask));

/* src/messages/canceled_mail.c */

extern struct MailboxView *give_canceled_mail P_((void));
extern void close_canceled_mail P_((void));
extern FILE * add_canceled_mail P_((char **outfile,
				    struct mailing_headers * headers,
				    struct MailboxView *view,
				    time_t X,
				    int lines,
				    header_list_ptr h,
				    long body_offset));
extern void delete_marked_canceled_mails P_((struct MailboxView *view));
extern void sync_canceled_mails P_((struct MailboxView *view));
extern int cancel_set_current P_((struct MailboxView * cancel_view,
				  char *last_canceled_mail));
extern void  delete_current_cancel P_((struct MailboxView * cancel_view,
				       FILE *ref_file));

/* src/messages/mailfile.c */

extern int add_mail_file P_((const char *mailfile));
extern int check_mail_file_list P_((void));
extern void free_mail_file_list P_((void));

enum mail_file_mode {
    no_mail_files_given = 0,
    mail_files_added,
    mail_files_as_mailbox,
    send_mail_files
    
} mail_files_used P_((void));

extern struct MailboxView * mailbox_view_mail_files P_((char **one_mail_file /* result malloced */));
extern int inline_parts_from_mail_files P_((struct Attachments *attach,
					    struct mailer_info  *mailer_info));




/* src/messages/thread_messages.c */

extern struct MailboxView * thread_to_mailbox_view P_((struct MailboxView *
						       parent, 
						       int thread_idx));
/* src/screen/init.c */

/* Reports -1 if not gound */
extern int report_TERMCH_char P_((int key));

/* src/screen/screen.c */

extern int InitScreen P_((struct menu_context  **page)); 
extern void ScreenSize P_((int *lines, int *columns));

extern int  has_highlighting;	      /* highlighting available? */

extern void signal_leave_screen P_((void));
extern void signal_enter_screen P_((void));

/* src/partial.c */

/* may return EOF */
extern int ViewPartial P_((struct MailboxView *parent_mailbox,
			   struct AliasView *aview,
			   struct menu_context  *parent_page,
			   int is_main_message_loop));

extern int have_partial P_((struct MailboxView *parent_mailbox));

/* src/digest.c */

/* Return 'i' is should go to index */
extern int ViewDigest P_((struct MailboxView *mailbox,
			  struct AliasView *aview,
			  struct menu_context  *parent_page
			  ));

/* src/view_one_thread.c */

/* May return EOF */
extern int ViewThread1 P_((struct MailboxView *parent_mailbox,
			    struct AliasView *aview,
			    int thread_index,
			    struct menu_context  *parent_page,
			    int *needresort
			    ));

/* src/screen/context.c */

/* -1 == no changes */
extern void set_root_menu(int lines, int columns);

extern struct menu_context  * default_context;

extern struct menu_context  * new_menu_context P_((void));
extern void  erase_menu_context P_((struct menu_context  **ptr));
extern int   menu_resized      P_((struct menu_context *ptr));
extern int   menu_need_redraw  P_((struct menu_context *ptr));
extern void  menu_get_sizes    P_((struct menu_context *ptr,
				   int *lines, int *columns));


enum menu_allow_redraw {
    menu_disable_redraw_callback = 0,
    menu_allow_redraw_callback
};

/* If allow_redraw = 0 (menu_disable_redraw_callback), do not call redraw routine,
   returns either menu_redraw_need or menu_redraw_none 
*/


extern enum menu_redraw {
    menu_redraw_need = -1,
    menu_redraw_none = 0,
    menu_done_redraw = 1
	} menu_redraw_done P_((struct menu_context *ptr,
			       enum menu_allow_redraw allow_redraw));


extern void menu_trigger_redraw P_((struct menu_context *ptr));

/* Call refresh routines of children */
extern void menu_redraw_children P_((struct menu_context *ptr));

/* called from signal handler */
extern void menu_context_resize P_((void));
extern void menu_context_redraw P_((void));

extern void cancel_set_ttysig_X P_((void));
extern void cancel_reset_ttysig_X P_((void));

/* src/screen/menu_param.c */

extern int mp_lookup_integer P_((struct menu_param *list, int idx));
extern struct menu_common *  mp_lookup_mcommon P_((struct menu_param *list, 
						   int idx));
extern struct menu_anon_param * mp_lookup_anon P_((struct menu_param *list, 
						   int idx));

extern void mp_list_set_integer P_((struct menu_param *list, int idx, int v));
extern void mp_list_set_mcommon P_((struct menu_param *list, 
				    int idx, 
				    struct menu_common  *v));
extern void mp_list_set_anon P_((struct menu_param *list, 
				 int idx, 
				 struct menu_anon_param  *v));

/* src/screen/subpage.c */

/* Returns 1 if redraw not need to be signaled */
typedef int subpage_simple_redraw P_((struct menu_context  *ptr,
				      struct menu_param *list));
extern int subpage_simple_noredraw P_((struct menu_context  *ptr,
				       struct menu_param *list));

extern struct menu_context * new_menu_subpage P_((struct menu_context  *parent,
						  int rel_start_line,
						  int lines,
						  subpage_simple_redraw redraw,
						  /* only rerefrence is saved */
						  struct menu_param *list));

/* Creates copy of subpage which is attached to new page */
extern struct menu_context * dup_menu_subpage P_((struct menu_context *
						  new_parent,
						  struct menu_context *orig));


extern void menu_subpage_relocate P_((struct menu_context  *subpage,
				      struct menu_context  *parent,
				      int rel_start_line,
				      int lines));


/* src/screen/header.c */

typedef void header_line_redraw P_((struct menu_context  *ptr,
				    struct menu_param *list,	   
				    int line_number,
				    int index,
				    int is_current));
extern void header_line_noredraw P_((struct menu_context  *ptr,
				     struct menu_param *list,	    
				     int line_number,
				     int index,
				     int is_current));

/* Returns 1 if header_setup_line() need to be called 
*/
typedef int header_setup_init P_((struct menu_context  *ptr,
				   struct menu_param *list));
extern int header_setup_noinit  P_((struct menu_context  *ptr,
				struct menu_param *list));
/* Prescan formatting */
typedef void header_setup_line P_((struct menu_context  *ptr,
				   struct menu_param *list,
				   int index));
extern void header_setup_noline P_((struct menu_context  *ptr,
				    struct menu_param *list,
				    int index));


enum header_params { header_top_line, header_current,
		     header_bottom_line  /* calculated from  header_top_line */,
		     HEADER_PARAMS_COUNT };

typedef void header_param_changed P_((struct menu_context  *ptr,
				      struct menu_param *list,	       
				      enum header_params param_index));
extern void null_header_param_changed P_((struct menu_context  *ptr,
					  struct menu_param *list,	       
					  enum header_params param_index));


#define HEADER_NO_SEPARATOR -1
typedef int header_line_separator_index P_((struct menu_context  *ptr,
					    struct menu_param *list,	    
					    int index));

extern int null_header_line_separator_index P_((struct menu_context  *ptr,
						struct menu_param *list,	    
						int index));
typedef  void header_separator_redraw  P_((struct menu_context  *ptr,
					   struct menu_param *list,	    
					   int line_number,  
					   int separator_index /* may be HEADER_NO_SEPARATOR if last line */));

extern  void header_separator_noredraw  P_((struct menu_context  *ptr,
					    struct menu_param *list,	    
					    int line_number,
					    int separator_index));

/* Return 1 if seperator lines are used */
typedef int header_separator_start P_((struct menu_context  *ptr,
					struct menu_param *list));
					 
extern int null_header_separator_start P_((struct menu_context  *ptr,
					    struct menu_param *list));
				       
extern struct menu_context * new_menu_header P_((struct menu_context         * parent,
						 int                           rel_start_line,
						 int                           lines,
						 header_line_redraw          * line_redraw,
						 header_line_redraw          * current_redraw,
						 header_param_changed        * param_change,
						 header_line_redraw          * status_redraw,
						 header_line_separator_index * separator_index,
						 header_separator_redraw     * separator_redraw,
						 header_separator_start      * separator_start,
						 header_setup_init           * setup_init,
						 header_setup_line           * setup_line,
						 /* only rereference is saved */
						 struct menu_param *list));



#define HEADER_NO_CURRENT -1

extern void menu_header_change P_((struct menu_context  *subpage,
				   enum header_params  param,
				   int value));

/* Returns new  header_top_line value */
extern int  menu_header_change_page P_((struct menu_context  *subpage,
					int delta_line /* +lines or -lines */));
					

extern int menu_header_get P_((struct menu_context  *subpage,
			       enum header_params  param));
extern void menu_header_change_item P_((struct menu_context  *subpage,
					int index));

extern void menu_header_relocate P_((struct menu_context  *subpage,
				     struct menu_context  *parent,
				     int rel_start_line,
				     int lines));

extern void menu_header_status_update P_((struct menu_context  *subpage,
					  int item));

/* ------------------------------------------------------- */
/* src/screen/screen.c */

#define ClearLine(n)	MoveCursor(n,0); CleartoEOLN()
#define menu_ClearLine(page,n)	menu_MoveCursor(page,n,0); menu_CleartoEOLN(page)


extern int InitScreen P_((struct menu_context  **page)); 

extern void ScreenSize P_((int *lines, int *columns));

/* NOTE: menu_ScreenSize   DO NOT return lines-1 (as ScreenSize() do */ 
extern void menu_ScreenSize P_((struct menu_context * ctx,
				int *lines, int *columns));

extern void menu_set_default P_((struct menu_context *ctx));

extern void Writechar P_((int ch));
extern void menu_Writechar P_((struct menu_context * ctx, int ch));

extern void menu_WriteUnicode P_((struct menu_context * ctx, int unicode));

extern void Write_to_screen P_((const char *format, const char *msg, ...));
extern void menu_Write_to_screen P_((struct menu_context * ctx,
				     const char *format, const char *msg, ...));

extern void PutLine0 P_((int line, int col, const char *text));
extern void menu_PutLine0 P_((struct menu_context * ctx,
			      int line, int col, const char *text));

extern void PutLineX P_((int line , int col, const char *, const char *, ...));
extern void menu_PutLineX P_((struct menu_context * ctx,
			      int line , int col, const char *, const char *, ...));

extern void CleartoEOLN P_((void));
extern void menu_CleartoEOLN P_((struct menu_context * ctx));

extern void CleartoEOS P_((void));
extern void menu_CleartoEOS P_((struct menu_context * ctx));


extern enum rawstate RawState P_((void));
extern struct menu_context * Raw P_((int state));


#define READCH_MASK      0x0FFF         /* Mask flags off        */
#define READCH_CURSOR    0x1000         /* Return cursor keys    */      
#define READCH_NOCURSOR  0x2000         /* Disable cursor keys   */      
#define READCH_term_char 0x4000         /* Return term chars     */
#define READCH_resize    0x8000         /* Check resize ....     */
#define READCH_sig_char 0x10000         /* Return sig chars      */
#define READCH_quote    0x20000         /* Try quote next control character      */
#define READCH_poll     0x40000         /* Wait a second for character,
					   returns TIMEOUT_MARK if not supported */

enum {
    REDRAW_MARK =   257,                /* Artificial "char" for  redrawing */
    UP_MARK     =   258,                /* Artificial UP key    */
    LEFT_MARK   =   259,                /* Artificial LEFT key  */
    RIGHT_MARK  =   260,                /* Artificial RIGHT key */
    DOWN_MARK   =   261,                /* Artificial DOWN key  */
    PAGEUP_MARK =   262,                /* Artificial PAGE UP key */
    PAGEDOWN_MARK = 263,                /* Artificial PAGE DOWN key */
    HELP_MARK   =   264,                /* Artificial HELP key      */
    HOME_MARK   =   265,              /* Artificial HOME key      */
    FIND_MARK   =   266,              /* Artificial FIND key      */
    SPACE_MARK  =   267,              /* used by builtinplus      */
    RESIZE_MARK =   268,              /* Used ny menu_context     */
    TIMEOUT_MARK =  269,              /* READCH_poll gives no character */
    DELETE_MARK  =  270,              /* Artificial DELETE key    */
    END_MARK     =  271,              /* Artificial END key       */
    INSERT_MARK  =  272,              /* Insert Character  -- Not used */
    BACKTAB_MARK =  273,              /* back-tab key      -- Not used */

    NUMBER_MARK,                      /* Only used on help display */

    F1_KEY_MARK,
    F2_KEY_MARK,
    F3_KEY_MARK,
    F4_KEY_MARK,
    F5_KEY_MARK,
    F6_KEY_MARK,
    F7_KEY_MARK,
    F8_KEY_MARK,
    F9_KEY_MARK,
    F10_KEY_MARK,
    F11_KEY_MARK,
    F12_KEY_MARK,
};


enum {
    TERMCH_min_char  =     300,
    TERMCH_backspace =     300,       /* term_char: backspace     */
    TERMCH_kill_line =     301,
    TERMCH_word_erase=     302,
    TERMCH_interrupt_char =303,
    TERMCH_reprint_char =  304,
    TERMCH_eof_char =      305,


    /* Used by report_TERMCH_char(): */
    TERMCH_report_VQUIT   = 310,
    TERMCH_report_VSUSP   = 311,
    TERMCH_report_VSTART  = 312,
    TERMCH_report_VSTOP   = 313
};


extern struct charset_state * ReadCh2 P_((int flags));
extern struct charset_state * menu_ReadCh2 P_((struct menu_context *ptr,
					       int flags));

extern void FlushInput P_((void));

extern int menu_ReadCh P_((struct menu_context *ptr, int flags));

extern void GetXYLocation P_((int *x,int *y));
extern void menu_GetXYLocation P_((struct menu_context *ctx,
				   int *x,int *y));

extern void ClearScreen P_((int interrupt));
extern void menu_ClearScreen P_((struct menu_context *ptr));

extern void MoveCursor P_((int row, int col));
extern void menu_MoveCursor P_((struct menu_context *ptr,
				int row, int col));
extern int menu_GetAbsLine P_((struct menu_context *ctx,int row));

/* Actual *res_col == col
   return 1 if *res_row is on area
*/
extern int menu_translate_pos P_((struct menu_context *ctx,
				  int row,
				  int col,
				  struct menu_context *res_ctx,
				  int * res_row,
				  int * res_col));

extern void CarriageReturn P_((void));
extern void NewLine P_((void));

extern void StartBold P_((void));
extern void EndBold P_((void));
extern void StartStandout P_((void));
extern void EndStandout P_((void));
extern void StartUnderline P_((void));   
extern void EndUnderline   P_((void));

extern void menu_StartXX P_((struct menu_context *ctx, int f));
extern void menu_EndXX P_((struct menu_context *ctx, int f));

extern int get_tabspacing P_((void));

/* screen/curses.c */

extern void WriteRaw P_((const char *str));
extern struct string *curses_printable_clip P_((const struct string *S,
						int *pos,
						int len,
						int *visible_len,
						int max_visible));
extern int raw_off_called P_((void));
extern void transmit_functions P_((int newstate));
extern void InvalidateLocation P_((void));

/* mallocs result -- result need to be valid characters and usable 
   may return NULL
*/
extern struct string * curses_available_string P_((const struct string *S));
extern int curses_available_charset P_((charset_t cs));

/* Called after config is read */
extern void curses_check_terminal P_((void));


/* screen/curs_input.c */

extern void error_sleep P_((int seconds));

/* screen/termcharcharset.c */

extern charset_t * give_display_charsets P_((charset_t *storage,
					     int max,
					     int maybe_signal));

extern int set_display_charset P_((charset_t set, int silent,
				   int maybe_signal
				   ));
extern void switch_display_charset P_((int to_display,
				       int maybe_signal));
extern void init_system_charset P_((void));


/* screen/termtitle.c */

extern int set_terminal_titles P_((char *title, char *icon));
extern void switch_title P_((int to_display));


/* screen/termbuffer.c */

extern void FlushBuffer P_((void));

/* src/aliases/aliases.c */

/* Open standard aliases */
extern void add_files_to_aview   P_((struct AliasView *aview));

extern struct AliasView          * new_aliasview P_((void));
extern void                        free_aliasview P_((struct AliasView **x));
extern struct aliasview_record   * give_alias P_((struct AliasView *aview,
						  int index));

extern struct aliasview_record * lookup_alias P_((struct AliasView *aview,
						  const struct string *key,
						  int *index));
struct alias_view {
    int classnum;
    int index;
};

extern void zero_alias_view P_((struct alias_view *x));
extern void aliasview_give_index_number P_((struct AliasView *aview,
					    int index, 
					    struct alias_view *res));


extern void free_all_aliasviews P_((void));

extern int get_alias_count  P_((struct AliasView *aview));

extern int get_total_alias_count P_((struct AliasView *aview));

/*  current == index+1     value is used only by caller */
extern int get_alias_current  P_((struct AliasView *aview));
extern void set_alias_current P_((struct AliasView *aview, int cur));

extern int get_alias_selected  P_((struct AliasView *aview));
extern void set_alias_selected P_((struct AliasView *aview, int sel));



#if ANSI_C
struct sort_data2;
struct alias_stack;
struct alias_vector;
#endif
extern struct aliasview_record *  give_alias_s P_((struct sort_data2 *s));

extern void aliasview_give_index_number_s P_((struct sort_data2 *s, 
					      struct alias_view *res));

typedef int alias_compare_func P_((struct sort_data2 *s1,
				   struct sort_data2 *s2));

extern void sort_aview P_((struct AliasView *aview,
			   alias_compare_func   *func));

/* Return 1 if changes */
extern int update_aview P_((struct AliasView *aview));

extern void add_aview_to_alias_stack P_((struct alias_stack * stack,
					 struct AliasView *aview));


/* Caller must free buffer */       
extern struct alias_buffer * give_alias_buffer P_((struct aliasview_record *rec));

/* Adds alias to aview, if old_alias == -1 adds new alias to top level
   may replace existing alias
 */
extern struct aliasview_record * add_alias_to_aview P_((struct AliasView *aview,
							const struct alias_buffer *buffer,
							int old_alias));


/* makes alias to be NULL -- does not change index */
extern void delete_alias_from_aview P_((struct AliasView *aview,
					int idx));

extern int file_changed_aliasview P_((struct AliasView *aview));

extern int write_aliasview P_((struct AliasView *aview));

extern int start_edit_aliases P_((struct AliasView *aview,
				  const char **edited_file));
extern void end_edit_aliases P_((struct AliasView *aview));


extern struct aliases_find_state * aliases_find_init P_((
           struct AliasView *aview));
extern void aliases_find_free P_((struct aliases_find_state **state));

extern int aliases_find_compat P_((struct aliases_find_state *state,
				   const char **from_filename,
				   const char **to_filename));
extern void aliases_find_remove P_((struct aliases_find_state *state));
extern void aliases_find_convert P_((struct aliases_find_state *state));

/* src/aliases/buffer.c */

extern void free_alias_buffer P_((struct alias_buffer **rec));

extern struct alias_buffer * malloc_empty_alias_buffer P_((void));

extern const struct string * alias_buffer_key P_((const struct alias_buffer 
						  *rec));
extern void  set_alias_buffer_key P_((struct alias_buffer *rec,
				      const struct string *key));

extern const struct address_alias * alias_buffer_value P_((
       const struct alias_buffer  *rec));

extern void  set_alias_buffer_value P_((struct alias_buffer *rec,
					struct address_alias *value));

/* alias_display.c */

/* 1   == modified
   0   == not modified
   -1  == cancel */

extern int alias_modify P_((struct AliasView *aview,
			     struct alias_buffer * a, 
			     int new,
			     struct menu_context * parent_page));

extern struct string * display_list_members P_((
    const struct alias_vector * group_vector,
    int len));
extern struct string * display_list_addrs P_((
    const struct addr_list * address_list,
    int len));


/* alias_itemized.c */


extern struct display_list_addrs_state * display_list_addrs_iterator_alloc P_((
    const struct addr_list          * address_list));
extern struct string * display_list_addrs_iterator P_((
   struct display_list_addrs_state * state));
extern void display_list_addrs_iterator_free P_((
   struct display_list_addrs_state **state));

extern struct display_list_aliases_state * 
   display_list_aliases_iterator_alloc P_((
     const struct alias_vector     * alias_vector));
extern void display_list_aliases_iterator_free P_((
  struct display_list_aliases_state **state));
extern struct string * display_list_aliases_iterator P_((
  struct display_list_aliases_state * state));

/* generalized */

extern struct display_list_state * display_list_iterator_alloc_addrs P_((
    const struct addr_list          * address_list));

extern struct display_list_state * display_list_iterator_alloc_aliases P_((
    const struct alias_vector      * alias_vector));

extern void display_list_iterator_free P_((
   struct display_list_state **state));
extern struct string * display_list_iterator P_((
  struct display_list_state * state));

extern int genlist_display_list P_((struct menu_context * page,
				    const struct string * prefix,
				    int *line, int reserve,
				    struct display_list_state *state));

extern struct string * genlist_display_list_string P_((struct display_list_state 
						       *state,
						       int len));

/* alias_info.c */

/* Returns command or \0   */
extern int alias_info P_((struct aliasview_record *a,
			  struct menu_context *page));

extern void alias_expansion_info P_((struct aliasview_record *a,
				     const struct string *key,
				     struct menu_context * parent_page,
				     struct AliasView *aview));

extern int alias_expansion_info0 P_((struct aliasview_record *a,
				     const struct string *key,
				     struct menu_context * page,
				     struct AliasView *aview,
				     int ask_command));

/* alias_info_1.c */

extern int show_alias_info P_((struct AliasView *aview,
			       struct menu_context  *page,
			       struct menu_context  *header_area));
extern int show_alias_expanded P_((struct AliasView *aview,
				   struct menu_context  *page,
				   struct menu_context  *header_area));

/* src/aliases/record.c */

extern const struct string   * aliasview_key P_((struct aliasview_record *a));
extern const struct address_alias * aliasview_address_alias P_((struct aliasview_record *a));
extern int aliasview_have_type_mask   P_((struct aliasview_record *a, int mask));
extern int aliasview_have_status_mask   P_((struct aliasview_record *a, int mask));

/* 1)   Type values */
#define SYSTEM		1
#define USER		2
#define DUPLICATE	16
#define EXPUNGED        32

/** 2) some defines to aid in the limiting of alias displays **/

#define BY_PERSON        4
#define BY_GROUP         8
#define BY_NAME		64
#define BY_ALIAS	128


extern int aliasview_get_type P_((struct aliasview_record *rec));
extern int aliasview_get_status P_((struct aliasview_record *rec));
extern int aliasview_setf_status P_((struct aliasview_record *rec,
				     int stat));
extern int aliasview_ison_status P_((struct aliasview_record *rec,
				     int stat));
extern int aliasview_clearf_status P_((struct aliasview_record *rec,
				     int stat));

extern const struct string * aliasview_get_key P_((struct aliasview_record *rec));
extern const struct  address_alias * aliasview_get_alias P_((struct aliasview_record *rec));



/* menu_common/ */


struct menu_common {
    unsigned short         magic;
    struct mcommon_type  * mtype;
    void                 * ptr;
};

/* menu_common/alias.c */

extern  void set_mcommon_from_aliasview P_((struct menu_common * m,
					    struct AliasView   * aw));

/* menu_common/mailbox.c */
void set_mcommon_from_mbxview P_((struct menu_common * m,
				  struct MailboxView * mw));

/* menu_common/mcommon.c */

/* bit field (for aliases):  
   SYSTEM, USER,  DUPLICATE
*/
extern int mcommon_get_type   P_((struct menu_common *m, int idx));

extern int mcommon_setf_status P_((struct menu_common *m, int idx, 
				   enum status_x t, int stat));
extern int mcommon_ison_status P_((struct menu_common *m, int idx, 
				   enum status_x t, int stat));
#define mcommon_isoff_status(m,idx,t,stat) (!mcommon_ison_status(m,idx,t,stat))
extern int mcommon_clearf_status P_((struct menu_common *m, int idx, 
				     enum status_x t, int stat));

extern char * mcommon_show_status P_((struct menu_common *m, int idx));

/* note that current is index+1 */
extern int mcommon_get_current P_((struct menu_common *m));
extern int mcommon_get_count P_((struct menu_common *m));
extern int mcommon_get_selected P_((struct menu_common *m));
extern void mcommon_set_current P_((struct menu_common *m, int cur));
extern void mcommon_set_selected P_((struct menu_common *m, int sel));


extern int mcommon_matches   P_((struct menu_common *m, int idx, struct string * meta_pattern));

extern int mcommon_limit_helper P_((struct menu_common *m,
				    struct string *str,
				    int **retarr,
				    struct menu_context  *page));

extern void mcommon_limit_print_help P_((struct menu_common *m,
					 int last_selected));
extern void mcommon_limit_print_result P_((struct menu_common *m));
extern enum pattern_result mcommon_match_in_text P_((struct menu_common *m,
				     struct string * meta_pattern,
				     struct menu_context  *page,
				     struct screen_parts *LOC));

extern void mcommon_screen_print_menu_line P_((struct menu_common *m, 
					       int idx,
					       struct menu_context  *page,
					       struct menu_param *list));

extern int mcommon_screen_setup_menu_init P_((struct menu_common *m, 
					      struct menu_context  *page,
					      struct menu_param *list));

extern void mcommon_screen_setup_menu_line P_((struct menu_common *m, 
					       int idx,
					       struct menu_context  *page,
					       struct menu_param *list));

enum mcommon_item { m_item, m_items, m_Item, m_Items, m_Prompt,
		    m_no_item,
		    MCOMMON_ITEM_COUNT
};

extern const struct string * mcommon_give_item P_((struct menu_common *m,
						   enum mcommon_item I));

extern struct string * mcommon_title P_((struct menu_common *m));

extern int mcommon_init_separators P_((struct menu_common  * m,
				       struct menu_context * page));
extern int mcommon_separator_count P_((struct menu_common  * m));
extern void mcommon_screen_print_sep_line P_((struct menu_common  * m,
					      int                   sepidx,
					      struct menu_context * page,
					      struct menu_param   * list));

extern int mcommon_get_separator_index P_((struct menu_common *m, 
					   int idx));

/* menu_common/message_screen.c */

extern void make_size_lines P_((struct header_rec * h,
				struct MailboxView *mailbox,
				int mbx_idx
				));

/* view_folder.c */

/* may return EOF */
extern int  send_view_folder P_((struct MailboxView *current_mailbox, 
				  struct Attachments *attachments,
				  struct menu_context *parent_page,
				  struct AliasView *aview,
				  struct mailer_info  *mailer_info));


/* url/url.c */


/* raw implies some charset used on URL
   must be absolute url if parent is no given 
*/
extern struct url * url_from_raw P_((struct string *raw, struct url *parent,
				     struct header_errors **header_error));

extern struct url * new_url P_((const char *scheme));

extern void free_url P_((struct url **url));

extern enum url_type { url_unknown, 
		       url_mailing, 
		       url_mailbox_list,
		       url_mailbox
} get_url_type P_((const struct url 
							   *url));

extern int set_mailing_headers_from_url P_((struct mailing_headers *headers,
					    const struct url *url,
					    struct mailer_info  *mailer_info));
extern struct text_block * give_text_body_from_url P_((const struct url *url,
						       int quote_l,
						       int *errors));

/* This gives absolute URL even when original URL was relative */
extern struct string * raw_from_url P_((const struct url *url));

/* May not be 
      uin16 port
   because this is promoted to int
*/

/* May not be 
      uin16 port
   because this is promoted to int
*/


/* Return 1 for open */
typedef int verify_remote_url_f P_((const struct url *url,
				    const struct string  * user,
				    const struct string  * host,
				    struct string  ** anon_passwd,  /* prompt for 'anon password' */
				    int port,
				    int default_port,
				    int   * ret_letter /* returns '\0' or EOF */
				    ));

extern struct folder_info * get_folder_from_url P_((const struct url *url,
						    verify_remote_url_f * verify_remote,
						    int   * ret_letter /* returns '\0' or EOF */
						    ));

/* block.c */

extern struct text_block * block_from_filename P_((const char * filename, 
						   charset_t cs,
						   int quote));
extern struct text_block * block_from_stdin P_((void));
extern struct text_block * block_from_string P_((const struct string *S,
						 int quote));

extern int add_block_to_mail P_((struct text_block *block,
				 int        * already_has_text,
				 FILE       * edit_buffer,
				 charset_t  * edit_charset));

extern void free_block P_((struct text_block **block));

const char * get_block_filename P_((struct text_block *block));


/* src/list/list.c */

extern void free_list_info P_((struct list_info **list));

extern struct list_info * parse_list_headers P_((header_list_ptr 
						 parsed_headers,
						 int mime,
						 charset_t cs,
						 struct header_errors 
						 ** header_error));

extern struct list_info * dup_list_info P_((struct list_info *src));

extern const struct string * get_list_phrase P_((struct list_info *list));
extern const char * get_list_id P_((struct list_info *list));

extern void metapager_list_note P_((struct out_state *buffer,
				    struct list_info *list));


/* src/list/reply.c */

/* Returns 'i' if should go index */
extern int generic_reply P_((int index,
			     struct MailboxView *mailbox,
			     struct AliasView   *aview,
			     struct menu_context  *page,
			     struct menu_context  *old_prompt));

/* src/list/info.c */

/* Returns 'i' if should go index */
extern int list_info P_((int index,
			 struct MailboxView *mailbox,
			 struct AliasView   *aview,
			 struct menu_context  *page,
			 struct menu_context  *old_prompt));

/* May not be 
      uin16 port
   because this is promoted to int
*/

/* Return 1 for open */
extern int verify_remote_url P_((const struct url *url,
				 const struct string  * user,
				 const struct string  * host,
				 struct string  ** anon_passwd,  /* prompt for 'anon password' */
				 int port,
				 int default_port,
				 int   * ret_letter /* returns '\0' or EOF */));

/* src/extended.c */

extern int extended_command P_((struct MailboxView *mailbox,
				 struct AliasView   *aview,
				 struct menu_context  *parent_page,
				 struct screen_parts *parent_LOC,
				 int is_main_message_loop));
					      
/* src/duplicate_removal.c */

extern int ViewRemoveDuplicate P_((struct MailboxView *parent_mailbox,
				    struct AliasView *aview,
				    struct menu_context  *parent_page,
				    int is_main_message_loop));


/* src/thread.c */

/* May return EOF */
extern int ViewThreads P_((struct MailboxView *mailbox,
			   struct AliasView *aview,
			   struct menu_context  *parent_page));

extern int compare_threads_1_sentd P_((const struct thread_info *X1,
				       const struct thread_info *X2));
extern int compare_threads_1_revsentd P_((const struct thread_info *X1,
					  const struct thread_info *X2));


/* src/mailbox.c */


extern int main_messages_menu P_((struct menu_context  *page,
				  char **req_mfile_vector,
				  struct AliasView     * cur_aliaslist));

extern int url_messages_menu P_((struct menu_context  * page,
				 struct url           * url,
				 struct AliasView     * cur_aliaslist));

/* src/command/maincmd.c */

extern struct elm_commands *give_main_commands P_((void));        /* increment refcount */

/* src/command/pagercmd.c */

extern struct elm_commands *give_pager_commands P_((void));        /* increment refcount */

/* src/command/extendedcmd.c */

extern struct elm_commands *give_extended_commands P_((void));        /* increment refcount */

/* src/command/fbrowsercmd.c */

extern struct elm_commands *give_fbrowser_commands P_((void));      /* increment refcount */

/* src/command/headercmd.c */

extern struct elm_commands *give_edithdr_commands P_((void));      /* increment refcount */

/* src/command/listinfocmd.c */

extern struct elm_commands *give_list_info_commands P_((void));        /* increment refcount */


/* src/command/genericreply.c */

extern struct elm_commands *give_generic_reply_commands P_((void));

/* src/command/partialcmd.c */

extern struct elm_commands *give_partialmbx_commands P_((void));   /* increment refcount */
extern struct elm_commands *give_partialpager_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_partialmain_commands P_((void)); /* increment refcount */


/* src/command/digestcmd.c */

extern struct elm_commands *give_digestmbx_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_digestpager_commands P_((void)); /* increment refcount */

/* src/command/builtincmd.c */

extern struct elm_commands *give_builtinpager_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_builtinpg_core_commands P_((void)); /* increment refcount */

/* src/command/duplicate_removalcmd.c */

extern struct elm_commands *give_dupremmbx_commands  P_((void)); /* increment refcount */
extern struct elm_commands *give_dupremmain_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_duprempager_commands P_((void)); /* increment refcount */

/* src/command/aliascmd.c */

extern struct elm_commands *give_alias_commands P_((void));  /* increment refcount */

/* src/command/sndcmd.c */

extern struct elm_commands *give_send_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_preview_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_checkfrom_commands P_((void)); /* increment refcount */

/* src/command/quota_dispcmd.c */

extern struct elm_commands *give_quotadisp_commands P_((void)); /* increment refcount */

/* src/command/view_foldercmd.c */

extern struct elm_commands *give_snd_view_folder_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_snd_view_pager_commands P_((void)); /* increment refcount */

/* src/command/canceledmailcmd.c */

extern struct elm_commands *give_view_canceled_mail_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_canceled_mail_pager_commands P_((void)); /* increment refcount */

/* src/command/threadcmd.c */

extern struct elm_commands *give_view_threads_commands P_((void)); /* increment refcount */

/* src/command/onethreadcmd.c */

extern struct elm_commands *give_view_thread_mail_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_view_thread_pager_commands P_((void)); /* increment refcount */

/* src/command/visit_mailboxcmd.c */

extern struct elm_commands *give_visit_mailbox_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_visit_mbx_pager_commands P_((void)); /* increment refcount */

/* src/command/attach_menucmd.c */

extern struct elm_commands *give_attach_menu_mime_commands P_((void)); /* increment refcount */
extern struct elm_commands *give_attach_menu_norm_commands P_((void)); /* increment refcount */

/* src/command/opt_gencmd.c */

struct elm_commands * give_option_commands P_((struct elm_commands  **STORE,
					       struct optsmenu     * cfg_opts,
					       struct option_extra * 
					       extra_actions,
					       struct string *key_title
					       /* shared, free'ed by 
						  free_commands */,
					       struct string *desc_title 
					       /* shared, free'ed by 
						  free_commands */,
					       int title_pg_flags,
					       struct string *title 
					       /* shared, free'ed by 
						  free_commands */,
					       struct string * quittext   
					       /* shared, free'ed by 
						  free_commands */,
					       char * opt_string
					       ));


/* src/command/command.c */

extern void free_commands P_((struct elm_commands **cmd));        /* decrement refcount */

extern void free_cached_commands P_((void));

extern struct stringbuffer * give_commands_help P_((struct elm_commands *cmd));

extern const struct elm_command * lookup_elm_command P_((struct elm_commands *cmd,
						   int key));


/* Caller must free result */
extern struct string * elm_command_key_text P_((const struct elm_command *C));

/* Shared result, caller must not free result */
extern const struct string * elm_command_key_desc P_((const struct elm_command *C));

/* Caller must free result */
extern struct string * elm_command_same_text P_((int key, const struct elm_command *C));

/* Caller must free result */
extern struct string * elm_command_key1_desc P_((int key));

extern struct elm_commands *give_merged_commands P_((const struct elm_commands 
						     *base,
						     const struct elm_commands 
						     *append,
						     int pg_flags_base, 
						     int pg_flags_append));  
/* increment refcount -- does not touch original */


/* src/quotadisp.c ----------------------------------------------------- */

/* Increments refcount */
extern struct quota_display * new_quota_display
    P_((struct mail_quota   * mquota,
	struct menu_context * parent_page,
	struct cancel_data  * cd
	));

extern void quota_display_add_quota P_((struct quota_display * quotad,
					struct mail_quota    * mquota,
					struct cancel_data   * cd));
extern void quota_display_add_qlist P_((struct quota_display       * quotad,
					struct mail_quotaroot_list * qlist,
					struct string              * folder_disp_name,
					struct cancel_data         * cd));

/* Return '\0', EOF, or letter from cmds (may be NULL) */
extern int quota_display_show P_((struct quota_display       * quotad,
				  struct elm_commands        * cmds /* may be NULL */));

extern void free_quota_display P_((struct quota_display ** quotad,
				   struct menu_context   * parent_page
				   ));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
