/* $Id: menu.h,v 2.3 2014/07/14 15:07:25 hurtta Exp $ */

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, 
 *                            hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  This code initially written by: Michael Elkins <elkins@aero.org>, 
 *  17 May 1995.
 ****************************************************************************/

/* returns the number of the current selection from the menu */
#define MenuCurrent(X) X.current

/* this will make MenuLoop() update the screen on the next call */
#define MenuUpdate(X) (X.update = 1)

struct menu_object {
    char **data;
    char *title;
    char *prompt;
    char *help;
    int prompt_length;
    int len;
    int max;
    int current;
    int pagetop; /* the index of the first entry on this page */
    unsigned int update : 1;
};
typedef struct menu_object menu_t;

extern void MenuInit P_((menu_t *m, char *t, char *p, char *h));
extern void MenuDestroy P_((menu_t *m));

/* new menu context assumed */
extern int MenuLoop P_((menu_t *m, struct menu_context *page));
extern int MenuAdd P_((menu_t *m, char *s));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
