/* @(#)$Id: pg_range_imp.h,v 2.5 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


/* If line is not changed, returns original pointer */
extern struct string * pager_range_change_line P_((const struct pager_range *range,
						   struct string *line,
						   int filter_on_BOL,
						   int filter_on_BOR));

extern struct pager_range *malloc_simple_pager_range 
P_((struct pager_range *inherit, int range_flags,int quote_level,
    int indent));

extern void set_pager_range_opcode P_((struct pager_range *range,
				       enum pager_range_opcode  opcode));

/* Caller must call free_pager_range() */
extern struct pager_range * give_parent_pager_range 
  P_((const struct pager_range *range));

/* Caller must call free_pgrng_bfr_binding() */
extern struct pgrng_bfr_binding * give_pager_range_stringbuffer
  P_((const struct pager_range *range)); 

/* Calls pgrng_bfr_bnd_set_range(), caller must handle 
 * free_pgrng_bfr_binding()
 */
extern void set_pager_range_stringbuffer P_((struct pager_range *range,
					     struct pgrng_bfr_binding *buffer));
					    

extern struct pager_range *get_pager_range_serialization_from_file 
  P_((FILE *fh, struct stringbuffer * buffer));
extern void put_pager_range_serialization_to_file P_((FILE *fh,
						      struct pager_range 
						      *range,
						      struct stringbuffer *buffer,
						      long *pos));

/*  stringbuffer.c ------------------------------------------------------ */

extern void stringbuffer_add_pager_range P_((struct stringbuffer *buffer,
					     struct pager_range *range));
extern void stringbuffer_add_pager_range_b P_((struct stringbuffer *buffer,
					       struct pgrng_bfr_binding *binding,
					       struct pager_range *range));

extern void inc_stringbuffer_refcount P_((struct stringbuffer *buffer));

/* Caller must call free_pager_range() */
extern struct pager_range * stringbuffer_get_pager_range
   P_((struct stringbuffer *buffer, int index));     

/* pgrng_bfr_binding.c -------------------------------------------------- */

/* 1) binding -> pager_range */
extern void pgrng_bfr_bnd_clear_range P_((struct pgrng_bfr_binding **binding,
					  const struct pager_range *range));
extern void pgrng_bfr_bnd_set_range P_((struct pgrng_bfr_binding *binding,
					struct pager_range *range));

/* Caller must call free_pager_range() */
struct pager_range * pgrng_bfr_bnd_get_range P_((const struct pgrng_bfr_binding *binding));

/* 2) binding -> stringbuffer */

extern void pgrng_bfr_bnd_clear_stringbuffer P_((struct pgrng_bfr_binding **binding,
						 const struct stringbuffer *buffer,
						 int index));
extern void pgrng_bfr_bnd_set_stringbuffer P_((struct pgrng_bfr_binding *binding,
					       struct stringbuffer *buffer,
					       int index));


/* Caller must call free_stringbuffer() */
extern struct stringbuffer * pgrng_bfr_bnd_get_stringbuffer 
   P_((struct pgrng_bfr_binding *binding, int *index));


/* 3) general */

struct pgrng_bfr_binding * new_pgrng_bfr_binding P_((void));

extern void free_pgrng_bfr_binding P_((struct pgrng_bfr_binding **binding));

extern void inc_pgrng_bfr_binding_refcount P_((struct pgrng_bfr_binding *binding));

/* param value */

extern void pgrng_binding_add_value P_((struct pgrng_bfr_binding * backlink,
					struct pager_param_value * value,
					int  buffer_index));

/* Increments refcount */
struct pager_param_value * pgrng_binding_get_value
          P_((struct pgrng_bfr_binding * backlink,
	      int  buffer_index));

/* Increments refcount */
struct pager_param_value *  pgrng_binding_search_helper
    P_((struct pgrng_bfr_binding * backlink,
	int                      * next_pos /* iterator */,
	int                      * found_pos /* -1 if not found */));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

