/* $Id: schedule_time.h,v 2.10 2020/01/26 14:58:09 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* schedule-time.c  ------------------------------------------------------- */

extern const struct schedule_timelimit {
    time_t         wallclock;

#ifdef USE_GETTIMEOFDAY
    struct timeval timeofday;
#endif    
    
#ifdef USE_CLOCK_MONOTONIC
    struct timespec monotonic;
#endif
} NO_schedule_timelimit;

extern int schedule_set_next_timeout P_((struct schedule_timelimit *X,
					 int              timeout_sec));

struct sec_ms {
    int                timeout_sec;
    unsigned short int timeout_ms;
};

extern int same_sec_ms P_((const struct sec_ms *a, const struct sec_ms *b));

enum schedule_errmode {
    se_use_time_MAX          /* set timout to time_MAX */,
    se_use_before_time_MAX   /* set timout to time_MAX-1 */,
    se_use_zero              /* set timeout to zero */
};

extern int schedule_set_next_timeout0 P_((struct schedule_timelimit *X,
					  const struct schedule_timelimit *
					  current,
					  int              timeout_sec,
					  enum schedule_errmode errmode
					  ));

extern int schedule_set_next_timeout2a P_((struct schedule_timelimit *X,
					   const struct schedule_timelimit *
					   current,
					   const struct sec_ms *timeout,
					   enum schedule_errmode errmode));

extern int schedule_set_next_timeout2 P_((struct schedule_timelimit *X,
					  const struct sec_ms *timeout));

extern int schedule_shorten_next_timeout  P_((struct schedule_timelimit *
					      next_timeout,
					      const struct schedule_timelimit *
					      candinate));

extern int schedule_extend_valid_until P_((struct schedule_timelimit *valid_until,
					   const struct schedule_timelimit *
					   candinate));

extern int  schedule_invalid_next_timeout P_((const struct schedule_timelimit *
					      next_timeout));
extern int  schedule_have_timelimit P_((const struct schedule_timelimit * timelimit));
     
extern void schedule_set_current_time P_((struct schedule_timelimit *
					  next_timeout));

/* Almost same than schedule_valid_until_expired */
extern int schedule_timeout_reached P_((const struct schedule_timelimit *
					next_timeout,
					const struct schedule_timelimit *
					current));

/* Almost same than schedule_timeout_reached */
extern int schedule_valid_until_expired P_((const struct schedule_timelimit *
					    valid_until,
					    const struct schedule_timelimit *
					    current));

/* Rougly reverse of schedule_valid_until_expired */
extern int schedule_valid_until_ok P_((const struct schedule_timelimit *
				       valid_until,
				       const struct schedule_timelimit *
				       current));


extern int schedule_valid_until_is_MAX P_((const struct schedule_timelimit *
					   valid_until));

extern void  set_MAX_schedule_timelimit P_((struct schedule_timelimit *max));
extern const struct schedule_timelimit * give_MAX_schedule_timelimit P_((void));
					  
/* Result malloced, caller must free */
extern char * schedule_timeout_string P_((const struct schedule_timelimit *
					  next_timeout));

#if defined(SELECT) || defined(I_SYS_SELECT) || defined(S_TIMEVAL) || defined(USE_GETTIMEOFDAY)
extern int  schedule_timeout_to_timeval P_((const struct schedule_timelimit *
					    next_timeout,
					    struct timeval * timeout));
#endif

extern int  schedule_timeout_to_timeout_msec P_((const struct schedule_timelimit *
						 next_timeout,
						 int * timeout_msec));

extern int  schedule_timeout_to_timeout_sec P_((const struct schedule_timelimit
						* next_timeout,
						unsigned int * timeout_sec));

#define SCHEDULE_TP_HAVE_TIME 1
#define SCHEDULE_TP_HAVE_MSEC 2

extern int schedule_time_passed P_((const struct schedule_timelimit * start,
				    const struct schedule_timelimit * end,
				    struct sec_ms                   * result));

/* schedule.c ------------------------------------------------------ */

/* Updates *current */
extern enum wait_for_status wait_for_any_action_settime P_((struct schedule_timelimit *current));

/* Updates *current */
extern enum wait_for_status wait_for_action_or_timeout_settime P_((action_routine * action,
								   int seconds,
								   struct schedule_timelimit *current));

extern enum wait_for_status wait_for_action_or_timeout_settime_c P_((action_routine * action,
								     int seconds,
								     struct schedule_timelimit *current,
								     struct cancel_data *cd));


/* Updates *current */
extern enum wait_for_status wait_for_any_action_settime_c P_((struct schedule_timelimit *current,
							      struct cancel_data *cd));


#ifdef ANSI_C
struct timed_task;
struct timed_task_handle;
#define E_(x) extern x;
#else
#define E_(x)
#endif

typedef void timed_task_free_f          P_((struct timed_task **task));
typedef void inc_timed_task_refcount_f  P_((struct timed_task *task));
typedef enum timed_task_r {
    timed_task_default = 0,
    timed_task_retry,      /* mark task as not runned */
    timed_task_disable     /* mark task as already runned */
} timed_task_action_f        P_((struct timed_task *task /* NULL if task on alter_timed_task()
							    was not given */,
				 const struct schedule_timelimit *now));

E_(timed_task_free_f         NO_timed_task_free)
E_(inc_timed_task_refcount_f NO_timed_task_refcount)
E_(timed_task_action_f       NO_timed_task_action)

/* Return 1 if timed_task is sceduled 
   Return 0 if there is no POLL_method
*/
extern int alter_timed_task P_((struct timed_task_handle  ** handle,
				struct timed_task          * task   /* may be NULL */,   
				timed_task_free_f          * free_task,
				inc_timed_task_refcount_f  * inc_task_refcount,
				timed_task_action_f        * task_action,
				const struct schedule_timelimit * deadline)); 
extern void NO_timed_task_free                 P_((struct timed_task **task));
extern void NO_inc_timed_task_refcount         P_((struct timed_task *task));
extern enum timed_task_r NO_timed_task_action  P_((struct timed_task *task,
						   const struct schedule_timelimit *now));

enum timed_task_cleanup { tt_discard_free_schedule_cleanup = 0,
			  tt_allow_free_schedule_cleanup };

extern void timed_task_alter_cleanup P_((struct timed_task_handle  ** handle,
					 enum timed_task_cleanup allow_cleanup));

/* Return 1 if task (or some other action or timeout) occured */
extern enum wait_for_status wait_for_task P_((struct timed_task_handle  * task));

/* Returns 1 if action or deadline is reached          */
extern enum wait_for_status wait_for_action_or_deadline_c P_((action_routine                  * action,
							      const struct schedule_timelimit * deadline,
							      struct cancel_data *cd));
/* Updates *current */
extern enum wait_for_status wait_for_action_or_deadline_settime P_((action_routine                  * action,
								    const struct schedule_timelimit * deadline,
								    struct schedule_timelimit       * current));

extern enum wait_for_status wait_for_action_or_deadline_settime_c P_((action_routine                  * action,
								      const struct schedule_timelimit * deadline,
								      struct schedule_timelimit       * current,
								      struct cancel_data              * cd));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

