/* $Id: state_imp.h,v 2.15 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.15 $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

enum state_policy { state_policy_putc_use_filter = 1,
		    state_policy_flush_via_put,
		    state_policy_support_pg_flags,
		    state_policy_gets_via_getc,
		    state_policy_convert_entity
};

#if ANSI_C
struct pager_param_value;
#endif

/* ----------------------------------------------------------------------- */


typedef void init_so_func P_((struct out_state *s)); 
typedef void dest_so_func P_((struct out_state *s));

typedef int  seekable_so_func P_((struct out_state *s));
typedef FILE * FILE_so_func P_((struct out_state *s));
typedef int  seek_so_func P_((struct out_state *s, long pos));
typedef long ftell_so_func P_((struct out_state *s));
typedef void flush_filter_so_func P_((struct out_state *s, int munge_eoln,
				      int pg_flags, struct pager_range *range,
				      int force_eoln));

typedef int policy_so_func P_((struct out_state *s, 
			       enum state_policy question));

typedef int  putc_so_func P_((struct out_state *s, int ch));
typedef int  put_so_func P_((struct out_state *s, const char *string, int len));

typedef int ferror_so_func P_((struct out_state *s));

typedef void add_pager_range_func P_((struct out_state *s, struct pager_range *range));

typedef enum sout_entity_result {
    sout_entity_reference_key = -2 /* Print reference_key */,
    sout_entity_fallback = -1,
    sout_entity_failed = 0,
    sout_entity_succeed,
}  putentity_so_func P_((struct out_state *s, struct out_entity *oe));


typedef void add_pager_param_func P_((struct out_state *s, struct pager_range *range,
				      enum pager_param_opcode opcode,
				      struct pager_param_value * param_value));

#define OUT_STATE_type_magic 0xEB05

struct out_state_type {
    unsigned short magic;     /* OUT_STATE_type_magic */
    
    init_so_func     * init_so_it;
    dest_so_func     * dest_so_it;
    seekable_so_func * seekable_so_it;
    FILE_so_func     * FILE_so_it;
    seek_so_func     * seek_so_it;
    ftell_so_func    * ftell_so_it;
    flush_filter_so_func * flush_filter_so_it;
    policy_so_func   * policy_so_it;
    putc_so_func     * putc_so_it;
    put_so_func      * put_so_it;
    ferror_so_func   * ferror_so_it;
    add_pager_range_func * add_pager_range_it;
    putentity_so_func * putentity_so_it;
    add_pager_param_func * add_pager_param_it;
};


/* This only registers pointer, struct is not copied */
void register_state_out_type P_((struct out_state_type *T));


/* ---------------------------------------------------------------------- */

#define STATE_out_magic	     0xEB00

struct out_state {
    unsigned short magic;     /* STATE_out_magic */

    struct out_state_type   *  state_type;

    unsigned int EOLN_is_CRLF : 1;       /* 0 == \n   is EOLN
					    1 == \r\n is EOLN */

    unsigned int filter_on_BOL : 1;      /* filter is on beginning of line  */
    unsigned int filter_on_BOR : 1;      /* filter is on beginning of range */

    charset_t    * display_charset;      /* output charset -- vector
					  * of possible sets 
					  */
    charset_t       filter;
    struct string * filter_line;       /* input charset */
    int             pg_flags;          /* pager flags   pg_BOLD, and so on */
    struct pager_range * pager_range;  /* pager quotation and so on        */

    union {
	void                  * dummy;
	struct out_state_file * file;
	struct stringbuffer   * buffer;
	struct dirstate_out   * dir;
    } u;
};

/* ---------------------------------------------------------------------- */

#define IN_STATE_type_magic  0xEA02

typedef void init_si_type_f P_((struct in_state *)); /* Prototype */
typedef void dest_si_type_f P_((struct in_state *)); /* Prototype */
typedef int  seekable_si_type_f P_((struct in_state *s));
typedef int  getc_si_type_f P_((struct in_state *)); /* Prototype */
typedef int  ungetc_si_type_f P_((int,struct in_state *)); /* Prototype */
typedef char *gets_si_type_f P_((char *, int, struct in_state *));
typedef int getl_si_type_f P_((char *, int, struct in_state *));
typedef long ftell_si_type_f P_((struct in_state *s));
typedef int fseek_si_type_f P_((struct in_state *s, long pos));

/* Caller frees result, NULL if no error */
typedef struct string * errmsg_si_type_f P_((struct in_state *s,
					     int clearerr /* pop message from stack*/ ));

typedef int policy_si_type_f P_((struct in_state *s, 
				 enum state_policy question));
typedef int ferror_si_type_f P_((struct in_state *s));
typedef int feof_si_type_f   P_((struct in_state *s));

struct in_state_type {
    unsigned short magic;   /* IN_STATE_type_magic */

    init_si_type_f     * init_si_type;
    dest_si_type_f     * dest_si_type;
    seekable_si_type_f * seekable_si_type;
    getc_si_type_f     * getc_si_type;
    ungetc_si_type_f   * ungetc_si_type;
    gets_si_type_f     * gets_si_type;
    getl_si_type_f     * getl_si_type;
    ftell_si_type_f    * ftell_si_type;
    fseek_si_type_f    * fseek_si_type;
    errmsg_si_type_f   * errmsg_si_type;
    policy_si_type_f   * policy_si_type;
    ferror_si_type_f   * ferror_si_type;
    feof_si_type_f     * feof_si_type;
};

/* ---------------------------------------------------------------------- */

#define STATE_in_magic       0xEA00

struct in_state {
    unsigned short magic;       /* STATE_in_magic */
    
    struct in_state_type   * state_type;
    struct string          * error_message;

    int          refcount;

    union {
	struct in_state_file   * file;
	struct in_state_decode * decode;
    } u;
    
};

/* ---------------------------------------------------------------------- */

extern void state_panic P_((char *,int,char *, char *));


/* ------------------------------------------------------------------- */

extern char *state_gets_helper P_((char *dest, int length, 
				   struct in_state *s));
extern int state_getl_helper P_((char *dest, int length, 
				 struct in_state *s));


/* -------------------------------------------------------------------- */

#define OUT_ENTITY_magic	0xEB25

struct out_entity {
    unsigned short          magic;    /* OUT_ENTITY_magic */

    int   refcount;
    
    struct string  * reference_key;     /* Named reference including & ; */
    int    reference_key_pg_flags;      /* pg_flags when displaying reference_key */

    struct string * entity_value;
    uint16          unicode_value;          /* Numeric reference             */
};


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
