/* $Id: tagfilter_imp.h,v 2.3 2024/09/27 16:32:09 hurtta Exp $ */

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

#if ANSI_C
struct tagfilter_selection;
struct tagfilter_tags;
struct tagfilter_stack_item;
struct tagfilter_global;
#endif

typedef struct tagfilter_stack_item *
  give_top_stack_item_f P_((mime_t                     * body,
			    struct in_state            * state_in,
			    struct out_state           * state_out,
			    const struct decode_opts   * decode_opt,
			    charset_t                    text_charset,
			    struct tagfilter_selection * tagfilter));

typedef struct tagfilter_tag_state *
   give_stack_item_f P_((struct tagfilter_stack_item **new_item,
			 struct tagfilter_tags      * tags,
			 struct string              * tag_name,
			 struct tagfilter_stack_item **stack,
			 size_t                        stack_len,
			 size_t                     * stack_pos,
                         mime_t                     * body,
			 struct in_state            * state_in,
			 struct out_state           * state_out,
			 const struct decode_opts   * decode_opt,
			 charset_t                    text_charset,
			 struct tagfilter_selection * tagfilter,
			 struct tagfilter_global    * counter));
typedef struct tagfilter_tag_state *
   locate_stack_item_f P_((struct string              * tag_name,
			   struct tagfilter_stack_item **stack,
			   size_t                        stack_len,
			   size_t                      * stack_pos
			   /* or stack_len if not found */,
			   mime_t                     * body,
			   struct in_state            * state_in,
			   struct out_state           * state_out,
			   charset_t                    text_charset,
			   struct tagfilter_selection * tagfilter));
typedef void
   end_tag_state_f P_((struct tagfilter_tag_state **tag_state,
		       mime_t                     * body,
		       struct in_state            * state_in,
		       struct out_state           * state_out,
		       charset_t                    text_charset,
		       struct tagfilter_selection * tagfilter,
		       struct tagfilter_global    * counter
		       ));

typedef struct tagfilter_stack_item *
  push_stack_item_f P_((struct tagfilter_tag_state * tag_state,
			struct tagfilter_stack_item **stack,
			size_t                        stack_len,
			mime_t                     * body,
			struct in_state            * state_in,
			struct out_state           * state_out,
			const struct decode_opts   * decode_opt,
			charset_t                    text_charset,
			struct tagfilter_selection * tagfilter));

enum stack_close_mode { stack_close_end = 0   /* normal close on
				 		 end of tag */,
			stack_close_middle    /* close on end of tag
						 on middle of stack */,
			stack_close_auto     /* automatic close on
						start of end tag */,
			
			stack_enter_auto     /* automatic close on
						start of open tag */
			
};
 
/* return 1 if stack is closed and need to be removed from stak */

typedef int close_stack_item_f P_((struct tagfilter_tag_state   * tag_state,
				   struct tagfilter_stack_item ** stack,
				   size_t                         stack_len,
				   size_t                         idx,
				   enum stack_close_mode          close_pos,
				   mime_t                       * body,
				   struct in_state              * state_in,
				   struct out_state             * state_out,
				   charset_t                      text_charset,
				   struct tagfilter_selection   * tagfilter,
				   struct tagfilter_global      * counter));

typedef struct  tagfilter_atr_state *
   start_attribute_f P_((struct string              * atr_name,
			 struct tagfilter_tag_state * tag_state,
			 mime_t                     * body,
			 struct in_state            * state_in,
			 struct out_state           * state_out,
			 charset_t                    text_charset,
			 struct tagfilter_selection * tagfilter));
typedef void end_attribute_f P_((struct tagfilter_atr_state **atr_state,
				 struct tagfilter_tag_state * tag_state,
				 mime_t                     * body,
				 struct in_state            * state_in,
				 struct out_state           * state_out,
				 charset_t                 text_charset,
				 struct tagfilter_selection * tagfilter));
enum atrvalue_start_end {
    atrvalue_start = 0,
    atrvalue_end
};

typedef void start_end_atrvalue_f
    P_((struct tagfilter_atr_state * atr_state,
	enum atrvalue_start_end      start_end,
	struct tagfilter_tag_state * tag_state,
	mime_t                     * body,
	struct in_state            * state_in,
	struct out_state           * state_out,
	charset_t                    text_charset,
	struct tagfilter_selection * tagfilter));

typedef void atrvalue_seg_string_f
   P_((struct tagfilter_atr_state * atr_state,
       struct string              * atr_value_segment,
       struct tagfilter_tag_state * tag_state,
       mime_t                     * body,
       struct in_state            * state_in,
       struct out_state           * state_out,
       charset_t                    text_charset,
       struct tagfilter_selection * tagfilter));

typedef void atrvalue_seg_ent_f
    P_((struct tagfilter_atr_state * atr_state,
	struct out_entity          * atr_value_segment,
	struct tagfilter_tag_state * tag_state,
	mime_t                     * body,
	struct in_state            * state_in,
	struct out_state           * state_out,
	charset_t                    text_charset,
	struct tagfilter_selection * tagfilter));

/* Does not do free struct tagfilter_stack_item */
typedef void stack_item_clear_f
  P_((struct tagfilter_stack_item * item,
      struct tagfilter_selection  * tagfilter));


enum TAGFLT_MODE_bits {

    TAGFLT_MODE_bit_tag_attributes,  /* Allow <tag attributes>       */
    TAGFLT_MODE_bit_double_smaller,  /* Allow << encode < character  */
    TAGFLT_MODE_bit_many_linebreak,  /* Convert n linebreak to space and 
					n-1 linebreak 
				     */
    TAGFLT_MODE_bit_enriched_tag,    /* Tag all in US-ASCII, restricted
					to the alphanumeric and hyphen 
					("-") characters.
				     */
    
    TAGFLT_MODE_bit_lowerascii,      /* Tag lowercase ascii names */
    TAGFLT_MODE_bit_convert_cr,      /* Convert CR (outside of CRLF) 
					to LF      
				     */
    
    TAGFLT_MODE_bit_count
};

/* Allow <tag attributes> */
#define TAGFLT_MODE_tag_attributes  (1 << TAGFLT_MODE_bit_tag_attributes)

/* Allow << encode < character  */
#define TAGFLT_MODE_double_smaller  (1 << TAGFLT_MODE_bit_double_smaller)

/* Convert n linebreak to space and n-1 linebreak  */
#define TAGFLT_MODE_many_linebreak  (1 << TAGFLT_MODE_bit_many_linebreak)

/*  Tag all in US-ASCII, restricted to the alphanumeric and hyphen ("-") 
    characters 
*/
#define TAGFLT_MODE_enriched_tag    (1 << TAGFLT_MODE_bit_enriched_tag)

/* Tag lowercase ascii names */
#define TAGFLT_MODE_lowerascii      (1 << TAGFLT_MODE_bit_lowerascii)    

/* Convert CR (outside of CRLF) to LF      */
#define TAGFLT_MODE_convert_cr      (1 << TAGFLT_MODE_bit_convert_cr)   


#define TAGFILTER_SELECTION_magic	0xFD0A

extern struct tagfilter_selection {
    unsigned short               magic;    /* TAGFILTER_SELECTION_magic */

    unsigned int                 tagflt_mode : TAGFLT_MODE_bit_count;

    const char                 * doctype_name;    /* Allow <!             
						     Also <!DOCTYPE                    -->
						     and  <!-- comment1 -- -- comment2 -->
						  */
    
    struct tagfilter_entities  * have_entities;   /* Allow &entity; 
						     Allow &#ddd;   
						     where ddd is decimal
						  */
    struct tagfilter_tags      * top_tags;    
    give_top_stack_item_f      * give_top_item;
    give_stack_item_f          * give_stack_item;
    locate_stack_item_f        * locate_stack_item;
    end_tag_state_f            * end_tag_state;
    push_stack_item_f          * push_stack_item;
    close_stack_item_f         * close_stack_item;
    start_attribute_f          * start_attribute;
    end_attribute_f            * end_attribute;
    start_end_atrvalue_f       * start_end_atrvalue;
    atrvalue_seg_string_f      * atrvalue_seg_string;
    atrvalue_seg_ent_f         * atrvalue_seg_ent;
    stack_item_clear_f         * stack_item_clear;
} tagfilter_text_enriched, tagfilter_text_html;

#define TAGFILTER_STACK_ITEM_magic	0xFD13

struct tagfilter_stack_item {
    unsigned short               magic;   /*  TAGFILTER_STACK_ITEM_magic */

    struct pager_range         * range;

    int                          pg_flags;

    struct tagfilter_tags      * nested_tags;  /* static */

    struct tagfilter_cmd       * current_tag;
    
    unsigned int                reset_pg_flags: 1;  /* Stop inheritance */
    unsigned int                force_eoln: 1;      /* Pass force_newline
						     */
    unsigned int                text_visible: 1;

    union tagfilter_stack_uitem {
	unsigned short                   * magic;
	struct tagfilter_stack_html_item * html;
    } u;
};


/* melib/tagfilter_decode.c ------------------------------------------ */


extern void text_enriched_decode P_((mime_t                   * part, 
			     struct in_state          * instream, 
			     struct out_state         * outstream,
			     const struct decode_opts * decode_opt,
			     charset_t                  defcharset, 
			     struct header_rec        * hdr,
			     type_mismatch_prompt     * badtype,
			     charset_t                  bodydefcharset));
extern int text_enriched_selector P_((mime_t            * p,
				      struct header_rec * hdr));

extern void text_html_decode P_((mime_t                   * part, 
			     struct in_state          * instream, 
			     struct out_state         * outstream,
			     const struct decode_opts * decode_opt,
			     charset_t                  defcharset, 
			     struct header_rec        * hdr,
			     type_mismatch_prompt     * badtype,
			     charset_t                  bodydefcharset));
extern int text_html_selector P_((mime_t            * p,
				  struct header_rec * hdr));



/* melib/tagfilter.c -------------------------------------------------- */

extern void tagfilter_decoder P_((mime_t *body,
				struct in_state            * state_in,
				struct out_state           * state_out,
				const struct decode_opts   * decode_opt,
				charset_t                    text_charset,
				struct tagfilter_selection * tagfilter));


/* melib/tagfilter_entity.c ------------------------------------------- */

extern  struct tagfilter_entities HTML_entities;

extern struct name_entity_walk * tagfilter_start_reference
    P_((struct tagfilter_entities *ents));
extern void free_name_entity_walk P_((struct name_entity_walk **ptr));

/*  free'es struct name_entity_walk, if no match */
extern void advance_entity_walk P_((struct name_entity_walk **walk,
				    uint16 u));

enum tagfilter_match { tagfilter_match_prefix = 0,
		       tagfilter_match_semicolon };

/* increment refcount */
extern struct name_entity_match * tagfilter_match_reference
    P_((struct name_entity_walk *walk,
	enum tagfilter_match
	have_semicolon));
extern void free_name_entity_match P_((struct name_entity_match **ptr));

extern int tagfilter_entity_character P_((uint16 u, int *res));

extern struct out_entity * out_entity_from_match
    P_((struct string            * reference_key,
	struct name_entity_match * match,
	 int                       reference_key_pg_flags));

/* melib/tagfilter_tag.c ---------------------------------------------- */

#define TAGFILTER_GLOBAL_magic 		0xFD18

extern struct tagfilter_global {
    unsigned short               magic;

    struct sortlist            * unsupported_tags;

    unsigned int                 have_other:1;  /* Have other unsupported tags */
    
} NULL_counter;

extern void tagfilter_global_dest P_((struct tagfilter_global *counter));

/* caller must free */
extern struct string **tagfilter_list_tags P_((struct sortlist * unsupported_tags));

extern struct tagfilter_tags text_enriched_tags, text_html_top;

extern struct tagfilter_tags text_html_head_body;
extern struct tagfilter_tags text_html_metadata;
extern struct tagfilter_tags text_html_flow;
extern struct tagfilter_tags text_html_phrasing;

extern struct tagfilter_tags text_html_close_head;
extern struct tagfilter_tags text_html_noscript_head;
extern struct tagfilter_tags text_html_datalist;
extern struct tagfilter_tags text_html_details;
extern struct tagfilter_tags text_html_dl;
extern struct tagfilter_tags text_html_fieldset;
extern struct tagfilter_tags text_html_figure;
extern struct tagfilter_tags text_html_footer;
extern struct tagfilter_tags text_html_form;
extern struct tagfilter_tags text_html_hgroup;
extern struct tagfilter_tags text_html_label;
extern struct tagfilter_tags text_html_list_items;
extern struct tagfilter_tags text_html_close_li;
extern struct tagfilter_tags text_html_close_p;
extern struct tagfilter_tags text_html_address;
extern struct tagfilter_tags text_html_meter;
extern struct tagfilter_tags text_html_picture;
extern struct tagfilter_tags text_html_progress;
extern struct tagfilter_tags text_html_ruby;
extern struct tagfilter_tags text_html_table;
extern struct tagfilter_tags text_html_div_dl;
extern struct tagfilter_tags text_html_caption;
extern struct tagfilter_tags text_html_colgroup;
extern struct tagfilter_tags text_html_tr_list;
extern struct tagfilter_tags text_html_tr;
extern struct tagfilter_tags text_html_close_thead;
extern struct tagfilter_tags text_html_close_tbody;
extern struct tagfilter_tags text_html_close_tr;
extern struct tagfilter_tags text_html_close_td;
extern struct tagfilter_tags text_html_th;
extern struct tagfilter_tags text_html_close_th;
extern struct tagfilter_tags text_html_close_dtdd;
extern struct tagfilter_tags text_html_close_rtrp;

extern give_top_stack_item_f give_top_text_enriched, give_top_text_html;
extern give_stack_item_f     give_item_text_enriched,give_item_text_html;
extern locate_stack_item_f   locate_item_text_enriched,
    locate_item_text_html;
extern end_tag_state_f       end_tag_text_enriched, end_tag_text_html;
extern push_stack_item_f     push_tag_text_enriched, push_tag_text_html;
extern close_stack_item_f    close_tag_text_enriched, close_tag_text_html;
extern start_attribute_f     start_atr_text_enriched, start_atr_text_html;
extern end_attribute_f       end_atr_text_enriched, end_atr_text_html;
extern start_end_atrvalue_f  start_end_atrval_text_enriched,
    start_end_atrval_text_html;
extern atrvalue_seg_string_f atrvalue_seg_str_text_enriched,
    atrvalue_seg_str_text_html;
extern atrvalue_seg_ent_f    atrvalue_seg_ent_text_enriched,
    atrvalue_seg_ent_text_html;
extern stack_item_clear_f stack_item_clear_text_enriched,
    stack_item_clear_text_html;

enum  tagfilter_cmd_base {
    tfc_unsupported = -1,        /* Add to unsupported tag list	 */
    tfc_none         = 0,        /* No special code */
    tfc_enriched_cmd     = 1000,
    tfc_html_cmd         = 2000   

};

enum  tagfilter_cmd_enriched {
    tfc_enriched_unsupported = tfc_unsupported,
    tfc_enriched_none        = tfc_none,
    
    /* text/enriched specific */
    
    tfc_center = tfc_enriched_cmd,  /* Not work really */
    tfc_nojoin,             /* text/enriched: No (CRLF span or) 
			       line joining 
			    */
    tfc_quote,              /* Increase quote level */
};

enum  tagfilter_cmd_html {
    tfc_html_unsupported = tfc_unsupported,
    tfc_html_none        = tfc_none,

    /* text/html specific */
    
    tfc_html_br          = tfc_html_cmd        /* <br> */,
    tfc_html_hr           /* <hr> */,
    tfc_html_p            /* <p> */,
    tfc_html_pre          /* <pre> */,
    tfc_html_q            /* <q> */,
    tfc_html_li           /* <li> */,

    tfc_html_ul           /* <ul> */,
    tfc_html_ol           /* <ol> */,
    tfc_html_img          /* <img> */,
    
};

#define TAGFILTER_CMD_magic             0xFD14

enum TAGFLT_CMD_bits {
    TAGFLT_CMD_bit_is_static,
    TAGFLT_CMD_bit_force_newline,

    TAGFLT_CMD_bit_close_search,   /* Opening tag may close this */
    TAGFLT_CMD_bit_nested_search,  /* Opening tag is optional    */
    TAGFLT_CMD_bit_no_context,     /* No context - start tag is end tag */
    TAGFLT_CMD_bit_inherit_nested_tags, /* Transparent content model */
    TAGFLT_CMD_bit_hide_text,      /* Hide text */
    TAGFLT_CMD_bit_show_text,      /* show text */
    
    TAGFLT_CMD_bit_count
};

#define TAGFLT_CMD_is_static	    (1 << TAGFLT_CMD_bit_is_static)
#define TAGFLT_CMD_force_newline    (1 << TAGFLT_CMD_bit_force_newline)
#define TAGFLT_CMD_close_search     (1 << TAGFLT_CMD_bit_close_search)
#define TAGFLT_CMD_nested_search    (1 << TAGFLT_CMD_bit_nested_search)
#define TAGFLT_CMD_no_context       (1 << TAGFLT_CMD_bit_no_context)
#define TAGFLT_CMD_inherit_nested_tags (1 << TAGFLT_CMD_bit_inherit_nested_tags)
#define TAGFLT_CMD_hide_text        (1 <<  TAGFLT_CMD_bit_hide_text)
#define TAGFLT_CMD_show_text        (1 <<  TAGFLT_CMD_bit_show_text)

struct tagfilter_cmd {
    unsigned short            magic;    /*  TAGFILTER_CMD_magic */

    int                       refcount;
    
    char *                    ascii_command;

    int                       pg_flags;

    union tagfilter_cmd_code {
	int                           code;
	enum  tagfilter_cmd_base      base;
	enum  tagfilter_cmd_enriched  enriched;
	enum  tagfilter_cmd_html      html;
    } code;

    struct tagfilter_tags   * nesting; /* static always */

    unsigned  int   cmd_mode  : TAGFLT_CMD_bit_count;

    /* Use struct string_sort because it have always
       comparision defined -- works better on
       sorting than struct string
    */
    
    struct string_sort  * string_command;  /* Maybe cached from
					      ascii_command
					   */

    struct tagfilter_tags   * auto_close;  /* These tag autoclose
					      this tag
					   */
    
} * tagfilter_cmd_from_string P_((struct string * text,
				  enum  tagfilter_cmd_base base_code,
				  int cmd_mode_flags));

#if __GNUC__ 
#define  TAGFILTER_CMD  tagfilter_cmd
#define baseC(x)     { base: x }
#define enrichedC(x) { enriched: x }
#define htmlC(x)     { html: x }

#define tag_command(x)  &x

#else
struct TAGFILTER_CMD {
    unsigned short            magic;    /*  TAGFILTER_CMD_magic */

    int                       refcount;
    
    char *                    ascii_command;

    int                       pg_flags;

    int                           code;

    struct tagfilter_tags   * nesting; /* static always */

    unsigned  int   cmd_mode  : TAGFLT_CMD_bit_count;

    /* Use struct string_sort because it have always
       comparision defined -- works better on
       sorting than struct string
    */
    
    struct string_sort  * string_command;  /* Maybe cached from
					      ascii_command
					   */
    struct tagfilter_tags   * auto_close;  /* These tag autoclose
					      this tag
					   */
    

    
};
#define baseC(x)     x 
#define enrichedC(x) x 
#define htmlC(x)     x

#define tag_command(x)  (struct tagfilter_cmd *)&x
    
#endif

/* Derement refcount -- free if not static */
extern void tagfilter_release_cmd P_((struct tagfilter_cmd **cmd));
extern void tagfilter_inc_cmd_refcount P_((struct tagfilter_cmd *cmd));

#define TAGFILTER_TAG_STATE_magic	0xFD17

struct tagfilter_tag_state {
    unsigned short            magic; 

    struct tagfilter_cmd    * current_tag;

    union {
	void                 * dummy;
	
	struct tagfilter_html_state  * html;


    } u;

    unsigned int     no_context: 1;    /* Treate as end tag */
    
} * tagfilter_new_tag_state P_((struct tagfilter_cmd    * current_tag));


/* melib/tagfilter_enriched.c ---------------------------------------- */

extern struct tagfilter_cmd * tagfilter_enriched_cmds[];


/* melib/tagfilter_enriched.c ---------------------------------------- */

extern void tagfilter_free_stack_item
   P_((struct tagfilter_stack_item **item,
       struct tagfilter_selection * tagfilter));


/* melib/tagfilter_html.c ---------------------------------------- */

extern struct tagfilter_cmd * tagfilter_html_top[];
extern struct tagfilter_cmd * tagfilter_html_head_body[];
extern struct tagfilter_cmd * tagfilter_html_metadata[];
extern struct tagfilter_cmd * tagfilter_html_flow[];
extern struct tagfilter_cmd * tagfilter_html_close_head[];
extern struct tagfilter_cmd * tagfilter_html_phrasing[];
extern struct tagfilter_cmd * tagfilter_html_noscript_head[];
extern struct tagfilter_cmd * tagfilter_html_datalist[];
extern struct tagfilter_cmd * tagfilter_html_details[];
extern struct tagfilter_cmd * tagfilter_html_dl[];
extern struct tagfilter_cmd * tagfilter_html_fieldset[];
extern struct tagfilter_cmd * tagfilter_html_figure[];
extern struct tagfilter_cmd * tagfilter_html_footer[];
extern struct tagfilter_cmd * tagfilter_html_form[];
extern struct tagfilter_cmd * tagfilter_html_hgroup[];
extern struct tagfilter_cmd * tagfilter_html_label[];
extern struct tagfilter_cmd * tagfilter_html_list_items[];
extern struct tagfilter_cmd * tagfilter_html_close_li[];
extern struct tagfilter_cmd * tagfilter_html_close_p[];
extern struct tagfilter_cmd * tagfilter_html_address[];
extern struct tagfilter_cmd * tagfilter_html_meter[];
extern struct tagfilter_cmd * tagfilter_html_picture[];
extern struct tagfilter_cmd * tagfilter_html_progress[];
extern struct tagfilter_cmd * tagfilter_html_ruby[];
extern struct tagfilter_cmd * tagfilter_html_table[];
extern struct tagfilter_cmd * tagfilter_html_div_dl[];
extern struct tagfilter_cmd * tagfilter_html_caption[];
extern struct tagfilter_cmd * tagfilter_html_colgroup[];
extern struct tagfilter_cmd * tagfilter_html_tr_list[];
extern struct tagfilter_cmd * tagfilter_html_tr[];
extern struct tagfilter_cmd * tagfilter_html_close_thead[];
extern struct tagfilter_cmd * tagfilter_html_close_tbody[];
extern struct tagfilter_cmd * tagfilter_html_close_tr[];
extern struct tagfilter_cmd * tagfilter_html_close_td[];
extern struct tagfilter_cmd * tagfilter_html_th[];
extern struct tagfilter_cmd * tagfilter_html_close_th[];
extern struct tagfilter_cmd * tagfilter_html_close_dtdd[];
extern struct tagfilter_cmd * tagfilter_html_close_rtrp[];


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
