/* $Id: def_addr.h,v 2.10 2020/05/12 18:18:18 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "addrlib.h"


/* getaddrc.c ------------------------------------------------------ */

extern char *scanned_to_str P_((char **scanned));

#define TMPSTORE_magic       0xE804

struct tmpstore {
    unsigned short         magic;   /*  TMPSTORE_magic */
    char           * addr;
    struct string  * fullname;
    struct string  * comment;    
};

extern void tmpstore_to_result P_((struct addr_list *result,
				   struct tmpstore  *res,
				   int group_num,
				   charset_t defcharset));

extern void zero_tmpstore P_((struct tmpstore  *res));


/* ------------------------------------------------------------------- */


/* split_addr.c ------------------------------------------------------- */


extern int strcpy_dequote P_((char * target, const char * source, int size));


/* parsestring.c ------------------------------------------------------ */

extern int string_nonnull P_((const struct string *S));

/* outexpires.c ------------------------------------------------------- */

extern time_t expanded_get_time_t P_((struct tm *tm));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

