static char rcsid[] = "@(#)$Id: digest.c,v 1.2 2020/05/13 05:11:21 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"header");

static const unsigned char *cs2cus P_((const char *str));
static const unsigned char *cs2cus(str) 
     const char *str;
{
    return (const unsigned char *)str;
}

void digest_feed_str(ret,str)
     struct digest_proc * ret;
     const char * str;
{
    feed_digest_proc(ret,cs2cus(str),strlen(str));
}


void digest_feed_references(ret,ref)
     struct digest_proc * ret;
     const struct references *ref;
{
    int idx;
    int count;
    int x = 0;

    count = references_item_count(ref);

    
    for (idx = 0; idx < count; idx++) {
	
	/* message_id also includes comment */
	const struct message_id * id = references_get_message_id(ref,idx);
	const struct string * phrase = references_get_phrase(ref,idx);
	const struct string * tail_comment = references_get_comment(ref,idx);

	if (id) {
	    if (x)
		digest_feed_str(ret," ");
	    x = 1;
	    
	    digest_feed_message_id(ret,id);
	}

	if (phrase) {
	    if (x)
		digest_feed_str(ret," ");
	    x = 1;
	    
	    digest_feed_string(ret,phrase);
	}

	if (tail_comment) {
	    if (x)
		digest_feed_str(ret," ");
	    x = 1;

	    digest_feed_str(ret,"(");
	    digest_feed_string(ret,tail_comment);
	    digest_feed_str(ret,")");
	}
    }
}

void digest_feed_message_id(ret,id)
    struct digest_proc * ret;
    const struct message_id * id;
{
    const char * left                = message_id_left(id);
    const char * domain              = message_id_domain(id);
    const struct string * id_comment = message_id_comment(id);

    digest_feed_str(ret,"<");
    if (left)
	digest_feed_str(ret,left);

    if (domain) {
	digest_feed_str(ret,"@");
	digest_feed_str(ret,domain);
    }
    digest_feed_str(ret,">");

    if (id_comment) {
	digest_feed_str(ret," (");
	digest_feed_string(ret,id_comment);
	digest_feed_str(ret,")");
    }
}

void digest_feed_addrs(ret,addrs,add_group)
     struct digest_proc * ret;
     const struct addr_list   * addrs;
     int                  add_group;
{
    int glen = addr_list_group_count(addrs);
    int len  = addr_list_item_count(addrs);
    int idx;
    int gidx  = -1;
    int last_group = -1;

    if (! add_group && glen > 0) {
	DPRINT(Debug,14,
	       (&Debug, "digest_feed_addrs: add_group is not set. Resetting group count (%d)\n",
		glen));
	glen = 0;
    }

    for (idx = 0; idx < len; idx++) {
	
	int group = -1;
	const struct address * address = 
	    addr_list_get_item(addrs,idx,&group);
	
	const char          * ad          = address_get_ascii_addr(address);
	const struct string * fullname    = address_get_phrase(address);
	const struct string * comment     = address_get_comment(address);

	const int fn = fullname  ? string_len(fullname)  : 0;
	const int cm = comment   ? string_len(comment)   : 0;
	
    next_phrase:
	if (last_group != group &&
	    last_group != -1) {
	    digest_feed_str(ret,";");
	    last_group = -1;	
	}

	if (!ad) {
	    continue;
	}

	if (idx > 0) {
	    digest_feed_str(ret,", ");
	}

	if (gidx < group &&  
	    group >= 0 && last_group == -1) {
		    
	    /*  empty groups */
	    
	    const struct string * groupname =
		addr_list_get_group(addrs,++gidx);
	    digest_feed_string(ret,groupname);

	    digest_feed_str(ret,":");
	    last_group = group;
	    
	    if (gidx < group)
		goto next_phrase;

	    digest_feed_str(ret," ");
	}
	
	if (fn || ! ad[0] || '@' == ad[0]) {

	    if (fn) {
		digest_feed_string(ret,fullname);
	    }

	    digest_feed_str(ret," <");
	    digest_feed_str(ret,ad);
	    digest_feed_str(ret,">");
	} else {
	    digest_feed_str(ret,ad);
	}

	if (cm) {
	    digest_feed_str(ret," (");
	    digest_feed_string(ret,comment);
	    digest_feed_str(ret,")");
	}
    }

    if (last_group != -1) {
	digest_feed_str(ret,";");
	last_group = -1;	
    }

    if (gidx+1 < glen && idx > 0) {
	digest_feed_str(ret,", ");
    }

    while (gidx+1 < glen) {
	const struct string * groupname =
	    addr_list_get_group(addrs,++gidx);

	digest_feed_string(ret,groupname);
	digest_feed_str(ret,":;");

	last_group = -1;	

	if (gidx+1 < glen) {
	    digest_feed_str(ret,", ");
	}
    }
}

void digest_feed_expires_hdr(ret,hdr_name,expires)
     struct digest_proc      * ret;
     const char              * hdr_name;
     struct expanded_expires * expires;
{
    char timebuf[SLEN] = "";
    int  print_time = get_expanded_expires_print_time(expires);

    if (days_ahead_hdrval(expires,timebuf,sizeof timebuf,
			  print_time)) {
	digest_feed_str(ret,hdr_name);
	digest_feed_str(ret,": ");
	digest_feed_str(ret,timebuf);
	digest_feed_str(ret,"\n");
    }
}

void digest_feed_date_hdr(ret,hdr_name,date_value)
     struct digest_proc      * ret;
     const char              * hdr_name;
     struct expanded_date    * date_value;
{
    char timebuf[SLEN] = "";

    if (date_hdrval(date_value,timebuf,sizeof timebuf, 1 /* print time */)) {
	digest_feed_str(ret,hdr_name);
	digest_feed_str(ret,": ");
	digest_feed_str(ret,timebuf);
	digest_feed_str(ret,"\n");
    }
}
    

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
