static char rcsid[] = "@(#)$Id: write_hdr.c,v 2.17 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.17 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"header");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

#define APPENDRET(buf)  { ret = strmcat(ret,buf); free(buf); buf = NULL; }
#define ADDTEXT(text)   { ret = strmcat(ret,text); }

#define ADDPHRASE(buf1) { char * buffer = string_to_hdr(HDR_PHRASE, buf1, \
  hdr_charset, enmime, NULL,0); APPENDRET(buffer); }

/* Result is is malloced */
char * address_to_str(address,enmime,hdr_charset)
     const struct address *address; 
     int enmime;
     charset_t hdr_charset;
{
    char * ret = NULL;

    const char          * ad          = address_get_ascii_addr(address);
    const struct string * fullname    = address_get_phrase(address);
    const struct string * comment     = address_get_comment(address);

    const int fn = fullname  ? string_len(fullname)  : 0;
    const int cm = comment   ? string_len(comment)   : 0;
    

    if (ad || fullname || comment) {
	if (fn || !ad || ! ad[0] || '@' == ad[0]) {
	    if (fn) {
		ADDPHRASE(fullname);
	    }
	    
	    ADDTEXT(" <");
	    if (ad) {
		ADDTEXT(ad);
	    }
	    ADDTEXT(">");
	} else {
	    ADDTEXT(ad);
	}
	
	if (cm) {
	    char * buffer = string_to_hdr(HDR_COMMENT, comment,
					  hdr_charset, enmime,NULL,0);
	    ADDTEXT(" (");
	    APPENDRET(buffer);
	    ADDTEXT(")");
	}
    }
	
    return ret;
}

/* Result is is malloced */
char * list_to_str(list,enmime,hdr_charset)
     const struct addr_list *list; 
     int enmime;
     charset_t hdr_charset;
{
    
    int  glen = addr_list_group_count(list);
    int len   = addr_list_item_count(list);
    int idx;
    int gidx  = -1;
    int last_group = -1;

    char * ret = NULL;

    for (idx = 0; idx < len; idx++) {

	int group = -1;
	const struct address * address = 
	    addr_list_get_item(list,idx,&group);

	char * addr = address_to_str(address,enmime,hdr_charset);

    next_phrase:
	if (last_group != group &&
	    last_group != -1) {
	    ADDTEXT(";");
	    last_group = -1;	
	}
	
	if (!addr)
	    continue;

	if (idx > 0) {
	    ADDTEXT(", ");
	}

	if (gidx < group &&  
	    group >= 0 && last_group == -1) {
	    
	    /* Print empty groups */
	    
	    const struct string * groupname =
		addr_list_get_group(list,++gidx);
	 
	    ADDPHRASE(groupname);
	    ADDTEXT(":");

	    last_group = gidx;

	    if (gidx < group)
		goto next_phrase;

	    ADDTEXT(" ");
	}

	if (group >= 0 && last_group == -1) {
	    const struct string * groupname =
		addr_list_get_group(list,group); 

	    ADDPHRASE(groupname);
	    ADDTEXT(":");
	    last_group = group;
	}

	APPENDRET(addr);
    }

    if (last_group != -1) {
	ADDTEXT(";");
	last_group = -1;	
    }

    if (gidx+1 < glen && idx > 0) {
	ADDTEXT(", ");
    }

    while (gidx+1 < glen) {
	const struct string * groupname =
	    addr_list_get_group(list,++gidx);
	
	ADDPHRASE(groupname);
	ADDTEXT(":;");
	last_group = -1;

	if (gidx+1 < glen) {
	    ADDTEXT(", ");
	}
    }

    return ret;
}

#undef ADDPHRASE
#undef APPENDRET
#undef ADDTEXT

#define LEN (out_state_ftell(mailer)-POS)
#define WRAP print_EOLN(mailer,top_encoding), \
 (POS = out_state_ftell(mailer)), state_putc(' ',mailer)

#define PUT(c)     {  int c1=(c); state_putc(c1,mailer); \
                      DPRINT(Debug,9, (&Debug,"%c",c1)); }
#define PUTS(s)    {  const char * s1=(s); state_puts(s1,mailer); \
                      DPRINT(Debug,9, (&Debug,"%s",s1)); }

static void print_phrase P_((struct out_state *mailer, const struct string *phrase,
			     int idx, long *posp, enum encoding top_encoding, 
			     int enmime, charset_t hdr_charset));

static void print_phrase(mailer,phrase,idx,posp,top_encoding,enmime,hdr_charset)
     struct out_state *mailer;
     const struct string *phrase;
     int idx;
     long *posp;
     enum encoding top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    long POS = *posp;
    char * c;                    
    char * buffer = string_to_hdr(HDR_PHRASE, phrase,         
				  hdr_charset, enmime, NULL,0); 

    DPRINT(Debug,9, (&Debug,"{phrase quoted=%s}\n", buffer)); 
    DPRINT(Debug,9, (&Debug, "\n          [%d] ",idx));       

    for (c = buffer; *c != '\0'; c++) {                       
	
	if (*c == '\n' || (whitespace(*c) && (LEN > 120))) {    
	    WRAP;                                               
	    DPRINT(Debug,9,(&Debug, "[WRAP]\n          [%d] ", idx)); 
	
	} else {                                                
	    PUT(*c);                                            
	}                                                       
    }
    free(buffer);                                             
    
    *posp = POS;
}

#define PRINT_PHRASE(phrase) print_phrase(mailer,phrase,idx,&POS,\
  top_encoding,enmime,hdr_charset)

void write_addr_header(mailer,hdr_name,addr,top_encoding,enmime,hdr_charset,add_group)
     struct out_state *mailer;
     char *hdr_name;
     struct addr_list * addr;
     enum encoding top_encoding;
     int enmime;
     charset_t hdr_charset;
     int add_group;
{
    long POS = out_state_ftell(mailer);

    int glen = addr_list_group_count(addr);
    int len  = addr_list_item_count(addr);
    int idx;
    int gidx  = -1;
    int last_group = -1;

    if (! add_group && glen > 0) {
	DPRINT(Debug,9,
	       (&Debug, 
		"write_addr_header: add_group is not set. Resetting group count (%d)\n",
		glen));
	glen = 0;
    }
    state_puts(hdr_name,mailer);
    state_puts(": ",mailer);

    DPRINT(Debug,9,
	   (&Debug, "write_addr_header: (enmime=%d) %s: ",
	    enmime,hdr_name));
    
    for (idx = 0; idx < len; idx++) {

	int group = -1;
	const struct address * address = 
	    addr_list_get_item(addr,idx,&group);
	
	const char          * ad          = address_get_ascii_addr(address);
	const struct string * fullname    = address_get_phrase(address);
	const struct string * comment     = address_get_comment(address);

	const int al = ad        ? strlen(ad )          : 0;
	const int fn = fullname  ? string_len(fullname)  : 0;
	const int cm = comment   ? string_len(comment)   : 0;

	DPRINT(Debug,9,
	       (&Debug, "\n          [%d] ",idx));

    next_phrase:
	if (last_group != group &&
	    last_group != -1) {
	    PUT(';');
	    last_group = -1;	
	}
	    
	if (!ad) {
	    continue;
	}

	if (idx > 0) {
	    PUT(',');
	    if (LEN > 70 || al + fn + cm + LEN > 76) {
		WRAP;
		DPRINT(Debug,9,
		       (&Debug,"[WRAP]\n          [%d] ",idx));
	    } else {
		PUT(' ');
	    }
	}
	    
	if (gidx < group &&  
	    group >= 0 && last_group == -1) {

	    /* Print empty groups */

	    const struct string * groupname =
		addr_list_get_group(addr,++gidx);

	    PRINT_PHRASE(groupname);	    
	    PUT(':');
	    last_group = gidx;

	    if (gidx < group)
		goto next_phrase;

	    PUT(' ');
	}

	if (group >= 0 && last_group == -1) {
	    const struct string * groupname =
		addr_list_get_group(addr,group);

	    PRINT_PHRASE(groupname);	    
	    PUTS(": ");
	    last_group = group;
	}

	if (fn || ! ad[0] || '@' == ad[0]) {
	    if (fn) {
		PRINT_PHRASE(fullname);
	    }

	    if (LEN > 120 || (LEN > 70 && fn > 70)) {
		WRAP;
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",idx));
	    } else {
		PUT(' ');

	    }

	    PUT('<');
	    PUTS(ad);
	    PUT('>');
	} else {
	    PUTS(ad);
	}

	if (cm) {
	    char * buffer = string_to_hdr(HDR_COMMENT, comment,
					  hdr_charset, enmime,NULL,0);
	    char * c;
	    
	    if (LEN > 85) {
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",idx));
		WRAP;
	    } else {
		state_putc(' ',mailer);
		DPRINT(Debug,9,
		       (&Debug ," "));
	    }
   
	    DPRINT(Debug,9,
		   (&Debug, "\n          {comment encoded=%s}",buffer));
	    DPRINT(Debug,9,
		   (&Debug, "\n          [%d] ",idx));

	    PUT('(');
	    for (c = buffer; *c != '\0'; c++) {
		if (*c == '\n' || 
		    (whitespace(*c) && (LEN > 100))) {
		    WRAP;
		    DPRINT(Debug,9,
			   (&Debug, "[WRAP]\n          [%d] ",idx));
		} else {
		    PUT(*c);
		}
	    }
	    PUT(')');
	    free(buffer);
	}
    }


    if (last_group != -1) {
	PUT(';');
	last_group = -1;	
    }

    if (gidx+1 < glen && idx > 0) {
	PUT(',');
	if (LEN > 70) {
	    WRAP;
	    DPRINT(Debug,9,
		   (&Debug,"[WRAP]\n          [%d] ",idx));
	} else {
	    PUT(' ');
	}
    }

    while (gidx+1 < glen) {
	const struct string * groupname =
	    addr_list_get_group(addr,++gidx);
	
	
	PRINT_PHRASE(groupname);	    
	PUTS(":;");
	last_group = -1;	

	if (gidx+1 < glen) {
	    PUT(',');
	    if (LEN > 70) {
		WRAP;
		DPRINT(Debug,9,
		       (&Debug,"[WRAP]\n          [%d] ",idx));
	    } else {
		PUT(' ');
	    }
	}
    }

    print_EOLN(mailer,top_encoding);
    DPRINT(Debug,9,
	   (&Debug, "[EOLN]\n"));
}

int check_8bit_str (str)
     const char *str;
{
    const char *s;
    int r = 0;
    
    for (s = str;	*s; s++) {
	if (*s & 0x80) {
	    r = HAVE_8BIT;
	    break;
	}
    }

    DPRINT(Debug,12, (&Debug,"check_8bit_str=%d; str=%Q\n",
		      r,str));
    
    return r;
}

int check_8bit_string(P)
     struct string *P;
{
    int r  = 0;
    
    if (!P)
	return FALSE;
    
    if (!can_ascii_string(P))
	r = HAVE_8BIT;
    
    DPRINT(Debug,12, (&Debug,"check_8bit_strint=%d; string %S\n",
		      r,P));

    return r;
}



static void do_simple_wrapping1 P_((struct out_state *mailer,  long *pos,
				    char *s, enum encoding top_encoding,
				    int lim));
static void do_simple_wrapping1(mailer, pos, s, top_encoding,lim)
     struct out_state *mailer;
     long *pos;
     char *s;
     enum encoding top_encoding;
     int lim;
{
    long POS = *pos;
    char *c;
    char *d;

    for (c = s; *c != '\0'; c=d) {

	if (*c == '\n' || 
	    (whitespace(*c) && (LEN > lim-5))) {
	    WRAP;
	    DPRINT(Debug,9,(&Debug,"[WRAP]\n          "));
	  
	    c++;
	    d = c;
	} else if (whitespace(*c)) {
	    int len;
	    char *e;

	    for (d = c+1; '\0' != *d; d++) {
		if (*d == '\n' || whitespace(*d))
		    break;
	    }

	    len = d-c;
	   
	    if (len + LEN > lim-2 && LEN > 0) {
		WRAP;
		DPRINT(Debug,9,(&Debug,"[WRAP > %d]\n          ",lim-2));

		/* replace space with folding */
		c++;
	    }

	    for (e = c; e < d; e++) {
		state_putc(*e,mailer);
		DPRINT(Debug,9,(&Debug,"%c",*e));
	    }


	} else {

	    state_putc(*c,mailer);
	    DPRINT(Debug,9,(&Debug,"%c",*c));

	    c++;
	    d = c;
	}
    }

    *pos = POS;
}

static void do_simple_wrapping P_((struct out_state *mailer,  long *pos,
				   char *s, enum encoding  top_encoding));
static void do_simple_wrapping(mailer, pos, s, top_encoding)
     struct out_state *mailer;
     long *pos;
     char *s;
     enum encoding top_encoding;
{
    do_simple_wrapping1(mailer,pos,s,top_encoding,79);
}

void write_string_header (mailer,hdr_name,P, top_encoding, enmime, hdr_charset)
     struct out_state *mailer;
     const char *hdr_name; 
     struct string * P;
     enum encoding top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    long POS = out_state_ftell(mailer);

    int X = 0;

    uint16 was_delim = 0;
	    
    state_puts(hdr_name,mailer);
    state_puts(": ",mailer);

    DPRINT(Debug,9, (&Debug, "write_string_header: (enmime=%d) %s: \n",
		     enmime,hdr_name));

    DPRINT(Debug,9, (&Debug, "write_string_header: %s: ",hdr_name));
   
    while (string_len(P) > X) {
	int x = X;

	if (x > 0) {
	    WRAP;
	    DPRINT(Debug,9,(&Debug,
			    "[WRAP]\n          "));
	}

	if (long_encoded_headers) {
	    int slen = LEN;
	    struct string * temp = NULL;
	    char *s;
	    int was_encoded = 0;
	    int do_ascii_prefix = 1;

	    while (string_len(P) > X) {
		int new_x = X;
	    
		struct string *word = NULL;
		int len1;
		uint16 delim = 0;

		len1 = get_word_from_string(P,&word,&new_x,0,s2us(" "),&delim);
		if (len1 < 1) {
		    /* This handles case where there is no conversion
		       to unicode available
		    */
		    
		    DPRINT(Debug,9, (&Debug, " <<failure: pos %d>>",new_x));
		    
		    free_string(&word);
		    break;
		}
	    
		if (slen + len1 > 70) {
		    free_string(&word);
		    break;
		}
		
		/* Caching delim causes effectively that
		   it is not stored on encoded -> non-encoded
		   transition -- that avoid double space after
		   decoding
		*/


		if (was_delim) {
		    const charset_t P_cs     = get_string_type(P);
		    if (!temp)
			temp = new_string(P_cs);

		    add_unicode_to_string(temp,1,&was_delim);		
		    was_delim = 0;
		}

		append_string(&temp,word,0);

		free_string(&word);

		slen += len1;   /* Includes delim */
		
		was_delim = delim;

		X = new_x;
	    }

	    if (!temp) {
		X = x;
		goto failure;
	    }

	    s = string_to_hdr(HDR_TEXT,temp,
			      hdr_charset,enmime,&was_encoded,
			      do_ascii_prefix);
	    DPRINT(Debug,9, (&Debug,"{text encoded=%s}\n",s));
	    DPRINT(Debug,9, (&Debug,"\n          [%d..%d] ",x,X));
	    

	    /* Hack -- remove extra space (if not encoded) also from raw output */

	    if (' ' == *s)
		do_simple_wrapping1(mailer,&POS,s+1,top_encoding,900);
	    else
		do_simple_wrapping1(mailer,&POS,s,top_encoding,900);

	    /* Remove extra space if just not encoded result */
	    if (!was_encoded)
		was_delim = 0;
	    
	    do_ascii_prefix = !was_encoded;

	    free(s);
	    free_string(&temp);	    

	} else {
	    struct string * temp;
	    char * s;

	failure:
	    temp = clip_from_string(P,&X,900);
	    s = string_to_hdr(HDR_TEXT,temp,
			      hdr_charset,enmime,NULL,1);
	    DPRINT(Debug,9, (&Debug,"{text encoded=%s}\n",s));
	    DPRINT(Debug,9, (&Debug,"\n          [%d..%d] ",x,X));
	    
	    do_simple_wrapping(mailer,&POS,s, top_encoding);
	    
	    free(s);
	    free_string(&temp);
	}
    }
    print_EOLN(mailer,top_encoding);    
    DPRINT(Debug,9, (&Debug,"[EOLN]\n"));
}

void write_text_header (mailer,hdr_name,text, top_encoding)
     struct out_state *mailer;
     const char *hdr_name; 
     const char * text;
     enum encoding top_encoding;
{
    long POS = out_state_ftell(mailer);
    const char *c;

    state_puts(hdr_name,mailer);
    state_puts(": ",mailer);

    DPRINT(Debug,9,
	   (&Debug,"write_text_header: %s: ",hdr_name));
    
    for (c = text; *c != '\0'; c++) {
	if (*c == '\n' || 
	    (whitespace(*c) && (LEN > 75))) {
	    WRAP;
	    DPRINT(Debug,9,
		   (&Debug,"[WRAP]\n          "));
	} else {
	    state_putc(*c,mailer);
	    DPRINT(Debug,9,
		   (&Debug,"%c",*c));
	}
    }
    print_EOLN(mailer,top_encoding);    
    DPRINT(Debug,9,
	   (&Debug,"[EOLN]\n"));
}

void write_expires_header(mailer,hdr_name,expires,top_encoding)
     struct out_state        * mailer;
     const char              * hdr_name;
     struct expanded_expires * expires;
     enum encoding             top_encoding;
{
    char timebuf[SLEN] = "";
    enum print_time  print_time = get_expanded_expires_print_time(expires);
	
    if (days_ahead_hdrval(expires,timebuf,sizeof timebuf,
			  print_time)) {

	write_text_header(mailer,hdr_name,timebuf,top_encoding);
    }   
}

void write_date_header(mailer,hdr_name,date_value,top_encoding)
     struct out_state        * mailer;
     const char              * hdr_name;
     struct expanded_date    * date_value;
     enum encoding             top_encoding;
{
    char timebuf[SLEN] = "";
	
    if (date_hdrval(date_value,timebuf,sizeof timebuf,
		    print_date_and_time /* print_time */)) {

	write_text_header(mailer,hdr_name,timebuf,top_encoding);
    }   
}



void print_EOLN(mailer,top_encoding) 
     struct out_state *mailer;
     enum encoding top_encoding;
{  
    /* Write canonocal end of line if we are sending binary mail 
     * Also SMTP requires \r\n
     */
    if (top_encoding == ENCODING_BINARY || 
	out_state_EOLN_is_CRLF(mailer))
	state_putc('\r',mailer);
    state_putc('\n',mailer);
}

static void write_id_part P_((struct out_state        * mailer,
			      long                    * pos_p,
			      enum encoding             top_encoding,
			      int                       enmime,
			      charset_t                 hdr_charset,
			      const struct message_id * id,
			      int extra,
			      int idx));
static void write_id_part(mailer,pos_p,top_encoding,enmime,hdr_charset,id,extra,idx)
     struct out_state        * mailer;
     long                    * pos_p;
     enum encoding             top_encoding;
     int                       enmime;
     charset_t                 hdr_charset;
     const struct message_id * id;
     int extra;
     int idx;
{
    long POS = * pos_p;

    const char * left                = message_id_left(id);
    const char * domain              = message_id_domain(id);
    const struct string * id_comment = message_id_comment(id);
    
    int len1 = 3 + extra;
    
    if (left)
	len1 += strlen(left);
    if (domain)
	len1 += strlen(domain);
    if (id_comment)
	len1 += string_len(id_comment) +3;
    
    if ((LEN + len1 > 70) && idx > 0) {
	if (idx >= 0) {
	    DPRINT(Debug,9,(&Debug, "[WRAP]\n          [%d] ", idx)); 	    
	} else {
	    DPRINT(Debug,9,(&Debug, "[WRAP]\n          "));
	}
	WRAP;
    } else {
	state_putc(' ',mailer);
	DPRINT(Debug,9,
	       (&Debug ," "));
    }
    
    PUT('<');
    
    if (left) {
	PUTS(left);
    }
    
    if (domain) {
	PUT('@');
	PUTS(domain);
    }
    
    PUT('>');
    
    if (id_comment) {
	char * buffer = string_to_hdr(HDR_COMMENT, id_comment,
				      hdr_charset, enmime,NULL,
				      0);
	char *c;
	
	if (LEN > 85) {
	    DPRINT(Debug,9,
		   (&Debug, "[WRAP]\n          "));
	    WRAP;
	} else {
	    state_putc(' ',mailer);
	    DPRINT(Debug,9,
		   (&Debug ," "));
	}
	
	DPRINT(Debug,9,
	       (&Debug, "\n          {comment encoded=%s}",buffer));
	DPRINT(Debug,9,
	       (&Debug, "\n          "));
	
	PUT('(');
	for (c = buffer; *c != '\0'; c++) {
	    if (*c == '\n' || 
		(whitespace(*c) && (LEN > 100))) {
		WRAP;
		if (idx >= 0) {
		    DPRINT(Debug,9,(&Debug, "[WRAP]\n          [%d] ", idx)); 	    
		} else {
		    DPRINT(Debug,9,(&Debug, "[WRAP]\n           "));
		}
	    } else {
		PUT(*c);
	    }
	}
	PUT(')');
	free(buffer);		
    }
    
    * pos_p = POS;
}
			      
void write_references_header (mailer,hdr_name,ids, top_encoding, enmime, 
			     hdr_charset)
     struct out_state *mailer;
     const char *hdr_name; 
     struct references * ids;
     enum encoding top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    int idx;
    int count;
    
    long POS = out_state_ftell(mailer);
    
    state_puts(hdr_name,mailer);
    state_puts(":",mailer);
    
    DPRINT(Debug,9,(&Debug,
		    "write_references_header: (enmime=%d) %s:",
		    enmime,hdr_name));
    
    count = references_item_count(ids);
    
    for (idx = 0; idx < count; idx++) {
	
	/* message_id also includes comment */
	const struct message_id * id = references_get_message_id(ids,idx);
	const struct string * phrase = references_get_phrase(ids,idx);
	const struct string * tail_comment = references_get_comment(ids,idx);
	
	DPRINT(Debug,9,
	       (&Debug, "\n          [%d] ",idx));

	if (id) {
	    int extra = 0;
	    
	    if (phrase)
		extra += string_len(phrase) +1;
	    if (tail_comment)
		extra += string_len(tail_comment) +3;

	    write_id_part(mailer,&POS,top_encoding,enmime,hdr_charset,id,extra,idx);	    
	}

	if (phrase) {

	    int len1 = 3;

	    if (phrase)
		len1 += string_len(phrase) +1;
	    if (tail_comment)
		len1 += string_len(tail_comment) +3;


	    if (LEN + len1 > 77) {
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",idx));
		WRAP;
	    } else {
		state_putc(' ',mailer);
		DPRINT(Debug,9,
		       (&Debug ," "));
	    }

	    PRINT_PHRASE(phrase);
	}

	if (tail_comment) {
	    char * buffer = string_to_hdr(HDR_COMMENT, tail_comment,
					  hdr_charset, enmime,NULL,0);
	    char *c;
	    
	    if (LEN > 85) {
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",idx));
		WRAP;
	    } else {
		state_putc(' ',mailer);
		DPRINT(Debug,9,
		       (&Debug ," "));
	    }
	    
	    DPRINT(Debug,9,
		   (&Debug, "\n          {comment encoded=%s}",buffer));
	    DPRINT(Debug,9,
		   (&Debug, "\n          [%d] ",idx));
	    
	    PUT('(');
	    for (c = buffer; *c != '\0'; c++) {
		if (*c == '\n' || 
		    (whitespace(*c) && (LEN > 100))) {
		    WRAP;
		    DPRINT(Debug,9,
			   (&Debug, "[WRAP]\n          [%d] ",idx));
		} else {
		    PUT(*c);
		}
	    }
	    PUT(')');
	    free(buffer);		
	}
	
    }

    print_EOLN(mailer,top_encoding);    
    DPRINT(Debug,9,(&Debug,"[EOLN]\n"));
}

void write_msgid_header (mailer,hdr_name,id,top_encoding, enmime, 
			 hdr_charset)
     struct out_state *mailer;
     const char *hdr_name; 
     struct message_id * id;
     enum encoding top_encoding;
     int enmime;
     charset_t hdr_charset;
{     
    long POS = out_state_ftell(mailer);

    state_puts(hdr_name,mailer);
    state_puts(":",mailer);
    
    DPRINT(Debug,9,(&Debug,"write_msgid_header: (enmime=%d) %s:",
		    enmime,hdr_name));

    write_id_part(mailer,&POS,top_encoding,enmime,hdr_charset,id,0,-1);	    

    print_EOLN(mailer,top_encoding);    
    DPRINT(Debug,9,(&Debug,"[EOLN]\n"));
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
