static char rcsid[] = "@(#)$Id: can_open.c,v 2.5 2020/05/17 06:02:35 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/can_open.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** can_open - can this user open this file using their normal uid/gid

**/

#include "elm_defs.h"
#include <errno.h>
#ifndef ANSI_C
extern int errno;		/* system error number */
#endif

DEBUG_VAR(Debug,__FILE__,"file");

#ifndef I_UNISTD
void _exit();
#endif



int can_open(file, mode)
     const char *file, *mode;
{
	/** Returns 0 iff user can open the file.  This is not
	    the same as access - it's used for when the file might
	    not exist... **/

	FILE *fd;
	int ret = 0, pid, w, sig;
	volatile int preexisted = 0;
	S__ status;

	if (userid == -1 || groupid == -1) {

	    DPRINT(Debug,1,(&Debug, 
			    "can_open(%s,%s): userid = %d groupid = %d\n",
			    file,mode,userid,groupid));


	    ret = 1;
	    goto out;
	}
	
#ifdef VFORK
	if ((pid = vfork()) == 0) {
#else
	if ((pid = fork()) == 0) {
#endif
	  if (-1 == setgid(groupid)) {
	    int err = errno;
	    fprintf(stderr,"can_open: setgid(%d) FAILED: %s\n",
		    groupid,strerror(err));
	    fflush(stderr);
	    _exit(err != 0? err : 1);	/* never return zero! */
	  }
	  if (-1 == setuid(userid)) {		/** back to normal userid **/
	    int err = errno;
	    fprintf(stderr,"can_open: setuid(%d) FAILED: %s\n",
		    userid,strerror(err));
	    fflush(stderr);
	    _exit(err != 0? err : 1);	/* never return zero! */
	  }
	  errno = 0;
	  if (mode[0] == 's' && mode[1] == 'w' && ! mode[2]) {
	      int filedes = open(file, O_WRONLY | O_CREAT | O_EXCL, 0600);
	      if (filedes < 0 &&
		  (unlink(file) ||
		   (filedes = open(file, O_WRONLY|O_CREAT|O_EXCL, 0600)) < 0))
		  _exit(errno);
	      else {
		  close(filedes);
		  _exit(0);
	      }
	  }
	  if (access(file, ACCESS_EXISTS) == 0)
	    preexisted = 1;
	  if ((fd = fopen(file, mode)) == NULL)
	    _exit(errno != 0 ? errno : 1);
	  else {
	    fclose(fd);		/* don't just leave it open! */
	    if(!preexisted)	/* don't leave it if this test created it! */
	      unlink(file);
	    _exit(0);
	  }
	  _exit(127);

	} else if (-1 == pid) {
	    int err = errno;

	    DPRINT(Debug,1,(&Debug, 
			    "can_open(%s,%s): fork failed\n",file,mode));

	    ret = err != 0? err : 1;
	    goto out;
	}

	

	errno = 0;
	while ((w = my_wait(pid,&status)) != pid && 
	       (w != -1 || EINTR == errno))
	  ;

	sig = convert_status(status,&ret);
	if (sig)
	    ret = 1;

	out:
	DPRINT(Debug,(0 == ret) ? 10 : 1,
	       (&Debug, 
		"can_open(%s,%s) = %d%s\n",
		file,mode,ret,
		ret ? " FAIL" : " OK"));
	return(ret);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
