static char rcsid[] = "@(#)$Id: conf_writer.c,v 2.8 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "conf_writer_imp.h"

DEBUG_VAR(Debug,__FILE__,"config");

struct config_files * cfiles = NULL;
int                   cfiles_num = 0;

void register_conf_write(shortname,fname,dump_map,write_message,
			 rewrite_flag,merge_map)
     char * shortname;
     char *fname;
     dump_conf_map_f * dump_map;
     dump_message_f  * write_message;
     int             * rewrite_flag;
     merge_conf_map_f * merge_map;
{
    cfiles = safe_array_realloc(cfiles, 
				(cfiles_num+1),
				sizeof(cfiles[0]));

    cfiles[cfiles_num].shortname     = shortname;
    cfiles[cfiles_num].fname         = fname;
    cfiles[cfiles_num].dump_map      = dump_map;
    cfiles[cfiles_num].write_message = write_message;
    cfiles[cfiles_num].rewrite_flag  = rewrite_flag;
    cfiles[cfiles_num].merge_map     = merge_map;
    cfiles_num++;
};

int NO_merge_conf_map(fname,f)
     const char  * fname;
     FILE        * f;
{
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

