static char rcsid[] = "@(#)$Id: len_next.c,v 2.4 2014/07/14 15:07:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/len_next.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1992 USENET Community Trust
 *****************************************************************************/

/** get the length of the next part of the address/data field

	This code returns the length of the next part of the
  string field containing address/data.  It takes into account
  quoting via " as well as \ escapes.
  Quoting via ' is not taken into account, as RFC-822 does not
  consider a ' character a valid 'quoting character'

  A 1 is returned for a single character unless:

  A 0 is returned at end of string.

  A 2 is returned for strings that start \

  The length of quoted sections is returned for quoted fields

**/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"core");

int len_next_part(str)
     const char *str;
{
	const char *s;

	switch (*str) {

	case '\0':
		return 0;

	case '\\':
		return (*++str != '\0' ? 2 : 1);

	case '"':
		for (s = str+1 ; *s != '\0' ; ++s) {
			if (*s == '\\') {
				if (*++s == '\0')
					break;
			} else if (*s == '"') {
				++s;
				break;
			}
		}
		return (s - str);

	default:
		return 1;

	}

	/*NOTREACHED*/
}

#ifdef _TEST
#include <stdio.h>
main()
{
	char buf[256], *s;
	int len;

	while (gets(buf) != NULL) {
		for (s = buf ; (len = len_next_part(s)) > 0 ; s += len)
			printf("%4d %-.*s\n", len, len, s);
	}
	exit(0);
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
