static char rcsid[] = "@(#)$Id: feed_common.c,v 2.2 2020/11/15 16:02:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mailer.h"

DEBUG_VAR(Debug,__FILE__,"header");

/* NOTE: write_common_mailing_headers() must have same headers */


void  feed_common_mailing_headers(ret,headers,encode_hdr,cs)
     struct digest_proc            * ret;
     struct mailing_headers        * headers;
     int                             encode_hdr;
     charset_t                       cs;
{
    const char *MIME_name_h = NULL;
	
    
    DPRINT(Debug,12,(&Debug,
		     "feed_common_mailing_headers: encode_hdr=%d cs=%p",encode_hdr,cs));
    
    MIME_name_h = 
	get_charset_MIME_name(cs);
    if (MIME_name_h) {
	DPRINT(Debug,12,(&Debug," %s",MIME_name_h));
    }
    DPRINT(Debug,12,(&Debug,"\n"));

    if (headers->subject) {
	digest_feed_str(ret,"Subject: ");
	digest_feed_string(ret,headers->subject);
	digest_feed_str(ret,"\n");
    } else {
	digest_feed_str(ret,"Subject: ");
	digest_feed_str(ret,"\n");	
    }

    {	
	/* Our standard violations */
	char OSV[100];
	OSV[0] = '\0';
	
	if (!encode_hdr && MIME_name_h)
	    add_parameter(OSV,"hdr-charset",
			  MIME_name_h,sizeof(OSV),FALSE);
	
	/* If allow_no_hdrencoding is set, there is no mime-encoding on
	   user headers either
	*/
	if (allow_no_hdrencoding) {
	    add_parameter(OSV,"no-hdr-encoding","1",sizeof(OSV),FALSE);	    
	}
	
	if (OSV[0]) {
	    digest_feed_str(ret,"X-ELM-OSV: (Our standard violations) ");
	    digest_feed_str(ret,OSV);
	    digest_feed_str(ret,"\n");	
	}
    }
    
    if (headers->sender) {
	digest_feed_str(ret,"Sender: ");
	digest_feed_str(ret,headers->sender);
	digest_feed_str(ret,"\n");	
    }
    
    
    if (headers->from.addrs) {
	digest_feed_str(ret,"From: ");
	digest_feed_addrs(ret,headers->from.addrs,0);
	digest_feed_str(ret,"\n");
    }

    if (!headers->date) {
	time_t now = 0;
	
	if (((time_t) -1) != time(&now)) {
	    
	    DPRINT(Debug,12,(&Debug,
			     "feed_common_mailing_headers: Date: not given, generating it, now=%ld\n",
			     (long)now));
	    headers->date =  new_expanded_date(NULL,now,
					       date_automatic /* automatically gnerated */);
	} else {
	    int err UNUSED_VAROK = errno;
	    
	    DPRINT(Debug,12,(&Debug,
			     "feed_common_mailing_headers: Date: not given, time: %s\n",
			     strerror(err)));
	}
    }

    if (headers->date) {
	digest_feed_date_hdr(ret,"Date",headers->date);
    }

    if (headers->to.addrs) {
	digest_feed_str(ret,"To: ");
	digest_feed_addrs(ret,headers->to.addrs,1);
	digest_feed_str(ret,"\n");
    }

    if (headers->reply_to.addrs) {
	digest_feed_str(ret,"Reply-To: ");
	digest_feed_addrs(ret,headers->reply_to.addrs,1);
	digest_feed_str(ret,"\n");
    }

    if (headers->cc.addrs) {
	digest_feed_str(ret,"CC: ");
	digest_feed_addrs(ret,headers->cc.addrs,1);
	digest_feed_str(ret,"\n");
    }

    /* If there is no To or CC recipients,
       BCC recipent are included to mail 
    */
    if (!headers->to.addrs && !headers->cc.addrs && headers->bcc.addrs) {
	digest_feed_str(ret,"Bcc: ");
	digest_feed_addrs(ret,headers->bcc.addrs,1);
	digest_feed_str(ret,"\n");
    }

    if (headers->in_reply_to) {
	digest_feed_str(ret,"In-Reply-To: ");
	digest_feed_references(ret,headers->in_reply_to);  
	digest_feed_str(ret,"\n");
    }

    if (headers->references) {
	digest_feed_str(ret,"References: ");
	digest_feed_references(ret,headers->references);
	digest_feed_str(ret,"\n");
    }

    /* Message-ID is not included to result, because result
       is used for Message-ID generation
    */

    if (headers->action) {
	digest_feed_str(ret,"Action: ");
	digest_feed_str(ret,headers->action);
	digest_feed_str(ret,"\n");
    }

    if (headers->priority) {
	digest_feed_str(ret,"Priority: ");
	digest_feed_str(ret,headers->priority);
	digest_feed_str(ret,"\n");
    }

    if (headers->precedence) {
	digest_feed_str(ret,"Precedence: ");
	digest_feed_str(ret,headers->precedence);
	digest_feed_str(ret,"\n");
    }

    if (headers->expires) {
	digest_feed_expires_hdr(ret,"Expires", headers->expires);
    }

    if (headers->xmailer) {
	digest_feed_str(ret,"X-Mailer: ");
	digest_feed_string(ret,headers->xmailer);
	digest_feed_str(ret,"\n");
    
    }

    if (headers->encoded_user_agent) {
	digest_feed_str(ret,"User-Agent: ");
	digest_feed_str(ret,headers->encoded_user_agent);
	digest_feed_str(ret,"\n");
    }
    
    if (headers->user_header_count > 0) {
	int i;
	for (i = 0; i <  headers->user_header_count; i++) {
	    digest_feed_str(ret,give_header_name(headers->user_header[i].
						 name));
	    digest_feed_string(ret,headers->user_header[i].value);
	    digest_feed_str(ret,"\n");
	}
    }

}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
