static char rcsid[] = "@(#)$Id: mbox_generic.c,v 2.11 2024/06/23 07:38:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"file");

/* Returns 1 if changed,
   -1 error
 */
int browser_reset_filter_generic(dir)
     struct folder_browser *dir;     
{  
    int ret = -1;
    
    struct string * buffer = NULL;
    
    buffer = dir->type->browser_cat_it(dir,NULL);
    
    if (!buffer) {
	
	DPRINT(Debug,12,(&Debug,
			 "browser_reset_filter_generic: Failed to generate current directory\n"));
	
	ret = -1;
	goto FAIL;
    }

    DPRINT(Debug,12,(&Debug,
		     "browser_reset_filter_generic: directory=%S\n",buffer));
    
    free_string(&(dir->filter));
    clear_dir_vector(dir);

    
    if (!change_dir_helper(dir,&buffer)) {
	DPRINT(Debug,12,(&Debug,
			 "browser_reset_filter_generic: Failed to change directory to %S\n",
			 buffer));
	ret = -1;
	goto FAIL;
    }

    ret = 1;

 FAIL:

    if (buffer)
	free_string(&buffer);

    DPRINT(Debug,11,(&Debug,"browser_reset_filter_generic=%d\n", ret));

    return ret;
}


/* This can change type of dir */
int browser_select_idx_generic(dir,entry,buffer) 
     struct folder_browser *dir;
     struct name_vector *entry;
     struct string **buffer;
{
    int ret = 0;

    struct string *name = dir->type->browser_cat_it(dir,entry->disp_name);

    if (!name)
	goto FAIL;

    if (*buffer)
	free_string(buffer);

    *buffer = name;

    ret = select_dir_item_helper(dir,buffer,NULL);

 FAIL:

    DPRINT(Debug,11,(&Debug,"browser_select_idx_generic=%d\n", ret));

    return ret;
}

/* Increments refcount */
E_(browser_gethm_name_vector_dir browser_gethm_name_vector_null)
struct hashmark_item * browser_gethm_name_vector_null(dir,entry)
     struct folder_browser * dir;
     struct name_vector    * entry;
{
    /* Entry do not have hashmark */

    DPRINT(Debug,11,(&Debug,"browser_gethm_name_vector_null=NULL\n"));
    
    return NULL;
}

E_(browser_sethm_name_vector_dir browser_sethm_name_vector_null)
int browser_sethm_name_vector_null(dir,entry,hm)
     struct folder_browser * dir;
     struct name_vector    * entry;
     struct hashmark_item  * hm;
{
    /* Entry do not have hashmark */


    DPRINT(Debug,11,(&Debug,"browser_sethm_name_vector_null=0\n"));
    return 0;
}

E_(mbx_comp_prev_hdr_folder mbx_comp_prev_hdr_default)
enum comp_prev_hdr_result mbx_comp_prev_hdr_default(folder,entry,prev_entry,
						    reconnect_mode_ptr)
     struct folder_info * folder;
     struct header_rec  * entry;
     struct header_rec  * prev_entry;
     RECONNECT_MODE    reconnect_mode_ptr;
{
     DPRINT(Debug,12,(&Debug,"mbx_comp_prev_hdr_default=comp_prev_hdr_pass\n"));

     return comp_prev_hdr_pass;
}

E_(mbx_update_prev_hdr_folder mbx_update_prev_hdr_default)
void mbx_update_prev_hdr_default(folder,entry,prev_entry,
				 reconnect_mode_ptr,
				 read_state_ptr)
     struct folder_info * folder;
     struct header_rec  * entry;
     struct header_rec  * prev_entry;
     RECONNECT_MODE    reconnect_mode_ptr;
     READ_STATE        read_state_ptr;
{
    DPRINT(Debug,12,(&Debug,"mbx_update_prev_hdr_default\n"));
}


E_(mbx_have_folder_quota  mbx_have_default_quota)
struct mail_quota * mbx_have_default_quota(folder)
     struct folder_info * folder;
{
    DPRINT(Debug,12,(&Debug,"mbx_have_default_quota=NULL\n"));

    return NULL;
}

E_(mbx_give_folder_quotar_list mbx_give_default_quotar_list)
struct mail_quotaroot_list * mbx_give_default_quotar_list(folder,mq,cd,refresh)
     struct folder_info * folder;
     struct mail_quota   * mq; 
     struct cancel_data  * cd /* Allow cancelation (Ctrl-C) on remote mailbox */;
     enum quota_mode      refresh;
{
    DPRINT(Debug,12,(&Debug,"mbx_give_default_quotar_list=NULL\n"));

    return NULL;
}

E_(mbx_give_message_msize_folder  mbx_give_message_msize_default)
int mbx_give_message_msize_default(folder,entry,ret_size)
     struct folder_info * folder;
     struct header_rec  * entry;
     unsigned long      * ret_size;
{
    DPRINT(Debug,12,(&Debug,
		     "mbx_give_message_msize_default=0 (dummy): folder=%p (%s)\n",
		     folder,folder->cur_folder_sys));

    return 0;
}

E_(mbx_give_message_count_folder mbx_give_message_count_default)
/* Return -1 if not available (local mail) */
int mbx_give_message_count_default(folder)
     struct folder_info * folder;
{
    DPRINT(Debug,12,(&Debug,
		     "mbx_give_message_count_default=-1 (dummy): folder=%p (%s)\n",
		     folder,folder->cur_folder_sys));

    return -1;
}

int sessionlock_create_tempfolder(folder,errcode)
     struct folder_info *folder;
     int *errcode /* errno */;
{
    int ret = 0;
    int temp_handle = -1;
    
    if (PRIVATE_DATA_magic != folder->p->magic) 
	panic("MBX PANIC",__FILE__,__LINE__,"sessionlock_create_tempfolder",
	      "Bad magic number (private_data)",0);

    if (errcode)
	*errcode = 0;
    
    if (! folder-> cur_tempfolder[0]) {
	DPRINT(Debug,12,(&Debug,
			 "sessionlock_create_tempfolder: cur_tempfolder not set\n"));
	goto fail;
    }
    
    temp_handle = open(folder-> cur_tempfolder, 
		       O_RDWR|O_CREAT|O_EXCL,
		       0600);

    if (-1 == temp_handle) {
	int err = errno;

	DPRINT(Debug,12,(&Debug,
			 "sessionlock_create_tempfolder: Creating of %s failed: %s (errno=%d)\n",
			 folder-> cur_tempfolder,
			 strerror(err),
			 err));
	
	if (errcode)
	    *errcode = err;

	if (folder -> p->fh_temp &&
	    EEXIST == err) {

	    DPRINT(Debug,12,(&Debug,
			     "sessionlock_create_tempfolder: assuming fh_temp already opended\n"));
	    ret = 1;
	}
	
	goto fail;
    }

    if (folder -> p->fh_temp) {
	int r;
	
	DPRINT(Debug,12,(&Debug,
			 "sessionlock_create_tempfolder: Closing previous fh_temp"));
	r = fclose(folder -> p->fh_temp);
	if (0 == r) {
	    DPRINT(Debug,12,(&Debug," (succeed)"));
	} else if (EOF == r) {
	    int err = errno;
	    DPRINT(Debug,12,(&Debug,": %s (errno=%d)",
			     strerror(err),err));
	}
	DPRINT(Debug,12,(&Debug,"\n"));
    }
    
    folder -> p->fh_temp = fdopen(temp_handle,"w+");
    if (folder -> p->fh_temp) {
	DPRINT(Debug,12,(&Debug,
			 "sessionlock_create_tempfolder: %s created\n",
			 folder-> cur_tempfolder));
	ret = 1;
    } else {
	int err = errno;

	DPRINT(Debug,12,(&Debug,
			 "sessionlock_create_tempfolder: failed to open fh_temp (temp_handle=%d): %s (errno=%d)\n",
			 temp_handle,
			 strerror(err),
			 err));

	if (errcode)
	    *errcode = err;
    }
    
 fail:
    if (!ret && -1 != temp_handle) {
	int r;
	close(temp_handle);

	r = unlink(folder -> cur_tempfolder);
	if (0 == r) {
	    DPRINT(Debug,12,(&Debug,
			     "sessionlock_create_tempfolder: %s unlinked\n",
			     folder -> cur_tempfolder));
	} else if (-1 == r) {
	    int err = errno;

	    DPRINT(Debug,12,(&Debug,
			     "sessionlock_create_tempfolder: Unlinking of %s failed: %s (errno=%d)\n",
			     folder-> cur_tempfolder,
			     strerror(err),
			     err));
	}
    }
	
    
    DPRINT(Debug,12,(&Debug,
		     "sessionlock_create_tempfolder=%d",
		     ret));
    if (errcode && *errcode) {
	DPRINT(Debug,12,(&Debug,"; *errcode=%d (%s)",
			 *errcode,strerror(*errcode)));
    }
    DPRINT(Debug,12,(&Debug,"\n"));
    
    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
