static char rcsid[] = "@(#)$Id: commentfile.c,v 2.3 2024/06/10 18:05:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_misc.h"
#include "s_me.h"

/* extra prototype */
#include "commentfile.h"

DEBUG_VAR(Debug,__FILE__,"config");

void insert_commentfile(f,defaultfile,commentfile,actor,version_buff)
     FILE *f; 
     const char *defaultfile;
     FILE *commentfile; 
     const char *actor;
     char *version_buff;
{
    int close_comment_file = 0;

    if (!commentfile) {
	commentfile = fopen(defaultfile,"r");   
	if (!commentfile) {
	    int err = errno;
	    
	    lib_error(CATGETS(elm_msg_cat, MeSet, 
			      MeSavingWithoutComments,
			      "Warning: saving without comments! Can't get to %s: %s"),
		      defaultfile,
		      strerror(err));
	} else 
	    close_comment_file++;
    }

    if (actor && version_buff) {
	elm_fprintf(f, 
		    CATGETS(elm_msg_cat, MeSet, MeSavedAutoWrite1,
			    "# Saved automatically by %s %s\n#\n\n"), 
		    actor,version_buff);
    } else {
	elm_fprintf(f, 
		    CATGETS(elm_msg_cat, MeSet, MeSavedAutoWrite2,
			    "# Saved automatically\n#\n\n"));

    }
	
    if (commentfile) {
	char line_buffer[SLEN];
	int len;

	while (0  < (len = 
		     mail_gets(line_buffer, sizeof line_buffer, 
			       commentfile))) {

	    if (line_buffer[len-1] != '\n') {
		DPRINT(Debug,1,(&Debug, 
				"insert_commentfile: Too long line (read len=%d): %s\n",
				len,line_buffer));
		break;
	    }
	    line_buffer[--len] = '\0';
	    if (0 == len)
		continue;

	    /* Only copies initial comment */
	    if ('#' == line_buffer[0] || whitespace(line_buffer[0])) {		
		fprintf(f,"%s\n",line_buffer);
	    } else
		break;
	}

	fprintf(f,"\n");
    }

    if (close_comment_file)
	fclose(commentfile);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
