static char rcsid[] = "@(#)$Id: iso2022.c,v 2.2 2016/03/21 20:26:14 hurtta Exp $";

/**************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 **************************************************************************/

#include "def_misc.h"
#include "s_me.h"
#include "cs_imp.h"

DEBUG_VAR(Debug,__FILE__,"charset");

void change_iso2022_map(conf,new,mode)
     struct iso2022_map_conf **conf;
     struct iso2022_map_conf *new;
     enum map_list_mode mode;
{
    int idx;
    int count;
    int new_max = 0;

    if (!*conf)
	*conf = malloc_iso2022_map_conf();	
    else if (ISO2022_MAP_CONF_magic != (*conf)->magic)
	panic("ISO2022 PANIC",__FILE__,__LINE__,
	      "change_iso2022_map",
	      "Bad magic number (conf, iso2022_map_conf)",0);

    if (!new)
	return;

    if (ISO2022_MAP_CONF_magic != new->magic)
	panic("ISO2022 PANIC",__FILE__,__LINE__,
	      "change_iso2022_map",
	      "Bad magic number (new, iso2022_map_conf)",0);

    if (new->iso2022_maps_count < 1)
	return;

    count = (*conf)->iso2022_maps_count + new->iso2022_maps_count;
	
    (*conf)->iso2022_maps_list = 
	safe_array_realloc((*conf)->iso2022_maps_list,
			   count, sizeof((*conf)->iso2022_maps_list[0]));

    if (ml_none != mode)
	new_max = realloc_iso2022_map_list(new->iso2022_maps_count);

    for (idx = 0; idx < new->iso2022_maps_count; idx++) {
	int idx_conf;
	
	/* 1) Update (*conf) */

	for (idx_conf = 0; idx_conf < (*conf)->iso2022_maps_count; idx++) {

	    if (same_setid(new->iso2022_maps_list[idx].ID,
			   (*conf)->iso2022_maps_list[idx_conf].ID))
		goto set_idx_conf;
	}

	if (idx_conf >= count)
	    panic("ISO2022 PANIC",__FILE__,__LINE__,
		  "change_iso2022_map","Overflow (idx_conf)",0);
		  
	if (idx_conf != (*conf)->iso2022_maps_count)
	    panic("ISO2022 PANIC",__FILE__,__LINE__,
		  "change_iso2022_map","Bad index (idx_conf)",0);

	(*conf)->iso2022_maps_list[idx_conf].ID = 
	    new->iso2022_maps_list[idx].ID;
	(*conf)->iso2022_maps_list[idx_conf].map = NULL;

	(*conf)->iso2022_maps_count++;

    set_idx_conf:

	if ((*conf)->iso2022_maps_list[idx_conf].map)
	    free_iso2022_mapinfo(& ((*conf)->iso2022_maps_list[idx_conf].map));

	if (new->iso2022_maps_list[idx].map) {
	    (*conf)->iso2022_maps_list[idx_conf].map =
		new->iso2022_maps_list[idx].map;

	    inc_iso2022_mapinfo_refcount((*conf)->
					 iso2022_maps_list[idx_conf].map);
	}

	if (ml_none != mode) {
	    /* 2) Update  iso2022_map_list */

	    int idx_list;
	    struct iso2022_setid * id = NULL;

	    for (idx_list = 0; idx_list < iso2022_map_list_count; idx_list++) {

		if (iso2022_map_list[idx_list].mode == mode &&
		    iso2022_map_list[idx_list].setid &&
		    same_setid(new->iso2022_maps_list[idx].ID,
			       * (iso2022_map_list[idx_list].setid)))
		    goto set_idx_list; 
		
	    }

	    if (idx_list >= new_max)
		 panic("ISO2022 PANIC",__FILE__,__LINE__,
		       "change_iso2022_map","Overflow (idx_list)",0);

	    if (idx_list != iso2022_map_list_count)
		panic("ISO2022 PANIC",__FILE__,__LINE__,
		      "change_iso2022_map","Bad index (idx_list)",0);

	    id = safe_malloc(sizeof (struct iso2022_setid));
	    *id = new->iso2022_maps_list[idx].ID;

	    iso2022_map_list[idx_list].setid = id;
	    iso2022_map_list[idx_list].map  = NULL;
	    iso2022_map_list[idx_list].mode = mode;

	    iso2022_map_list_count++;

	set_idx_list:

	    if (iso2022_map_list[idx_list].map)
		free_iso2022_mapinfo(& (iso2022_map_list[idx_list].map));

	    if (new->iso2022_maps_list[idx].map) {
		iso2022_map_list[idx_list].map =
		    new->iso2022_maps_list[idx].map;

		inc_iso2022_mapinfo_refcount(iso2022_map_list[idx_list].map);		
	    }
	    
	}
    }
}


void dump_iso2022_map(f,conf,commentfile,actor,version_buff)
     FILE  *f;
     struct iso2022_map_conf *conf;
     FILE *commentfile;
     const char *actor;
     char *version_buff;
{
    int i;
    
    if (!conf)
	return;
    
    if (ISO2022_MAP_CONF_magic != conf->magic)
	panic("ISO2022 PANIC",__FILE__,__LINE__,
	      "dump_iso2022_map",
	      "Bad magic number (iso2022_map_conf)",0);
    
    insert_commentfile(f,ELMISO2022SETS_INFO,
		       commentfile,actor,version_buff);
    
    for (i = 0; i < conf->iso2022_maps_count; i++) {
	if (conf->iso2022_maps_list[i].map) {
	    
	    const char * kw =
		locate_iso2022_keyword(conf->iso2022_maps_list[i].ID.bank,
				       conf->iso2022_maps_list[i].ID.type);

	    if (kw) {
		char * t = iso2022_codestr(conf->iso2022_maps_list[i].
					   ID.bytes,
					   sizeof (conf->
						   iso2022_maps_list[i].
						   ID.bytes));
		
		if (t) {
		    const char *X;
		    
		    if (NULL == strchr(t,' '))
			elm_fprintf(f,FRM("%s\t%s\t%s"),
				    kw,t,
				    iso2022_mapname(conf->
						    iso2022_maps_list
							[i].map));
			else
			    elm_fprintf(f,FRM("%s\t%Q\t%s"),
					kw,t,
					iso2022_mapname(conf->
							iso2022_maps_list
							[i].map));
			

		    X = iso2022_mapflags(conf->iso2022_maps_list[i].map);
		    
		    if (X)
			fprintf(f,"\t%s",X);

		    putc('\n',f);
		    
		    free(t);
		}
	    }      
	}
    }
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
