
static char rcsid[] = "@(#)$Id: mimesend.c,v 2.3 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Moved needs_encoding() from src/mime.c. However needs_encoding() do not
 * exist on Elm 2.4. needs_encoding() may be introduced on ELM 2.4 PL24 MEx
 * series.
 *
 * That Elm 2.4 file src/mime.c was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/* This routine is on misclib because routines related to 
 *             struct scan_list *list
 * are on misclib
 */

#include "def_misc.h"

DEBUG_VAR(Debug,__FILE__,"mime");

/* Determine whether or not the data in "fp" needs to be QUOTED-PRINTABLE
    encoded.  Used when sending a message.
       1 == have 8bit data                (HAVE_8BIT)
       4 == have control charcters        (HAVE_CTRL)
       8 == mime requires encoding BINARY (HAVE_BINARY)
   
*/


/* Does not rewind state, leaves it on middle! */
int in_state_needs_encoding (st,list, utf8)
     struct in_state *st;
     struct scan_list *list;
     int utf8;    /* Check for UTF-8 */
{
    int ch;
    int ret = 0;
    int len = 0;
    int printed = 0;
    int utf8failed = 0;

    struct charset_state * P = NULL;

    if (utf8) {
	charset_t utf8cs = MIME_name_to_charset("UTF-8",0);
	
	if (!utf8cs)
	    panic("CHARSET PANIC",__FILE__,__LINE__,"needs_encoding",
		  "UTF-8 not found",0);


	DPRINT(Debug,9,(&Debug,    
			"in_state_needs_encoding(): Checking for UTF-8\n"));
	
	P = new_state(utf8cs);
    }
    
    while ((ch = state_getc (st)) != EOF) {
	int need_more = 0;
	
    reprocess:
	need_more = 0;

	if (P && !utf8failed) {
	    
	    if (state_ready(P)) {
		uint16 u = give_unicode_from_state(P);
		/* Found UTF-8 character */
		
		if (u > 127) {
		    DPRINT(Debug,49,(&Debug,    
				     "\nin_state_needs_encoding(): found utf-8 decimal=%d\n", 
				     u));
		    
		}

		reset_state(P,0);
	    }
	    
	    if (!add_streambyte_to_state(P, ch)) {
		DPRINT(Debug,9,(&Debug,    
				"\nin_state_needs_encoding(): UTF-8 Failed\n"));
		utf8failed = 1;
		
	    } else if (! state_ready(P) && ch < 128) {
		DPRINT(Debug,9,(&Debug,    
				"\nin_state_needs_encoding(): bad ????\n"));
		utf8failed = 1;
	    }	    
	}
	
	if (list) {
	    need_more = scanlist_need_more(list,ch);
	    
	    if (!need_more && !printed) {
		DPRINT(Debug,9,(&Debug,    
				"\nin_state_needs_encoding(): magic scan finished\n"));
		printed++;
	    }
	}
	
	/* check for end of line */
	if (ch == 13) {   /* CR */
	    ch = state_getc(st);
	    
	    if (ch != 10) {  /* Not CR LF */
		DPRINT(Debug,9,(&Debug,    
				"\nin_state_needs_encoding(): found CR without LF\n"));
		ret |= HAVE_BINARY;

		len++;
	    }
	    if (ch == EOF)
		break;
	    
	    goto reprocess;
	}

	if (ch == 10) {  /* LF */
	    len = 0;
	    continue; /* skip newlines and tabs */
	}
	len++;
	if (len > 990) {
	    DPRINT(Debug,9,(&Debug,   
			    "\nin_state_needs_encoding(): Line over 990 characters\n"));	
	    ret |= HAVE_BINARY;
	}

	if (ch == 9) /* skip newlines and tabs */
	    continue;
	if (ch < 32 || ch > 126) {	    
	    DPRINT(Debug,49,(&Debug,    
			     "\nin_state_needs_encoding(): found char decimal=%d\n", ch));
	    if (ch == 0) 
		ret |= HAVE_BINARY;
	    if (ch < 32 || ch == 127)
		ret |= HAVE_CTRL;
	    if (ch > 127)
		ret |= HAVE_8BIT;
	}

	if (ret == (HAVE_8BIT | HAVE_CTRL | HAVE_BINARY) &&
	    !need_more && (!P || utf8failed))
	    break;
	
    }

    if (P) {

	if (!utf8failed &&
	    ! state_ready(P)) {
	    utf8failed = 1;
	    
	    DPRINT(Debug,9,(&Debug,    
			    "\nin_state_needs_encoding(): Incomplete UTF-8\n"));
	}
	

	free_state(&P);


	if (!utf8failed && ( ret & HAVE_8BIT))
	    ret |= HAVE_UTF8;

    }


    DPRINT(Debug,4,(&Debug,
		    "in_state_needs_encoding()=%d%s%s%s%s\n",
		    ret,
		    ret & HAVE_8BIT ? " HAVE_8BIT" : "",
		    ret & HAVE_CTRL ? " HAVE_CTRL" : "",
		    ret & HAVE_BINARY ? " HAVE_BINARY" : "",
		    ret & HAVE_UTF8 ? " HAVE_UTF8" : ""));
		  
    return ret;
}

/* Rewinds file */
int needs_encoding (fp,list, utf8)
     FILE *fp;
     struct scan_list *list;
     int utf8;    /* Check for UTF-8 */
{
    int ret = 0;

    struct in_state * state_in = new_in_state(STATE_in_file);

    rewind (fp);

    set_in_state_file(fp,state_in);

    ret = in_state_needs_encoding(state_in,list,utf8);

    free_in_state(&state_in);

    rewind (fp);

    return ret;
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
