static char rcsid[] = "@(#)$Id: okay_addr.c,v 2.9 2018/07/30 14:10:42 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                      (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *          or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"

static const unsigned char *cs2us P_((const char *str));
static const unsigned char *cs2us(str)
     const char *str;
{
    return (const unsigned char *)str;
}

DEBUG_VAR(Debug,__FILE__,"addr");

/* Used also on lib/misc/terminal.c */

int compare_helper(A,pat,ignore_case)
     const char *A; 
     const char *pat;
     int ignore_case;
{
    /* NOTE: Inefficient */

    struct string *SA   = new_string2(ASCII_SET,cs2us(A));
    struct string *Spat = new_string2(ASCII_SET,cs2us(pat));

    int r = string_match(SA,Spat,ignore_case);


    free_string(&Spat);
    free_string(&SA);
    
    return r;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
