static char rcsid[] = "@(#)$Id: out_entity.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

#include "elm_defs.h"
#include "state_imp.h"

DEBUG_VAR(Debug,__FILE__,"stateio");

struct out_entity * new_out_entity(reference_key,entity_value,
				   unicode_value,reference_key_pg_flags)
     const struct string * reference_key;
     const struct string * entity_value  /* May be NULL */;
     uint16          unicode_value;
     int    reference_key_pg_flags;
{
    struct out_entity * entity =
	safe_zero_alloc(sizeof(*entity));

    entity->refcount = 1;
    entity->reference_key = dup_string(reference_key);

    entity->entity_value =
	entity_value ? dup_string(entity_value) :  NULL;
    entity->unicode_value = unicode_value;
    entity->reference_key_pg_flags = reference_key_pg_flags;
    
    entity->magic = OUT_ENTITY_magic;

    return entity;
}

/* Drop const --  duplicate/copy this */
struct out_entity * dup_out_entity(ptr)
     const struct out_entity * ptr;
{
    if (OUT_ENTITY_magic != ptr->magic)
	state_panic(__FILE__,__LINE__,
		    "dup_out_entity",
		    "Bad magic number");

    return  new_out_entity(ptr->reference_key,
			   ptr->entity_value,
			   ptr->unicode_value,
			   ptr->reference_key_pg_flags);
}



void free_out_entity(ptr)
     struct out_entity ** ptr;
{
    if (OUT_ENTITY_magic != (*ptr)->magic)
	state_panic(__FILE__,__LINE__,
		    "free_out_entity",
		    "Bad magic number");

    if ((*ptr)->refcount < 1)
	state_panic(__FILE__,__LINE__,
		    "free_out_entity",
		    "Bad refcount");
    (*ptr)->refcount--;
    
    if ( (*ptr)->refcount > 0) {
	(*ptr) = NULL;
	return;
    }

    if ((*ptr)->reference_key)
	free_string(& ((*ptr)->reference_key));
    if ((*ptr)->entity_value)
	free_string(& ((*ptr)->entity_value));
    
    (*ptr)->unicode_value = 0;
    
    (*ptr)->magic = 0;  /* Invalidate */
    free (*ptr);
    *ptr = NULL;
}

void inc_out_entity_refcount(ptr)
     struct out_entity *ptr;
{
    if (OUT_ENTITY_magic != ptr->magic)
	state_panic(__FILE__,__LINE__,
		    "inc_out_entity_refcount",
		    "Bad magic number");

    ptr->refcount++;
}

/* Returns pointer to underline string on struct out_entity - do not free */
const struct string  * out_entity_reference_key(oe,pg_flags)
     const struct out_entity *oe;
     int *pg_flags;
{
   if (OUT_ENTITY_magic != oe->magic)
	state_panic(__FILE__,__LINE__,
		    "out_entity_reference_key",
		    "Bad magic number");

   if (pg_flags)
       *pg_flags = oe->reference_key_pg_flags;

   return oe->reference_key;
}

/* May be NULL */
const struct string  * out_entity_text_value(oe)
     const struct out_entity *oe;
{
   if (OUT_ENTITY_magic != oe->magic)
	state_panic(__FILE__,__LINE__,
		    "out_entity_text_value",
		    "Bad magic number");

   return oe->entity_value;
}

/* May be UNICODE_BAD_CHAR */
const uint16  out_entity_unicode_value(oe)
     const struct out_entity *oe;
{
    if (OUT_ENTITY_magic != oe->magic)
	state_panic(__FILE__,__LINE__,
		    "out_entity_unicode_value",
		    "Bad magic number");

    return oe->unicode_value;
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
