static char rcsid[] = "@(#)$Id: panic.c,v 2.11 2020/02/01 06:52:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"core");

static void def_panic_prepare P_((const int interrupt, 
				  const char * title,
				  const char * ms));

static void def_panic_prepare(interrupt,title,ms)
     const int interrupt;
     const char * title;
     const char * ms;
{
    /* NULL */
}

static panic_prepare *prepare = &def_panic_prepare;
void set_panic_prepare(fn)
     panic_prepare *fn;
{
    prepare = fn;
}

static void def_panic_exit P_((const int interrupt));
static void def_panic_exit(interrupt)
     const int interrupt;
{
    if (interrupt)
	abort();
    exit(127);
}

static panic_exit *exit_rut = &def_panic_exit;
void set_panic_exit(fn)
     panic_exit *fn;
{
    exit_rut = fn;
}

static void print_str_err P_((const char * ptr));
static void print_str_err(ptr)
     const char * ptr;
{
    int l = strlen(ptr);
    int r UNUSED_VAROK = write(2,ptr,l);
}

static void print_num_err P_((unsigned int num));
static void print_num_err(num)
     unsigned int num;
{
    char buffer[100];    
    int x = sizeof buffer;
    int r UNUSED_VAROK;

    do {	
	buffer[--x] = "0123456789"[num % 10];
	num /= 10;
    } while (num != 0 && x > 0);

    r = write (2, buffer + x, sizeof buffer -x);
}

#ifdef BACKTRACE
static void print_ptr_err P_((void * nump));
static void print_ptr_err(nump)
     void * nump;
{
    unsigned long num = (unsigned long)nump;
    char buffer[100];    
    int x = sizeof buffer;
    int r UNUSED_VAROK;

    do {	
	buffer[--x] = "0123456789ABCDEF"[num % 16];
	num /= 16;
    } while (num != 0 && x > 0);

    r = write (2, buffer + x, sizeof buffer -x);
}

#include <execinfo.h>   /* Needed for backtrace() function */

#define MAXSTACK 100

/* That is overwritten on nested panic(), but
   that does not matter because panic() should not return
*/
void * stack_buffer[MAXSTACK];


#endif

/* fd == -1 unsets */
static int panic_tty_fd = -1;
static int panic_tty_pid = 0;

void set_panic_tty_fd(fd,pid)
     int fd;
     int pid;
{
    panic_tty_fd  = fd;
    panic_tty_pid = pid;
}


void panic(title,f,ln,pr,ms,interrupt) 
     const char * title;     
     const char * f;
     const int ln;
     const char * pr;
     const char * ms;
     const int interrupt;
{

    static volatile int in_panic  = 0;
    static char ABORTING[] = "ABORTING...\n";

    static char PROMPT1[] = "\rPress a <enter> to abort or <enter> to exit: ";
    static char PROMPTd[] = "\rPress <enter> to abort: ";

#if DEBUG
    int level;
 
    panic_dprint ("\n%s in %s:%d:%s\n",title,f,ln,pr);
    panic_dprint (">>%s\n",ms);
        
    level = panic_dprint ("\n** in_panic = %d\n** interrupt = %d\n** wait_can_signal = %d\n",
			  in_panic,interrupt,wait_can_signal);
#endif

    switch (in_panic) {
	int r UNUSED_VAROK;
#ifdef BACKTRACE
	int stacklen;
#endif	
	
    case 0: in_panic++;
	prepare(interrupt,title,ms);

    case 1: in_panic++;
	
	print_str_err("\n");
	print_str_err(title);
	print_str_err(" in ");
	print_str_err(f);
	print_str_err(":");
	print_num_err(ln);
	print_str_err(":");
	print_str_err(pr);
	print_str_err("\n>>>");
	print_str_err(ms);
	print_str_err("\n");

    case 2: case 3: in_panic++;

#ifdef BACKTRACE
	stacklen = backtrace(stack_buffer,MAXSTACK);
	
	if (stacklen > 0) {
	    int i;

	    print_str_err("Call stack: ");
	    
	    for (i = 0; i < stacklen; i++) {
		if (i > 0) {
		    if (0 == i % 5) {
			print_str_err("\n continues: "); 
		    } else {
			print_str_err(" "); 
		    }
		}
		print_ptr_err(stack_buffer[i]);
	    }
	    print_str_err("\n"); 

#if DEBUG
	    panic_dprint("Call stack: ");

	    for (i = 0; i < stacklen; i++) {
		if (i > 0) {
		    if (0 == i % 5) {
			panic_dprint("\n continues: "); 
		    } else {
			panic_dprint(" "); 
		    }
		}
		panic_dprint("%p",stack_buffer[i]);
	    }
	    panic_dprint("\n"); 
#endif

	    if (3 == in_panic) {
		in_panic++;
		
		print_str_err("backtrace: \n"); 
		backtrace_symbols_fd(stack_buffer,stacklen,2);

#if DEBUG
		panic_dprint("backtrace: \n");
		panic_print_backtrace(stack_buffer,stacklen);
#endif
	    }
	} else
	    in_panic++; 


#else
	in_panic++;
#endif

    case 4: in_panic++;

	if (panic_tty_fd > 2) {
	    int p = getpid();	    
	    
	    if (p == panic_tty_pid) {
		char input_buffer[90];
		int d = 0;		
#if DEBUG
		if (level > 10) {
		    d = 1;
		    r = write(panic_tty_fd,PROMPTd,sizeof PROMPTd -1);
		}
#endif
		if (!d) {
		    r = write(panic_tty_fd,PROMPT1,sizeof PROMPT1 -1);
		}

		/* bzero is defined hdrs/elm_defs.h */
		bzero(input_buffer, sizeof input_buffer);
		
		r = read(panic_tty_fd,input_buffer,sizeof input_buffer);

		if (r > 0) {
		    int x;
		    int a = 0;
		    int q = 0;
		    

		    for (x = 0; x < r; x++) {
			switch (input_buffer[x]) {
			case 'a': a = 1;  break;
			case '\r' : case '\n':
			    q = 1;
			    if (d)
				a = 1;			    
			    break;			    
			}
			
		    }

		    if (q) {
			if (a) {
			    r = write(panic_tty_fd,ABORTING,sizeof ABORTING -1);
			    abort();
			}
			exit_rut(interrupt);
		    }		    
		}
	    }
	}

    case 5: in_panic++;	
#if DEBUG
	if (level > 10) {
	    r = write(2,ABORTING,sizeof ABORTING);
	    abort();
	}
#endif
	exit_rut(interrupt);
    case 6: in_panic++;	

	r = write(2,ABORTING,sizeof ABORTING);
	abort();
    default:
	abort();
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
