static char rcsid[] = "@(#)$Id: putenv.c,v 2.4 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/putenv.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1992 USENET Community Trust
 *****************************************************************************/

/*
 * This code was stolen from cnews.  Modified to make "newenv" static so
 * that realloc() can be used on subsequent calls to avoid memory leaks.
 *
 * We only need this if Configure said there isn't a putenv() in libc.
 */

#include "defs_major.h"

static const char * dummy_xxx UNUSED_VAROK = rcsid;

#ifndef PUTENV /*{*/

/* peculiar return values */
#define WORKED 0
#define FAILED 1

int putenv(var)			/* put var in the environment */
     char *var;
{
	register char **envp;
	register int oldenvcnt;
	extern char **environ;
	static char **newenv = NULL;

	/* count variables, look for var */
	for (envp = environ; *envp != 0; envp++) {
		register char *varp = var, *ep = *envp;
		register int namesame;

		namesame = NO;
		for (; *varp == *ep && *varp != '\0'; ++ep, ++varp)
			if (*varp == '=')
				namesame = YES;
		if (*varp == *ep && *ep == '\0')
			return WORKED;	/* old & new var's are the same */
		if (namesame) {
			*envp = var;	/* replace var with new value */
			return WORKED;
		}
	}
	oldenvcnt = envp - environ;

	/* allocate new environment with room for one more variable */
	if (newenv == NULL)
	    newenv = (char **)malloc((unsigned)((oldenvcnt+1+1)*sizeof(*envp)));
	else
	    newenv = (char **)realloc((char *)newenv, (unsigned)((oldenvcnt+1+1)*sizeof(*envp)));
	if (newenv == NULL)
		return FAILED;

	/* copy old environment pointers, add var, switch environments */
	(void) bcopy((char *)environ, (char *)newenv, oldenvcnt*sizeof(*envp));
	newenv[oldenvcnt] = var;
	newenv[oldenvcnt+1] = NULL;
	environ = newenv;
	return WORKED;
}

#endif /*}PUTENV*/

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
