static char rcsid[] = "@(#)$Id: rc_propline.c,v 2.8 2016/03/21 20:26:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "rc_imp.h"


DEBUG_VAR(Debug,__FILE__,"config");

#define EDITOR_PROPLINE_magic   0xF404

static struct editor_propline {
    unsigned short magic;       /* EDITOR_PROPLINE_magic */

    enum editor_propline_v   detected_line;

    struct param_value {
	char * param;
	char * value;
    } * params;
    int param_count;


} * malloc_editor_propline P_(( enum editor_propline_v mode));


static struct editor_propline * malloc_editor_propline(mode)
     enum editor_propline_v mode;
{
    struct editor_propline *ret = safe_zero_alloc(sizeof (*ret));

    ret->magic = EDITOR_PROPLINE_magic;

    ret->detected_line = mode;

    ret->params      = NULL;
    ret->param_count = 0;
    
    return ret;
}

void free_editor_propline(propline)
     struct editor_propline **propline;
{
    if (EDITOR_PROPLINE_magic != (*propline)->magic)
	panic("RC PANIC",__FILE__,__LINE__,"free_editor_propline",
	      "Bad magic number",0);

    if ((*propline)->params) {
	int i;

	for (i = 0; i < (*propline)->param_count; i++) {

	    if ((*propline)->params[i].param) {
		free((*propline)->params[i].param);
		(*propline)->params[i].param = NULL;
	    }

	    if ((*propline)->params[i].value) {
		free((*propline)->params[i].value);
		(*propline)->params[i].value = NULL;
	    }
	}

	free((*propline)->params);
	(*propline)->params = NULL;
    }
    (*propline)->param_count = 0;


    (*propline)->magic = 0;   /* Invalidate */
    free(*propline);
    *propline = NULL;
}

struct editor_propline * copy_editor_propline(propline)
     const struct editor_propline *propline;
{
    struct editor_propline *ret;

    if (EDITOR_PROPLINE_magic != propline->magic)
	panic("RC PANIC",__FILE__,__LINE__,"copy_editor_propline",
	      "Bad magic number",0);

    ret = malloc_editor_propline(propline->detected_line);

    if (propline->params && propline->param_count > 0) {
	int i;

	ret->params = safe_calloc((propline->param_count+1),
				  sizeof(ret->params[0]));

	for (i = 0; i < propline->param_count; i++) {
	    
	    ret->params[i].param = 
		propline->params[i].param ?
		safe_strdup(propline->params[i].param) :
		NULL;

	    ret->params[i].value = 
		propline->params[i].value ?
		safe_strdup(propline->params[i].value) :
		NULL;

	}

	ret->param_count = i;
    }

    return ret;
}


struct editor_propline *detect_editor_propline(detect_mode,buffer,buffer_len,
					       filename,lineno,current_charset)
     enum editor_propline_v detect_mode;
     char * buffer; 
     int buffer_len;
     const char *filename; 
     int lineno;
     charset_t *current_charset;
{
    struct editor_propline *found = NULL;

    switch (detect_mode) {
	int mark1, mark2, i;
	int count;

    case editor_propline_auto:
	/* Search all modes */

	/* 1) Look for emacs line */
    case editor_propline_emacs:

	count = 0;
	mark1 = 0;
	mark2 = 0;

	for (i = 0; i <= buffer_len-3; i++) {
	    
	    /* Only ascii characters on property line! */
	    if (1 == count && !isascii(buffer[i]))
		goto fail_emacs;

	    /* No \0 on property line! */
	    if (1 == count && !buffer[i])
		goto fail_emacs;

	    /* Only printable characters on property line! */
	    if (1 == count && !isprint(buffer[i]))
		goto fail_emacs;

	    if (0 == memcmp(buffer+i,"-*-",3)) {

		count++;
		
		switch(count) {
		case 1: mark1 = i+3; break;
		case 2: mark2 = i; break;
		}

		i += 3;
	    }
	}

	if (2 == count) {
	    char *p;
	    

	    found = malloc_editor_propline(editor_propline_emacs);

	    for (p = buffer + mark1 ; p < buffer + mark2; p++) {
		char * startsym   = NULL;
		char * startvalue = NULL;
		int len;
		char * param = NULL;
		char * value = NULL;

		if (whitespace(*p))
		    continue;

		startsym = p;
		
		while (p < buffer + mark2) {
		    if (':' == *p)
			break;

		    if (whitespace(*p)) {
			free_editor_propline(&found);
			goto fail_emacs;
		    }
		    p++;
		}
		
		len = p - startsym;
		if (':' != *p || len < 1) {

		    free_editor_propline(&found);
		    goto fail_emacs;
		}
		p++;

		param = safe_malloc(len+1);
		memcpy(param,startsym,len);
		param[len] = '\0';

		while (p < buffer + mark2) {
		    if (!whitespace(*p))
			break;
		    p++;
		}

		startvalue = p;

		while (p < buffer + mark2) {
		    if (';' == *p)
			break;

		    if (whitespace(*p)) {
			free_editor_propline(&found);
			free(param); param = NULL;
			goto fail_emacs;
		    }
		    p++;
		}
		len = p - startvalue;
		
		if (';' != *p || len < 1) {

		    free_editor_propline(&found);
		    free(param); param = NULL;
		    goto fail_emacs;
		}
		p++;

		value = safe_malloc(len+1);
		memcpy(value,startvalue,len);
		value[len] = '\0';

		if (0 == strcmp(param,"coding") ||
		    0 == strcmp(param,"buffer-file-coding-system")) {
		    charset_t set = MIME_name_to_charset(value,0);

		    if (!set)
			set = codeset_name_to_charset(value);

		    if (!set) {
			DPRINT(Debug,20,(&Debug,
					 "detect_editor_propline: %s:%d; %s: %s  not found\n",
					 filename,lineno,param,value));
		    } else {
			*current_charset = set;
		    }

		    free(param); param = NULL;
		    free(value); value = NULL;

		} else {
		    found->params = safe_array_realloc(found->params,
						       (found->param_count+1),
						       sizeof(found->params[0]));

		    found->params[found->param_count].param = param; param = NULL;
		    found->params[found->param_count].value = value; value = NULL;
		    found->param_count++;
		}
	    }
	}

    fail_emacs:
	if (editor_propline_auto != detect_mode || found)
	    break;

	/* Next mode ... */
#if 0
    case editor_propline_XXXX:

	/* ... */

	if (editor_propline_auto != detect_mode || found)
	    break;
#endif

	break;

    case editor_propline_none:
    case editor_propline_ignore:
    case NUM_editor_propline:
	/* Not used */
	break;

    }

    return found;
}

void write_editor_propline(propline,detect_mode,f,line_prefix,
			   line_tail,file_charset)
     const struct editor_propline *propline;
     enum editor_propline_v detect_mode;
     FILE *f;
     const char * line_prefix; 
     const char * line_tail;
     charset_t file_charset;
{
    const char * sysnam = get_charset_MIME_name(file_charset);

    if (editor_propline_auto == detect_mode && propline)
	detect_mode = propline->detected_line;
	
    switch (detect_mode) {

    case editor_propline_emacs:

	if (line_prefix)
	    fputs(line_prefix,f);

	fputs("-*-",f);

	if (propline && 
	    editor_propline_emacs == propline->detected_line) {
	    int i;

	    for (i = 0; i < propline->param_count; i++)
		fprintf(f," %s: %s;",
			propline->params[i].param,
			propline->params[i].value);

	}

	if (sysnam) {
	    fprintf(f," coding: %s;",shift_lower(sysnam));
	}


	fputs(" -*-",f);
	if (line_tail)
	    fputs(line_tail,f);

	break;

#if 0
    case editor_propline_XXXX:

	break;
#endif

    case editor_propline_auto:
    case editor_propline_none:
    case editor_propline_ignore:
    case NUM_editor_propline:
	/* Not used */
	break;

    }

    /* TODO */
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
