static char rcsid[] = "@(#)$Id: shared_config.c,v 2.2 2018/01/20 17:10:15 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/*
 * This file is compiled only if dlopen() is available, so
 * that file does not need to be guarded with #ifdef 
 */

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"dl");

#include "shared_imp.h"
#include "rc_imp.h"
#include "save_opts.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(RC_change_config_f NO_RC_change_config)
static void NO_RC_change_config P_((int *errors, int flag,
				    const char * tag,
				    struct rc_save_info_rec * rc_options,
				    size_t  rc_option_count,
				    size_t rec_size,
				    const char * shared_tag));
static void NO_RC_change_config(errors,flag,tag,rc_options,
				rc_option_count,rec_size,
				shared_tag)
     int *errors; 
     int flag;
     const char * tag;
     struct rc_save_info_rec * rc_options;
     size_t  rc_option_count;
     size_t rec_size;
     const char * shared_tag;
{
    /* nothing */
}

#define SHARED_CONFIG_magic	0xF90D

struct sl_config_data {
    uint16            magic; 
    
    RC_change_config_f * change_config;

};

S_(sl_reg_functions sl_reg_config)
static int sl_reg_config P_((struct ImpInfo *i,
			   int reg_idx));
static int sl_reg_config(i,reg_idx)
     struct ImpInfo *i;
     int reg_idx;
{
    /* union hack to avoid warnings about casting
     * between pointer-to-object and pointer-to-function
     */
    
    int res = 0;

    union F16 {
	void *                       ptr;
	RC_change_config_f         * f16;
    } f16;

    struct reg_list *r = & (i->regs[reg_idx] );
    
    if (&use_shared_config != r->var)
	panic("SHARED PANIC",__FILE__,__LINE__,
	      "sl_reg_config",
	      "Wrong variable",0);

    f16.ptr = dlsym(i->handle, "RC_change_config");

    if (!f16.f16) {
	DPRINT(Debug,7,(&Debug, " ... NO RC_change_config\n"));
    }

    if (r->r.config->magic != SHARED_CONFIG_magic)
	panic("SHARED PANIC",__FILE__,__LINE__,
	      "sl_reg_config",
	      "Bad magic bumber",0);
    
    if (f16.f16) {
	r->r.config->change_config = f16.f16;
	
	res = 1;

	DPRINT(Debug,7,(&Debug," ... RC_change_config\n"));
    }

    r->valid   = res;

    return res;
}

S_(sl_zero_reg_list sl_zero_config)
static void sl_zero_config P_((struct dt_shared_info *var,
			      struct reg_list *r));
static void sl_zero_config(var,r)
     struct dt_shared_info *var;
     struct reg_list *r;
{
  r->var     = var;
  r->r.config  = safe_malloc(sizeof (*r->r.config));   /* never freed ... */
  r->r.config->magic = SHARED_CONFIG_magic;

  r->r.config->change_config = NO_RC_change_config;

}

S_(sl_unreg_functions sl_unreg_config)
static void sl_unreg_config P_((struct ImpInfo *i, int reg_idx));
static void sl_unreg_config(i,reg_idx)
     struct ImpInfo *i; 
     int reg_idx;
{
#if 0
    struct reg_list *r = & (i->regs[reg_idx] );
#endif

}

static struct shared_loader config_loader = {
    SHARED_LOADER_magic,
    sl_reg_config,
    sl_zero_config,
    sl_unreg_config
};

SHAREDLIB use_shared_config = {
    &config_loader            /* loader */,
    0,                       
    NULL, 0,
    NULL
};

/* --------------------------------------------------------------- */

/* change default of unset options */

void post_init_change_config(errors,flag,tag,rc_options,
			     rc_option_count,
			     rec_size)
     int *errors;
     int flag;
     const char              * tag;
     struct rc_save_info_rec * rc_options;
     size_t                    rc_option_count;
     size_t                    rec_size;
{
    int i;

    if (rec_size != sizeof(rc_options[0])) {
	DPRINT(Debug,7,(&Debug,
			"post_init_change_config: Bad res_size %d (should be %d)\n",
			rec_size,sizeof(rc_options[0])));
	
	return;
    }

    /* We must load all config libraries */
    load_shared_libs1(&use_shared_config);  

    for (i = 0; i < use_shared_config.shared_list_len; i++) {
	if (use_shared_config.shared_list[i]->handle) {
	    int r = give_rnum(use_shared_config.shared_list[i],
			      &use_shared_config);

	    struct sl_config_data * config =
		use_shared_config.shared_list[i]->regs[r].r.config;
	    
	    if (config->magic !=  SHARED_CONFIG_magic)
		panic("SHARED PANIC",__FILE__,__LINE__,
		      "post_init_change_config",
		      "Bad magic bumber",0);

	    if (use_shared_config.shared_list[i]->regs[r].valid) {

		DPRINT(Debug,8,(&Debug,"change_config library %s (for %s)\n",
				use_shared_config.shared_list[i]->tag,
				tag ? tag : "main config"));

		config->change_config(errors,flag,tag,
				      rc_options,rc_option_count,
				      sizeof(rc_options[0]),
				      use_shared_config.shared_list[i]->tag);
	    }

	}
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

