static char rcsid[] = "@(#)$Id: state.c,v 2.14 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "elm_defs.h"
#include "state_imp.h"

DEBUG_VAR(DebugIO,__FILE__,"stateio");

void state_panic(f,ln,pr,ms) 
     char * f;
     int ln;
     char *pr;
     char *ms;
     
{
    panic("STATE PANIC",f,ln,pr,ms,0);
}

/* Return 1 if is copy succeed */
int state_copy(infile,outfile)
     struct in_state *infile; 
     struct out_state *outfile; 
{
    int ok = 1;

    while (1) {
	int ch = state_getc(infile);
	
	if (EOF == ch) 
	    break;

	if (EOF == state_putc(ch,outfile))
	    ok = 0;
    }

    if (in_state_ferror(infile))
	ok = 0;

    return ok;
}

/* Return 1 if is copy succeed, return -1 on unexpected EOF */
int state_copy_range(infile,outfile, bytes)
     struct in_state *infile; 
     struct out_state *outfile; 
     int bytes;
{
    int ok = 1;
    int copied = 0;

    while (copied < bytes) {
	int ch = state_getc(infile);
	
	if (EOF == ch) {  /* Unexpected EOF */
	    if (ok) 
		ok = -1;
	    break;
	}

	if (EOF == state_putc(ch,outfile))
	    ok = 0;

	copied++;
    }

    if (in_state_ferror(infile))
	ok = 0;

    return ok;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
