static char rcsid[] = "@(#)$Id: state_in_gets.c,v 2.2 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *****************************************************************************
 *  Based on Elm 2.4 lib/mail_gets.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1992 USENET Community Trust
 *****************************************************************************/

#include "elm_defs.h"
#include "state_imp.h"

DEBUG_VAR(DebugIO,__FILE__,"stateio");

char *state_gets_helper(dest,length,s)
     char *dest; 
     int length; 
     struct in_state *s;
{
    int len = 0;
    int c = '\0';

    if (STATE_in_magic != s->magic)
	state_panic(__FILE__,__LINE__,"state_gets_helper",
		    "Bad state magic number");

    if (IN_STATE_type_magic != s->state_type->magic)
	state_panic(__FILE__,__LINE__,"state_gets_helper",
		    "Bad state type magic number");

    while (len < length-1) {
	c = s->state_type->getc_si_type(s);

	if (EOF == c)
	    break;

	dest[len++] = c;
	
	if ('\n' == c)
	    break;
    }
    dest[len] = '\0';

    if (EOF == c && s->state_type->ferror_si_type(s)) {

	DPRINT(DebugIO,15,
	       (&DebugIO,"state_gets_helper: Error on read\n"));

	if (len < 1) {
	    DPRINT(DebugIO,15,
		   (&DebugIO,"state_gets_helper=NULL (no bytes read)\n"));

	    return NULL;
	}	
    }

    DPRINT(DebugIO,45,
	   (&DebugIO,"state_gets_helper: %d bytes read\n",len));
    

    return dest;
}

int state_getl_helper(dest,length,s)
     char *dest; 
     int length; 
     struct in_state *s;
{
    int len = 0;
    int c = '\0';

    if (STATE_in_magic != s->magic)
	state_panic(__FILE__,__LINE__,"state_getl_helper",
		    "Bad state magic number");

    if (IN_STATE_type_magic != s->state_type->magic)
	state_panic(__FILE__,__LINE__,"state_getl_helper",
		    "Bad state type magic number");

    while (len < length-1) {
	c = s->state_type->getc_si_type(s);
	
	if (EOF == c) {
	    if (len > 0 && dest[len-1] != '\n') {
		dest[len++] = '\n';
	    }
	    
	    break;
	}
	dest[len++] = c;

	if (c == '\n')
	    break;
    }

    dest[len] = '\0';

    DPRINT(DebugIO,45,
	   (&DebugIO,"state_getl_helper=%d (bytes stored)\n",len));

    return len;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
