static char rcsid[] = "@(#)$Id: strfcpy.c,v 2.4 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/strfcpy.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1993 USENET Community Trust
 *****************************************************************************/

/*
 * This is just like strncpy() except:
 *
 * - The result is guaranteed to be '\0' terminated.
 *
 * - strncpy is supposed to copy _exactly_ "len" characters.  We copy
 *   _at_most_ "len" characters.  (Actually "len-1" to save space for
 *   the trailing '\0'.  That is, strncpy() fills in the end with '\0'
 *   if strlen(src)<len.  We don't bother.
 */

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"mem");

char *strfcpy(dest, src, len)
     char *dest;
     const char *src;
     int len;
{
    int size         UNUSED_VAROK = len;
    const char *src0 UNUSED_VAROK = src;

  char *dest0 = dest;

  while (--len > 0 && *src != '\0')
    *dest++ = *src++;

  if (*src != '\0') {
    DPRINT(Debug,1,(&Debug,
		    "strfcpy: --- too long string (max=%d): %.30s...\n",
		    size,src0));
  }

  *dest = '\0';
  return dest0;
}

char *strfcat(dest, src, len)
     char *dest;
     const char *src;
     int len;
{
    int size         UNUSED_VAROK = len;
    const char *src0 UNUSED_VAROK = src;

  char *dest0 = dest;
  while ('\0' != *dest && --len > 0)
    dest++;
  while (--len > 0 && *src != '\0')
    *dest++ = *src++;

  if (*src != '\0') {
    DPRINT(Debug,1,(&Debug,
		    "strfcat: --- too long string (max target=%d): %.30s...\n",
		    size,src0));
  }

  *dest = '\0';
  return dest0;
}

char *strnfcpy(dest, src, len, size, produced)
     char *dest;
     const char *src;
     int len,size, *produced;
{
    int size0        UNUSED_VAROK = size;
    const char *src0 UNUSED_VAROK = src;

  char *dest0 = dest;

  while (--size > 0 && len-- > 0 && *src != '\0') {
    *dest++ = *src++;
  }
  *dest = '\0';
  if (produced)
    *produced = dest - dest0;

  if (*src != '\0' && len > 0) {
    DPRINT(Debug,1,(&Debug,
		    "strnfcpy: --- too long string (max=%d): %.30s...\n",
		    size0,src0));
  }
  return dest0;
}


#ifdef _TEST
#include <stdio.h>
main()
{
	char src[1024], dest[1024];
	int len;

	for (;;) {
		printf("string > ");
		fflush(stdout);
		if (gets(src) == NULL)
			break;
		printf("maxlen > ");
		fflush(stdout);
		if (gets(dest) == NULL)
			break;
		len = atoi(dest);
		(void) strfcpy(dest, src, len);
		printf("dest=\"%s\" maxlen=%d len=%d\n",
			dest, len, strlen(dest));
		putchar('\n');
	}
	putchar('\n');
	exit(0);
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
