static char rcsid[] = "@(#)$Id: string_alt.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

#include "elm_defs.h"

/* Needs STRING_magic and OUT_ENTITY_magic */
#include "elmme-magic.h"


DEBUG_VAR(Debug,__FILE__,"charset");

/* String or out_entity */

enum string_alt_type_magic {
    sa_type_magic_text   = STRING_magic,
    sa_type_magic_entity = OUT_ENTITY_magic
};

#define STRING_ALT_magic	0xEB27

struct string_alt {
    unsigned short magic; 

    int refcount;
       
    union string_alt_value u;
};

static struct string_alt * new_string_alt P_((union string_alt_value u));
static struct string_alt * new_string_alt(u)
     union string_alt_value u;
{
    struct string_alt *ret =
	safe_zero_alloc(sizeof(*ret));

    ret->magic = STRING_ALT_magic;
    ret->refcount = 1;

    if (u.magic) {
	int ok = 0;
	enum string_alt_type_magic m = * (u.magic);

	switch (m) {
	case sa_type_magic_text:
	case sa_type_magic_entity:
	    ok = 1;
	    break;
	}

	if (!ok)
	    panic("STRING PANIC",__FILE__,__LINE__,"new_string_alt",
		  "Bad magic number (string_alt_value)",0);	
    }

    ret->u = u;
    
    return ret;
}


struct string_alt * new_string_alt_text(str)
     const struct string *str;
{
    union string_alt_value u;
    
    u.text = dup_string(str);
    
    return new_string_alt(u);
}

struct string_alt * new_string_alt_entity(oe)
     struct out_entity *oe;
{
    union string_alt_value u;
    
    u.entity = oe;
    inc_out_entity_refcount(u.entity);

    return new_string_alt(u);
}

const union string_alt_value get_string_alt_value(str_alt,res_type)
     struct string_alt * str_alt;
     enum string_alt_type * res_type;
{ 
    
    if (STRING_ALT_magic != str_alt->magic)
	panic("STRING PANIC",__FILE__,__LINE__,"get_string_alt_value",
	      "Bad magic number (string_alt)",0);

    
    
    if (res_type)
	*res_type = string_alt_none;

    if (str_alt->u.magic) {
	int ok = 0;
	enum string_alt_type_magic m = * (str_alt->u.magic);
	
	switch (m) {
	case sa_type_magic_text:
	    ok = 1;
	    if (res_type)
		*res_type = string_alt_text;
	    break;
	case sa_type_magic_entity:
	    ok = 1;
	    if (res_type)
		*res_type = string_alt_entity;
	    break;
	}
	
	if (!ok)
	    panic("STRING PANIC",__FILE__,__LINE__,"get_string_alt_value",
		  "Bad magic number (string_alt_value)",0);
    }
    
    return str_alt->u;
}


void inc_string_alt_refcount(str_alt)
     struct string_alt *str_alt;
{

    if (STRING_ALT_magic != str_alt->magic)
	panic("STRING PANIC",__FILE__,__LINE__,"inc_string_alt_refcount",
	      "Bad magic number (string_alt)",0);
    
    str_alt->refcount++;
}

void free_string_alt(str_alt)
     struct string_alt **str_alt;
{


    if (STRING_ALT_magic != (*str_alt)->magic)
	panic("STRING PANIC",__FILE__,__LINE__,"free_string_alt",
	      "Bad magic number (string_alt)",0);

    if ((*str_alt)->refcount < 1)
	panic("STRING PANIC",__FILE__,__LINE__,"free_string_alt",
	      "Bad refcount",0);
	
    (*str_alt)->refcount--;

    if ((*str_alt)->refcount > 0) {
	(*str_alt) = NULL;
	return;
    }

    if ((*str_alt)->u.magic) {
	int ok = 0;
	enum string_alt_type_magic m = * ((*str_alt)->u.magic);
	
	switch (m) {
	case sa_type_magic_text:
	    ok = 1;
	    if ((*str_alt)->u.text)
		free_string(& ((*str_alt)->u.text));
	    
	    break;
	    
	case sa_type_magic_entity:
	    ok = 1;
	    if ((*str_alt)->u.entity)
		free_out_entity(& ((*str_alt)->u.entity));
	    
	    break;
	}

	if (!ok)
	    panic("STRING PANIC",__FILE__,__LINE__,"free_string_alt",
		  "Bad magic number (string_alt_value)",0);
	
    }

    free(*str_alt);
    (*str_alt) = NULL;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
