static char rcsid[] = "@(#)$Id: striparens.c,v 2.4 2014/07/14 15:07:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *          or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/striparens.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/* 
 * strip_parens() - Delete all (parenthesized) information from a string.
 * get_parens() - Extract all (parenthesized) information from a string.
 *
 * These routines handle RFC-822 comments.  Nested parens are understood.
 * get_parens() does not include the parens in the return result.  Both
 * routines are non-destructive.  They return a pointer to static data
 * that will be overwritten on the next call to either routine.
 */

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static char paren_buffer[VERY_LONG_STRING];

char *strip_parens(src)
     const char *src;
{
    int len;
    char *dest                    = paren_buffer;
    const char *src0 UNUSED_VAROK = src;

    while (*src != '\0') {
	len = rfc822_toklen(src);		
	if (*src != '(') {	/*)*/
	    if ((dest-paren_buffer) + len < sizeof paren_buffer -1) {
		strncpy(dest, src, len);
		dest += len;
	    } else {
		DPRINT(Debug,1,(&Debug,
				"strip_parens: --- too long string (max=%d): %.30s...\n",
				sizeof paren_buffer,src0));	
		DPRINT(Debug,1,(&Debug,
				"strip_parens: next token: %.*s\n",len,src));
		break;
	    }
	}
	src += len;
    }
    *dest = '\0';
    return paren_buffer;
}

char *get_parens(src)
     const char *src;
{
    int len;
    char *dest                    = paren_buffer;
    const char *src0 UNUSED_VAROK = src;
    
    while (*src != '\0') {
	len = rfc822_toklen(src);
	if (len > 2 && *src == '(') {	/*)*/
	    if ((dest-paren_buffer) + len < sizeof paren_buffer) {	
		strncpy(dest, src+1, len-2);
		dest += (len-2);
	    } else {
		DPRINT(Debug,1,(&Debug,
				"get_parens: --- too long string (max=%d): %.30s...\n",
				sizeof paren_buffer,src0));	
		DPRINT(Debug,1,(&Debug,
				"get_parens: next token: %.*s\n",len,src));
		break;
	    }	    
	}
	src += len;
    }
    *dest = '\0';
    return paren_buffer;
}

#ifdef _TEST
main()
{
	char buf[1024];
	while (fputs("\nstr> ", stdout), gets(buf) != NULL) {
		printf("strip_parens() |%s|\n", strip_parens(buf));
		printf("get_parens()   |%s|\n", get_parens(buf));
	}
	putchar('\n');
	exit(0);
}
#endif



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

