static char rcsid[] = "@(#)$Id: partial.c,v 2.13 2021/01/16 17:58:50 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");

void free_partial_vector(mss)
     struct header_rec *mss;
{
    if (mss->partial_vector) {
	int i;
	
	for (i = 0; i < mss->partial_len; i++) {
	    
	    mss->partial_vector[i].reference = NULL;
	    
	    if (mss->partial_vector[i].id) {
		free (mss->partial_vector[i].id);
		mss->partial_vector[i].id = NULL;
	    }
	}
	
	free(mss->partial_vector);
	mss->partial_vector = NULL;
    }
    mss->partial_len = 0;  
}

struct partial_vector *reg_partial(mss,reference)
     struct header_rec *mss;
     mime_t   * reference;
{
    int i;
    const char *id;
    const char *number;
    const char *total;


    /* Already collected? */
    for (i = 0; i < mss->partial_len; i++) {
	if (mss->partial_vector[i].reference ==  reference)
	    
	    return (& (mss->partial_vector[i] ));
    }

    id = get_mime_param_compat(reference->TYPE_opts,"id");
    
    if (!id) {
	
	DPRINT(Debug,11,(&Debug, 
			 "reg_partial: No id paramater -- corrupted.\n"));
	
	return NULL;
    }
    
    number = get_mime_param_compat(reference->TYPE_opts,"number");
    if (!number) {
	
	DPRINT(Debug,11,(&Debug, 
			 "reg_partial: No number paramater -- corrupted.\n"));
	
	return NULL;
    }
    
    mss->partial_vector = safe_array_realloc(mss->partial_vector,
					     (mss->partial_len+1),
					     sizeof (mss->partial_vector[0]));
   
    mss->partial_vector[mss->partial_len].reference = reference;
    mss->partial_vector[mss->partial_len].id       = safe_strdup(id);
    mss->partial_vector[mss->partial_len].number   = atoi(number);
    mss->partial_vector[mss->partial_len].total    = -1;

    total = get_mime_param_compat(reference->TYPE_opts,"total");
    if (total) 
	mss->partial_vector[mss->partial_len].total = atoi(total);    
    
    return & (mss->partial_vector[mss->partial_len++]);
}


#if ANSI_C
mime_run_selector partial_selector;
CT_decoder partial_decode;
#endif

int partial_selector(p,hdr)     
     mime_t *p;
     struct header_rec * hdr;
{
    const char *id;
    const char *number;

    int ret = 0;
    enum fragment_handling_v fh = 
	give_dt_enumerate_as_int(&fragment_handling);

    id = get_mime_param_compat(p->TYPE_opts,"id");

    if (!id) {
	
	DPRINT(Debug,11,(&Debug, 
			 "partial_selector: No id parameter -- corrupted.\n"));
	
	ret |=  NOTPLAIN_need_metamail;
    }
    
    number = get_mime_param_compat(p->TYPE_opts,"number");
    if (!number) {
	
	DPRINT(Debug,11,(&Debug, 
			 "partial_selector: No number paremater -- corrupted.\n"));
	
	ret |=  NOTPLAIN_need_metamail;
    }
    
    /* fragment_handling: 0 == none,
       1 == manual,
       2 == auto  */
    
    if (fragment_handling_none == fh)
	ret |=  NOTPLAIN_need_metamail;
    
    DPRINT(Debug,11,(&Debug, 
		     "partial_selector(%p) = %d\n",
		     p,
		     ret));
    
    return ret;  
}

void partial_decode(ptr,s_in,s_out,decode_opt,defcharset,mss, badtype,bodydefcharset)
     mime_t *ptr; 
     struct in_state *s_in; 
     struct out_state  *s_out;
     const struct decode_opts *decode_opt;
     charset_t defcharset;
     struct header_rec *mss;
     type_mismatch_prompt *badtype;
     charset_t bodydefcharset;
{
    int print = 0;
    enum fragment_handling_v fh = 
	give_dt_enumerate_as_int(&fragment_handling);
    struct pager_range *title_range = 
	state_add_simple_pager_range(s_out,NULL,PR_MAX_WIDTH,0,0);

    state_nlputs("\n",s_out);

    set_out_state_line_mode(s_out,pg_BOLD,title_range,1 /* Newline */); /* \n resets this */
    state_nlputs("[ ",s_out);

    state_printf(s_out,
		 CATGETS(elm_msg_cat, MeSet, MeMessageFragment,
			 "Message fragment"));

    
    if (mss) {
	struct partial_vector * r = reg_partial(mss,ptr);

	if (r) {
	    state_printf(s_out,
			 CATGETS(elm_msg_cat, MeSet, MePartNum,
				 ", part %d"),
			 r->number);
	    print = 1;
	} else
	    state_printf(s_out,
			 CATGETS(elm_msg_cat, MeSet, MeCorrupted,
				 ", corrupted"));

    }

    state_nlputs(". ]\n",s_out);
    

    /* fragment_handling: 0 == none,
       1 == manual,
       2 == auto  */
    
    if (fragment_handling_manual == fh && print &&
	ptr == & mss->mime_rec && decode_opt->displaying) {

	set_out_state_line_mode(s_out,pg_BOLD,title_range,1 /* Newline */); /* \n resets this */
	state_printf(s_out,
		     CATGETS(elm_msg_cat, MeSet, MeAssembleCommand,
			     "[ Command 'A' assembles fragmented messages. ]\n"));

    }

    free_pager_range(&title_range);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
