static char rcsid[] = "@(#)$Id: tagfilter_enriched.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

#include "def_melib.h"
#include "tagfilter_imp.h"

DEBUG_VAR(Debug,__FILE__,"mime");

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

/* Parameter Command */

static struct TAGFILTER_CMD enriched_parameter = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Param", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };

/* Font-Alteration Commands */

static struct TAGFILTER_CMD enriched_bold =
    { TAGFILTER_CMD_magic, 1, "Bold", pg_BOLD, baseC(tfc_none), NULL,
      TAGFLT_CMD_is_static, NULL, NULL };
static struct TAGFILTER_CMD enriched_italic =  
    { TAGFILTER_CMD_magic, 1, "Italic", pg_ITALIC,  baseC(tfc_none), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };
static struct TAGFILTER_CMD enriched_underline =
    { TAGFILTER_CMD_magic, 1, "Underline", pg_UNDERLINE, baseC(tfc_none), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };
static struct TAGFILTER_CMD enriched_fixed =  /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Fixed", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };  
static struct TAGFILTER_CMD enriched_fontfamily = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "FontFamily", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };
static struct TAGFILTER_CMD enriched_color = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Color", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };
static struct TAGFILTER_CMD enriched_smaller = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Smaller", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };
static struct TAGFILTER_CMD enriched_bigger = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Bigger", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL  };

/* Fill/Justification/Indentation Commands */

static struct TAGFILTER_CMD enriched_center = /* incomplete */
    { TAGFILTER_CMD_magic, 1, "Center", 0, enrichedC(tfc_center), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL  };
static struct TAGFILTER_CMD enriched_flushleft = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "FlushLeft", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };
static struct TAGFILTER_CMD enriched_flushright = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "FlushRight", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline, NULL, NULL };
static struct TAGFILTER_CMD enriched_flushboth = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "FlushBoth", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };
static struct TAGFILTER_CMD enriched_paraindent = /* unsupported */
    { TAGFILTER_CMD_magic, 1, "ParaIndent", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };
static struct TAGFILTER_CMD enriched_nofill = 
    { TAGFILTER_CMD_magic, 1, "Nofill", 0, enrichedC(tfc_nojoin), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

/* Markup Commands */

static struct TAGFILTER_CMD  enriched_excerpt =
    { TAGFILTER_CMD_magic, 1, "Excerpt", 0, enrichedC(tfc_quote), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };
static struct TAGFILTER_CMD  enriched_lang =  /* unsupported */
    { TAGFILTER_CMD_magic, 1, "Lang", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static, NULL, NULL };

struct tagfilter_cmd * tagfilter_enriched_cmds[] = {

    /* Parameter Command */
    
    tag_command(enriched_parameter), 
    
    /* Font-Alteration Commands */
    
    tag_command(enriched_bold),
    tag_command(enriched_italic),
    tag_command(enriched_underline),
    tag_command(enriched_fixed),
    tag_command(enriched_fontfamily),
    tag_command(enriched_color),
    tag_command(enriched_smaller),
    tag_command(enriched_bigger),

    /* Fill/Justification/Indentation Commands */
    
    tag_command(enriched_center),
    tag_command(enriched_flushleft),
    tag_command(enriched_flushright),
    tag_command(enriched_flushboth),
    tag_command(enriched_paraindent),
    tag_command(enriched_nofill),

    /* Markup Commands */

    tag_command(enriched_excerpt),
    tag_command(enriched_lang),

    NULL
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
