case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH = "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac


echo "Extracting nls/gencat/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 1.8 2018/08/01 09:36:26 hurtta Exp $
#
CC		=	$cc
CP		=	$cp
CHMOD		=	$chmod
TOUCH		=	$touch
IHDR		= 	../../hdrs

$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
CFLAGS= -g -I$(IHDR) -I$(INCLDIR) -DNOCHARSET
INCLDIR		=	$(SRCROOT)/hdrs


all:	gencat dumpmsg

#	Dependencies of header files upon other header files they include
.PRECIOUS:  $(IHDR)/elm_defs.h $(IHDR)/defs_major.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h:  ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

strfcpy.c: $(SRCROOT)/lib/strfcpy.c
	$(CP) $(SRCROOT)/lib/strfcpy.c strfcpy.c
output.c: ../../lib/output.c
	$(CP) $(SRCROOT)/lib/output.c output.c
safemalloc.c: $(SRCROOT)/lib/safemalloc.c
	$(CP) $(SRCROOT)/lib/safemalloc.c safemalloc.c

	
gencat:	gencat.o genlib.o strfcpy.o output.o safemalloc.o
	$(CC) $(CFLAGS) -o $@ gencat.o genlib.o strfcpy.o output.o safemalloc.o

dumpmsg: dumpmsg.o genlib.o  strfcpy.o safemalloc.o
	$(CC) $(CFLAGS) -o $@ dumpmsg.o genlib.o strfcpy.o safemalloc.o

clean:
	rm -f gencat.o genlib.o dumpmsg.o *~ *.bak gencat dumpmsg

gencat.o:	gencat.h
genlib.o:	gencat.h $(INCLDIR)/msgcat.h $(IHDR)/elm_defs.h
dumpmsg.o:	gencat.h $(IHDR)/elm_defs.h

!NO!SUBS!
