case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH = "
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    ;;
esac

echo "Extracting shared_libs/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.7 2016/02/22 18:14:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI) 
#       or Kari Hurtta <elm@elmme-mailer.org>
#
#
REG             =       ../bin/elmregister
$vpathdef

!GROK!THIS!

if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

modules=''
insmods=''
rmmods=''
allmods=''
cleanmods=''
uninstallmods=''
installmods=''
for domake in $shared_list ; do
	varname="\$${domake}_ok"
	if eval $test "X$varname" = "Xdefine" ; then
		modules="$modules ../shlib/libelmme-${domake}.so"
		insmods="$insmods \$(ELM_ROOT)//$shlib/libelmme-${domake}.so$d_shared_rev"
		allmods="$allmods all-${domake}"
		cleanmods="$cleanmods clean-${domake}"
		uninstallmods="$uninstallmods uninstall-${domake}"
		installmods="$installmods install-${domake}"
	else
		rmmods="$rmmods \$(ELM_ROOT)//$shlib/libelmme-${domake}.so$d_shared_rev"
	fi
done

$cat >>Makefile <<SUBSMODULES

all:			Makefile $modules $allmods
			cd include; \$(MAKE) \$(MJ) \$(MFLAGS) \$@

install_s:		Makefile $insmods $installmods remove_not_configured
			cd include; \$(MAKE) \$(MJ) \$(MFLAGS) \$@

clean:			$cleanmods
			cd include; \$(MAKE) \$(MJ) \$(MFLAGS) \$@

uninstall_s:		$uninstallmods remove_not_configured remove_installed
			cd include; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
	
SUBSMODULES

if $test "$rmmods" != "" ; then
	$cat >>Makefile <<SUBSMODULES
remove_not_configured:
	\$(REG) rm $rmmods

SUBSMODULES
else
	$cat >>Makefile <<SUBSMODULES
remove_not_configured:

SUBSMODULES
fi

if $test "$insmods" != "" ; then
	$cat >>Makefile <<SUBSMODULES
remove_installed:
	\$(REG) rm $insmods

SUBSMODULES
else
	$cat >>Makefile <<SUBSMODULES
remove_installed:

SUBSMODULES
fi

$cat >>Makefile <<'!NO!SUBS!'
Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

!NO!SUBS!

for domake in $shared_list ; do
$cat >>Makefile <<SUBSMODULES

../shlib/libelmme-${domake}.so: $domake/lib${domake}.a
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) ../../shlib/libelmme-${domake}.so

$domake/lib${domake}.a all-${domake}: 
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) all

\$(ELM_ROOT)//$shlib/libelmme-${domake}.so$d_shared_rev: ../shlib/libelmme-${domake}.so
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) \$@

clean-${domake}:
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) clean

install-${domake}:
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) install_s

uninstall-${domake}:
	cd ${domake}; \$(MAKE) \$(MJ) \$(MFLAGS) uninstall_s

SUBSMODULES

done


