static char rcsid[] = "@(#)$Id: resolvertest.c,v 1.4 2017/11/11 12:37:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* This test file is used by config */

#if defined(__STDC__) || defined(_AIX)
# define ANSI_C 1
#endif

#include <stdio.h>
#ifdef ANSI_C
#include <stdlib.h>
#endif


#include "testconfig.h"

#ifdef STRINGS
#  include <strings.h>
#else
#  include <string.h>
#endif

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif

#ifdef I_NETINET_IN
#include <netinet/in.h>
#endif

#ifdef I_ARPA_INET
#include <arpa/inet.h>
#endif

#include <arpa/nameser.h>
#include <resolv.h>


#ifndef _res
extern struct state _res;
#endif

#ifdef I_NETDB
#include <netdb.h>
#endif
#ifndef h_errno
extern int h_errno;
#endif

#if defined(__STDC__)
int main (int argc, char * argv[]);
#endif

int main (argc,argv)
   int argc;
   char * argv[];
{

  int r;
  char * t = "";
  unsigned char answer[1024];
  int anslen;

  ns_msg parsed_answer;
  
  ns_sect sect;
  char * name = NULL;
  ns_type q_type;

  if (argc != 4) {
  USAGE:
    fprintf(stderr, "Usage: %s [query|search] [a|ns|mx|aaaa|txt|srv|ptr] <name>\n",argv[0]);
    exit(1);
  }

  if (0 == strcasecmp(argv[2],"a"))
    q_type = ns_t_a;
  else if (0 == strcasecmp(argv[2],"ns"))
    q_type = ns_t_ns;
  else if (0 == strcasecmp(argv[2],"cname"))
    q_type = ns_t_cname;
  else if (0 == strcasecmp(argv[2],"mx"))
    q_type = ns_t_mx;
  else if (0 == strcasecmp(argv[2],"aaaa"))
    q_type = ns_t_aaaa;
  else if (0 == strcasecmp(argv[2],"txt"))
    q_type = ns_t_txt;
  else if (0 == strcasecmp(argv[2],"srv"))
    q_type = ns_t_srv;
  else if (0 == strcasecmp(argv[2],"ptr"))
    q_type = ns_t_ptr;
  else 
    goto USAGE;

  name = argv[3];

  errno = 0;
  if (0 == strcmp(argv[1],"query")) {
    t = "res_query";
    anslen = res_query(name,ns_c_in,q_type,
		       answer,sizeof answer);
  } else if (0 == strcmp(argv[1],"search")) {
     t = "res_search";
     anslen = res_search(name,ns_c_in,q_type,
			 answer,sizeof answer);
  } else 
    goto USAGE;

  if (anslen < 0) {
    int err = errno;
    fprintf(stderr, "%s %s: h_errno=%d",t,name,h_errno);

    switch(h_errno) {
    case HOST_NOT_FOUND:
      fprintf(stderr, " name not found");
      break;
    case NO_DATA:
      fprintf(stderr, " no %s record",argv[2]);
      break;
    case TRY_AGAIN:
      fprintf(stderr, " not found yet");
      break;
    }

    if (0 != err) {
      fprintf(stderr," errno=%d %s",err,strerror(err));
    }

    fprintf(stderr, "\n");

    if (TRY_AGAIN == h_errno)
       exit(3);
    exit(2);
  }

  errno = 0;
  r = ns_initparse(answer,anslen,&parsed_answer);
  if (r < 0) {
    int err = errno;

    fprintf (stderr,"%s %s: failed to parse answer (ns_initparse)",
	     t,name);

    if (0 != err) {
      fprintf(stderr," errno=%d %s",err,strerror(err));
    }
    
    fprintf(stderr, "\n");
    exit(3);
  }

#ifdef RESOLV_NS_FLAG
  {
    ns_flag f;
    
    for (f = 0; f < ns_f_max; f++) {
      char *N = "???";
      u_int16_t val = ns_msg_getflag(parsed_answer,f);
      
      switch(f) {
      case ns_f_qr:      N="Question/Response";    break;
      case ns_f_opcode:  N="Operation Code";       break;
      case ns_f_aa:      N="Authoritative Answer"; break;
      case ns_f_tc:      N="Truncation Occurred";  break;
      case ns_f_rd:      N="Recursion Desired";    break;
      case ns_f_ra:      N="Recursion Available";  break;
      case ns_f_z:       N="Must Be Zero";         break;
      case ns_f_ad:      N="Authentic Data (DNSSEC)"; break;
      case ns_f_cd:      N="Checking Disabled (DNSSEC)"; break;
      case ns_f_rcode:   N="Response Code";        break;
      }
      printf("%s %u\n",N,(unsigned)val);    
    }

  }
  
#endif
  

  
  for (sect = 0; sect < ns_s_max; sect++) {
    int count = ns_msg_count(parsed_answer,sect);
    int recnum;

    if (count < 1)
      continue;

    printf("%s %s section %d",t,name,sect);

    switch(sect) {
    case ns_s_qd: printf(" question"); break;
    case ns_s_an: printf(" answer"); break;
    case ns_s_ns: printf(" name servers"); break;
    case ns_s_ar: printf(" additional records"); break;
    }
    printf(":\n");

    for (recnum = 0; recnum < count; recnum++) {
      char   * recname = NULL;
      ns_class recclass;
      ns_type rectype;
      unsigned int ttl;
      ns_rr   answer_record;
      const unsigned char * walk_ptr;
      int                   size_left;
  
      errno = 0;
      r = ns_parserr(&parsed_answer,sect,recnum,&answer_record);
      if (r < 0) {
	int err = errno;

	fprintf (stderr,
		 "%s %s: section %d, record %d: failed to parse answer",
		 t,name,sect,recnum);

	if (0 != err) {
	  fprintf(stderr," errno=%d %s",err,strerror(err));
	}
	
	fprintf(stderr, "\n");
	continue;
      }

      recname  = ns_rr_name(answer_record);
      recclass = ns_rr_class(answer_record);
      rectype   = ns_rr_type(answer_record);
      ttl       = ns_rr_ttl(answer_record);
      walk_ptr  = ns_rr_rdata(answer_record);
      size_left = ns_rr_rdlen(answer_record);

      printf ("#%d: ",recnum);

      if (recname) {
	printf(" name=%s", recname);
      }

      printf(" class=%d", recclass);

      switch(recclass) {
      case ns_c_in:
	printf(" internet");
	break;
      }

      if (ttl) {
	printf(" ttl=%u",ttl);
      }

      printf(" type=%d",
	     rectype);

      switch(rectype) {
	union {
	  struct in_addr  ip4addr;
	  struct in6_addr ip6addr;
	  
	  unsigned char buffer[16];
	} X;
	int n;

      case ns_t_a:
	printf(" IPv4 address");

	if (size_left >= sizeof (X.ip4addr)) {
	  char address[256];
	  const char *addr;

	  memcpy(X.buffer,walk_ptr,sizeof (X.ip4addr));

	  walk_ptr  += sizeof (X.ip4addr);
	  size_left -= sizeof (X.ip4addr);

#ifdef USE_INET_XTOX_PN
	  addr = inet_ntop(AF_INET,& (X.ip4addr),
			   address,sizeof address);

#else
	  addr = inet_ntoa(X.ip4addr);
#endif


	  if (addr) {
	    printf(" = %s",addr);
	  }
	}

	break;
      case ns_t_ns:
	printf(" name server");
	
	if (size_left > 0) {
	  char domain_name[1024];
	  int compressed_len;

	  errno = 0;
	  compressed_len = 
	    ns_name_uncompress(ns_msg_base(parsed_answer),
			       ns_msg_end(parsed_answer),
			       walk_ptr,
			       domain_name,
			       sizeof domain_name);

	  if (compressed_len < 0) {
	    printf(", failed to expand name");
	    break;	    
	  }

	  walk_ptr  += compressed_len;
	  size_left -= compressed_len;

	  printf(" = %s",domain_name);	 
	}


	break;
      case ns_t_cname:
	printf(" canonical name");

	if (size_left > 0) {
	  char domain_name[1024];
	  int compressed_len;

	  errno = 0;
	  compressed_len = 
	    ns_name_uncompress(ns_msg_base(parsed_answer),
			       ns_msg_end(parsed_answer),
			       walk_ptr,
			       domain_name,
			       sizeof domain_name);

	  if (compressed_len < 0) {
	    printf(", failed to expand name");
	    break;	    
	  }

	  walk_ptr  += compressed_len;
	  size_left -= compressed_len;

	  printf(" = %s",domain_name);	 
	}

	break;
      case ns_t_mx:
	printf(" mail handler");

	if (size_left > 2) {
	  int precedence;
	  char domain_name[1024];
	  int compressed_len;

	  precedence = ns_get16(walk_ptr);
	  walk_ptr  += 2;
	  size_left -= 2;

	  compressed_len = 
	    ns_name_uncompress(ns_msg_base(parsed_answer),
			       ns_msg_end(parsed_answer),
			       walk_ptr,
			       domain_name,
			       sizeof domain_name);

	  if (compressed_len < 0) {
	    printf(", failed to expand name");
	    break;	    
	  }

	  walk_ptr  += compressed_len;
	  size_left -= compressed_len;

	  printf(" = %s precedence=%d",domain_name,precedence);	 
	}

	break;
#ifdef HAVE_IN6
      case ns_t_aaaa:
	printf(" IPv6 address");

	if (size_left >= sizeof (X.ip6addr)) {
	  char address[256];
	  const char *addr;

	  memcpy(X.buffer,walk_ptr,sizeof (X.ip6addr));
	  
	  walk_ptr  += sizeof (X.ip6addr);
	  size_left -= sizeof (X.ip6addr);

#ifdef USE_INET_XTOX_PN	  
	  addr = inet_ntop(AF_INET6,& (X.ip6addr),
			   address,sizeof address);
	  
	  if (addr) {
	    printf(" = %s",addr);
	  }
#endif
	}

	break;
#endif

      case ns_t_txt:
	printf(" text record");

	n = 0;
	while (size_left > 0) {
	  char text[256];

	  int len =  *walk_ptr;

	  if (len > size_left + 1) {
	      printf(", failed to read text record");
	      break;
	  }

	  walk_ptr ++;
	  size_left --;

	  memcpy(text,walk_ptr,len);
	  text[len] = '\0';

	  walk_ptr   += len;
	  size_left -= len;

	  if (n++ > 0) {
	    printf(",\n text record");
	  }

	  printf(" = %s",text);
	}

	break;

      case ns_t_srv:
	printf(" server");

	if (size_left > 6) {
	  int priority, weight, port;
	  char domain_name[1024];
	  int compressed_len;
	  
	  priority = ns_get16(walk_ptr);
	  walk_ptr  += 2;
	  size_left -= 2;
	  
	  weight = ns_get16(walk_ptr);
	  walk_ptr  += 2;
	  size_left -= 2;
	  
	  port = ns_get16(walk_ptr);
	  walk_ptr  += 2;
	  size_left -= 2;
	  
	  compressed_len = 
	    ns_name_uncompress(ns_msg_base(parsed_answer),
			       ns_msg_end(parsed_answer),
			       walk_ptr,
			       domain_name,
			       sizeof domain_name);
	  
	  if (compressed_len < 0) {
	    printf(", failed to expand name");
	    break;	    
	  }
	  
	  walk_ptr  += compressed_len;
	  size_left -= compressed_len;
	  
	  printf(" = %s priority=%d  weight=%d port=%d",
		 domain_name,priority,weight,port);
	}
	break;

      case ns_t_ptr:
	printf(" domain name");

	if (size_left > 0) {
	  char domain_name[1024];
	  int compressed_len;

	  errno = 0;
	  compressed_len = 
	    ns_name_uncompress(ns_msg_base(parsed_answer),
			       ns_msg_end(parsed_answer),
			       walk_ptr,
			       domain_name,
			       sizeof domain_name);

	  if (compressed_len < 0) {
	    printf(", failed to expand name");
	    break;	    
	  }

	  walk_ptr  += compressed_len;
	  size_left -= compressed_len;

	  printf(" = %s",domain_name);	 
	}


	break;
      }

      if (0 != size_left) {
	printf(", %d trailing bytes",size_left);
      }

      printf("\n");
    }
    
  }
  
  exit(0);
}
