case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    regarg=
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    regarg="-A \"$source_dir/$subdir/\""
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

# libelmme-tls.so my be loaded with program, which do not have
# linked with libelmme-XXXX.so. On that case loading failed
# with unresolved symbols. Therefore we link libelmme-tls.so
# with libelmme-XXXX.so. If loading program is linked with
# libelmme-tls.so, that do not cause that libelmme-mailer.so
# is linked twice on run time.
#
libxs="../../shlib/libelmme-mbox.so ../../shlib/libelmme-addr.so"

# If it is not possible to resolve mail program symbols from
# dynamic library, link libelmme-tls.so with libelmme-base.so

if $test $d_dynamic_main = "$define" ; then
	   : 
else
	libxs="$libxs ../../shlib/libelmme-base.so"
fi

echo "Extracting shared_libs/tls/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.15 2020/05/31 11:57:36 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
#                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-tls.so$d_shared_rev
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
LIB		=	\$(ELM_ROOT)//$lib
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
LIBXS           =       $libxs
$vpathdef
REGARG		=	$regarg
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

A=
if $test "$soname_include_path" = y ; then
	A="$shlib/"
fi

cat >>Makefile <<SUBSTITUTE
SONAME          = ${soname_opt}${A}libelmme-tls.so$d_shared_rev
SUBSTITUTE

if $test "$tls_lib_dir" != ""; then
    $cat >>Makefile <<EOS
LIBDIRLIST      =  -L$tls_lib_dir $rpath_opt$tls_lib_dir
EOS
else
    cat >>Makefile <<'EOX'
LIBDIRLIST      =
EOX
fi

if $test "$tls_include_dir" != "" ; then
    $cat >>Makefile <<EOS
INCDIRLIST      = -I$tls_include_dir
EOS
else
    $cat >>Makefile <<'EOX'
INCDIRLIST      =
EOX

fi
$cat >>Makefile <<'!NO!SUBS!'
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) -I$(IHDR2) \
 -I$(INCLDIR2) -I. $(INCDIRLIST) $(CCFLAGS) $(OPTIMIZE)
# -I. is required for tlsconf.h
INCLDIR		=	$(SRCROOT)/shared_libs/include
INCLDIR2	=	$(SRCROOT)/hdrs
IHDR		=	../include
IHDR2		=	../../hdrs
OBJS            =       pop.o tls.o imap.o smtp.o remote.o
REG             =       ../../bin/elmregister -M tls $(REGARG)

all:	Makefile libtls.a ../../shlib/libelmme-tls.so
install_s: all $(INSTLIB) $(LIB)/elmrc-tls-info

uninstall_s:
	$(REG) rm $(INSTLIB) $(LIB)/elmrc-tls-info

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-tls.so libtls.a

.PRECIOUS: $(IHDR)/elmshared.h o$(IHDR2)/elm_defs.h $(IHDR2)/defs_major.h

$(IHDR)/elmshared.h: $(IHDR2)/elm_defs.h $(INCLDIR2)/patchlevel.h \
 $(INCLDIR)/shared.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/elm_defs.h: $(IHDR2)/defs_major.h $(INCLDIR2)/elm_nl_types.h \
 $(INCLDIR2)/hdrs/elmlib.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/defs_major.h: ../../config.h $(IHDR2)/sysdefs.h 
	-$(CHMOD) -f +w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

tlsconf.h: tlsconf.h.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

../../config.sh config.res:
	@echo "You must run 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

elmtls.h: $(INCLDIR)/elmshared.h $(INCLDIR2)/ss_imp.h \
  $(INCLDIR2)/connection_imp.h $(INCLDIR2)/mbx_imp.h \
  $(INCLDIR2)/mboxlib.h $(INCLDIR2)/s_tls.h \
  $(INCLDIR2)/schedule_time.h tlsconf.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

pop.o: elmtls.h
tls.o: elmtls.h $(INCLDIR2)/save_opts.h $(INCLDIR2)/rc_imp.h
imap.o: elmtls.h
smtp.o: elmtls.h $(INCLDIR)/shared_smtp.h
remote.o: elmtls.h


libtls.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

../../shlib/libelmme-tls.so: $(OBJS) $(LIBXS)
	$(CC) $(LFLAGS) $(LIBDIRLIST) $(SONAME) -o $@ $(OBJS) \
 $(LIBXS) -lssl -lcrypto 

$(INSTLIB): ../../shlib/libelmme-tls.so
	$(REG) copy -m 644 $? $@

$(LIB)/elmrc-tls-info: elmrc-tls-info
	$(REG) copy -m 444 $? $@

!NO!SUBS!

for i in $headers 
do
	cat >>Makefile <<!SUBS!
copy_$i:    \$(INCLDIR2)/$i
		cmp \$? \$(IHDR2)/$i 2>/dev/null || \$(CP) \$? \$(IHDR2)/$i

!SUBS!
done
