static char rcsid[] = "@(#)$Id: smtp.c,v 2.12 2022/02/12 14:00:07 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmtls.h"
#include "shared_smtp.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

DEBUG_VAR(Debug,__FILE__,"tls");

#ifdef REMOTE_MBX

S_(smtp_ext_handler smtp_STARTTLS_handler)
static  int smtp_STARTTLS_handler P_((struct smtp_info *mailer_info,
				      char * ext,
				      char * ext_args,
				      size_t mailer_info_size,
				      struct smtp_callbacks *cb, 
				      size_t cb_size,
				      struct SE_option   *service_config,
				      size_t sc_size,
				      enum CAPA_phase *phase));
static  int smtp_STARTTLS_handler(mailer_info,ext,ext_args,mailer_info_size,
				  cb,cb_size,service_config,sc_size,phase)
     struct smtp_info      * mailer_info;
     char                  * ext;
     char                  * ext_args;
     size_t                  mailer_info_size;
     struct smtp_callbacks * cb;
     size_t                  cb_size;
     struct SE_option      * service_config;
     size_t                  sc_size;
     enum CAPA_phase       * phase;
{
    union stream_types T;   

    int ret = 1;
    enum tls_version tls =
	give_dt_enumerate_as_int(&default_tls_version);
    const char * tls_config = "default-tls-version";
    int bits;
    char response_code[4];
    char * proto_string = NULL;

    
    if (! StreamOK(sizeof (struct stream_type))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: sizeof (struct stream_type) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }


    if (mailer_info_size != sizeof (*mailer_info)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: sizeof (struct smtp_info) = %d != %d\n",
			sizeof (*mailer_info),mailer_info_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (cb_size != sizeof (*cb)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: sizeof (struct smtp_callbacks) = %d != %d\n",
			sizeof (*cb),cb_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: sizeof (struct struct SE_option) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }
    
    if (!remote_account_OK (sizeof (mailer_info->RA))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: sizeof (struct remote_account) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (!tls_init(NULL)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:smtp_STARTTLS_handler: Initialization failed\n"));
	goto fail;
    }

    StreamInfo(mailer_info->RA.stream,SS_ssf,&bits,NULL,NULL);
    if (bits > 0) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:smtp_STARTTLS_handler: Already %d 'bits' encryption -- TLS already active?\n",
			bits));
	goto fail;
    }   

    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"smtp_STARTTLS_handler",
		  "Bad option storage",0);
	}
	
	if (0 != (service_config->value->flags & TLS_starttls)) {
	    tls        = service_config->value->v_starttls;
	    tls_config = "tls:starttls-version";

	} else if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:smtp_STARTTLS_handler: starttls disabled by use-tls\n"));
	    goto fail;
	    
	} else if (0 != (service_config->value->flags & TLS_tls)) {
	    tls = service_config->value->v_tls;
	    tls_config = "tls:tls-version";	    
	}

	if (tls_none == tls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:smtp_STARTTLS_handler: tls disabled\n"));
	    goto fail;
	}
	
    } else {

	DPRINT(Debug,10,(&Debug,			    
			 "tls:smtp_STARTTLS_handler: no mail services config\n"));
	
	if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:imap_STARTTLS_handler: starttls disabled by use-tls\n"));
	    goto fail;
	    
	} 		
    }


    DPRINT(Debug,4,(&Debug,			    
		    "tls:smtp_STARTTLS_handler: version: %d",tls));
    switch(tls) {
    case tls_none: DPRINT(Debug,4,(&Debug, " tls_none")); break;
    case v_ssl:    DPRINT(Debug,4,(&Debug, " v_ssl"));    break;
    case v_tls:    DPRINT(Debug,4,(&Debug, " v_tls"));    break;
    case v_tls1:   DPRINT(Debug,4,(&Debug, " v_tls1"));   break;
    case v_tls1_1: DPRINT(Debug,4,(&Debug, " v_tls1_1")); break;
    case v_tls1_2: DPRINT(Debug,4,(&Debug, " v_tls1_2")); break;
    case NUM_tls_version: DPRINT(Debug,4,(&Debug, " NUM_tls_version")); break;
    }
    DPRINT(Debug,4,(&Debug,"\n"));

    if (!tls_version_supported(tls_config,tls)) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:smtp_STARTTLS_handler: tls version not supported\n"));
	goto fail;            /* Just fail ... */		
    }
    
    if (!cb->start_command(mailer_info,"STARTTLS")) {
	cb->command_reset(mailer_info);
	goto fail;            /* Just fail ... */
    }
    cb->command_ready(mailer_info,0);  /* Command do not have arguments */

    if (!cb->command_ok(mailer_info,response_code)) {
	if (response_code[0]) {
	    int idx = 0;
	    const char * r = 
		cb->command_response(mailer_info,&idx);
	    
	    if (r) {
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsRejectedStartls,
				  "%S server rejected STARTTLS with %3.3s %s"),
			  cb->Server(mailer_info),
			  response_code,r);

		while (NULL != (r = 
				cb->command_response(mailer_info,
						     &idx))) {
		    lib_error(CATGETS(elm_msg_cat, TlsSet,
				      TlsServerMsg,
				      "%S server: %s"),
			      cb->Server(mailer_info),
			      r);
		}
	    }
	}
	
	cb->command_reset(mailer_info);
	goto fail;            /* Just fail ... */
    }

    if (0 != memcmp(response_code,"220",3)) {
	DPRINT(Debug,5,(&Debug,
			 "tls:smtp_STARTTLS_handler: not expected response code: %.3s\n",
			response_code));

	ret = 0;  /* Hard failure -- not sure if connection is useful */
	goto fail;
    }

    cb->command_reset(mailer_info);
    
    /* After that we need need return failure if something
       goes wrong because connection is messed beyond repair
    */

    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = 0;
	goto fail;
    }
    if (tls >= 0 && tls < NUM_tls_version) {
	proto_string = elm_message(FRM("%S/%s"),
				   cb->Server(mailer_info),
				   TLS_VERSION[tls]);
    } else {
	proto_string = elm_message(FRM("%S/TLS?"),
				   cb->Server(mailer_info));
	
    }

    if (!ra_wrap_tls(& (mailer_info->RA),
		     T,
		     proto_string,
		     phase)) {
	ret = 0;
	goto fail;
    }
 
   
 fail:
    if (proto_string) {
	free(proto_string);
	proto_string = NULL;
    }

    DPRINT(Debug,10,(&Debug,			    
		     "tls:smtp_STARTTLS_handler=%d\n",
		     ret));

    
    return ret;
}

static struct provides_shared_SMTP_EXT LIST[] = {
  { "STARTTLS", 1, smtp_STARTTLS_handler },
};

#ifdef ANSI_C
provides_shared_SMTP_EXT_f provides_shared_SMTP_EXT;
#endif
struct provides_shared_SMTP_EXT  *  provides_shared_SMTP_EXT(count,s_size)
     int *count; 
     size_t *s_size;
{
    *s_size = sizeof (LIST[0]);

    *count = (sizeof LIST) / *s_size;

    return &(LIST[0]);
}


#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
