static char rcsid[] = "@(#)$Id: a_edit.c,v 2.6 2014/07/14 15:07:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/a_edit.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is for allowing the user to edit their .elm/elmaliases
    as they wish. 

**/

#include "def_elm.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

int edit_aliases_text(aview, page, LOC)
     struct AliasView *aview;
     struct menu_context *page;
     struct screen_parts *LOC;
{

    /** Allow the user to edit their aliases text, always resynchronizing
	afterwards.   This routine calls the function edit_a_file()
	to do the actual editing.  Thus editing is done the same
	way here as in mailbox editing.
	
	We will ALWAYS resync on the aliases text file
	even if nothing has changed since, not unreasonably, it's
	hard to figure out what occurred in the edit session...
    **/

    const char *edited_file = NULL;

    if (! start_edit_aliases(aview,&edited_file))
	return 0;

    menu_Write_to_screen(LOC->prompt_page,
			 CATGETS(elm_msg_cat, AliasesSet, AliasesEdit,
				 "Edit %s..."), 
			 edited_file);
    FlushBuffer();

    if (edit_a_file(edited_file,page) == 0) {
	return (0);
    }


    /*
     *	Redo the hash table...always!
     */
    
    
    end_edit_aliases(aview);
    
    /*
     *	clear any limit in effect.
     */

    set_alias_selected(aview,0);
    
    menu_trigger_redraw(LOC->header_page);
    menu_trigger_redraw(LOC->title_page); 

    return(1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
