static char rcsid[] = "@(#)$Id: alias_display.c,v 2.19 2022/06/26 16:55:21 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.19 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_elm.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str)
     char *str;
{
    return (unsigned char *)str;
}


struct menu_anon_param {
    struct alias_buffer *alias_buffer;

};

enum { alias_info_mp_param,
       alias_info_mp_COUNT };

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


S_(subpage_simple_redraw sb_update_alias_info_title)
static int sb_update_alias_info_title(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    menu_ClearScreen(ptr);

    menu_StartXX(ptr,pg_BOLD);
    menu_print_format_center(ptr,0,
			     CATGETS(elm_msg_cat, AliasesSet, AliasesInfoTitle,
				     "Alias info"));
    menu_EndXX(ptr,pg_BOLD);

    return 1;   /* title completed */
}

S_(subpage_simple_redraw sb_update_alias_info_menu)
static int sb_update_alias_info_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    menu_ClearScreen(ptr);

    menu_print_format_center(ptr,0,
			     CATGETS(elm_msg_cat, AliasesSet, 
				     AliasesInfoMenu1,
				     "Enter letter or go to i)ndex; Press RETURN to save changes."));

    menu_print_format_center(ptr,1,
			     CATGETS(elm_msg_cat, AliasesSet, 
				     AliasesInfoMenu2,
				     "Select alias type: p)erson, g)roup, address l)ist"));

    return 1;   /* menu completed */
}


struct string * display_list_members(group_vector,len)
     const struct alias_vector * group_vector;
     int len;
{
    struct string * ret = NULL;

    struct display_list_state * state =
	display_list_iterator_alloc_aliases(group_vector);

    ret = genlist_display_list_string(state,len);
    
    display_list_iterator_free(&state);

    if (ret) {
	DPRINT(Debug,9, (&Debug, "display_list_members=%S\n",
			 ret));
    }
    
    return ret;
}


struct string * display_list_addrs(address_list,len)
     const struct addr_list * address_list;
     int len;
{
    struct string * ret = NULL;

    struct display_list_state * state = 
	display_list_iterator_alloc_addrs(address_list);


    ret = genlist_display_list_string(state,len);

    display_list_iterator_free(&state);

    if (ret) {
	DPRINT(Debug,9, (&Debug, "display_list_addrs=%S\n",
			 ret));
    }

    return ret;
}

S_(subpage_simple_redraw sb_update_alias_info_part)
static int sb_update_alias_info_part P_((struct menu_context  *ptr,
					 struct menu_param *list));
static int sb_update_alias_info_part(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{

    struct menu_anon_param *A = mp_lookup_anon(list,alias_info_mp_param);
    int line = 0;

    int LINES, COLUMNS;

    menu_get_sizes(ptr, &LINES, &COLUMNS);

    menu_ClearScreen(ptr);

    if (A->alias_buffer) {
	const struct string *key = alias_buffer_key(A->alias_buffer);
	const struct address_alias * value = 
	    alias_buffer_value(A->alias_buffer);

	if (key)
	    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoAliasName,
					     "A)lias name     : %S"),
			  key);
	else
	    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoAliasNameNone,
					     "A)lias name     : <none>"));
	line++;
	    

	if (value) {
	    const struct string * comment = address_alias_get_comment(value);

	    const struct string     *firstn   = NULL;
	    const struct string     *lastn    = NULL;
	    const struct address    *address  = NULL;
	
	    const struct alias_vector    * group_vector = NULL;
	    const struct string          * group_phrase = NULL;

	    const struct addr_list * address_list = 
		address_alias_get_list(value);
		
	    if (comment)
		menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoAliasComment,
						 "Alias c)omment  : %S"),
			      comment);
	    else
		menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoAliasCommentNone,
						 "Alias c)omment  : <none>"));
		

	    line++;

	    if (address_alias_get_person(value,&firstn,&lastn,&address)) {

		menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoPersonAlias,
						 "Person alias:"));

		line++;

		if (firstn)
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoFirstName,
						     "   F)irst name  : %S"),
				  firstn);
		else
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoFirstNameNone,
						     "   F)irst name  : <none>"));
		    
		line++;

		if (lastn)
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoLastName,
						     "   L)ast name   : %S"),
				  lastn);
		else
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoLastNameNone,
						     "   L)ast name   : <none>"),
				  lastn);

		line++;


		if (address) {
		    /* Address should always exist for person alias */

		    if (address_is_empty(address)) {

			menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
							 AliasesInfoAddressNone,
							 "   Add(r)ess    : <none>"));


		    } else {
			
		    struct string * buffer = new_string(display_charset);

		    display_add_one_address(&buffer,address);

		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoAddress,
						     "   Add(r)ess    : %S"),
				  buffer);
		   
		    free_string(&buffer);

		    }
		    
		    line++;
		    
		} 
	    }

	    
	    if (address_alias_get_group(value,&group_phrase,&group_vector)) {

		menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoAliasGroup,
						 "Alias group:"));

		line++;
		    
		if (group_phrase)
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoPhrase,
						     "   P)hrase      : %S"),
				  group_phrase);
		else if (alias_group_phrase)
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoPhraseNone,
						     "   P)hrase      : <none>"));
		    
		line++;

		if (group_vector) {
		    /* group vector should always exist for group alias */

		    struct display_list_state * state = 
			display_list_iterator_alloc_aliases(group_vector);
		    
		    struct string * prefix = 
			format_string(CATGETS(elm_msg_cat, AliasesSet, 
							 AliasesInfoMembers,
					      "   M)embers     : "));
				      

		    if (! genlist_display_list(ptr,prefix,
					       &line,3,state))	 
			menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
							 AliasesInfoMembersEmpty,
							 "   M)embers     : <empty>"));
		  
		    line++;		     

		    free_string(&prefix);
		    display_list_iterator_free(&state);
		} 
	    }
	    
	    if (address_list) {
		struct display_list_state * state = 
		    display_list_iterator_alloc_addrs(address_list);

		struct string * prefix = 
		    format_string(CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesInfoListAddr,
					  "   Addresse(s)  : "));

		menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoListAlias,
						 "List alias:"));
		line++;

		if (! genlist_display_list(ptr,prefix,
					   &line,0,state))	 
		    menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						     AliasesInfoListAddrEmpty,
						     "   Addresse(s)  : <no addresses>"));
		
		line++;	

		free_string(&prefix);
		display_list_iterator_free(&state);
	    }	    
	}

    } else {

	menu_PutLineX(ptr,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesInfoAliasNameNone,
					 "A)lias name     : <none>"));

	line++;
    }


    return 1;   /* info completed */
}

static void ad_set_alias_info_screen P_((struct menu_context  *page, 
				      struct screen_parts *LOC,
				      struct menu_param  *LIST));
static void ad_set_alias_info_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts *LOC;
     struct menu_param  *LIST;    
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* Title part */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,2,sb_update_alias_info_title,
					   LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,2);


    /* Info part */

    if (! LOC->header_page)
	LOC->header_page = new_menu_subpage(page,2,LINES-8,
					    sb_update_alias_info_part,LIST);
    else
	menu_subpage_relocate(LOC->header_page,page,2,LINES-8);


    /* Menu part */

    /* Command line option -m (!mini_menu) does not disable
       menu on here
    */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-6,2);
    else if ( /* mini_menu && */ LINES > 14) 
	LOC->menu_page = new_menu_subpage(page,LINES-6,2,
					  sb_update_alias_info_menu,LIST);

    /* Prompt part */

    if (LOC->prompt_page)
	menu_subpage_relocate(LOC->prompt_page,page,LINES-4,4);
    else 
	LOC->prompt_page = new_menu_subpage(page,LINES-4,4,
					    subpage_simple_noredraw,LIST);
}


static void check_alias_info_screen P_((struct screen_parts *LOC,
				   struct menu_param *list));
static void check_alias_info_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    /* Title area */

    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_alias_info_title(LOC->title_page,list);
    }

    /* Menu area */

    if (LOC->menu_page) {

	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw\n"));
	    sb_update_alias_info_menu(LOC->menu_page,list);
	}

    }

    /* Prompt area */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	DPRINT(Debug,7, (&Debug, "prompt page redraw\n"));
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }

    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));

	menu_trigger_redraw(LOC->header_page);
    }

    if (menu_need_redraw(LOC->header_page)) {

	DPRINT(Debug,7, (&Debug, "info page redraw\n"));

	sb_update_alias_info_part(LOC->header_page,list);
    }
}

/* ------------------------------------------------------------------------- */

static int ad_set_alias_name P_((struct alias_buffer *buffer,
			       struct menu_context  *page,
			       struct screen_parts  *LOC));
			       
static int ad_set_alias_name(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;

    struct string * alias_name = NULL;
    const struct string *key   = alias_buffer_key(buffer); 
    int delay_redraw = 0;
    int code;
    int line;

    if (key)
	alias_name = dup_string(key);	

 redraw:
    menu_MoveCursor(LOC->prompt_page,1,0);
    menu_CleartoEOS(LOC->prompt_page);

    /* FIXME --optionally_enter*  should use prompt_page */
    line = menu_GetAbsLine(LOC->prompt_page,1);

    code = optionally_enter2(page,
			     &alias_name,
			     line,0,
			     OE_APPEND_CURRENT|OE_REDRAW_MARK|
			     OE_SIG_CHAR /* Ctrl-C */,
			     CATGETS(elm_msg_cat, AliasesSet,
				     AliasesPromptAliasName,
				     "Alias name: "));

    if (REDRAW_MARK == code ||
	('L'&31)    == code) {
	menu_ClearScreen(page);   /* Clear possible redraw mark */
	
	/* Call refresh routines of children */
	menu_redraw_children(page);
	
	if (menu_need_redraw(LOC->prompt_page))
	    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	
	/* NOTICE: using menu_trigger_redraw(page) on here
	   may cause redraw loop!
	*/

	delay_redraw++;
	goto redraw;
    }

    if (0 == code && alias_name) {
	set_alias_buffer_key(buffer,alias_name);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	ret = 1;
    }		
        
    if (alias_name)
	free_string(&alias_name);
    
    if (delay_redraw)
	menu_trigger_redraw(page);    

    DPRINT(Debug,10, (&Debug, "ad_set_alias_name=%d\n",
		     ret));

    return ret;
}			       


/* ------------------------------------------------------------------------- */

static int ad_set_person_alias P_((struct alias_buffer *buffer,
			       struct menu_context  *page,
			       struct screen_parts  *LOC));
			       
static int ad_set_person_alias(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;

    int delay_redraw = 0;
    int line;

    if (value) {
	int code = 0;

	const struct string *firstn   = NULL;
	const struct string *lastn    = NULL;
	const struct address       *address  = NULL;

	struct string * address_string    = NULL;
	
	if (address_alias_get_person(value,&firstn,&lastn,&address)) {
	    
	    if (firstn && lastn)
		menu_PutLineX (LOC->prompt_page,1, 0,
			       CATGETS(elm_msg_cat, AliasesSet,
				       AliasesIsPersonAliasFor,
				       "Is a person alias for %S %S"),
			       firstn,lastn);
	    else
		menu_PutLineX (LOC->prompt_page,1, 0,
			       CATGETS(elm_msg_cat, AliasesSet,
				       AliasesIsPersonAlias,
				       "Is a person alias"));
	    FlushBuffer();
	    
	    return 0;
	}
	
    redraw1:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);
	
	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &address_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesPersonAliasAddress,
					 "Address for person alias: "));
	
	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */

	    delay_redraw++;
	    goto redraw1;
	}
	
	if (0 == code && address_string) {
	    
	    struct address *address1 = 
		parse_one_string_address(address_string,
					 unq_can_print_error,
					 NULL,0,NULL);
	    if (address1) {
		new_value = dup_address_alias(value);
		
		set_person_address_alias(new_value,
					 firstn,lastn,address1);
	    }
	}			     


	if (address_string)
	    free_string(&address_string);

    } else {  /* Not a alias available */
	int code = 0;	
	struct string * address_string    = NULL;

    redraw2:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);

	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);
	
	code = optionally_enter2(page,
				 &address_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesPersonAliasAddress,
					 "Address for person alias: "));
	
	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */

	    delay_redraw++;
	    goto redraw2;
	}

	if (0 == code && address_string) {
	    
	    struct address *address1 = 
		parse_one_string_address(address_string,
					 unq_can_print_error,
					 NULL,0,NULL);

	    if (address1) {
		new_value = new_person_address_alias(NULL,NULL,NULL,address1);
		free_address(&address1);
	    }
	}		            

	if (address_string)
	    free_string(&address_string);
    }

    if (new_value) {

	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }

    if (delay_redraw)
	menu_trigger_redraw(page);

    DPRINT(Debug,10, (&Debug, "ad_set_person_alias=%d\n",
		      ret));

    return ret;
}

static int ad_set_alias_comment P_((struct alias_buffer *buffer,
			       struct menu_context  *page,
			       struct screen_parts  *LOC));
			       
static int ad_set_alias_comment(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value     = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {
	int code = 0;
	const struct string *comment  = address_alias_get_comment(value);
	
	struct string *new_comment  = NULL;

	if (comment)
	    new_comment = dup_string(comment);

    redraw:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);
	
	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &new_comment,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesCommentPrompt,
					 "Comment for alias: "));
	
	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */
	    
	    delay_redraw++;
	    goto redraw;
	}

	if (0 == code && new_comment) {
	    new_value = dup_address_alias(value);
	    
	    set_alias_comment(new_value,new_comment);
	}

	if (new_comment)
	    free_string(& new_comment);

    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));

    }

    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);	
	ret = 1;
    }

    if (delay_redraw)
	menu_trigger_redraw(page);

    DPRINT(Debug,10, (&Debug, "ad_set_alias_comment=%d\n",
		      ret));

    return ret;	
}

static int ad_set_alias_first_name P_((struct alias_buffer *buffer,
			       struct menu_context  *page,
			       struct screen_parts  *LOC));			       
static int ad_set_alias_first_name(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value     = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {
	const struct string *firstn   = NULL;
	const struct string *lastn    = NULL;
	const struct address       *address  = NULL;

	if (address_alias_get_person(value,&firstn,&lastn,&address)) {
	    int code = 0;

	    struct string *new_firstn  = NULL;

	    if (firstn)
		new_firstn = dup_string(firstn);

	redraw:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);

	    code = optionally_enter2(page,
				     &new_firstn,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesFirstNamePrompt,
					     "First name for person alias: "));
	
	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw;
	    }

	    if (0 == code && new_firstn) {
		new_value = dup_address_alias(value);

		if (!address) {
		    struct address  * addr1      = new_address(NULL,NULL,NULL);

		    DPRINT(Debug,1, (&Debug, 
				     "ad_set_alias_first_name: No address!  FIXUP\n"));

		    set_person_address_alias(new_value,new_firstn,lastn,addr1);

		    free_address(&addr1);

		} else
		    set_person_address_alias(new_value,new_firstn,lastn,address);
	    }

	    if (new_firstn)
		free_string(& new_firstn);

	
	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNotPersonAlias,
			      "Not a person alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }
    
    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);		
	ret = 1;
    }

    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_alias_first_name=%d\n",
		      ret));

    return ret;
}

static int ad_set_alias_last_name P_((struct alias_buffer *buffer,
			       struct menu_context  *page,
			       struct screen_parts  *LOC));			       
static int ad_set_alias_last_name(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);

    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {

	const struct string *firstn   = NULL;
	const struct string *lastn    = NULL;
	const struct address       *address  = NULL;

	if (address_alias_get_person(value,&firstn,&lastn,&address)) {
	    int code = 0;

	    struct string *new_lastn  = NULL;

	    if (lastn)
		new_lastn = dup_string(lastn);

	redraw:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);

	    code = optionally_enter2(page,
				     &new_lastn,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesLastNamePrompt,
					     "Last name for person alias: "));
	
	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw;
	    }

	    if (0 == code && new_lastn) {
		new_value = dup_address_alias(value);


		if (!address) {
		    struct address  * addr1      = new_address(NULL,NULL,NULL);

		    DPRINT(Debug,1, (&Debug, 
				     "ad_set_alias_last_name: No address!  FIXUP\n"));

		    set_person_address_alias(new_value,firstn,new_lastn,addr1);

		    free_address(&addr1);
		} else
		    set_person_address_alias(new_value,firstn,new_lastn,address);
	    }

	    if (new_lastn)
		free_string(& new_lastn);

	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNotPersonAlias,
			      "Not a person alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }
    
    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);		
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_alias_last_name=%d\n",
		      ret));
    
    return ret;
}

static int ad_set_alias_person_address P_((struct alias_buffer *buffer,
					    struct menu_context  *page,
					    struct screen_parts  *LOC));
static int ad_set_alias_person_address(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    
    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {
	const struct string *firstn   = NULL;
	const struct string *lastn    = NULL;
	const struct address       *address  = NULL;

	if (address_alias_get_person(value,&firstn,&lastn,&address)) {
	    int code = 0;

	    struct string *new_address  = NULL;

	    if (address) { 
		if (address_is_empty(address))
		    new_address = new_string(display_charset);
		else
		    new_address = address_to_string(address);
	    }

	redraw:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);

	    code = optionally_enter2(page,
				     &new_address,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesPersonAddressPrompt,
					     "Address for person alias: "));
	    

	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw;
	    }

	    if (0 == code && new_address) {
		struct address *address1 = 
		    parse_one_string_address(new_address,
					     unq_can_print_error,
					     NULL,0,NULL);
		if (address1) {
		    new_value = dup_address_alias(value);
		    
		    set_person_address_alias(new_value,
					     firstn,lastn,address1);

		    free_address(&address1);
		}
	    }
	    
	    if (new_address)
		free_string(& new_address);

	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNotPersonAlias,
			      "Not a person alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }
    
    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_alias_person_address=%d\n",
		      ret));

    return ret;
}


/* ------------------------------------------------------------------------ */

static struct string * string_dequote P_((const struct string *orig));
static struct string * string_dequote(orig)
     const struct string *orig;
{
    struct string * res = NULL;
    int len = string_len(orig);
    int i;

    if (len < 2) 
	goto error;
    

    if ( 0x0022 /* " */ != give_unicode_from_string(orig,0) ||
	 0x0022 /* " */ != give_unicode_from_string(orig,len-1)) 
	goto error;
    
    res = new_string(get_string_type(orig));

    for (i = 1; i < len-1; ) {	
	int dummy;
	const uint16 code = give_unicode_from_string(orig,i);

	if (0x005C  /* '\\' */ == code) {
	    if (i < len-2) {
		i++;
		goto add_char;
	    } else
		goto error;
	} else if ( 0x0022 /* " */ == code)
	    goto error;

    add_char:
	
	string_copy_character(&res,orig,&i,1,&dummy); 

    }

    return res;

 error:
    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesDequoteError,
		      "Dequote error for %S"),
	      orig);
    
    if (res)
	free_string(&res);
    
    return NULL;			  
}


/* Return NULL on interrupt or error */
static struct alias_vector *string_to_alias_list P_((
             struct AliasView *aview,
	     struct string *buffer,
	     struct menu_context  *page,
	     struct screen_parts  *LOC));

static struct alias_vector *string_to_alias_list(aview,buffer,page,LOC)
     struct AliasView *aview;
     struct string *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    struct alias_vector * res = NULL;

    struct string_token * tokens = 
	string_tokenize(buffer,TOK_mail);
    int i;
    int delay_redraw = 0;
    int comma = 0;

    if (!tokens)
	return NULL;

    DPRINT(Debug,12, (&Debug, "string_to_alias_list: buffer=%S\n",
		      buffer));

    res = new_alias_vector();

    for (i = 0; tokens[i].token; i++) {
	struct string * tmp = NULL;

	struct aliasview_record * alias = NULL;
	int dummy;

	DPRINT(Debug,12, (&Debug, 
			  "string_to_alias_list: [%d] special = %04x, token = %S\n",
			  i,tokens[i].special,
			  tokens[i].token));


	if (0x0022 /* " */ == tokens[i].special) {
	    /* Quoted aliases are allowed */

	    tmp = string_dequote( tokens[i].token );

	    if (!tmp)
		goto error;

	    comma = 0;
	   
	} else if (0x002C    /* ',' */ == tokens[i].special) {
	 
	    /* Allow space after comma */
	    comma = 1;

	    continue;
	} else if (0x0020   /* SPACE */ == tokens[i].special &&
		   comma) 

	    continue;
	else if (tokens[i].special) {
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesGroupListError,
			      "Bad character %S on alias group list %S"),
		      tokens[i].token,buffer);
	    goto error;		     
	} else {
	    tmp = dup_string( tokens[i].token );

	    comma = 0;
	}	

	
	alias = lookup_alias(aview,tmp,&dummy);

	if (!alias) {

	    do {
		int ch;
				
		ch = prompt_letter(2,"",*def_ans_no,
				   PROMPT_yesno|PROMPT_redraw_mark|
				   PROMPT_ctrlL|PROMPT_cancel,LOC->prompt_page,
				   CATGETS(elm_msg_cat,
					   AliasesSet, AliasesNotFoundAddAnyway,
					   "Alias %S do not found. Add %S to group anyway? (%c/%c) "),
				   tmp,tmp,
				   *def_ans_yes, *def_ans_no);
		
		if (ch == *def_ans_yes) 
		    break;
		else if (ch == *def_ans_no) 
		    goto skip_alias;
		else if (TERMCH_interrupt_char == ch || EOF == ch)
		    goto error;
		else if (ch == ('L'&31) || ch == REDRAW_MARK) {
		    
		    menu_ClearScreen(page);   /* Clear possible redraw mark */
		    
		    /* Call refresh routines of children */
		    menu_redraw_children(page);
		    
		    if (menu_need_redraw(LOC->prompt_page))
			menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		    
		    /* NOTICE: using menu_trigger_redraw(page) on here
		       may cause redraw loop!
		    */
	    	    
		    delay_redraw++;
		    continue;
		}

	    } while (1);

	}
	
	alias_vector_add_alias(res,tmp);


	skip_alias:
	free_string(&tmp);


    }

    free_string_tokenized(&tokens);

    if (delay_redraw)
	menu_trigger_redraw(page);	

    return res;

 error:
    if (res)
	free_alias_vector(&res);

    if (delay_redraw)
	menu_trigger_redraw(page);	

    
    return NULL;
}

static struct string * alias_list_to_string P_((const struct alias_vector *alias_list));
static struct string * alias_list_to_string(alias_list)
     const struct alias_vector *alias_list;
{
    int len = alias_vector_item_count(alias_list);
    int i;
    struct string *ret = NULL;

    for (i = 0; i < len; i++) {
	const struct string * alias = alias_vector_get_alias(alias_list,i);

	if (ret)
	    add_ascii_to_string(ret,s2us(", "));

	if (string_need_quote(alias))
	    append_quoted_to_string(&ret,alias);
	else
	    append_string(&ret,alias,0);
    }

    return ret;
}

static int ad_set_group_alias P_((struct AliasView *aview,
				   struct alias_buffer *buffer,
				   struct menu_context  *page,
				   struct screen_parts  *LOC));
static int ad_set_group_alias(aview,buffer,page,LOC)
     struct AliasView *aview;
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;

    int delay_redraw = 0;
    int line;

    if (value) {
	int code = 0;

	const struct alias_vector    * group_vector = NULL;
	const struct string          * group_phrase = NULL;

	struct string          * list_string    = NULL;


	if (address_alias_get_group(value,&group_phrase,&group_vector)) {
	    if (group_phrase)
		menu_PutLineX (LOC->prompt_page,1, 0,
			       CATGETS(elm_msg_cat, AliasesSet,
				       AliasesIsGroupAliasFor,
				       "Is a group alias for %S"),
			       group_phrase);
	    
	    else
		menu_PutLineX (LOC->prompt_page,1, 0,
			       CATGETS(elm_msg_cat, AliasesSet,
				       AliasesIsGroupAlias,
				       "Is a group alias"));
	    FlushBuffer();
	    
	    return 0;

	} 

    redraw1:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);

	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &list_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesAliasListGroup,
					 "Alias list for group: "));
	
	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */

	    delay_redraw++;
	    goto redraw1;
	}

	if (0 == code && list_string) {

	    struct alias_vector * vector = 
		string_to_alias_list(aview,list_string,page,LOC);
	    
	    if (vector) {
		new_value = dup_address_alias(value);
		
		set_group_address_alias(new_value,NULL,vector);
		free_alias_vector(&vector);
	    }
	}
	
	if (list_string)
	    free_string(&list_string);
	
    } else {  /* Not a alias available */
	int code = 0;	

	struct string          * list_string    = NULL;


    redraw2:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);

	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &list_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesAliasListGroup,
					 "Alias list for group: "));
	
	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */

	    delay_redraw++;
	    goto redraw2;
	}

	if (0 == code && list_string) {

	    struct alias_vector * vector = 
		string_to_alias_list(aview,list_string,page,LOC);
	    
	    if (vector) {		
		new_value = new_group_address_alias(NULL,NULL,
						    vector);	       
		free_alias_vector(&vector);
	    }
	}
	
	if (list_string)
	    free_string(&list_string);
       
    }

    if (new_value) {
	
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_group_alias=%d\n",
		      ret));
    
    return ret;
}


static int ad_set_alias_group_member P_((struct AliasView *aview,
					  struct alias_buffer *buffer,
					  struct menu_context  *page,
					  struct screen_parts  *LOC));
static int ad_set_alias_group_member(aview,buffer,page,LOC)
     struct AliasView *aview;
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    
    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {

	const struct alias_vector    * group_vector = NULL;
	const struct string          * group_phrase = NULL;

	if (address_alias_get_group(value,&group_phrase,&group_vector)) {
	    int code = 0;
	    struct string          * new_vector_string    = NULL;

	    if (group_vector)
		new_vector_string = alias_list_to_string(group_vector);


	redraw1:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	    
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);


	    code = optionally_enter2(page,
				     &new_vector_string,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesAliasListGroup,
					     "Alias list for group: "));
	
	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw1;
	    }

	    if (0 == code && new_vector_string) {
		
		struct alias_vector * vector = 
		    string_to_alias_list(aview,new_vector_string,page,LOC);
		
		if (vector) {
		    new_value = dup_address_alias(value);
		    
		    set_group_address_alias(new_value,group_phrase,vector);
		    free_alias_vector(&vector);
		}
	    }
	    
	    if (new_vector_string)
		free_string(&new_vector_string);

	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNotGroupAlias,
			      "Not a group alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }
    
    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_alias_group_member=%d\n",
		      ret));

    return ret;
}

static int ad_set_alias_group_phrase P_((struct alias_buffer *buffer,
					  struct menu_context  *page,
					  struct screen_parts  *LOC));
static int ad_set_alias_group_phrase(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    
    struct address_alias       * new_value = NULL;
    int delay_redraw = 0;
    int line;

    if (value) {

	const struct alias_vector    * group_vector = NULL;
	const struct string          * group_phrase = NULL;

	if (address_alias_get_group(value,&group_phrase,&group_vector)) {
	    int code = 0;

	    struct string          * new_group_phrase    = NULL;

	    if (group_phrase)
		new_group_phrase = dup_string(group_phrase);

	redraw1:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	    
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);

	    code = optionally_enter2(page,
				     &new_group_phrase,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesAliasGroupPhrase,
					     "Phrase for group: "));
	    
	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw1;
	    }

	    if (0 == code && new_group_phrase) {
		new_value = dup_address_alias(value);

		if (!group_vector) {
		    struct alias_vector * vector = new_alias_vector();

		    DPRINT(Debug,1, (&Debug, 
				     "ad_set_alias_group_phrase: No group vector!  FIXUP\n"));
		    set_group_address_alias(new_value,new_group_phrase,
					    vector);
				
		    free_alias_vector(&vector);
		

		} else		
		    set_group_address_alias(new_value,new_group_phrase,
					    group_vector);
	    }

	    if (new_group_phrase)
		free_string(&new_group_phrase);
	    

	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNotGroupAlias,
			      "Not a group alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }
    
    if (new_value) {
	set_alias_buffer_value(buffer,new_value);
	menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_alias_group_phrase=%d\n",
		      ret));

    return ret;
}

/* ------------------------------------------------------------------------- */

static int ad_set_address_list_alias P_((struct alias_buffer *buffer,
					  struct menu_context  *page,
					  struct screen_parts  *LOC));
			       

static int ad_set_address_list_alias(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;

    int delay_redraw = 0;
    int line;

    if (value) {
	int code = 0;

	const struct addr_list * address_list = address_alias_get_list(value);
	struct string          * list_string  = NULL;

	if (address_list) {
	    menu_PutLineX (LOC->prompt_page,1, 0,
			   CATGETS(elm_msg_cat, AliasesSet,
				   AliasesIsListAlias,
				       "Is a alias for address list"));

	    FlushBuffer();
	    
	    return 0;
	}


    redraw1:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);

	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &list_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesAliasAddressList,
					 "Address list for alias: "));
	

	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */
	    
	    delay_redraw++;
	    goto redraw1;
	}

	if (0 == code && list_string) {
	    struct addr_list * new_list = 
		parse_string_address(list_string,
				     unq_can_print_error,
				     NULL,0,NULL);

	    if (new_list) {
		new_value = dup_address_alias(value);

		set_list_address_alias(new_value,new_list);

		free_addr_list(&new_list);
	    } 
	}

	if (list_string)
	    free_string(&list_string);

    } else {  /* Not a alias available */
	int code = 0;

	struct string          * list_string  = NULL;


    redraw2:
	menu_MoveCursor(LOC->prompt_page,1,0);
	menu_CleartoEOS(LOC->prompt_page);

	/* FIXME --optionally_enter*  should use prompt_page */
	line = menu_GetAbsLine(LOC->prompt_page,1);

	code = optionally_enter2(page,
				 &list_string,
				 line,0,
				 OE_APPEND_CURRENT|OE_REDRAW_MARK|
				 OE_SIG_CHAR /* Ctrl-C */,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesAliasAddressList,
					 "Address list for alias: "));
	

	if (REDRAW_MARK == code ||
	    ('L'&31)    == code) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC->prompt_page))
		menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
	    
	    /* NOTICE: using menu_trigger_redraw(page) on here
	       may cause redraw loop!
	    */
	    
	    delay_redraw++;
	    goto redraw2;
	}

	if (0 == code && list_string) {
	    struct addr_list * new_list = 
		parse_string_address(list_string,
				     unq_can_print_error,
				     NULL,0,NULL);
	    
	    if (new_list) {
		new_value = new_list_address_alias(NULL,new_list);
		
		free_addr_list(&new_list);
	    }
	}

	if (list_string)
	    free_string(&list_string);
    }

    if (new_value) {

	set_alias_buffer_value(buffer,new_value);
	menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }

    if (delay_redraw)
	menu_trigger_redraw(page);	

    DPRINT(Debug,10, (&Debug, "ad_set_address_list_alias=%d\n",
		      ret));

    return ret;
}


static int ad_set_alias_address_list_addresses P_((
                     struct alias_buffer *buffer,
		     struct menu_context  *page,
		     struct screen_parts  *LOC));
			       

static int ad_set_alias_address_list_addresses(buffer,page,LOC)
     struct alias_buffer *buffer;
     struct menu_context  *page;
     struct screen_parts  *LOC;
{
    int ret = 0;
    const struct address_alias * value = alias_buffer_value(buffer);
    struct address_alias       * new_value = NULL;

    int delay_redraw = 0;
    int line;

    if (value) {
	const struct addr_list * address_list = address_alias_get_list(value);

	if (address_list) {

	    struct string  * list_string = addr_list_to_string(address_list);
	    int code = 0;

	redraw1:
	    menu_MoveCursor(LOC->prompt_page,1,0);
	    menu_CleartoEOS(LOC->prompt_page);
	    
	    /* FIXME --optionally_enter*  should use prompt_page */
	    line = menu_GetAbsLine(LOC->prompt_page,1);

	    code = optionally_enter2(page,
				     &list_string,
				     line,0,
				     OE_APPEND_CURRENT|OE_REDRAW_MARK|
				     OE_SIG_CHAR /* Ctrl-C */,
				     CATGETS(elm_msg_cat, AliasesSet,
					     AliasesAliasAddressList,
					     "Address list for alias: "));
	    
	    if (REDRAW_MARK == code ||
		('L'&31)    == code) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(LOC->prompt_page))
		    menu_ClearScreen(LOC->prompt_page);   /* but clear redraw mark from prompt_area*/
		
		/* NOTICE: using menu_trigger_redraw(page) on here
		   may cause redraw loop!
		*/
		
		delay_redraw++;
		goto redraw1;
	    }
	
	    if (0 == code && list_string) {
		struct addr_list * new_list = 
		    parse_string_address(list_string,
					 unq_can_print_error,
					 NULL,0,NULL);

		if (new_list) {
		    
		    new_value = dup_address_alias(value);
		    
		    set_list_address_alias(new_value,new_list);
		    
		    free_addr_list(&new_list);
		}
	    }

	    if (list_string)
		free_string(&list_string);
	    
	} else { 
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, 
			      AliasesNotAddrListAlias,
			      "Not a address list alias"));

	}
	
    } else { /* No value */
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoAliastypeSelected,
			  "No alias type selected"));
	
    }

    if (new_value) {
	set_alias_buffer_value(buffer,new_value);

	if (!delay_redraw)
	    menu_trigger_redraw(LOC->header_page);

	free_address_alias(&new_value);
	ret = 1;
    }
    
    if (delay_redraw)
	menu_trigger_redraw(page);	

     DPRINT(Debug,10, (&Debug, "ad_set_alias_address_list_addresses=%d\n",
		      ret));

    return ret;
}

/* ------------------------------------------------------------------------ */

/* 1   == modified
   0   == not modified
   -1  == cancel */

int alias_modify(aview,a,new,parent_page)
     struct AliasView *aview;  /* For lookup */
     struct alias_buffer * a;
     int new;
     struct menu_context * parent_page;
{
    int update = 1;
    int ret = 0;

    struct menu_anon_param A;
    struct menu_context  *page = new_menu_context();

    struct screen_parts  LOC  = { NULL, NULL, NULL, NULL };
    struct menu_param  PARAM[alias_info_mp_COUNT+1] = { 
	{ mp_anon_param, { 0 } },
	{ mp_END, { 0 } }
    };

    
    A.alias_buffer = a;
   
    mp_list_set_anon(PARAM,alias_info_mp_param,&A);
 
    ad_set_alias_info_screen(page,&LOC,PARAM);

    if (new) {
	menu_PutLineX (LOC.prompt_page,0, 0, 
		       CATGETS(elm_msg_cat, AliasesSet, AliasesInfoPrompt,
			       "Alias info: "));
	menu_CleartoEOS(LOC.prompt_page);   


	goto prompt_name;
    }


    for (;;) {
	int ch = '\0';

	if (menu_resized(page)) {
	    ad_set_alias_info_screen(page,&LOC,PARAM);
	    update = 1;
	}

	if (update || menu_need_redraw(page)) {
	    menu_ClearScreen(page);

	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    	    
	    update = 0;
	    show_last_error(); 
	} 
	
	check_alias_info_screen(&LOC,PARAM);

#ifdef BACKGROUD_PROCESSES      
	if (handle_sigchld)
	    sigchld_handler();
#endif
	
	{
	    int lin,col;
	    
	    menu_ClearLine(LOC.prompt_page,0);
	    
 	    menu_PutLineX (LOC.prompt_page,0, 0, 
			   CATGETS(elm_msg_cat, AliasesSet, AliasesInfoPrompt,
				   "Alias info: "));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);
	    
	    menu_CleartoEOS(LOC.prompt_page);   
	
	    show_last_error();
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	    
	    ch = menu_ReadCh(LOC.prompt_page, 
			     REDRAW_MARK|READCH_CURSOR|READCH_resize|
			     READCH_sig_char);
	    
	    menu_CleartoEOS(LOC.prompt_page);

	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,
		       (&Debug, "-- Alias display command: %c [%d]\n",ch,ch));
	    } else {
		DPRINT(Debug,4,
		       (&Debug, "-- Alias display command: [%d]\n",ch));
	    }

	    set_error("");	/* clear error buffer */
	}

	switch (ch) {

	case RESIZE_MARK:
	    DPRINT(Debug,4, (&Debug, " ... resizing\n"));
	    
	    continue;

	case ctrl('L'):
	case REDRAW_MARK:
	    DPRINT(Debug,4, (&Debug, " ... redrawing\n"));

	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    if (menu_need_redraw(LOC.prompt_page))		    
		menu_ClearScreen(LOC.prompt_page);   /* Clear redraw mark from prompt_area*/
	    

	    update = 1;
	    continue;
	
	case ctrl('J'):
	case ctrl('M'):
	    goto OUT;


	case 'A':
	prompt_name:
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoAliasName,
					 "Alias name"));
	    FlushBuffer();
	    if (ad_set_alias_name(a,page,&LOC))
		ret = 1;
	    break;

	case 'c':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoComment,
					 "Alias comment"));
	    FlushBuffer();
	    if (ad_set_alias_comment(a,page,&LOC))
		ret = 1;

	    break;

	case 'F':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoFirstName,
					 "Person alias first name"));
	    FlushBuffer();
	    if (ad_set_alias_first_name(a,page,&LOC))
		ret = 1;

	    break;


	case 'g':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoGroupAlias,
					 "Group alias"));
	    FlushBuffer();

	    if (ad_set_group_alias(aview,a,page,&LOC))
		ret = 1;

	    break;


	case 'l':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoAddressListAlias,
					 "Address list alias"));
	    FlushBuffer();

	    if (ad_set_address_list_alias(a,page,&LOC))
		ret = 1;

	    break;


	case 'L':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoLastName,
					 "Person alias last name"));
	    FlushBuffer();

	    if (ad_set_alias_last_name(a,page,&LOC))
		ret = 1;

	    break;

	case 'M':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoGroupMembers,
					 "Group members"));
	    FlushBuffer();
		
	    if (ad_set_alias_group_member(aview,a,page,&LOC))
		ret = 1;

	    break;


	case 'p':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoPersonAlias,
					 "Person alias"));
	    FlushBuffer();

	    if (ad_set_person_alias(a,page,&LOC))
		ret = 1;

	    break;
	    
	case 'P':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoGroupPhrase,
					 "Group phrase"));
	    FlushBuffer();
		
	    if (ad_set_alias_group_phrase(a,page,&LOC))
		ret = 1;

	    break;

	case 'r':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoPersonAddress,
					 "Person alias address"));
	    FlushBuffer();

	    if (ad_set_alias_person_address(a,page,&LOC))
		ret = 1;

	    break;
	    
	case 's':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoListAddress,
					 "List addresses for alias"));
	    FlushBuffer();

	    if (ad_set_alias_address_list_addresses(a,page,&LOC))
		ret = 1;

	    break;
	    
	case 'q':
	case 'x':
	    goto OUT;


	case 'i':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, AliasesSet,
					 AliasesGoIndex,
					 "Go to index"));
	    
	    FlushBuffer();
	    /* FALLTHRU */
	case TERMCH_interrupt_char:
	case EOF:
	    ret = -1;
	    goto OUT;

	default:
	    if (isascii(ch) && isprint(ch))
		lib_error(CATGETS(elm_msg_cat, AliasesSet,
				  AliasesInfoUnknownCommand,		       
				  "Unknown command: %c"), 
			  ch);
	    else
		lib_error(CATGETS(elm_msg_cat, AliasesSet,
				  AliasesInfoUnknownCommand2,		       
				  "Unknown command."));
	    continue;
	}          
    }

    OUT:
    
    error_wait();
    
    erase_menu_context(&page);

    /* Force default return to parent page ... */
    menu_set_default(parent_page); 

    menu_trigger_redraw(parent_page); 


    DPRINT(Debug,9, (&Debug, "alias_modify=%d\n",
		     ret));

    return ret;
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
