static char rcsid[] = "@(#)$Id: alias_info.c,v 2.12 2021/07/13 07:58:37 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_elm.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");


/* ------------- alias info display ---------------------------------------- */

void alias_info_update P_((struct menu_context *page,
			   struct aliasview_record *a));

void alias_info_update(page,a)
     struct menu_context * page;
     struct aliasview_record *a;

{
    const struct string *key            = aliasview_key(a);
    const struct address_alias * value  = aliasview_address_alias(a);

    int LINES, COLUMNS;
    int line = 0;
    
    menu_get_sizes(page, &LINES, &COLUMNS);

    menu_ClearScreen(page);

    if (aliasview_ison_status(a, DELETED)) {	
	menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesInfoDeleted,
					  "[Deleted]"));
    }

    menu_StartXX(page,pg_BOLD);
    menu_print_format_center(page,line,
			     CATGETS(elm_msg_cat, AliasesSet, AliasesInfoTitle,
				     "Alias info"));
    menu_EndXX(page,pg_BOLD);
 
    line += 2;
        
    if (key)
	menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesInfoAliasNameRO,
					 "Alias name     : %S"),
		      key);
    else
	menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesInfoAliasNameNoneRO,
					 "Alias name     : <none>"));
    line++;
    
    if (value) {
	const struct string * comment = address_alias_get_comment(value);
	
	const struct string     *firstn   = NULL;
	const struct string     *lastn    = NULL;
	const struct address    *address  = NULL;
	
	const struct alias_vector    * group_vector = NULL;
	const struct string          * group_phrase = NULL;
	
	const struct addr_list * address_list = 
	    address_alias_get_list(value);

	
	if (comment)
	    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoAliasCommentRO,
					      "Alias comment  : %S"),
			  comment);
	else
	    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoAliasCommentNoneRO,
					      "Alias comment  : <none>"));
		
	
	line++;
	
	if (address_alias_get_person(value,&firstn,&lastn,&address)) {
	    
	    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoPersonAlias,
					     "Person alias:"));
	    
	    line++;

	    if (firstn)
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoFirstNameRO,
						 "   First name  : %S"),
			      firstn);
	    else
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoFirstNameNoneRO,
						 "   First name  : <none>"));
		    
	    line++;

	    if (lastn)
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoLastNameRO,
						 "   Last name   : %S"),
			      lastn);
	    else
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoLastNameNoneRO,
						 "   Last name   : <none>"),
			      lastn);
	    
	    line++;
	    
	    if (address) {
		/* Address should always exist for person alias */

		if (address_is_empty(address)) {

		    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						      AliasesInfoAddressNoneRO,
						      "   Address     : <none>"));
		    
		} else {
		    struct string * buffer = new_string(display_charset);
		    
		    display_add_one_address(&buffer,address);
		    
		    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						      AliasesInfoAddressRO,
						      "   Address     : %S"),
				  buffer);
		    
		    free_string(&buffer);
				   
		}
		line++;
	    } 
	}

	if (address_alias_get_group(value,&group_phrase,&group_vector)) {
	    
	    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoAliasGroup,
					     "Alias group:"));
	    
	    line++;
	    
	    if (group_phrase)
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoPhraseRO,
						 "   Phrase      : %S"),
			      group_phrase);
	    else if (alias_group_phrase)
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						 AliasesInfoPhraseNoneRO,
						 "   Phrase      : <none>"));
	    
	    line++;
	    
	    
	    if (group_vector) {
		/* group vector should always exist for group alias */

		struct display_list_state * state = 
		    display_list_iterator_alloc_aliases(group_vector);
		
		struct string * prefix = 
		    format_string(CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesInfoMembersRO,
					  "   Members     : "));

		
		if (! genlist_display_list(page,prefix,
					   &line,3,state))	  
		    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						      AliasesInfoMembersROEmpty,
						      "   Members     : <empty>"));
		
		line++;		     

		free_string(&prefix);
		display_list_iterator_free(&state);
	    } 
	}
	
	if (address_list) {
	    struct display_list_state * state = 
		display_list_iterator_alloc_addrs(address_list);
	    
	    struct string * prefix = 
		format_string(CATGETS(elm_msg_cat, 
				      AliasesSet, 
				      AliasesInfoListAddrRO,
				      "   Addresses   : "));

	    
	    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					     AliasesInfoListAlias,
					     "List alias:"));
	    line++;

	    if (! genlist_display_list(page,prefix,
				       &line,2,state))	   
		menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
						  AliasesInfoListAddrEmptyRO,
						  "   Addresses   : <no addresses>"));
	    
	    	    

	    line++;		     

	    free_string(&prefix);
	    display_list_iterator_free(&state);
	}     
    }   
}


/* Returns command or \0   */
int alias_info(a,page)
     struct aliasview_record *a;
     struct menu_context *page;
{
    int ret = '\0';
    int update = 1;

    int LINES, COLUMNS;
    
    menu_get_sizes(page, &LINES, &COLUMNS);


    for (;;) {
        int ch = '\0';
	int lin,col;

	if (menu_resized(page)) {
	    menu_get_sizes(page, &LINES, &COLUMNS);
	    update = 1;
	}

	if (update || menu_need_redraw(page)) {
	    menu_ClearScreen(page);

	    alias_info_update(page,a);
	    update = 0;
            show_last_error(); 
	}

	menu_ClearLine(page,LINES-2);
	menu_PutLineX (page,LINES-2, 0,
		       CATGETS(elm_msg_cat, AliasesSet, AliasesInfoCommand,
			       "Command ('i' to return to index): "));

	menu_GetXYLocation(page,&lin,&col);
	menu_CleartoEOS(page);   
	
	show_last_error();
	menu_MoveCursor(page,lin,col);

	ch = menu_ReadCh(page, 
			     REDRAW_MARK|READCH_CURSOR|READCH_resize|
			     READCH_sig_char);
	    
	menu_CleartoEOS(page);
	set_error("");	/* clear error buffer */
    
	switch (ch) {

	case RESIZE_MARK:
	    DPRINT(Debug,4, (&Debug, " ... resizing\n"));
	    continue;

	case ctrl('L'):
	case REDRAW_MARK:
	    DPRINT(Debug,4, (&Debug, " ... redrawing\n"));
	  
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	  
	    update = 1;
	    break;
	    
	case 'i':
	    ret = '\0';
	    goto OUT;
	    
	default:
	    ret = ch;
	    goto OUT;
	}


    }


 OUT:

    return ret;
}


/* ------------- alias expansion display ---------------------------------- */

static void alias_expansion_info_update P_((struct menu_context  *page,
					    const struct string *key,
					    struct addr_list     *addr,
					    int deleted));

static void alias_expansion_info_update(page,key,addr,deleted)
     struct menu_context  *page;
     const struct string *key;
     struct addr_list     *addr;
     int deleted;
{
    int LINES, COLUMNS;
    int line = 0;
     
    menu_get_sizes(page, &LINES, &COLUMNS);

    menu_ClearScreen(page);

    if (deleted) {
	menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesInfoDeleted,
					  "[Deleted]"));
    }

    menu_StartXX(page,pg_BOLD);
    menu_print_format_center(page,line,
			     CATGETS(elm_msg_cat, AliasesSet, AliasesInfoTitle,
				     "Alias info"));
    menu_EndXX(page,pg_BOLD);

    line += 2;

    menu_PutLineX(page,line,0,CATGETS(elm_msg_cat, AliasesSet, 
				      AliasesInfoAliasNameRO,
				      "Alias name     : %S"),
		  key);

    line += 2;

    if (addr) {
	struct display_list_state * state = 
	    display_list_iterator_alloc_addrs(addr);

	struct string * prefix = 
	    format_string(CATGETS(elm_msg_cat, AliasesSet, 
				  AliasesInfoExpansion,
				  "Aliased address: "));
	
	
	genlist_display_list(page,prefix,
			     &line,2,state);

	free_string(&prefix);
	display_list_iterator_free(&state);
    }

}


void alias_expansion_info(a,key,parent_page,aview)
     struct aliasview_record *a;
     const struct string *key;
     struct menu_context * parent_page;
     struct AliasView *aview;
{

    struct menu_context  *page = new_menu_context();

    alias_expansion_info0(a,key,page,aview,0);

    erase_menu_context(&page);

    /* Force default return to parent page ... */
    menu_set_default(parent_page); 

    menu_trigger_redraw(parent_page); 
}


int alias_expansion_info0(a,key,page,aview,ask_command)
     struct aliasview_record *a;
     const struct string *key;
     struct menu_context * page;
     struct AliasView *aview;
     int ask_command;
{
    struct addr_list     *addr = NULL;
    struct alias_stack         * stack = new_alias_stack();
    int update = 1;
    int ret = '\0';
    int deleted  = 0;

    int LINES, COLUMNS;

    union alias_stack_item  mailer;
    mailer.dummy_arg = NULL;
    
    menu_get_sizes(page, &LINES, &COLUMNS);

    if ((a && key) 
	|| 
	(!a && !key)
	) 
	panic("ALIAS PANIC",__FILE__,__LINE__,"alias_expansion_info",
	      "bad arguments",0);
	    
    add_aview_to_alias_stack(stack,aview);
    add_lookup_to_alias_stack(stack,lookup_dummy,mailer);

    if (a) {
	const struct address_alias * address_alias
	    = aliasview_address_alias(a);

	key = aliasview_key(a);

	if (address_alias) 
	    addr = aliases_expand_alias_proto(stack,address_alias);

	deleted = aliasview_ison_status(a, DELETED);
       
    } else 
	addr = aliases_expand_alias(stack,key,NULL);

    free_alias_stack(&stack);


    for (;;) {
        int ch = '\0';
	int lin,col;

	if (menu_resized(page)) {
	    menu_get_sizes(page, &LINES, &COLUMNS);
	    update = 1;
	}

	if (update || menu_need_redraw(page)) {
	    menu_ClearScreen(page);

	    alias_expansion_info_update(page,key,addr,deleted);
	    update = 0;
            show_last_error(); 
	}

	menu_ClearLine(page,LINES-2);
	
	if (ask_command)
	    menu_PutLineX (page,LINES-2, 0,
			   CATGETS(elm_msg_cat, AliasesSet, AliasesInfoCommand,
				   "Command ('i' to return to index): "));
	else
	    menu_PutLineX (page,LINES-2, 0,
			   CATGETS(elm_msg_cat, AliasesSet, AliasesInfoPressAnyRet,
				   "Press any key to return to aliases menu: "));

	menu_GetXYLocation(page,&lin,&col);
	menu_CleartoEOS(page);   
	
	show_last_error();
	menu_MoveCursor(page,lin,col);

	ch = menu_ReadCh(page, 
			     REDRAW_MARK|READCH_CURSOR|READCH_resize|
			     READCH_sig_char);
	    
	menu_CleartoEOS(page);
	set_error("");	/* clear error buffer */
    
	switch (ch) {

	case RESIZE_MARK:
	    DPRINT(Debug,4, (&Debug, " ... resizing\n"));
	    continue;

	case ctrl('L'):
	case REDRAW_MARK:
	    DPRINT(Debug,4, (&Debug, " ... redrawing\n"));
	  
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	  
	    update = 1;
	    break;
	 
	case 'i':
	    ret = '\0';
	    goto OUT;
   
	default:
	    ret = ch;
	    goto OUT;
	}
    }

 OUT:
    if (addr)
	free_addr_list(&addr);

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
