static char rcsid[] = "@(#)$Id: aliaslib.c,v 2.7 2018/08/12 08:42:17 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/aliaslib.c. However this code is mostly rewritten.
 *  Original code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Library of functions dealing with the alias system...

 **/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"alias");


static char *us2s P_((unsigned char *str));
static char *us2s(str)
     unsigned char *str;
{
    return (char *)str;
}

/* Cause that all unknown aliases are treated as local addresses */

#if ANSI_C
static alias_stack_lookup_f lookup_local;
#endif
static int lookup_local P_((union alias_stack_item     value,
			    const struct string       *alias,
			    const struct address_alias **result_alias,
			    /* Caller must free result_list */
			    struct addr_list          **result_list,
			    enum alias_address_expand_result * expand_result
			    ));
static int lookup_local(value,alias,result_alias,result_list,expand_result)
     union alias_stack_item     value;
     const struct string       *alias;
     const struct address_alias **result_alias;
     /* Caller must free result_list */
     struct addr_list          **result_list;
     enum alias_address_expand_result * expand_result;
{
    int r = 0;

    char * name;
    charset_t ascii_ptr = MIME_name_to_charset("US-ASCII",0);
    struct string * tmp = NULL;

    struct addr_verify_result verify_result;
    enum mailer_errcode errcode = MAILER_NOT_AVAIL;

    *result_alias = NULL;
    *result_list  = NULL;

    /* Only ASCII accounts are accepted on here ... */

    if (!can_ascii_string(alias)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet,
			  ElmAsciiRequiredAddress,
			  "Ascii required for address %S"),
		  alias);
	return 0;
    }

    if (!ascii_ptr)
	panic("ALIAS PANIC",__FILE__,__LINE__,"lookup_local",
	      "US-ASCII not found",0);


    tmp = convert_string(ascii_ptr,alias,0);
    name = us2s(stream_from_string(tmp,0,NULL));

    if (verify_mailer_addr(value.localmailer,name,
			   &verify_result,&errcode)) {
	struct address * address =  new_address(verify_result.addr,
						verify_result.fullname,
						verify_result.comment);

	DPRINT(Debug,7,
	       (&Debug, 
		"Alias %s verified as address -- really %s\n",
		name,verify_result.addr));
		
	*result_list = new_empty_addr_list(1);

	add_address_to_list(*result_list,address,-1);

	free_address(&address);
	
	if (verify_result.fullname)
	    free_string(& verify_result.fullname);
	if (verify_result.comment)
	    free_string(& verify_result.comment);
	free(verify_result.addr); verify_result.addr = NULL;

	if (expand_result) {
	     *expand_result = alias_expand_local_fill;
	     DPRINT(Debug,10,
		    (&Debug,"lookup_local: setting alias_expand_local_fill\n"));
	}
	     
	r = 1;
	
    } else if (verify_local_address) {

	switch (errcode) {
	case MAILER_NOT_AVAIL:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmVerifyNot,
			      "Unable to verify mail address %S"),
		      alias);
	    break;
	case MAILER_NOT_EXIST:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmVerifyBad,
			      "Address %S is not e-mail address or Elm's alias"),
		      alias);
	    break;
	    
	default:
	    break;
	}

    } else {
	struct address * address =  new_address_string (alias,NULL,NULL);

	*result_list = new_empty_addr_list(1);

	add_address_to_list(*result_list,address,-1);


	if (expand_result) {
	     *expand_result = alias_expand_local_dummy;
	     DPRINT(Debug,10,
		    (&Debug,"lookup_local: setting alias_expand_local_dummy\n"));
	}
	r = 1;
    }
    
    free(name);
    free_string(&tmp);


    return r;
}

struct addr_list *get_alias_address_expanded (name, mailer_info,aview,
					      unquote,expand_result)
     const struct string   *name; /* name to expand as an alias */
     struct mailer_info  *mailer_info;
     struct AliasView *aview;
     int unquote;
     enum alias_address_expand_result * expand_result;   
{
    struct addr_list   * result  = NULL;
    struct alias_stack * stack   = new_alias_stack();

    if (expand_result)
	*expand_result = alias_expand_fail;
	
    add_aview_to_alias_stack(stack,aview);


    if (mailer_info) {
	union alias_stack_item  mailer;

	mailer.localmailer   = mailer_info;

	add_lookup_to_alias_stack(stack,lookup_local,mailer);
    }


    /* TODO: Reopens file if changed since last read ? */

    if (unquote) {
	struct string *s = unquote_string(name,
					  unq_can_print_error,
					  NULL,0,NULL);

	result = aliases_expand_alias(stack,s,expand_result);

	free_string(&s);
    } else
	result = aliases_expand_alias(stack,name,expand_result);

    free_alias_stack(&stack);

    return result;
}

const struct address_alias *get_alias_only  (name, aview)
     const struct string   *name; /* name to lookup as an alias */
     struct AliasView *aview;
{
    struct alias_stack * stack   = new_alias_stack();
    const struct address_alias    * result  = NULL;

    /* TODO: Reopens file if changed since last read ? */

    add_aview_to_alias_stack(stack,aview);
    
    result = aliases_get_alias(stack,name);

    free_alias_stack(&stack);
    
    return result;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
