static char rcsid[] = "@(#)$Id: canceled.c,v 2.14 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>  
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ****************************************************************************
 * Some code copiend from Elm 2.4 src/elm.c and src/leavembox.c. 
 * On these are following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

#if ANSI_C
static subpage_simple_redraw sb_cancel_menu;
#endif
static int sb_cancel_menu P_((struct menu_context  *ptr,
			      struct menu_param *list));
static int sb_cancel_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    menu_ClearScreen(ptr);

    menu_print_format_center(ptr,0,
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmCancelMenuLine1,
				     "To select canceled message for mailing, press <return>."));
    menu_print_format_center(ptr,1,
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmCancelMenuLine2,
				     "To read message, press space.   j = move down, k = move up"));
    menu_print_format_center(ptr,2, 
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmCancelMenuLine3,
				     "Also available: d)elete, u)ndelete, i)ndex"));

    return 1;   
}



static int showmsg_cancel_cmd P_((     struct MailboxView *mailbox,
				       int cmd, 
				       struct pager_page *pager_page));
static int showmsg_cancel_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{

    return cmd;
}

/* This leaks on exit */
char * last_canceled_mail = NULL;


static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param   *LIST));
static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts  *LOC;
     struct menu_param    *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_update_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);

    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_cancel_menu,LIST);
   
    mailbox_screen_common(page,LOC, LIST);	
}

static void check_mailbox_screen P_((struct screen_parts *LOC,
				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_title(LOC->title_page,list);
    }

    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_cancel_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}



int view_canceled_mails(cancel_view,cancel_selection,aview)
     struct MailboxView * cancel_view;
     int *cancel_selection;
     struct AliasView *aview;
{

    int leave = 0;
    int can_flag = 0;
    int i;

    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL, NULL, NULL };

    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_canceled_mail_pager_commands();
    struct elm_commands *menu_cmds =  give_view_canceled_mail_commands();


    int   LINES, COLUMNS;	

    set_mcommon_from_mbxview(&MENU,cancel_view);    
    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);
    set_mailbox_screen(page,&LOC,PARAM);

    if (get_message_count(cancel_view) > 0) {

	if (! last_canceled_mail ||
	    ! cancel_set_current(cancel_view,last_canceled_mail)) {

	    set_current(cancel_view,1);   /* Set current to first message */
	}
	
	copy_current(&MENU,LOC.header_page);

	update_view(cancel_view);
	resort_mailbox(cancel_view,1);
	get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
    }

 start_again:

    leave = 0;

    menu_get_sizes(page,&LINES, &COLUMNS);

    showscreen(page);
    
    while (!leave) {
	int ch;

	menu_set_default(page);

	if (menu_resized(page)) {

	    set_mailbox_screen(page,&LOC,PARAM);
	    
	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);
	} 
	

	new_mail_check(cancel_view, page, &LOC, NULL);      

	if (update_view(cancel_view)) {
	    resort_mailbox(cancel_view,1);
	    
	    /* resort_mailbox no longer call get_page() */	    
	    get_page(&MENU, LOC.header_page);  
	    menu_trigger_redraw(LOC.header_page);
	}

	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_mailbox_screen(&LOC, PARAM);

	{   
	    int lin,col;
	    
	    menu_PutLineX(LOC.prompt_page,0,0,
			  FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);
	    
	    menu_CleartoEOLN(LOC.prompt_page);
	    ch = GetPrompt(LOC.prompt_page, elm_timeout);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    
	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	      
	    set_error("");	/* clear error buffer */
	    
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}
	
	ch = motion(ch,&MENU,&LOC, 
		    page,menu_cmds);
	
	switch (ch) {
	case 0:  /* OK */
	    break;

	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;
	    
	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));
	    
	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));
	    
	    set_mailbox_screen(page,&LOC,PARAM);
		
	    menu_trigger_redraw(page);   /* ? Is needed? */
	    
	    break;


	quit_mark:
	case ctrl('Q') :

	case 'Q':
	case 'X':

	    leave = -2;
	    break;
	case 'q':
	case 'i':

	    leave = 1;

	    break;

	case '$':
	case F5_KEY_MARK:
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmResyncFolder,
					 "Resynchronize folder"));
	    FlushBuffer();
	    leave = -1;
	    break;
	    
        case ' ':  /*   Copied from mailbox_command */ {
	    int current = get_current(cancel_view);
		
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmDisplayMessage,
					 "Display message"));  
	    FlushBuffer();
	    
	    if (current < 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMailToRead,
				  "No mail to read!"));
	    else {
		int x = show_message_normal(cancel_view,showmsg_cancel_cmd,
					    aview,page,LOC.header_page,
					    SHOWMSG_NOMAIL,pager_cmds);
				    
		switch (x) {
		case EOF:
		    goto eof_mark;
			
		case 'X':      /* Quick Exit */			
		    goto quit_mark;
		}
	       
		current = get_current(cancel_view);		
	    }
	}
	    break;

    case ctrl('J'):
    case ctrl('M'): {
	int current = get_current(cancel_view);
		
	menu_Write_to_screen(LOC.prompt_page,
			     CATGETS(elm_msg_cat, ElmSet,
				     ElmSelectCanMessage,
				     "Select Canceled message"));  

	FlushBuffer();
	if (current > 0) {
	    *cancel_selection = current -1;
	    leave    = 1;
	    can_flag = 1;
	}
    }
	break;

	eof_mark:
	case EOF:
	    
	    goto OUT;

	default:
	    lib_error(CATGETS(elm_msg_cat, ElmSet,
			      ElmUnknownCommand2,			
			      "Unknown command."));

	}
	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU, &LOC);

	check_mailbox_screen(&LOC, PARAM);
		
    } /* the BIG while loop! */


    if (leave != -2) {
	int marked_deleted = 0;

	for (i = 0; i < get_message_count(cancel_view); i++) {
	    if (mcommon_ison_status(&MENU,i,status_basic,DELETED))
		marked_deleted++;
	}
	
	if (marked_deleted > 0) {
	    int answer = (always_del ? 
			  *def_ans_yes : *def_ans_no);	/* default answer */
	    
	    if(ask_delete) {
		int def = answer;
		
		/* NOTICE: prompt_letter may return EOF */
		if (marked_deleted == 1)
		    answer = prompt_letter(LINES-4,"",def,
					   PROMPT_yesno|PROMPT_cancel|
					   PROMPT_redraw_mark|PROMPT_ctrlL,
					   page,
					   CATGETS(elm_msg_cat, ElmSet, 
						   ElmLeaveDeleteMessage,
						   "Delete message? (%c/%c) "), 
					   *def_ans_yes, *def_ans_no);
		else
		    answer = prompt_letter(LINES-4,"",def,
					   PROMPT_yesno|PROMPT_cancel|
					   PROMPT_redraw_mark|PROMPT_ctrlL,	
					   page,				       
					   CATGETS(elm_msg_cat, ElmSet, 
						   ElmLeaveDeleteMessages,
						   "Delete messages? (%c/%c) "), 
					   *def_ans_yes, *def_ans_no);
		
		if (TERMCH_interrupt_char == answer) {
		    leave = 0;
		    can_flag = 0;
		    goto start_again;	    
		}
		
		if (answer == ('L'&31) || answer == REDRAW_MARK) {
		    menu_ClearScreen(page);      
		    goto start_again;
		}

		if (answer == EOF) {
		    can_flag = 0;
		    goto OUT;
		}
	    }
	    
	    if (answer == *def_ans_yes) {
		/* NOTICE: This does not update index so
		 *cancel_selection is still valid */
		
		delete_marked_canceled_mails(cancel_view);
	    }
	    
	}
    }

    if (leave == -1) {
	int n;

	*cancel_selection = -1;
	can_flag = 0;

	sync_canceled_mails(cancel_view) ;
	
	if (get_current(cancel_view) > (n = get_message_count(cancel_view)))
	    set_current(cancel_view,n);

	resort_mailbox(cancel_view,1);
	get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
	goto start_again;
    }

 OUT:
    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);

    erase_menu_context(&page);

    DPRINT(Debug,4,(&Debug, "view_canceled_mails=%d *cancel_selection=%d\n",
		    can_flag,*cancel_selection));
    return can_flag;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
