/* $Id: def_command.h,v 1.10 2014/05/17 12:46:13 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "me.h"
#include "elm_globals.h"

/* pointers are shared -- must be malloced and caller must not free them */
extern struct elm_commands * new_commands P_((struct string *key_title, /* shared, free'ed by free_commands */
					      struct string *desc_title /* shared, free'ed by free_commands */,
					      struct elm_commands **assign
					      ));

extern struct elm_commands * new_dummy_prefixed_commands P_((void));

extern int  inc_commands_refcount P_((struct elm_commands *cmd)); /* returns refcount */

extern void add_commands_title P_((struct elm_commands *cmd,int pg_flags,  
				   const char * format, const char *msg, ...));

extern void add_commands_title_shared P_((struct elm_commands *cmd,
				   int pg_flags,
				   struct string *title /* shared, free'ed by 
							   free_commands */));


extern void add_commands_trailer P_((struct elm_commands *cmd,int pg_flags,
				     const char * format, const char *msg, ...));

#define FLAG_KEY_no_nested        1         /* Do not show key, if listing prefixed key */

extern void add_commands_help_s_shared P_((struct elm_commands *cmd, int flags,
					   int key, 
					   struct string *help /* shared, 
								  free'ed by 
								  free_commands */));


extern void add_commands_help_single P_((struct elm_commands *cmd,
					 struct elm_commands *is_prefix,
					 int flags,int key,
					 const char * format, const char *msg, ...));

/* keyext pointer is shared -- 
 *  must be malloced and caller must not free it
 */
extern void add_commands_help_single_keyext P_((struct elm_commands *cmd,
						struct elm_commands *is_prefix,
						int flags,int key,
						struct string *keyext,
						const char * format, const char *msg, ...));


extern void add_commands_help_many P_((struct elm_commands *cmd,
				       int flags, int keys_table[],  /* 0 terminated */
				       const char * format, const char *msg, ...));

extern void add_commands_help_many2 P_((struct elm_commands *cmd,
					int flags, int keys_table[],  /* 0 terminated */
					int pg_flags,
					const char * format, const char *msg, ...));


/* First command is used as prefix */
extern void add_commands_help_many_prefix P_((struct elm_commands *cmd,
					      struct elm_commands *is_prefix,
					      int flags, int keys_table[],  /* 0 terminated */
					      const char * format, const char *msg, ...));


/* Only adds commands, not other texts */
extern void add_commands_help_merge P_((struct elm_commands *cmd,
					const struct elm_commands *addition,
					int addition_pg_flags));

extern void sort_commands P_((struct elm_commands *cmd));

/* maincmd.c */

extern struct elm_commands *give_common_commands P_((void)); /* increment refcount */

extern struct elm_commands *give_common_core_commands P_((void)); /* increment refcount */

extern struct elm_commands *give_additional_mailbox_commands P_((void)); /* increment refcount */

extern struct elm_commands *give_motion_commands P_((void));  /* increment refcount */

/* pagercmd.c */

/* increment refcount */
extern struct elm_commands *give_cpager_commands P_((void)); 


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
